
/*
 * File:      // soc.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: soc.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#include <string.h>
#include <ctype.h>
#include <math.h>
#include "soc.h"


// =========================================================================
Population::Population(double p) :
	pop_desc('0')
{
	dice = new Dice(6, 2, 0);
	SetPop(p);
}

Population::Population(short p, int m) :
	pop_desc(p)
{
	dice = new Dice(6, 2, 0);
	SetPop(p, m);
}

Population::~Population()
{
	delete dice;
}

void
Population::SetPop(double p)
{
char buff[20];

	tot_pop = p;
	sprintf(buff,"%.0f",p);
	pop_mult = buff[0] - '0';
	set_t_hex_val(strlen(buff) - 1);
}

void
Population::Generate(short p, int m)
{
	SetPop(p, m);
}

void
Population::SetPop(short p, int m)
{
double tot=0.0;
int i;

//fprintf(stderr, "\n p=%d m=%d", p, m);
	if(m < 0) m = dice->Roll(9, 1);
	tot = m * pow(10, p);
	for(i = 0;i < p;i++)
		tot += dice->Roll(10, 1, -1) * pow(10, i);
	tot_pop = tot;
	pop_mult = m;
//fprintf(stderr, " tot=%.0f", tot_pop);
}

// =========================================================================
Religion::Religion(int auto_flag, int pop, int tech)
{
	dice = new Dice(6, 2, 0);
	Generate(auto_flag, pop, tech);
}

void
Religion::Generate(int auto_flag, int pop, int tech)
{
int i;

	if(auto_flag)
		i = dice->Roll(6,2) + dice->Roll(6,3) - 5;
	else
		i = dice->Roll(6,2) - 2 + tech;
	if(i < 1) god_view = 0;
	else god_view = i;
	
	spiritual_aim = dice->Roll(6,2) - 2 + (god_view / 3);
	if(spiritual_aim < 0) spiritual_aim = 0;
	if(spiritual_aim > 15) spiritual_aim = 15;
	
	devotion = dice->Roll(6,2) - 7 + spiritual_aim;
	if(devotion < 0) devotion = 0;
	if(devotion > 15) devotion = 15;
	
	organization = dice->Roll(6,2) - 2 + devotion;
	if(organization < 0) organization = 0;
	if(organization > 15) organization = 15;
	
	liturgical = dice->Roll(6,2) - 2 + organization;
	if(liturgical < 0) liturgical = 0;
	if(liturgical > 15) liturgical = 15;
	
	fervor = dice->Roll(6,2) - 2;
	if(fervor < 0) fervor = 0;
	if(fervor > 15) fervor = 15;
	
	number = dice->Roll(6,3) - fervor;
	if(number < 0) number = 0;
	if(number > pop) number = pop;
}

Religion::~Religion()
{
	delete dice;
}

#if 0
void Religion::PrintShortRel(FILE *stdlog)
{
	fprintf(stdlog, "                 Religion: %c%c%c%c%c%c-%c\n",
		uwp_str.get_uwp(god_view), uwp_str.get_uwp(spiritual_aim),
		uwp_str.get_uwp(devotion), uwp_str.get_uwp(organization),
		uwp_str.get_uwp(liturgical), uwp_str.get_uwp(fervor),
		uwp_str.get_uwp(number));
}
void Religion::PrintReligion(FILE *stdlog)
{

//	fprintf(stdlog, "               Atmosphere: %X(%s)\n",
}
#endif

// =========================================================================
Govt::Govt(short govt, int wld) :
	govt_desc(govt)
{
	dice = new Dice(6, 2, 0);
	wilds = wld;
	Generate();
}

void
Govt::Generate(void)
{
int i,j,k;

	i = GetTrueGovt();

// division and authority
	j = dice->Roll(6, 1);
	k = dice->Roll(6, 1);
	if(j < 3)
		{
		division = 3;
		switch(k)
			{
			case 1:
				auth[0].authority = 0;
				auth[1].authority = 1;
				auth[2].authority = 2;
				break;
			case 2:
				auth[0].authority = 0;
				auth[1].authority = 2;
				auth[2].authority = 1;
				break;
			case 3:
				auth[0].authority = 1;
				auth[1].authority = 0;
				auth[2].authority = 2;
				break;
			case 4:
				auth[0].authority = 1;
				auth[1].authority = 2;
				auth[2].authority = 0;
				break;
			case 5:
				auth[0].authority = 2;
				auth[1].authority = 0;
				auth[2].authority = 1;
				break;
			default:
				auth[0].authority = 2;
				auth[1].authority = 1;
				auth[2].authority = 0;
				break;
			}
		}
	else if(j < 5)
		{
		division = 2;
		switch(k)
			{
			case 1:
			case 2:
				auth[0].authority = 3;
				auth[1].authority = 1;
				auth[2].authority = -1;
				break;
			case 3:
			case 4:
			case 5:
				auth[0].authority = 4;
				auth[1].authority = 2;
				auth[2].authority = -1;
				break;
			default:
				auth[0].authority = 5;
				auth[1].authority = 0;
				auth[2].authority = -1;
				break;
			}
		}
	else
		{
		division = 1;
		auth[0].authority = 6;
		auth[1].authority = -1;
		auth[2].authority = -1;
		}

// orginization
	j = dice->Roll(6, 1);
	for(k = 0;k < division;k++)
		{
		if(i == 2)
			auth[k].organization = 0;
		else if((i == 8) || (i == 9))
			auth[k].organization = 3;
		else if((i == 3) || (i == 12) || (i == 15))
			{
			if(j < 5)
				auth[k].organization = 1;
			else
				auth[k].organization = 3;
			}
		else if((i == 10) || (i == 11))
			{
			if(j < 6)
				auth[k].organization = 2;
			else
				auth[k].organization = 1;
			}
		else
			{
			j = dice->Roll(6,2);
			if((i == 13) || (i == 14))
				{
				if(j < 3) j = 3;
				if(j > 11) j = 11;
				}
			if((j < 3) || (j > 11))
				auth[k].organization = 0;
			else if(j < 6)
				auth[k].organization = 1;
			else if(j < 8)
				auth[k].organization = 2;
			else
				auth[k].organization = 3;
			}
		}
}

Govt::~Govt()
{
	delete dice;
}

int Govt::wilds_conv_table[13] =
	{ 0, 1, 2, 4, 10, 12, 11, 13, 15, 14, 8, 3, 9 };

char *Govt::govt_str[16] = {
	"None",
	"Company/Corporation",
	"Participating Democracy",
	"Self-Perpetuating Oligarchy",
	"Representative Democracy",
	"Feudal Technocracy",
	"Captive Government",
	"Balkanization",			// shouldn't happen!
	"Civil Service Bureaucracy",
	"Impersonal Bureaucracy",
	"Charismatic Dictator",
	"Non-Charismatic Dictator",
	"Charismatic Oligarchy",
	"Religious Dictatorship",
	"Religious Autocracy",
	"Totalitarian Oligarchy"
};
char *Govt::wgovt_str[13] = {
	"None",
	"Tribal Government",
	"Participating Democracy",
	"Representative Demorcracy",
	"Charismatic Dictator",
	"Charismatic Oligarchy",
	"Technologically Elevated Dictator",
	"Mystic Dictatorship",
	"Totalitarian Oligarchy",
	"Mystic Autocracy",
	"Civil Service Bureaucracy",
	"Self-Perpetuating Oligarchy",
	"Impersonal Bureaucracy"
};
char *Govt::org_str[4] = {
	"Democratic",
	"Elite Council",
	"Ruler",
	"Several Council"
};
char *Govt::auth_str[7] = {
	"Executive",
	"Legislative",
	"Judicial",
	"Executive & Judicial",
	"Executive & Legislative",
	"Legislative & Judicial",
	"Executive & Legislative & Judicial"
};

int 
Govt::GetTrueGovt(void)
{
	if(!wilds)
		return(get_t_hex_val());
	else 
		return(wilds_conv_table[get_t_hex_val()]);
}

#if 0
void 
Govt::PrintGovt(FILE *stdlog)
{
int i;
char *ptr;

	if(wilds)
		ptr = wgovt_str[type];
	else
		ptr = govt_str[type];
	fprintf(stdlog, "               Government: %s\n", ptr);
	for(i = 0;i < division;i++)
		{
		if(!i)
			fprintf(stdlog, "        Primary Authority: ");
		else
			fprintf(stdlog, "          Other Authority: ");
		fprintf(stdlog, "%s(%s)\n", auth_str[auth[i].authority],
			org_str[auth[i].organization]);
		}
//	fprintf(stdlog, "               Atmosphere: %X(%s)\n",
}
#endif

// =========================================================================
Law::Law(short law, int pop, int ext) :
	law_desc(law)
{
	dice = new Dice(6, 2, 0);
	Generate(pop, ext);
}

void
Law::Generate(int pop, int ext)
{
short i,j;

	i = dice->Roll(6,2);
	if(get_t_hex_val() > 9)
		i--;
	if(ext == 0)
		i += 2;
	if(i < 6)
		uniformity = 0;
	else if(i < 8)
		uniformity = 1;
	else
		uniformity = 2;

	for(i = 0;i < 5;i++)
		{
		j = dice->Roll(6, 2, pop - 7);
		if(j < 0) j = 0;
		profile.dets[i] = new law_desc(j);
		}
}

Law::~Law()
{
int i;

	delete dice;
	for(i = 0;i < 5;i++)
		delete profile.dets[i];
}

#if 0
void Law::PrintLaw(FILE *stdlog)
{
int i;

	fprintf(stdlog, "   Law Profile Detail:\n");
	fprintf(stdlog, "                  Overall: %c\n", uwp_str.get_uwp(overall));
	for(i = 0;i < 5;i++)
		fprintf(stdlog, "         %s: %c\n", law_str[i], uwp_str.get_uwp(profile.dets[i]));
	fprintf(stdlog, "               Uniformity: %s\n", unif_str[uniformity]);
}
#endif

char *Law::unif_str[3] = {
	"Personal",
	"Territorial",
	"Undivided"
};
char *Law::law_str[5] = {
	"         Weapons",
	"           Trade",
	"        Criminal",
	"           Civil",
	"Personal Freedom"
};

// =========================================================================
Tech::Tech(short t, char port, int pop, int ext_glob, int ext_int,
			int agg_att, int agg_act, int atm, int hyd) :
		tech_desc(t)
{
	dice = new Dice(6, 2, 0);
	Generate(port, pop, ext_glob, ext_int, agg_att, agg_act, atm, hyd);
}

tech_desc *
Tech::NewTech(int lo, int hi, short val)
{
tech_desc *td;

	// idiot check
	if(lo < 0) lo = 0;
	if(val < lo) val = lo;
	if(val > hi) val = hi;
	td = new tech_desc(val);

	return(td);
}

void
Tech::Generate(char port, int pop, int ext_glob, int ext_int,
			int agg_att, int agg_act, int atm, int hyd)
{
int i,j;
int lo,hi;

	tech.dtech.high_common = new tech_desc(get_t_hex_val());

	lo = get_t_hex_val() / 2;
	hi = get_t_hex_val();
	j = get_t_hex_val()  + gen_mod();
	if(pop < 6) j++;
	if(pop > 8) j--;
	if(ext_glob == 0) j++;
	if(ext_glob == 2) j--;
	if(ext_glob == 3) j -= 2;
	tech.dtech.low_common = NewTech(lo, hi, j);
	
	lo = get_t_hex_val() / 2;
	hi = get_t_hex_val() + (get_t_hex_val() / 5);
	j = get_t_hex_val() + gen_mod();
	tech.dtech.energy = NewTech(lo, hi, j);
	
	lo = hi / 3;
	j = tech.dtech.energy->get_t_hex_val() + gen_mod();
	if(pop < 6) j++;
	if(pop > 8) j--;
	tech.dtech.computer = NewTech(lo, hi, j);

	j = tech.dtech.computer->get_t_hex_val() + gen_mod();
	tech.dtech.commo = NewTech(lo, hi, j);

    lo = 0;
	j = tech.dtech.computer->get_t_hex_val() + gen_mod();
	if(ext_int == 0) j++;
	tech.dtech.medical = NewTech(lo, hi, j);
	
	lo = hi - 5;
	j = tech.dtech.energy->get_t_hex_val() + gen_mod();
	if((atm != 5) && (atm != 6) && (atm != 8)) j++;
	if((hyd < 1) || (hyd > 9)) j++;
	tech.dtech.environ = NewTech(lo, hi, j);

	j = tech.dtech.energy->get_t_hex_val() + gen_mod();
	if(hyd > 9) j--;
	tech.dtech.land_tran = NewTech(lo, hi, j);

	if(tech.dtech.land_tran->get_t_hex_val() > 9)
		{
		tech.dtech.water_tran = 
				new tech_desc(tech.dtech.land_tran->get_t_hex_val());
		tech.dtech.air_tran = 
				new tech_desc(tech.dtech.land_tran->get_t_hex_val());
		}
	else
		{
		j = tech.dtech.energy->get_t_hex_val() + gen_mod();
		if(hyd < 1) j--;
		tech.dtech.water_tran = NewTech(lo, hi, j);

		if(atm < 1)
			tech.dtech.air_tran = new tech_desc((short) 0);
		else
			{
			hi = tech.dtech.land_tran->get_t_hex_val();
			lo = hi - 5;
			if(lo < 2) lo = 2;
			j = tech.dtech.energy->get_t_hex_val() + gen_mod();
			tech.dtech.air_tran = NewTech(lo, hi, j);
			}
		}

	hi = get_t_hex_val() + (get_t_hex_val() / 5);
	lo = hi - 3;
	if(tech.dtech.energy->get_t_hex_val() <
			tech.dtech.computer->get_t_hex_val())
		j = tech.dtech.energy->get_t_hex_val();
	else
		j = tech.dtech.computer->get_t_hex_val();
	j += gen_mod();
	if((port == 'A') || (port == 'B')) j++;
	if(ext_int < 3) j++;
	else j--;
	tech.dtech.space_tran = NewTech(lo, hi, j);

	lo = 0;
	j = tech.dtech.energy->get_t_hex_val() + gen_mod();
	if(agg_att == 0) j++;
	if(agg_att == 3) j -= 2;
	if(agg_act == 0) j++;
	if(agg_act == 3) j--;
	tech.dtech.pers_milt = NewTech(lo, hi, j);

	j = tech.dtech.land_tran->get_t_hex_val() + gen_mod();
	if(agg_att == 0) j++;
	if(agg_att == 3) j -= 2;
	if(agg_act == 0) j++;
	if(agg_act == 3) j--;
	tech.dtech.hvy_milt = NewTech(lo, hi, j);

	j = 0;
	for(i = 0;i < 13;i++)
		{
		if(tech.dets[i]->get_t_hex_val() > j)
			j = tech.dets[i]->get_t_hex_val();
		}
	tech.dtech.novelty = new tech_desc((short) j);
}

int Tech::gen_mod(void)
{
int i;

	i = dice->Roll(6,2);
	if(i < 3)
		return(-(dice->Roll(6,1)));
	if(i < 4)
		return(-2);
	if(i < 5)
		return(-1);
	if(i > 11)
		return(dice->Roll(6,1));
	if(i > 10)
		return(2);
	if(i > 11)
		return(1);
	return(0);
}

Tech::~Tech()
{
int i;

	delete dice;
	for(i = 0;i < 14;i++)
		delete tech.dets[i];
}

#if 0
void Tech::PrintTech(FILE *stdlog)
{
int i;

	fprintf(stdlog, "   Technology Profile Detail:\n");
	for(i = 0;i < 14;i++)
		fprintf(stdlog, "     %s: %c\n", tech_str[i], uwp_str.get_uwp(tech.dets[i]));
}
#endif

char *Tech::tech_str[14] = {
	"         High Common",
	"          Low Common",
	"              Energy",
	"    Computer/Robitic",
	"       Communication",
	"             Medical",
	"         Environment",
	" Land Transportation",
	"Water Transportation",
	"  Air Transportation",
	"Space Transportation",
	"    Personal Miltary",
	"       Heavy Miltary",
	"             Novelty"
};


// =========================================================================
BaseCity::BaseCity(char prt, int pp) :
	wxObject()
{
	dice = new Dice(6, 2, 0);
	Generate(prt, pp);
}

BaseCity::~BaseCity()
{
	delete dice;
	delete port;
}

void BaseCity::Generate(char prt, int pp)
{
int i=9,j;

	for(i = 0;i < 10;i++)
		{
		if(port_table[i][0] == prt)
			{
			j = i;
			break;
			}
		}

	i = dice->Roll(6, 1);
	if(pp > 5) i++;
	if(pp > 7) i++;

	port = new port_desc(port_table[j][i]);
}

char *
BaseCity::GetPortQualityStr(void) 
{ 
char *ptr;

	ptr = port->get_quality();
	if(!strcmp(ptr, "No")) ptr = "None";

	return(ptr);
}

char *BaseCity::city_type[4] = {
    "  Primary Cities",
    "Secondary Cities",
    " Tertiary Cities",
    "  Orbital Cities"
};

char BaseCity::port_table[10][10] =  {
	"ADCCBBBBA",
	"BFDDCCBBB",
	"CHGFFEDCC",
	"DHHGGGEED",
	"EYYHHHHEE",
	"XYYYHHHHH",
	"FHGGGFFFF",
	"GYHHGGGGG",
	"HYYHHHHHH",
	"YYYYYYYYY"
};

// =========================================================================
CityData::CityData(char prt, int pp, int p_mult, CITY_TYPE t) :
	BaseCity(prt, pp)
{
	pop = new Population(pp, p_mult);
	type = t;
}

CityData::~CityData()
{
	if(pop)
		delete pop;
}

void
CityData::Generate(char prt, int pp, int p_mult)
{
	BaseCity::Generate(prt, pp);
	pop->Generate(pp, p_mult);
}

void
CityData::AdjPop(double val)
{
	pop->SetPop(val);
}

char *
CityData::GetCityFormat(char *buff)
{
	sprintf(buff, "%.0f;  Class %c %s", pop->GetPop(), port->get_port(),
			GetPortQualityStr());
	return(buff);
}

// -------------------------------------------------------------------------
SubCity::SubCity(char port, int p, int c) :
	BaseCity(port, p)
{
	pop = p;
	count = c;
}

char *
SubCity::GetCityFormat(char *buff)
{
	sprintf(buff, "%d;  circa %.0f;  Class %c %s", count, 5.0 * pow(10.0, pop),
			port->get_port(), GetPortQualityStr());
	return(buff);
}

// -------------------------------------------------------------------------
CityList::~CityList()
{
	Clear();
}

void
CityList::Clear(void)
{
BaseCity *bc;
wxNode *n;

	n = First();
	while(n != NULL)
		{
		bc = (BaseCity *)n->Data();
		if(bc->GetCityType() == CT_TERTARY)
			{
			SubCity *sc;

			sc = (SubCity *)bc;
			delete sc;
			}
		else
			{
			CityData *cd;

			cd = (CityData *)bc;
			delete cd;
			}

		delete n;
		n = First();
		}
}

BaseCity *
CityList::GetCity(int ndx)
{
wxNode *n;

	n = Nth(ndx);
	if(NULL == n) return(NULL);
	return((BaseCity *)n->Data());
}

// =========================================================================
char *CustomData::group_[20] = {
"entire populace",
"certain political groups",
"certain geographic regions",
"certain sex",
"enforcement figures",
"entertainment figures",
"heroic figures",
"athletic figures",
"certain races",
"religious figures",
"military figures",
"certain occupations",
"political figures",
"medical figures",
"certain age groups",
"scientific figures",
"academic figures",
"low social class",
"high social class",
"convicted criminals"
};

int CustomData::grp_map[37] = {	 0, 1, 1, 2, 2, 3, 3, 3, 4, 5, 6, 7,
									 8, 8, 8, 9, 9,10,10,11,11,12,12,13,
									13,14,14,15,15,16,16,17,17,18,18,19,19 
									};

struct _CUST CustomData::customs[170] = {
{"same clothes for all sexes",           0, 0, 0x00 },
{"have unusual clothes",                 0, 1, 0x80 },
{"have unusual handgear",                0, 4, 0x80 },
{"have shaved heads",                    0, 6, 0x80 },
{"have never cut hair",                  0, 8, 0x80 },
{"unusual hair color",                   0,10, 0x80 },
{"have unusual hairdos",                 0,12, 0x80 },
{"have unusual eyebrows",                0,15, 0x80 },
{"have unusual facial alterations",      0,16, 0x80 },
{"have unusual body alterations",        0,17, 0x80 },
{"have unusual fingernails",             0,18, 0x80 },
{"have unusual toenails",                0,20, 0x80 },
{"have unusual cosmetics",               0,22, 0x80 },
{"have unusual jewelery",                0,25, 0x80 },
{"have unusual accessories",             0,28, 0x80 },
{"have unusual handgear",                0,30, 0x80 },
{"have tatooing on face",                0,32, 0x80 },
{"have tatooing on body",                0,33, 0x80 },
{"have hidden tatooing",                 0,35, 0x80 },
{"eat unusual foods",                    1, 0, 0x80 },
{"have unusual beverages",               1, 2, 0x80 },
{"have unusual food preperation",        1, 4, 0x80 },
{"are segregated during meals",          1, 6, 0x80 },
{"are vegetarians",                      1, 8, 0x80 },
{"are carnivorous",                      1,10, 0x80 },
{"are omnivorous",                       1,12, 0x80 },
{"certain colored food taboo for",       1,14, 0x02 },
{"certain shaped food taboo for",        1,16, 0x02 },
{"certain food sources taboo for",       1,17, 0x02 },
{"eat in special location",              1,18, 0x80 },
{"eat only in private",                  1,19, 0x80 },
{"eat in special orientation",           1,20, 0x80 },
{"eat with unusual utensils",            1,21, 0x80 },
{"eat only at home",                     1,22, 0x80 },
{"eat at unusual times",                 1,24, 0x80 },
{"eat only certain times",               1,26, 0x80 },
{"eat only certain ways",                1,27, 0x80 },
{"have rituals before eating",           1,28, 0x80 },
{"have rituals after eating",            1,29, 0x80 },
{"one sex eats other's leftovers",       1,30, 0x00 },
{"one age eats other's leftovers",       1,31, 0x00 },
{"eats leftovers",                       1,32, 0x81 },
{"one class eats other's leftovers",     1,33, 0x00 },
{"one race eats other's leftovers",      1,34, 0x00 },
{"are cannibalistic",                    1,35, 0x80 },
{"live privately",                       2, 0, 0x80 },
{"live apart in groups",                 2, 2, 0x80 },
{"live in special locations",            2, 4, 0x80 },
{"live at place of work",                2, 6, 0x80 },
{"live under special conditions",        2, 9, 0x80 },
{"confined to quarters",                 2,11, 0x80 },
{"live under special care",              2,12, 0x80 },
{"have extravagant quarters",            2,13, 0x80 },
{"have minimal quarters",                2,15, 0x80 },
{"have unusual quarters",                2,18, 0x80 },
{"quarters are taboo to",                2,20, 0x80 },
{"quarters must be visited by",          2,23, 0x81 },
{"live with extended familes",           2,26, 0x81 },
{"live with groom's family",             2,27, 0x80 },
{"live with bride's family",             2,28, 0x80 },
{"live with children's family",          2,29, 0x80 },
{"live with relatives",                  2,30, 0x80 },
{"live in communal housing",             2,31, 0x80 },
{"live only in certain terrrain",        2,34, 0x80 },
{"must move around",                     2,35, 0x80 },
{"child named by",                       3, 0, 0x02 },
{"child named for living relative",      3, 1, 0x00 },
{"child named for dead relative",        3, 2, 0x00 },
{"child named for hero",                 3, 3, 0x00 },
{"child named for",                      3, 4, 0x02 },
{"child named for object",               3, 5, 0x00 },
{"child renamed at adulthood",           3, 6, 0x00 },
{"child renamed when married",           3, 7, 0x00 },
{"marriage arranged by",                 3, 8, 0x02 },
{"marriage performed by",                3, 9, 0x02 },
{"marriage arranged by parents",         3,10, 0x00 },
{"marriage performed by parents",        3,12, 0x00 },
{"have marriage only within group",      3,13, 0x80 },
{"remarriage prohibited for",            3,14, 0x02 },
{"remarriage required for",              3,15, 0x02 },
{"groom's family pays dowery for",       3,16, 0x02 },
{"bride's family pays dowery for",       3,17, 0x02 },
{"dowery paid by outsider for",          3,18, 0x02 },
{"very short marriages the rule for",    3,29, 0x02 },
{"very long marriages the rule for",     3,20, 0x02 },
{"non-marriage the rule for",            3,21, 0x02 },
{"very short marriages prohibited for",  3,22, 0x02 },
{"very long marriages prohibited for",   3,23, 0x02 },
{"non-marriage prohibited for",          3,24, 0x02 },
{"divorce and remarriage required for",  3,25, 0x02 },
{"widow must marry husband's relative",  3,26, 0x80 },
{"widow/widower must commit suicide",    3,27, 0x80 },
{"widower must marry wife's relative",   3,28, 0x80 },
{"onerous prerequisite to marriage for", 3,30, 0x02 },
{"marriage only at certain times for",   3,31, 0x02 },
{"marriage must be blessed by",          3,32, 0x02 },
{"practice polandry",                    3,33, 0x80 },
{"practice polgyny",                     3,34, 0x80 },
{"communal polygamy practied by",        3,35, 0x02 },
{"have unusual sleep location",          4, 0, 0x80 },
{"have unusual sleep time",              4, 1, 0x80 },
{"have unusual sleep duration",          4, 2, 0x80 },
{"have unusual sleep orientation",       4, 3, 0x80 },
{"special language for",                 4, 4, 0x02 },
{"sacred symbols for",                   4, 5, 0x02 },
{"unusual duties for",                   4, 6, 0x02 },
{"anonimity required for",               4, 7, 0x02 },
{"drinking/drugs prohibited for",        4, 8, 0x02 },
{"drinking/drugs required for",          4, 9, 0x02 },
{"bodily abuse prohibited for",          4,10, 0x02 },
{"bodily abuse required for",            4,11, 0x02 },
{"special privileges for",               4,12, 0x02 },
{"special privileges prohibited for",    4,14, 0x02 },
{"unusual greetings for",                4,15, 0x02 },
{"unusual mannerisms for",               4,17, 0x02 },
{"unusual leavetakings for",             4,18, 0x02 },
{"unusual secret societies for",         4,19, 0x02 },
{"closed meetings taboo for",            4,20, 0x02 },
{"psionics allowed for",                 4,21, 0x02 },
{"psionics mean instant death for",      4,22, 0x02 },
{"cloning allowed for",                  4,23, 0x02 },
{"cloning required for",                 4,24, 0x02 },
{"cloning prohibited for",               4,25, 0x02 },
{"robots allowed for",                   4,26, 0x02 },
{"robots required for",                  4,27, 0x02 },
{"robots prhibited for",                 4,28, 0x02 },
{"high-tech allowed for",                4,29, 0x02 },
{"high-tech required for",               4,30, 0x02 },
{"high-tech prohibited for",             4,31, 0x02 },
{"offworld contact allowed for",         4,32, 0x02 },
{"offworld contact required for",        4,33, 0x02 },
{"offworld contact prohibited for",      4,34, 0x02 },
{"unusual gift-giving customs for",      4,35, 0x02 },
{"free food/clothing required for",      5, 0, 0x02 },
{"free food/clothing prohibited for",    5, 1, 0x02 },
{"free education required for",          5, 2, 0x02 },
{"free education prohibited for",        5, 3, 0x02 },
{"unusual punishment required for",      5, 4, 0x02 },
{"unusual punishment prohibited for",    5, 5, 0x02 },
{"unusual training required for",        5, 6, 0x02 },
{"unusual training prohibited for",      5, 7, 0x02 },
{"unusual responsibilities for",         5, 8, 0x02 },
{"fixed times for visiting",             5, 9, 0x02 },
{"bargaining/haggling required for",     5,10, 0x02 },
{"bargaining/haggling prohibited for",   5,11, 0x02 },
{"travelling far away required for",     5,12, 0x02 },
{"travelling far away prohibited for",   5,13, 0x02 },
{"unusual holidays for",                 5,14, 0x02 },
{"no holidays for",                      5,15, 0x02 },
{"unusual leasure/recreation for",       5,16, 0x02 },
{"regimited leasure/recreation for",     5,17, 0x02 },
{"unusual maturity ceremony for",        5,18, 0x02 },
{"have unusual attitudes toward for",    5,19, 0x82 },
{"unusual significance of flora for",    5,20, 0x02 },
{"unusual significance of fauna for",    5,21, 0x02 },
{"unusual significance of smell for",    5,22, 0x02 },
{"unusual significance of sound for",    5,23, 0x02 },
{"unusual significance of color for",    5,24, 0x02 },
{"unusual significance of air for",      5,25, 0x02 },
{"unusual significance of water for",    5,26, 0x02 },
{"unusual significance of light for",    5,27, 0x02 },
{"unusual significance of clothing for", 5,28, 0x02 },
{"unusual significance of computers for",5,29, 0x02 },
{"unusual significance of technolgy for",5,30, 0x02 },
{"unusual significance of robots for",   5,31, 0x02 },
{"unusual significance of art for",      5,32, 0x02 },
{"unusual significance of superstition", 5,33, 0x02 },
{"daytime rest period required for",     5,34, 0x02 },
{"daytime rest period prohibited for",   5,35, 0x02 },
{NULL,									 6,37, 0x00 }
};

CustomData::CustomData() :
	wxObject()
{
	dice = new Dice(6, 2, 0);
	Generate();
}

CustomData::~CustomData()
{
	delete dice;
}

char *
CustomData::GetCustom(char *buff)
{
int i=0;

	buff[0] = 0;
	if(customs[detail].mask & 0x80)
		{
		FormatOut(buff, group_[group], i);
		i++;
		}
	FormatOut(buff, customs[detail].desc, i);
	if(customs[detail].mask & 0x02)
		{
		strcat(buff, " ");
		strcat(buff, group_[group]);
		}
	if(customs[detail].mask & 0x01)
		{
		strcat(buff, " ");
		strcat(buff, group_[o_group]);
		}
	strcat(buff, ".");
	return(buff);
}

void CustomData::FormatOut(char *buff, char *msg, int count)
{
	if(0 == count)
		{
		char c[2];

		c[0] = toupper(msg[0]);
		c[1] = 0;
		strcat(buff, c);
		strcat(buff, &msg[1]);
		}
	else
		{
		strcat(buff, " ");
		strcat(buff, msg);
		}
}

void CustomData::Generate(void)
{
int i=0,ndx1,ndx2;

	ndx1 = dice->Roll(6,1) - 1;
	ndx2 = dice->Roll(36,1) - 1;
	detail = -1;
	while(customs[i].desc != NULL)
		{
		if((customs[i].tab_num == ndx1) && (customs[i].max_num >= ndx2))
			{
			detail = i;
			break;
			}
		i++;
		}
		
	group = GetGroup();
	o_group	= GetGroup();
}

int CustomData::GetGroup(void)
{
int i=0;

	if(dice->Roll(6,1) > 3)
		i = dice->Roll(36,1);
	return(grp_map[i]);
}

// ------------------------------------------------------------------------
CustomList::~CustomList()
{
	Clear();
}

void
CustomList::Clear(void)
{
CustomData *cd;
wxNode *n;

	n = First();
	while(n != NULL)
		{
		cd = (CustomData *)n->Data();
		delete cd;
		delete n;
		n = First();
		}
}

CustomData *
CustomList::GetCustom(int ndx)
{
wxNode *n;

	n = Nth(ndx);
	if(NULL == n) return(NULL);
	return((CustomData *)n->Data());
}

// =========================================================================
// =========================================================================
// =========================================================================
SocialData::SocialData(double p, int g, int l,
		int t, char pt, int atm, int hyd, int wd) :
	wxObject()
{
	tot_pop = new Population(p);
	SubInit(g, l, t, pt, atm, hyd, wd);
}

SocialData::SocialData(int p, int p_ndx, int g, int l,
		int t, char pt, int atm, int hyd, int wd) :
	wxObject()
{
	tot_pop = new Population(p, p_ndx);
	SubInit(g, l, t, pt, atm, hyd, wd);
}

void
SocialData::SubInit(int g, int l, int t, char pt, int atm, int hyd, int wd)
{
int gv,p,p_ndx;

	dice = new Dice(6, 2, 0);

	p = tot_pop->get_t_hex_val();
	p_ndx = tot_pop->GetPopMult();
	GenOutlook(p, g, l);
	tot_pop = new Population(p, p_ndx);
	govt = new Govt(g, wd);
	law = new Law(l, p, ext_glob);
	tech = new Tech(t, pt, p, ext_glob, ext_int,
			agg_att, agg_act, atm, hyd);
	gv = govt->GetTrueGovt();

	cust_list = new CustomList();
	GenCustoms();
	city_list = new CityList();
	GenCities(pt, atm);

	if((13 == gv) || (14 == gv))
		religion = new Religion(1, p, t);
	else
		religion = new Religion(0, p, t);
}

SocialData::~SocialData()
{
	if(tot_pop) delete tot_pop;
	if(cust_list) delete cust_list;
	if(city_list) delete city_list;
	if(govt) delete govt;
	if(law) delete law;
	if(tech) delete tech;
	if(religion) delete religion;
	delete dice;
}

void
SocialData::Generate(int p, int p_ndx, int g, int l,
		int t, char pt, int atm, int hyd, int wd)
{
int gv;

	GenOutlook(p, g, l);
	tot_pop->Generate(p, p_ndx);
//	govt->Generate(g, wd);
	govt->Generate();
	law->Generate(p, ext_glob);
	tech->Generate(pt, p, ext_glob, ext_int, agg_att, agg_act, atm, hyd);
	gv = govt->GetTrueGovt();

	cust_list->Clear();
	GenCustoms();
	city_list->Clear();
	GenCities(pt, atm);

	if((13 == gv) || (14 == gv))
		religion->Generate(1, p, t);
	else
		religion->Generate(0, p, t);
}

void 
SocialData::GenOutlook(int p, int g, int l)
{
int i;

	i = dice->Roll(6, 2);
	if(p > 5) i++;
	if(p > 8) i++;
	if(i < 4)
		prog_att = 0;
	else if(i < 8)
		prog_att = 1;
	else if(i < 12)
		prog_att = 2;
	else
		prog_att = 3;

	i = dice->Roll(6, 2);
	if(prog_att == 2) i += 3;
	if(prog_att == 3) i += 6;
	if(l > 9) i++;
	if(i < 6)
		prog_act = 0;
	else if(i < 10)
		prog_act = 1;
	else if(i < 13)
		prog_act = 2;
	else
		prog_act = 3;

	i = dice->Roll(6, 2);
	if(l > 9) i++;
	if(i < 4)
		agg_att = 0;
	else if(i < 7)
		agg_att = 1;
	else if(i < 11)
		agg_att = 2;
	else
		agg_att = 3;

	i = dice->Roll(6, 2);
	if(agg_att == 0) i -= 2;
	if(agg_att == 1) i -= 1;
	if(agg_att == 3) i += 2;
	if(l > 9) i++;
	if(i < 5)
		agg_act = 0;
	else if(i < 9)
		agg_act = 1;
	else if(i < 12)
		agg_act = 2;
	else
		agg_act = 3;

	i = dice->Roll(6, 2);
	if(g < 3) i++;
	if(g == 7) i += 4;
	if(g == 15) i -= 1;
	if(agg_att == 3) i += 2;
	if(l < 5) i++;
	if(l > 9) i--;
	if(i < 4)
		ext_glob = 0;
	else if(i < 8)
		ext_glob = 1;
	else if(i < 12)
		ext_glob = 2;
	else
		ext_glob = 3;

	i = dice->Roll(6, 2);
	if(prog_att == 2) i += 2;
	if(prog_att == 3) i += 4;
	if(l > 9) i++;
	if(i < 4)
		ext_int = 0;
	else if(i < 8)
		ext_int = 1;
	else if(i < 12)
		ext_int = 2;
	else
		ext_int = 3;
}

void 
SocialData::AddOrbital(char pt, int t, int prim_size)
{
CityData *cd;
int j;

	if(pt == 'A')
		j = prim_size - 1;
	else if(pt == 'B')
		j = prim_size - 2;
	else 
		j = prim_size - 3;
	if(j > (t - 6))
		j = t - 6;
	if(j < 0)
		return;

	cd = new CityData(pt, j, dice->Roll(9, 1), CT_ORBIT);
	if(cd->GetPop() > rural_pop)
		cd->AdjPop(rural_pop);
	rural_pop -= cd->GetPop();
	city_list->Append(cd);
}

int 
SocialData::CheckOrbital(char pt, int t)
{
int k;

	k = dice->Roll(6, 2);
	if((pt == 'A') || (pt == 'B') || 
		(((pt == 'C') || (pt == 'F')) && (k < t)))
		return(1);
	else
		return(0);
}

void 
SocialData::GenCities(char pt, int atm)
{
int i,j,k,orb_pop,orb_mult;
int prim_size;
int orb_count=0;
//int p1=0;						// primary city size
int r1,r2,r3;					// rolls for pop,pop-1,pop-3 cities
double e;

	pt = toupper(pt);
	prim_size = -1;

    i = 0;							// allocation counter
	rural_pop = tot_pop->GetPop(); // assume they're all here
// first, check for orbital
	orb_pop = orb_mult = 0;
	if((atm > 9) && (atm < 13) && (tech->get_t_hex_val() > 8) && 
			(dice->Roll(6,3,-3) < tot_pop->get_t_hex_val()))
		{
		orb_pop = tech->get_t_hex_val() - 6;
		if(orb_pop > tot_pop->get_t_hex_val())
			{
			// everyone's in orbit
			prim_size = tot_pop->get_t_hex_val();
			orb_pop = tot_pop->get_t_hex_val();
			orb_mult = tot_pop->GetPopMult();
			}
		else
			orb_mult = dice->Roll(9,1);

		if(orb_pop > -1)
			{
			while((orb_mult) && (rural_pop > pow(10, orb_pop)))
				{
				CityData *cd;

				j = dice->Roll(orb_mult, 1);
				orb_mult -= j;
				cd = new CityData(pt, orb_pop, j, CT_ORBIT);
				if(cd->GetPop() > rural_pop)
					cd->AdjPop(rural_pop);
				rural_pop -= cd->GetPop();
				city_list->Append(cd);
				orb_count++;
				}
			orb_mult = 1;			// aux flag
			}
		}

	j = 0;						// intermediate flag
// check for a single city
	if(tot_pop->get_t_hex_val() < 5)
		{
		if(dice->Roll(6, 1) < tot_pop->get_t_hex_val())
			{
			j = 0;
			// if orbital is possible, check if entire pop is there
			//  otherwise, split it into 2 cities
			if((0 == orb_mult) && CheckOrbital(pt, tech->get_t_hex_val()))
				{
				orb_pop = tech->get_t_hex_val() - 6;	// orbital uwp pop
				if(orb_pop > tot_pop->get_t_hex_val())
					{
					prim_size = tot_pop->get_t_hex_val();
					orb_pop = tot_pop->get_t_hex_val();
					orb_mult = tot_pop->GetPopMult();
					j = 1;
					}
				else
					orb_mult = dice->Roll(9, 1);

				if(orb_pop > -1)
					{
					CityData *cd;

					cd = new CityData(pt, orb_pop, orb_mult, CT_ORBIT);
					if(cd->GetPop() > rural_pop)
						cd->AdjPop(rural_pop);
					rural_pop -= cd->GetPop();
					city_list->Append(cd);
					orb_count++;
					}
				}
			else
				prim_size = tot_pop->get_t_hex_val();

			if(0 == j)
				{
				CityData *cd;

				cd = new CityData(pt, tot_pop->get_t_hex_val(),
						tot_pop->GetPopMult(), CT_PRIMARY);
				if(cd->GetPop() > rural_pop)
					cd->AdjPop(rural_pop);
				rural_pop -= cd->GetPop();
				city_list->Append(cd);
 				j = 1;				// one city
 				}
			}
		else if(tot_pop->get_t_hex_val() < 3)
			j = 1;				// no cities at all!
		}

	if((j == 0) && (rural_pop > 0.0))
		{
// find the primary sizes
		r1 = r2 = r3 = 0;
		if(dice->Roll(6,3) < tot_pop->get_t_hex_val()) r1 = 1;
		if(dice->Roll(6,2) < tot_pop->get_t_hex_val()) r2 = 1;
		if(dice->Roll(6,1) < tot_pop->get_t_hex_val()) r3 = 1;
		if(prim_size < 0)
			{
			if(r1) prim_size = tot_pop->get_t_hex_val();
			else if(r2) prim_size = tot_pop->get_t_hex_val() - 1;
			else if(r3) prim_size = tot_pop->get_t_hex_val() - 2;
			else prim_size = tot_pop->get_t_hex_val() - 3;
			}
// check for C or F ports
		if(orb_mult == 0)
			{
			k = dice->Roll(6,2);
			if(((pt == 'C') || (pt == 'F')) && (k < tech->get_t_hex_val()))
				{
				orb_pop = tech->get_t_hex_val() - 6;
				if(orb_pop > (prim_size - 1))
					orb_pop = prim_size - 1;
				if(orb_pop > -1)
					{
					CityData *cd;

					cd = new CityData(pt, orb_pop, dice->Roll(9, 1), CT_ORBIT);
					if(cd->GetPop() > rural_pop)
						cd->AdjPop(rural_pop);
					rural_pop -= cd->GetPop();
					city_list->Append(cd);

					i++;
					orb_count++;
					orb_mult = 1;
					}
				}
			}
			
		// very large cities
		if((r1) && (rural_pop > pow(10, tot_pop->get_t_hex_val())))	
			{
			k = tot_pop->GetPopMult();
			while((k) && (rural_pop > pow(10, tot_pop->get_t_hex_val())))
				{
				CityData *cd;

				j = dice->Roll(k,1);
				cd = new CityData(pt, tot_pop->get_t_hex_val(), j, CT_PRIMARY);
				if(cd->GetPop() > rural_pop)
					cd->AdjPop(rural_pop);
				rural_pop -= cd->GetPop();
				city_list->Append(cd);
				k -= j;
				i++;
				if((orb_mult == 0) && ((pt == 'A') || (pt == 'B')) &&
					(cd->GetPort() == pt))
					{
					AddOrbital(pt, tech->get_t_hex_val(), prim_size);
					i++;
					orb_count++;
					}
				}
			if(orb_count)
				orb_mult = 1;                 
// check for a orb city here (A only)
			else if(pt == 'A')
				{
				AddOrbital(pt, tech->get_t_hex_val(), prim_size);
				i++;
				orb_mult = 1;
				}
			}
		// large cities
		if((r2) && (rural_pop > pow(10, (tot_pop->get_t_hex_val() - 1))))
			{
			e = rural_pop;
			while(e > (rural_pop / 2.0))
				{
				CityData *cd;

				j = dice->Roll(9, 1);
				cd = new CityData(pt, tot_pop->get_t_hex_val() - 1, j, 
								CT_PRIMARY);
				i++;
				if(cd->GetPop() > rural_pop)
					cd->AdjPop(rural_pop);
				e -= cd->GetPop();
				city_list->Append(cd);
				if((orb_mult == 0) && ((pt == 'A') || (pt == 'B')) &&
					(cd->GetPort() == pt))
					{
					AddOrbital(pt, tech->get_t_hex_val(), prim_size);
					i++;
					orb_count++;
					}
				}
			rural_pop = e;
			if(orb_count)
				orb_mult = 1;
// check for a orb city here (A and B)
			else if((pt == 'A') || (pt == 'B'))
				{
				AddOrbital(pt, tech->get_t_hex_val(), prim_size);
				i++;
				orb_mult = 1;
				}
			}
		// medium large cities
		if((r3) && (rural_pop > pow(10, (tot_pop->get_t_hex_val() - 2))))
			AddSubCity(pt, tot_pop->get_t_hex_val() - 2, 1);
		// moderate cities
		if(tot_pop->get_t_hex_val() > 3)
			AddSubCity(pt, tot_pop->get_t_hex_val() - 3, 10);
		// small cities
		if(tot_pop->get_t_hex_val() > 4)
			AddSubCity(pt, tot_pop->get_t_hex_val() - 4, 100);
		// very small cities
		if(tot_pop->get_t_hex_val() > 5)
			AddSubCity(pt, tot_pop->get_t_hex_val() - 5, 1000);
		}
}

void
SocialData::AddSubCity(char port, int u_pop, int multiplier)
{
SubCity *sc;
int l_number,number;

	number = ((int) (rural_pop / pow(10, tot_pop->get_t_hex_val()))) * 
			dice->Roll(6,1,9) * multiplier;
	if(number)
		{
		sc = new SubCity(port, u_pop, number);
		city_list->Append(sc);

		l_number = (sc->GetCount() * dice->Roll(6, 3, -3) / 100);
		rural_pop -= (((number - l_number) * 5) + (l_number * 9)) *
				pow(10, u_pop);
		}
//fprintf(stderr, "\n%c %d %d; #:%d %d  rural:%.0f", port, u_pop, multiplier,
//	number, l_number, rural_pop);
}

void
SocialData::GenCustoms(void)
{
int i,j;

	j = dice->Roll(6, 1);
	for(i = 0;i < j;i++)
		{
		CustomData *cd;

		cd = new CustomData();
		cust_list->Append(cd);
		}
}

#if 0
void SocialData::PrintSoc(FILE *stdlog)
{
int i,j;

	fprintf(stdlog, "         Total Population: %.0f\n", tot_pop->get_pop());

	for(i = 0;i < 3;i++)
		j = print_city(stdlog,i);

	if(med_large_cities.PrintCity(stdlog, j))
		j++;
	if(mod_cities.PrintCity(stdlog, j))
		j++;
	if(small_cities.PrintCity(stdlog, j))
		j++;
	if(vsmall_cities.PrintCity(stdlog, j))
		j++;

	print_city(stdlog,-1);			// orbitals

	fprintf(stdlog, "         Rural Population: %.0f\n", rural_pop);

	fprintf(stdlog, "\n   Customs: \n");
    print_customs(stdlog);
	fprintf(stdlog, "\n");

	print_outlook(stdlog);
	fprintf(stdlog, "\n");

	if(religion != NULL)
		{
		religion->PrintShortRel(stdlog);
		fprintf(stdlog, "\n");
		}
	if(govt != NULL)
		{
		govt->PrintGovt(stdlog);
		fprintf(stdlog, "\n");
		}
	if(law != NULL)
		{
		law->PrintLaw(stdlog);
		fprintf(stdlog, "\n");
		}
	if(tech != NULL)
		{
		tech->PrintTech(stdlog);
		fprintf(stdlog, "\n");
		}
}

int SocialData::print_city(FILE *stdlog, int which)
{
City *s2;
int i,j;

	i = 0;
	s2 = (City *) city_list->first();
	while(s2 != NULL)
		{
		if((j = s2->get_class()) == which)
			{
			if(i)
				fprintf(stdlog, "                           ");
			else
				fprintf(stdlog, "         %s: ", city_class[which+1]);
			s2->PrintCity(stdlog);
			i++;
			}
		s2= (City *) city_list->next();
		}
	return(i);
}

char *SocialData::city_class[4] = {
	"  Primary Cities",
	"Secondary Cities",
	" Tertiary Cities",
	"  Orbital Cities"
};
#endif

char *SocialData::outlook_str[6][4] =
{{	"Radical",
	"Progressive",
	"Conservative",
	"Reactionary"},
{	"Enterprising",
	"Advancing",
	"Indifferent",
	"Stagnant"},
{	"Expansionistic",
	"Competitive",
	"Unaggressive",
	"Passive"},
{	"Militant",
	"Neutral",
	"Peaceable",
	"Concillatory"},
{	"Monolithic",
	"Harmonious",
	"Discordant",
	"Fragmented"},
{	"Xenophilic",
	"Friendly",
	"Aloof",
	"Xenophobic"}
};

#if 0
int SocialData::print_customs(FILE *stdlog)
{
Custom *s1;
int i=0;

	s1 = (Custom *)cust_list->first();
	while(s1 != NULL)
		{
		fprintf(stdlog, "     ");
		s1->PrintCustom(stdlog);
		s1 = (Custom *)cust_list->next();
		i++;
		}
	return(i);
}

void 
SocialData::print_outlook(FILE *stdlog)
{
	fprintf(stdlog, " Progressiveness Attitude: %s\n", outlook_str[0][prog_att]);
	fprintf(stdlog, "   Progressiveness Action: %s\n", outlook_str[1][prog_act]);
	fprintf(stdlog, "  Aggressiveness Attitude: %s\n", outlook_str[2][agg_att]);
	fprintf(stdlog, "    Aggressiveness Action: %s\n", outlook_str[3][agg_act]);
	fprintf(stdlog, "     Extensiveness Global: %s\n", outlook_str[4][ext_glob]);
	fprintf(stdlog, " Extensiveness Interstelr: %s\n", outlook_str[5][ext_int]);
}
#endif

// ------------------------------------------------------------------------
SocList::SocList() :
	wxList()
{
	dice = new Dice(6, 2, 0);
}

SocList::~SocList()
{
	Clear();
	delete dice;
}

double
SocList::GetPop(void)
{
int i=0;
double ret=0.0;
SocialData *sd;

	while((sd = GetSoc(i++)) != NULL)
		{
		Population *p;

		p = sd->GetTotPop();
		ret += p->GetPop();
		}

	return(ret);
}

void
SocList::Clear(void)
{
SocialData *cd;
wxNode *n;

	n = First();
	while(n != NULL)
		{
		cd = (SocialData *)n->Data();
		delete cd;
		delete n;
		n = First();
		}
}

SocialData *
SocList::GetSoc(int ndx)
{
wxNode *n;

	n = Nth(ndx);
	if(NULL == n) return(NULL);
	return((SocialData *)n->Data());
}

#define MAX_BALK		5
void
SocList::Generate(planet *p, int wd)
{
char pt;
int pop,p_ndx,g,l,t,atm,hyd;
SocialData *sd;

	Clear();
	pt = p->get_port();
	atm = p->get_atmos_val();
	hyd = p->get_hydro_val();
	pop = p->get_pop_val();
	// FIXME: !!!!!!!
	p_ndx = -1;
	g = p->get_govt_val();
	l = p->get_law_val();
	t = p->get_tech_val();

	if(pop < 0) return;
	if(7 == g)
		{
		int j,k;
		int num;
		double tot_pop_val,dist_pop;
		Population *temp_pop;

		if(p_ndx < 1)
			p_ndx = dice->Roll(9, 1);

		num = dice->Roll(MAX_BALK, 1);
		temp_pop = new Population(pop, p_ndx);
		tot_pop_val = temp_pop->GetPop();
		dist_pop = temp_pop->GetPop() / num;
		delete temp_pop;

//fprintf(stderr, "\nX: %d %.0f %.0f", num, tot_pop_val, dist_pop);
		// allocate to seperate 'countries'
		j = 0;
		while((j < num) && (tot_pop_val > 0.0))
			{
			int new_pop_val,new_pop_mult;
			int new_govt,new_law;
			double new_pop;

			// alocate pop
			temp_pop = new Population(dist_pop);
			new_pop_val = temp_pop->get_t_hex_val();
			new_pop_mult = temp_pop->GetPopMult();
			if(new_pop_val > 1)
				{
				new_pop_mult -= dice->Roll(6, 2, -2);
				if(new_pop_mult < 0)
					{
					new_pop_mult += 10;
					new_pop_val--;
					}
				delete temp_pop;
				temp_pop = new Population(new_pop_val, new_pop_mult);
				}
			if(temp_pop->GetPop() > dist_pop)
				{
				temp_pop->SetPop(dist_pop);
				new_pop_val = temp_pop->get_t_hex_val();
				new_pop_mult = temp_pop->GetPopMult();
				}
			new_pop = temp_pop->GetPop();
			tot_pop_val -= new_pop;
			delete temp_pop;

			// figure new govt
			k = dice->Roll(6, 2, new_pop_val - 7);
			if(7 == k)
				{
				if(new_pop_val > 7)
					k = dice->Roll(5, 1, 7);
				else
					k = dice->Roll(5, 1, 1);
				}
			if(k < 0) k = 0;
			new_govt = k;

			// figure new law
			new_law = dice->Roll(6, 2, new_govt - 7);
			if(new_law < 0) new_law = 0;

			sd = new SocialData(new_pop, new_govt,
						new_law, t, pt, atm, hyd, wd);
			Append(sd);
			j++;
			}
		}
	else
		{
		sd = new SocialData(pop, p_ndx, g, l, t, pt, atm, hyd, wd);
		Append(sd);
		}
}

