
/*
 * File:      detail.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: detail.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */


#include <stdio.h>
#include <math.h>
#include "detail.h"

Detail::Detail()
{
int i;

	for(i = 0;i < MAX_STARS;i++)
		stars[i] = NULL;
	par = NULL;
	size = NULL;
	atmos = NULL;
	hydro = NULL;
	resources = NULL;
	soc_list = new SocList();
}

Detail::~Detail()
{
	ClearAll();
	delete soc_list;
}

// ----------------------------------------------------------------------
void
Detail::ClearAll(void)
{
int i;

	for(i = 0;i < MAX_STARS;i++)
		{
		if(stars[i] != NULL)
			delete stars[i];
		stars[i] = NULL;
		}

	ClearPar();
}

void
Detail::ClearPar(void)
{
	if(par != NULL)
		delete par;
	par = NULL;

	ClearDetail();
}

void
Detail::ClearDetail(void)
{
	if(size != NULL)
		{
		switch(size->GetType())
			{
			case ST_GG:
				{
				GGSize *sz = (GGSize *)size;
				delete sz;
				break;
				}
			case ST_BELT:
				{
				BeltSize *sz = (BeltSize *)size;
				delete sz;
				break;
				}
			case ST_WORLD:
				{
				WorldSize *sz = (WorldSize *)size;
				delete sz;
				break;
				}
			case ST_SAT:
				{
				SatSize *sz = (SatSize *)size;
				delete sz;
				break;
				}
			default:
				break;
			}
		}
	size = NULL;

	if(atmos != NULL)
		delete atmos;
	atmos = NULL;

	if(hydro != NULL)
		delete hydro;
	hydro = NULL;

	if(resources != NULL)
		delete resources;
	resources = NULL;

	soc_list->Clear();
}

// ----------------------------------------------------------------------
void
Detail::AddStar(int ndx, int t, int c, int s, float orb, float p_mass)
{
	if((ndx >= 0) && (ndx < MAX_STARS))
		{
		if(stars[ndx] != NULL)
			delete stars[ndx];
		stars[ndx] = new StarInfo(t, c, s, orb, p_mass);
		}
}

void
Detail::AddParent(short s, float orb, float p_mass, float e, float m, 
		int u, int n)
{
	par = new ParentSize(s, orb, p_mass, e, m, u, n);
}

void
Detail::AddParent(char c, float orb, float p_mass, float e, float m, 
		int u, int n)
{
	par = new ParentSize(c, orb, p_mass, e, m, u, n);
}

// ----------------------------------------------------------------------
void
Detail::AddSatDetail(SatOrbit *so, int star_type)
{
int pre_stress;
int hab_zone;
float min_l,mean_l,max_l;
planet *p;
WorldOrbit *wo;

	p = so->GetSat();
	wo = (WorldOrbit *)so->GetParent();
	pre_stress = GetPreStress(wo);
	hab_zone = so->GetHabitible();
	GetLumins(wo, &min_l, &mean_l, &max_l);

	AddDetail(p, so->GetOrbit(), par->GetMass(), pre_stress, 0, hab_zone, 
				par->GetUWPSize(), min_l, mean_l, max_l, star_type, 
				par->GetMass());
}

void
Detail::AddWorldDetail(WorldOrbit *wo, int star_type)
{
int num_sat=0;
int i=0;
int pre_stress;
int hab_zone;
float p_mass;
float min_l,mean_l,max_l;
planet *p;
StarOrbit *so;
DetailStar *ds;

	so = (StarOrbit *)wo->GetParent();
	ds = so->GetStar();
	p_mass = ds->GetMass();
	pre_stress = GetPreStress(wo);
	hab_zone = wo->GetHabitible();
	GetLumins(wo, &min_l, &mean_l, &max_l);

	while(wo->GetSat(i) != NULL)
		i++;
	num_sat = i;

	p = wo->GetWorld();

	if(p->is_gg())
		size = new GGSize(p->get_size_val(), wo->GetOrbit(), p_mass, num_sat);
	else 
		{
		AddDetail(p, wo->GetOrbit(), p_mass, pre_stress, num_sat, hab_zone, -1, 
				min_l, mean_l, max_l, star_type, 0.0);
		}
}

void
Detail::AddDetail(planet *p, float orbit, float p_mass, int pre_stress,
		int num_sat, int hab_zone, int p_size, float min_l, float mean_l,
		float max_l, int star_type, float par_mass)
{
float rot;
WORLD_CORE core;
int nat_life,stress,atm_comp;
WorldSize *ws;

	if(0 == p->get_size_val())
		{
		size = new BeltSize(hab_zone, orbit, p_mass);
		nat_life = 0;
		stress = 0;
		atm_comp = 0;
		core = WC_ROCKY;
		}
	else
		{
		// size
		if(p_size < 0)
			{
			size = new WorldSize(p->get_size_val(), orbit, p_mass, 
				pre_stress, p->get_atmos_val(), num_sat, hab_zone);
			ws = (WorldSize *)size;
			rot = ws->GetRotPeriod();
			}
		else
			{
			SatSize *ss;
			size = new SatSize(p->get_size_val(), orbit, p_mass, pre_stress, 
				p->get_atmos_val(), num_sat, hab_zone, p_size, par_mass);
			ss = (SatSize *)size;
			rot = ss->GetEffPeriod();
			}
		ws = (WorldSize *)size;

		// atmos
		atmos = new Atmos(p, hab_zone, min_l, mean_l, max_l, 
				ws->orb->GetEccen(), ws->GetTilt(), star_type, rot);
		// hydro
		nat_life = atmos->GetLife();
		core = ws->GetCoreVal();
		stress = ws->GetStress();
		atm_comp = atmos->GetComp();
		hydro = new Hydro(p, nat_life, core, stress, atm_comp);
		}
	// resources
	resources = new Resources(core, p, nat_life);
	// pop soc?
	soc_list->Generate(p, 0);
}

int 
Detail::GetPreStress(WorldOrbit *wo)
{
int i=0,j,k;
float f=0.0,g;
SatOrbit *so;
planet *s;

	while((so = wo->GetSat(i)) != NULL)
		{
		i++;
		s = so->GetSat();
		j = s->get_size_val();
		if(SIZE_SMALL == j)
			g = 600 * 1.6;
		else  if(j <= 10)
			g = j * 1000 * 1.6;
		else
			continue;
		k = (int) so->GetOrbit();
		f += g / (k * 64);
		}
	
	return((int) f);
}

void
Detail::GetLumins(WorldOrbit *wo, float *mn, float *mean, float *mx)
{
int i,sndx=0,orbit;
// orbs
float min[5],max[5];

	orbit = wo->GetIntOrbit();
	sndx = GetStarIndex(wo);
	*mn = *mean = *mx = 0.0;
	
	GetMinOrb(orbit, sndx, &min[0]);
	GetMaxOrb(orbit, sndx, &max[0]);

/* NOTE!!!!!  these may seem reversed, but
	min dist gives max lumin and
	max dist gives min lumin */
	for(i = 0;i < 5;i++)
		{
		if(stars[i] == NULL) continue;
		*mn += stars[i]->GetLumin() / sqrt(max[i]);
		*mx += stars[i]->GetLumin() / sqrt(min[i]);
		*mean += (stars[i]->GetLumin() / sqrt(min[i]) +
				stars[i]->GetLumin() / sqrt(max[i])) / 2;
		}
}

void 
Detail::GetMinOrb(int orb, int sndx, float min[])
{
int i;

	for(i = 0;i < 5;i++)
		min[i] = 0.0;

	switch(sndx)
		{
		case 0:
			min[0] = stars[0]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				min[1] = 
					fabs(stars[1]->GetAUOrbit() - stars[0]->ConvOrbToAU(orb));
			if(stars[2] != NULL) 
				min[2] = 
					fabs(stars[2]->GetAUOrbit() - stars[0]->ConvOrbToAU(orb));
			if(stars[3] != NULL) 
				min[3] = fabs(min[1] - stars[3]->GetAUOrbit());
			if(stars[4] != NULL) 
				min[4] = fabs(min[2] - stars[4]->GetAUOrbit());
			break;
		case 1:
			min[0] = fabs(stars[1]->GetAUOrbit() - stars[1]->ConvOrbToAU(orb));
			if(stars[1] != NULL) 
				min[1] = stars[1]->ConvOrbToAU(orb);
			if(stars[2] != NULL) 
				min[2] = fabs(stars[2]->GetAUOrbit() - min[0]);
			if(stars[3] != NULL) 
				min[3] = 
					fabs(stars[3]->GetAUOrbit() - stars[1]->ConvOrbToAU(orb));
			if(stars[4] != NULL) 
				min[4] = fabs(min[2] - stars[4]->GetAUOrbit());
			break;
		case 2:
			min[0] = fabs(stars[2]->GetAUOrbit() - stars[2]->ConvOrbToAU(orb));
			if(stars[1] != NULL) 
				min[1] = fabs(stars[1]->GetAUOrbit() - min[0]);
			if(stars[2] != NULL) 
				min[2] = stars[2]->ConvOrbToAU(orb);
			if(stars[3] != NULL) 
				min[3] = fabs(stars[3]->GetAUOrbit() - min[1]);
			if(stars[4] != NULL) 
				min[4] = 
					fabs(stars[4]->GetAUOrbit() - stars[2]->ConvOrbToAU(orb));
			break;
		case 3:
			min[0] = fabs(stars[1]->GetAUOrbit() - stars[3]->GetAUOrbit() - 
				stars[3]->ConvOrbToAU(orb));
			if(stars[1] != NULL) 
				min[1] = 
					fabs(stars[3]->GetAUOrbit() - stars[3]->ConvOrbToAU(orb));
			if(stars[2] != NULL) 
				min[2] = fabs(stars[2]->GetAUOrbit() - stars[1]->GetAUOrbit() - 
					min[3]);
			if(stars[3] != NULL) 
				min[3] = stars[3]->ConvOrbToAU(orb);
			if(stars[4] != NULL) 
				min[4] = fabs(min[2] - stars[4]->GetAUOrbit() );
			break;
		case 4:
			min[0] = fabs(stars[2]->GetAUOrbit() - stars[4]->GetAUOrbit() - 
				stars[4]->ConvOrbToAU(orb));
			if(stars[1] != NULL) 
				min[1] = fabs(stars[1]->GetAUOrbit() - stars[2]->GetAUOrbit() - 
					stars[3]->GetAUOrbit() - stars[4]->ConvOrbToAU(orb));
			if(stars[2] != NULL) 
				min[2] = fabs(stars[4]->GetAUOrbit() - 
					stars[4]->ConvOrbToAU(orb));
			if(stars[3] != NULL) 
				min[3] = fabs(stars[2]->GetAUOrbit() - stars[1]->GetAUOrbit() - 
					stars[3]->GetAUOrbit() - stars[4]->GetAUOrbit() - 
						stars[4]->ConvOrbToAU(orb));
			if(stars[4] != NULL) 
				min[4] = stars[4]->ConvOrbToAU(orb);
			break;
		}
}

void 
Detail::GetMaxOrb(int orb, int sndx, float max[])
{
int i;

	for(i = 0;i < 5;i++)
		max[i] = 0.0;

	switch(sndx)
		{
		case 0:
			max[0] = stars[0]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				max[1] = stars[1]->GetAUOrbit() + stars[0]->ConvOrbToAU(orb);
			if(stars[2] != NULL) 
				max[2] = stars[2]->GetAUOrbit() + stars[0]->ConvOrbToAU(orb);
			if(stars[3] != NULL) 
				max[3] = max[1] + stars[3]->GetAUOrbit();
			if(stars[4] != NULL) 
				max[4] = max[2] + stars[4]->GetAUOrbit();
			break;
		case 1:
			max[0] = stars[1]->GetAUOrbit() + stars[1]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				max[1] = stars[1]->ConvOrbToAU(orb);
			if(stars[2] != NULL) 
				max[2] = stars[2]->GetAUOrbit() + max[0];
			if(stars[3] != NULL) 
				max[3] = stars[3]->GetAUOrbit() + stars[1]->ConvOrbToAU(orb);
			if(stars[4] != NULL) 
				max[4] = max[2] + stars[4]->GetAUOrbit();
			break;
		case 2:
			max[0] = stars[2]->GetAUOrbit() + stars[2]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				max[1] = stars[1]->GetAUOrbit() + max[0];
			if(stars[2] != NULL) 
				max[2] = stars[2]->ConvOrbToAU(orb);
			if(stars[3] != NULL) 
				max[3] = stars[3]->GetAUOrbit() + max[1];
			if(stars[4] != NULL) 
				max[4] = stars[4]->GetAUOrbit() + stars[2]->ConvOrbToAU(orb);
			break;
		case 3:
			max[0] = stars[1]->GetAUOrbit() + stars[3]->GetAUOrbit() + 
					stars[3]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				max[1] = stars[3]->GetAUOrbit() + stars[3]->ConvOrbToAU(orb);
			if(stars[2] != NULL) 
				max[2] = stars[2]->GetAUOrbit() + stars[1]->GetAUOrbit() + 
						max[3];
			if(stars[3] != NULL) 
				max[3] = stars[3]->ConvOrbToAU(orb);
			if(stars[4] != NULL) 
				max[4] = fabs(max[2] + stars[4]->GetAUOrbit());
			break;
		case 4:
			max[0] = stars[2]->GetAUOrbit() + stars[4]->GetAUOrbit() + 
					stars[4]->ConvOrbToAU(orb);
			if(stars[1] != NULL) 
				max[1] = stars[1]->GetAUOrbit() + stars[2]->GetAUOrbit() + 
						stars[3]->GetAUOrbit() + stars[4]->ConvOrbToAU(orb);
			if(stars[2] != NULL) 
				max[2] = stars[4]->GetAUOrbit() + stars[4]->ConvOrbToAU(orb);
			if(stars[3] != NULL) 
				max[3] = stars[2]->GetAUOrbit() + stars[1]->GetAUOrbit() + 
						stars[3]->GetAUOrbit() + stars[4]->GetAUOrbit() + 
								stars[4]->ConvOrbToAU(orb);
			if(stars[4] != NULL) 
				max[4] = stars[4]->ConvOrbToAU(orb);
			break;
		}
}

int 
Detail::GetStarIndex(WorldOrbit *wo)
{
StarOrbit *so;

	so = (StarOrbit *)wo->GetParent();
	if(so->GetOrbType() & ORBIT_IS_PRIMARY)
		return(0);
	
	if(so->GetOrbOrbitType() & ORBIT_ORBITS_PRIMARY)
		{
		if(so->GetOrbOrbitType() & ORBIT_SECOND_STAR)
			return(2);
		else
			return(1);
		}

	if(so->GetOrbOrbitType() & ORBIT_SECOND_STAR)
		return(4);
	else
		return(3);
};

// ----------------------------------------------------------------------
void
Detail::Generate(BaseOrbit *bo, int star_type)
{
int zone_flag,pre_stress,stress,atm,life,atm_comp;
float p_mass,min_l,mean_l,max_l,tilt,rot;
WORLD_CORE core;
planet *p;
WorldOrbit *wo;
SatOrbit *sto;
StarOrbit *so;
DetailStar *ds;

	if(size != NULL)
		{
		if(bo->GetOrbType() & ORBIT_IS_SAT)
			{
			sto = (SatOrbit *)bo;
			p = sto->GetSat();
			wo = (WorldOrbit *)sto->GetParent();

			p_mass = par->GetMass();
			pre_stress = GetPreStress(wo);
			zone_flag = sto->GetHabitible();
			GetLumins(wo, &min_l, &mean_l, &max_l);
			}
		else
			{
			wo = (WorldOrbit *)bo;
			p = wo->GetWorld();
			so = (StarOrbit *)wo->GetParent();
			ds = so->GetStar();

			p_mass = ds->GetMass();
			pre_stress = GetPreStress(wo);
			zone_flag = wo->GetHabitible();
			GetLumins(wo, &min_l, &mean_l, &max_l);
			}

		if(size->GetType() == ST_GG)
			{
			GGSize *sz = (GGSize *)size;
			sz->Generate();
			return;
			}
		else if(size->GetType() == ST_BELT)
			{
			BeltSize *sz = (BeltSize *)size;
			sz->Generate(zone_flag);
			atm_comp = 0;
			core = WC_ROCKY;
			}
		else
			{
			WorldSize *sz = (WorldSize *)size;

			if(atmos != NULL)
				atm = atmos->get_t_hex_val();
			else
				atm = 0;

			sz->Generate(p_mass, pre_stress, atm, zone_flag);
			if(size->GetType() == ST_WORLD)
				{
				tilt = sz->GetTilt();
				rot = sz->GetRotPeriod();
				core = sz->GetCoreVal();
				stress = sz->GetStress();
				}
			else if(size->GetType() == ST_SAT)
				{
				SatSize *sz = (SatSize *)size;
				sz->Generate(p_mass);
				tilt = sz->GetTilt();
				rot = sz->GetEffPeriod();
				core = sz->GetCoreVal();
				stress = sz->GetStress();
				}
			}

		if(atmos != NULL)
			{
			atmos->Generate(p, zone_flag, min_l, mean_l, max_l, 
				size->orb->GetEccen(), tilt, star_type, rot);
			life = atmos->GetLife();
			atm_comp = atmos->GetComp();
			}
		else
			{
			life = 0;
			stress = 0;
			}

		if(hydro != NULL)
			{
			hydro->Generate(p, life, core, stress, atm_comp);
			}
	
		soc_list->Generate(p, 0);
		}
}

