
/*
 * File:      atmos.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: atmos.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "atmos.h"

Atmos::Atmos(uwp *u, int zone_flag, float min_l, float mean_l, float max_l, 
	float ecc, float tilt, int star_type, float rot) :
		atmos_desc(u->get_atmos_val())
{
	dice = new Dice(6, 2, 0);
	base_temp = new Temp();
	terr_temp = NULL;
	Generate(u, zone_flag, min_l, mean_l, max_l, ecc, tilt, star_type, rot);
}

Atmos::~Atmos()
{
	if(base_temp != NULL)
		delete base_temp;
	if(terr_temp != NULL)
		delete terr_temp;
	delete dice;
}

void Atmos::Generate(uwp *u, int zone_flag, float min_l, float mean_l, 
		float max_l, float ecc, float tilt, int star_type, float rot)
{
int i;

	GenAtmosComp();
	GenGases();
	GenPressure();
	SetLumin(0, min_l);
	SetLumin(1, mean_l);
	SetLumin(2, max_l);
	CalcAlbedo(u->get_hydro_val(), zone_flag);
	if((get_t_hex_val() > 9) && (get_t_hex_val() < 13))
		ExoticGreenhouse();
	else
		CalcGreenhouse();
// make this seperate:
	CalcBaseTemp();
	SetTempMods(u->get_size_val(), ecc, tilt);
	CalcNatDM(u->get_hydro_val(), star_type);
 	CheckNativeLife();
	CalcTerDM(u->get_size_val(), u->get_hydro_val(), u->get_pop_val(), 
			u->get_tech_val());
// seperate after base_temp (day/night stuff)
	CalcRot(rot);
	for(i = 0;i < 3;i++)
		CheckTer(i);
	if(alb_ter)
		adj_alb = albedo * (1.0 + ((dice->Roll(11, 1) - 6) * .01));
	if(grn_ter)
		adj_greenhouse = greenhouse * (1.0 + ((dice->Roll(21, 1) - 11) * .01));
	if(terr_temp != NULL) delete terr_temp;
	terr_temp = NULL;
	if((alb_ter) || (grn_ter))
		{
		terr_temp = new Temp();
		terr_temp->SetLumin(0, min_l);
		terr_temp->SetLumin(1, mean_l);
		terr_temp->SetLumin(2, max_l);
		terr_temp->CalcTemp(adj_alb, adj_greenhouse);
		terr_temp->CalcRot(GetTrueAtmos(), rot);
		}
}

void Atmos::RecalcTemp(float rot)
{
int i;

	base_temp->CalcTemp(albedo, greenhouse);
	base_temp->CalcRot(GetTrueAtmos(), rot);

	if(terr_temp != NULL) delete terr_temp;
	terr_temp = NULL;
	if((alb_ter) || (grn_ter))
		{
		terr_temp = new Temp();
		for(i = 0;i < 3;i++)
			terr_temp->SetLumin(i, base_temp->GetLumin(i));
		terr_temp->CalcTemp(adj_alb, adj_greenhouse);
		terr_temp->CalcRot(GetTrueAtmos(), rot);		
		}
}

void
Atmos::AdjAdjAlb(int alb, float new_alb)
{
	alb_ter = alb;
	if(alb)
		adj_alb = albedo * (1.0 + new_alb);
	else
		adj_alb = 0;
}

void
Atmos::AdjAdjGrn(int grn, float new_grn)
{
	grn_ter = grn;
	if(grn)
		adj_greenhouse = greenhouse * (1.0 + new_grn);
	else
		adj_greenhouse = 0;
}

//misc tables
char *Atmos::atmos_comp[25] = {
"None",                             // 00 0,1
"Standard Oxygen-Nitrogen mix",     // 01 std
"disease",                          // 02 taint
"gas",                              // 03   "
"high oxygen",                      // 04   "
"pollutant",                        // 05   "
"sulfur compound",                  // 06   "
"low oxygen",                       // 07   "

"Very thin,irritant",               // 08	A
"Very thin",                        // 09   AB
"Thin",                             // 10   A
"Thin,irritant",                    // 11   A
"Standard",                         // 12   AB
"Std,irritant",                     // 13   A
"Dense",                            // 14   A
"Dense,irritant",                   // 15   A
"Very dense",                       // 16   AB
"Very dense,irritant",              // 17   A
"Occasional corrosive",             // 18   A  ???

"temperature",                      // 19   (A)BC
"radiation",                        // 20   C
"pressure",                         // 21   C
"insidious gas",                    // 22   C (insidious)
"corrosive gas",                    // 23   B (corrosive)
/* several temporary types exist:
	
*/
NULL };

char *Atmos::atmos_str[16] = {
	"None",
	"Trace",
	"Very Thin, tainted",
	"Very Thin",
	"Thin, tainted",
	"Thin",
	"Standard",
	"Standard, tainted",
	"Dense",
	"Dense, tainted",
	"Exotic",
	"Corrosive",
	"Insidious",
	"Dense, High",
	"Ellipsoid",
	"Thin, Low" };
char *Atmos::true_atmos_str[7] = {
	"None",
	"Trace",
	"Very Thin",
	"Thin",
	"Standard",
	"Dense",
	"Very Dense" };
	
char *Atmos::gases[19] = {	"H2","He","CH4","NH3","H20","Ne",  
							"N2","CO","NO","H2S","Ar","CO2",
							"N2O","NO2","SO2","SO3","Kr","Xe",
							NULL };

char *
Atmos::GetAtmosCompStr(char *buff)
{
	if(comp < 2)
		sprintf(buff, "%s", atmos_comp[comp]);
	else if((get_t_hex_val() < 10) || (comp > 18))
		sprintf(buff, "%s with %s taint", atmos_comp[1],
			atmos_comp[comp]);
	else
		sprintf(buff, "%s", atmos_comp[comp]);

	return(buff);
}

char *
Atmos::GetGasStr(char *buff)
{
int i;
long l=1;

	buff[0] = 0;
	for(i = 0;i <20;i++)
		{
		if(gas_mask & l)
			sprintf(buff, "%s ", gases[i]);
		l <<= 1;
		}

	return(buff);
}

char *
Atmos::GetTrueAtmosStr(void)
{
	return(true_atmos_str[GetTrueAtmos()]);
}

#if 0
void Atmos::PrintAtmos(FILE *stdlog)
{
int i;
long l=1;

	fprintf(stdlog, "               Atmosphere: %X(%s)\n",
		atmos, atmos_str[atmos]);
	fprintf(stdlog, "              Composition: ");
	if(comp < 2)
		fprintf(stdlog, "%s\n", atmos_comp[comp]);
	else if((atmos < 10) || (comp > 18))
		fprintf(stdlog, "%s with %s taint.\n", atmos_comp[1],
			atmos_comp[comp]);
	else
		fprintf(stdlog, "%s\n", atmos_comp[comp]);

	if(gas_mask)
		{
		fprintf(stdlog, "                    Gases: ");

		for(i = 0;i <20;i++)
			{
			if(gas_mask & l)
				fprintf(stdlog, "%s ", gases[i]);
			l <<= 1;
			}
		fprintf(stdlog,"\n");
		}

	fprintf(stdlog, "                 Pressure: %s %.3f\n",
		true_atmos_str[GetTrueAtmos()], pressure);

	fprintf(stdlog, "                   Albedo: %.3f\n", albedo);
	fprintf(stdlog, "               Greenhouse: %.3f\n", greenhouse);

	if((albedo != adj_alb) || (greenhouse != adj_greenhouse))
		{
		if(albedo != adj_alb)
			fprintf(stdlog, "      Terraforming Albedo: %.3f\n", adj_alb);
		if(greenhouse != adj_greenhouse)
			fprintf(stdlog, "  Terraforming Greenhouse: %.3f\n", adj_greenhouse);
		base_temp->PrintTemp(stdlog, 0);
		if(terr_temp != NULL)		// shouldn't need this check....
			terr_temp->PrintTemp(stdlog, 1);
		}
	else
		base_temp->PrintTemp(stdlog, 1);

	fprintf(stdlog, " Orbital Eccentricity Mod: %c%.3f%cC\n",
		0xf1, eccen_mod, 0xf8);
	fprintf(stdlog, "     Axial Tilt Modifiers: %.3f%cC/%.3f%cC\n",
		ax_mod_plus, 0xf8, ax_mod_minus, 0xf8);
	fprintf(stdlog, "       Latitude Modifiers: %d%cC per hex row\n",
		lat_mod, 0xf8);

	fprintf(stdlog, "              Native Live: ");
	if(native_life) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", nat_dm);		
	fprintf(stdlog, "  Atmosphere Terraforming: ");
	if(atm_ter) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", atm_dm);		
	fprintf(stdlog, "  Greenhouse Terraforming: ");
	if(grn_ter) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", grn_dm);		
	fprintf(stdlog, "      Albedo Terraforming: ");
	if(alb_ter) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", alb_dm);		
			
}

void Atmos::PrintTempW(FILE *stdlog, float rot)
{
int i,j,k;
char buffer[80];

	if(get_base_temp(0) == get_base_temp(1))
		k = 1;
	else
		k = 0;

//	fprintf(stdlog, "   Temperature Worksheet:");
	fprintf(stdlog, "\n              ---Winter---- ---Summer----");
	if(!k)
		fprintf(stdlog, "         ---Winter---- ---Summer----");
	fprintf(stdlog, "\n Hex    Base   Night  Day    Night  Day");
//	     			   123456 123456 123456 123456 123456 123456
	if(!k)
		fprintf(stdlog, "     Base   Night  Day    Night  Day");
//	     		      123456 123456 123456 123456 123456 123456
	fprintf(stdlog, "\n");

	for(i = 0;i < 11;i++)
		{
		sprintf(buffer, "%d", i+1);
		strsetsz(buffer, 3);
		strrjust(buffer);
		strsetsz(buffer, 7);
		fprintf(stdlog, buffer);
		
		for(j = 0;j < 5;j++)
			{
			sprintf(buffer, "%.3f", calc_temp_at_row(i, k, j, rot));
			strsetsz(buffer, 6);
			strrjust(buffer);
			strsetsz(buffer, 7);
			fprintf(stdlog, buffer);
			}

		if(!k)
			{
			fprintf(stdlog, " ");
			for(j = 0;j < 5;j++)
				{
				sprintf(buffer, "%.3f", calc_temp_at_row(i, 2, j, rot));
				strsetsz(buffer, 6);
				strrjust(buffer);
				strsetsz(buffer, 7);
				fprintf(stdlog, buffer);
				}
			}

		fprintf(stdlog, "\n");
		}

	fprintf(stdlog, "\n");
}
#endif

int Atmos::alb_table[4][2][11] =
    {{{ 800, 744, 736, 752, 738, 753, 757, 782, 796, 810, 818 },
      { 900, 829, 803, 811, 782, 789, 795, 802, 808, 814, 818 }},
     {{ 800, 811, 789, 799, 774, 747, 718, 687, 654, 619, 619 },
      { 900, 900, 860, 860, 820, 780, 740, 700, 660, 620, 619 }},
     {{ 680, 646, 635, 644, 625, 599, 570, 537, 500, 500, 500 },
      { 740, 697, 672, 676, 648, 613, 577, 539, 500, 500, 500 }},
     {{ 800, 811, 807, 817, 813, 809, 805, 800, 794, 787, 773 },
      { 900, 900, 882, 883, 866, 850, 836, 821, 807, 793, 773 }}};

// misc random stuff:
void Atmos::GenAtmosComp(void)
{
int i,j=0;

	comp_mod = 0;
	if(get_t_hex_val() < 2)
		{
		comp = 0;					// none
		return;
		}
	if((get_t_hex_val() == 3) || (get_t_hex_val() == 5) || 
		(get_t_hex_val() == 6) || (get_t_hex_val() == 8) || 
		(get_t_hex_val() > 12))
		{
		comp = 1;					// std
		return;
		}

	if(get_t_hex_val() == 11)					// corrosive
		{
		if(dice->Roll(2,1) == 1)
			{
			comp = 23;					// corrosive gases
			return;
			}
		else
			j = 1;
		}

	i = dice->Roll(6, 2);
	if(get_t_hex_val() == 12)				// insidious
		{
		if((i == 4) || (i == 10))
			{
			comp = 20;					// radiation
			return;
			}
		else if((i == 5) || (i == 9))
			{
			comp = 19;					// tempeture
			j = 1;
			}
		else if((i == 6) || (i == 8))
			{
			comp = 21;					// pressure
			return;
			}
        else
			{
        	comp = 22;					// gas
			return;
			}
		}
	else if(get_t_hex_val() == 10)		// exotic
		{
		comp = i + 6;				// see above
		if(i > 11)
			j = 1;
		else
			return;
		}
	else if((get_t_hex_val() == 11) ||	// corrossive
			(j))
		{
		if((i < 3) || ((i > 5) && (i < 9)) || (i > 11))
			comp = 19;
		else if(i < 6)
			comp = 9;
		else 
			comp = 16;

		if(i < 3)
			comp_mod = -100;
		else if((i == 3) || (i == 6) || (i == 9))
			comp_mod = -100 + ((dice->Roll(15, 1) - 1 ) * 5);
		else if((i == 4) || (i == 7) || (i == 10))
			comp_mod = -25 + ((dice->Roll(15, 1) - 1 ) * 5);
		else if((i == 5) || (i == 8) || (i == 11))
			comp_mod = 50 + ((dice->Roll(50, 1) - 1 ) * 5);
        else
		    comp_mod = 100;
		return;
		}
	else						// taint.....
		{
		if((i < 3) || (i > 11))
			{
			comp = 2;				// disease
			return;
			}
		else if((i < 4) || (i > 10))
			{
			comp = 2;				// gas mix
			return;
			}
		else if(i < 5)
			{
			comp = 3;				// hi O2
			return;
			}
		else if(i > 9)
			{
			comp = 7;				// lo O2
			return;
			}
		else if((i == 6) || (i == 8))
			{
			comp = 5;				// sulfur
			return;
			}
		else 
			{
			comp = 5;				// pollutants
			return;
			}
		}
}

void Atmos::GenGases(void)
{
int i=1,j;

	gas_mask = 0l;

	if(comp < 3)
		return;	
	
	else if(comp == 3)
		 dice->SetDice(9, 1, -1);
	else if((comp == 8) || (comp == 11) ||
		(comp == 13) || (comp == 15) ||
		(comp == 17))
		{
		i = dice->Roll(3, 1);
		dice->SetDice(13, 1, 4);
		}
	else if(comp > 21)
		{
		i = dice->Roll(3, 1, 1);
		dice->SetDice(18, 1, -1);
		}

	for(j = 0; j < i;j++)
		gas_mask |= (1 << dice->Roll());
}

void Atmos::GenAltAlb(void)
{
	adj_alb = albedo * ((dice->Roll(11, 1) - 5) * .1);
}

void Atmos::GenAltGrn(void)
{
	adj_greenhouse = greenhouse * ((dice->Roll(11, 1) - 5) * .1);
}

TRUE_ATMOS Atmos::GetTrueAtmos(void)
{
	if(get_t_hex_val() == 0)
		return(TA_NONE);
	else if(get_t_hex_val() == 1)						// trace
		return(TA_TRACE);
	else if((get_t_hex_val() < 4) || (comp == 8) ||   // v thin
		(comp == 9))
		return(TA_V_THIN);
	else if((get_t_hex_val() < 6) || (comp == 10) ||	// thin
		(comp == 11) || (get_t_hex_val() > 14))
		return(TA_THIN);
	else if((get_t_hex_val() == 8) || (get_t_hex_val() == 9) ||	//dense
		(comp == 14) || (comp== 15))
		return(TA_DENSE);
	else if((get_t_hex_val() > 12) || (comp == 16) ||	// v dense
		(comp == 17))
		return(TA_V_DENSE);
	else 									// std
		return(TA_STD);
}

void Atmos::GenPressure(void)
{
int i;
float f = 0.0;

	i = dice->Roll(6,2);

	switch(GetTrueAtmos())
		{
		case TA_NONE: 	
			pressure = 0.0;
			break;
		case TA_TRACE:								// trace
			if(i < 3) pressure = 0.01;
			else if(i < 5) pressure = 0.05;
			else if(i < 7) pressure = 0.06;
			else if(i < 10) pressure = 0.07;
			else if(i < 12) pressure = 0.08;
			else pressure = 0.09;
			break;
		case TA_V_THIN:								// v thin
			if(i < 3) pressure = 0.1;
			else if(i < 4) pressure = 0.12;
			else if(i < 5) pressure = 0.14;
			else if(i < 6) pressure = 0.16;
			else if(i < 7) pressure = 0.18;
			else if(i < 8) pressure = 0.20;
			else if(i < 9) pressure = 0.23;
			else if(i < 10) pressure = 0.25;
			else if(i < 11) pressure = 0.30;
			else if(i < 12) pressure = 0.35;
			else pressure = 0.40;
			break;
		case TA_THIN:								// thin
			if(get_t_hex_val() == 14) f = .2;
			if(i < 3) pressure = 0.43 - f;  
			else if(i < 4) pressure = 0.45 - f;
			else if(i < 5) pressure = 0.48 - f;
			else if(i < 8) pressure = 0.50 - f;
			else if(i < 9) pressure = 0.55 - f;
			else if(i < 10) pressure = 0.60 - f;
			else if(i < 11) pressure = 0.65 - f;
			else if(i < 12) pressure = 0.70 - f;
			else pressure = 0.75 - f;
			break;
		case TA_DENSE:								// dense
			if(i < 3) pressure = 1.5;
			else if(i < 4) pressure = 1.60;
			else if(i < 5) pressure = 1.70;
			else if(i < 6) pressure = 1.80;
			else if(i < 7) pressure = 1.90;
			else if(i < 9) pressure = 2.00;
			else if(i < 11) pressure = 2.20;
			else pressure = 2.40;
			break;
		case TA_V_DENSE:								// v dense
			if(i < 3) pressure = 2.5;
			else if(i < 4) pressure = 5.00;
			else if(i < 5) pressure = 10.00;
			else if(i < 6) pressure = 25.00;
			else if(i < 7) pressure = 50.00;
			else if(i < 8) pressure = 100.00;
			else if(i < 9) pressure = 150.00;
			else if(i < 10) pressure = 200.00;
			else if(i < 11) pressure = 250.00;
			else if(i < 12) pressure = 500.00;
			else pressure = 750.00;
			break;
		default:							// std
			if(i < 3) pressure = 0.76;
			else if(i < 4) pressure = 0.80;
			else if(i < 5) pressure = 0.85;
			else if(i < 6) pressure = 0.90;
			else if(i < 7) pressure = 0.95;
			else if(i < 9) pressure = 1.00;
			else if(i < 10) pressure = 1.10;
			else if(i < 11) pressure = 1.20;
			else if(i < 12) pressure = 1.30;
			else pressure = 1.40;
			break;
		}
}

void Atmos::ExoticGreenhouse(void)
{
int i;

	i = dice->Roll(6,2);
	if(get_t_hex_val() == 10)
		{
		greenhouse = 1.2 + (((i - 2) / 2) * .1);
		}
	else
		{
		greenhouse = (1.2 + ((i - 2) * .1));
		}
	adj_greenhouse = greenhouse;
}

void Atmos::CheckNativeLife(void)
{
	if((dice->Roll(6,2) + nat_dm) > 9)
		native_life = 1;
	else
		native_life = 0;
}

void Atmos::CheckTer(int which)
{
int dm,*ptr;

	if(which == 1)
		{
		dm = grn_dm;
		ptr = &grn_ter;
		}
	else if(which == 2)
		{
		dm = alb_dm;
		ptr = &alb_ter;
		}
	else
		{
		dm = atm_dm;
		ptr = &atm_ter;
		}

	if(dice->Roll(6,2) < dm)
		*ptr = 1;
	else
		*ptr = 0;
}

void Atmos::CalcAlbedo(int hyd, int zone)
{
int i,j;

	if(get_t_hex_val() < 4) i = 0;
	else if(get_t_hex_val() < 10) i = 1;
	else if(get_t_hex_val() == 14) i = 3;
	else i = 2;
 
	if(zone)
		j = 0;
	else
		j = 1;

	albedo = alb_table[i][j][hyd] / 1000.0;
	adj_alb = albedo;
}

void Atmos::SetTempMods(int size, float eccen, float tilt)
{
	eccen_mod = eccen * 30.0;
	ax_mod_plus = tilt * 0.6;
	ax_mod_minus = tilt * -1.0;
	if((size < 2) || (size == 11))
		lat_mod = 3;
	else
		lat_mod = 4 + ((size - 2) / 2);
	if(tilt < 1.0)
		base_ax_row = 14;
	else if(tilt < 2)
		base_ax_row = 13;
	else if(tilt < 2)
		base_ax_row = 12;
	else if(tilt < 2)
		base_ax_row = 11;
	else if(tilt < 2)
		base_ax_row = 10;
	else if(tilt < 2)
		base_ax_row = 9;
	else if(tilt < 2)
		base_ax_row = 8;
	else if(tilt < 2)
		base_ax_row = 7;
	else if(tilt < 2)
		base_ax_row = 6;
	else if(tilt < 2)
		base_ax_row = 5;
	else if(tilt < 2)
		base_ax_row = 4;
	else if(tilt < 2)
		base_ax_row = 3;
	else if(tilt < 2)
		base_ax_row = 2;
	else if(tilt < 2)
		base_ax_row = 1;
}

void Atmos::CalcBaseTemp(void)
{
	base_temp->CalcTemp(albedo, greenhouse);
}

void Atmos::SetLumin(int which, float lum)
{
	base_temp->SetLumin(which, lum);
}

void Atmos::CalcNatDM(int hyd, int star_type)
{
	nat_dm = 0;
	if(get_t_hex_val() == 0)
		nat_dm -= 3;
	else if((get_t_hex_val() > 3) || (get_t_hex_val() < 10))
		nat_dm += 4;
	if(hyd == 0)
		nat_dm -= 2;
	else if((hyd > 1) || (hyd < 9))
		nat_dm += 1;
    if(star_type < 5)
    	nat_dm--;
    else if(star_type < 7)
    	nat_dm++;
}

void Atmos::CalcGreenhouse(void)
{
	if((get_t_hex_val() < 4) || (get_t_hex_val() > 14))
		greenhouse = 1.00;
	else if(get_t_hex_val() < 6)
		greenhouse = 1.05;
	else if((get_t_hex_val() < 8) || (get_t_hex_val() > 13))
		greenhouse = 1.10;
	else if((get_t_hex_val() < 10) || (get_t_hex_val() > 12))
		greenhouse = 1.15;
// shouldn't come here, but if it does, set it to mean value:
	else if(get_t_hex_val() == 10)
		greenhouse = 1.40;
	else
		greenhouse = 1.70;

	adj_greenhouse = greenhouse;
}

void Atmos::CalcRot(float day_len)
{
	base_temp->CalcRot(GetTrueAtmos(), day_len);
}

void Atmos::CalcTerDM(int size, int hyd, int pop, int tech)
{
	grn_dm = atm_dm = grn_dm = alb_dm = 0;
	if((size < 3) || (size > 10))
		{
		atm_dm += 2;
		grn_dm += 2;
		alb_dm += 2;
		}
	else if(size < 5)
		{
		atm_dm += 1;
		grn_dm += 1;
		alb_dm += 1;
		}
	else if(size > 8)
		{
		atm_dm -= 2;
		grn_dm -= 2;
		alb_dm -= 2;
		}
	else if(size > 6)
		{
		atm_dm -= 1;
		grn_dm -= 1;
		alb_dm -= 1;
		}
	if(get_t_hex_val() == 0)
		{
		atm_dm -= 5;
		grn_dm -= 5;
		alb_dm -= 5;
		}
	else if(get_t_hex_val() == 12)
		{
		atm_dm -= 5;
		grn_dm -= 5;
		}
	if(hyd < 1)
		{
		atm_dm -= 1;
		grn_dm += 1;
		alb_dm += 2;
		}
	else if(hyd > 9)
		{
		atm_dm += 1;
		grn_dm += 2;
		alb_dm += 1;
		}
	else if(hyd > 4)
		{
		grn_dm += 1;
		}
	if(pop < 5)
		{
		atm_dm -= 3;
		grn_dm -= 2;
		alb_dm -= 2;
		}
	else if(pop > 7)
		{
		atm_dm += 1;
		grn_dm += 2;
		alb_dm += 2;
		}
	if(tech < 5)
		{
		atm_dm -= 10;
		grn_dm -= 10;
		alb_dm -= 10;
		}
	else if(tech < 9)
		{
		atm_dm -= 1;
		grn_dm += 1;
		alb_dm += 1;
		}
	else if(tech < 12)
		{
		atm_dm += 1;
		grn_dm += 2;
		alb_dm += 2;
		}
	else
		{
		atm_dm += 2;
		grn_dm += 2;
		alb_dm += 3;
		}
	if(native_life)
		{
		atm_dm -= 4;
		grn_dm -= 2;
		alb_dm -= 2;
		}
	else
		{
		atm_dm += 2;
		grn_dm += 2;
		alb_dm += 2;
		}
}

float Atmos::CalcTempAtRow(int hex, int max_flag, int range_flag, float rot)
{
float f,g;

	if(terr_temp != NULL)
		f = terr_temp->GetBaseTemp(max_flag);
	else
		f = base_temp->GetBaseTemp(max_flag);

	if(rot == 0.0)						// add in the latitude mod
		f += hex * lat_mod;
	else
		f += (hex - 3) * lat_mod;

	if(range_flag == 0)					// base temp @ that row
		return(f);

// figure out the tilt modifier
	if(hex < base_ax_row - 3)
		g = 0.0;
	else if(hex < base_ax_row - 3)
		g = 0.25;
	else if(hex < base_ax_row - 2)
		g = 0.50;
	else if(hex < base_ax_row - 1)
		g = 0.75;
	else
		g = 1.0;

	if(range_flag)
		{
		if(range_flag < 3)					// winter
			f += (ax_mod_minus * g) - eccen_mod;
		else								// summer
			f += (ax_mod_plus) + eccen_mod;

    	if(!(range_flag & 1))				// day
			{
			if(terr_temp != NULL)
				f += terr_temp->GetDayRot(max_flag);
			else
				f += base_temp->GetDayRot(max_flag);
			}
		else								// night
			{
			if(terr_temp != NULL)
				f -= terr_temp->GetNightRot(max_flag);
			else
				f -= base_temp->GetNightRot(max_flag);
			}
		}

	return(f);
}


// ========================================================================
void Temp::CalcRot(TRUE_ATMOS tatm, float day_len)
{
int i;
float base_nums[4];

	switch(tatm)
		{
		case TA_NONE:
			base_nums[0] = 0.1;
			base_nums[1] = 1.0;
			base_nums[2] = 0.8;
			base_nums[3] = 20.0;
			break;
		case TA_TRACE:
			base_nums[0] = 0.3;
			base_nums[1] = 0.9;
			base_nums[2] = 0.7;
			base_nums[3] = 15.0;
			break;
		case TA_V_THIN:
			base_nums[0] = 0.8;
			base_nums[1] = 0.8;
			base_nums[2] = 0.5;
			base_nums[3] =  8.0;
			break;
		case TA_THIN:
			base_nums[0] = 1.5;
			base_nums[1] = 0.6;
			base_nums[2] = 0.3;
			base_nums[3] =  3.0;
			break;
		case TA_DENSE:
			base_nums[0] = 4.0;
			base_nums[1] = 0.4;
			base_nums[2] = 0.1;
			base_nums[3] =  0.5;
			break;
		case TA_V_DENSE:
			base_nums[0] = 5.0;
			base_nums[1] = 0.2;
			base_nums[2] = 0.05;
			base_nums[3] =  0.2;
			break;
		default:							// std
			base_nums[0] = 2.5;
			base_nums[1] = 0.5;
			base_nums[2] = 0.15;
			base_nums[3] =  1.0;
			break;
		}

	for(i = 0;i < 3;i++)
		{
		d_max[i] = (base_temp[i] + 273.0) * lumin[i] * base_nums[0];
		d_rot[i] = lumin[i] * base_nums[1];
		n_max[i] = (base_temp[i] + 273.0) * base_nums[2];
		n_rot[i] = base_nums[3];

		if(day_len == 0.0)
			{
			d_rot[i] = d_max[i];
			n_rot[i] = n_max[i];
			}
		else
			{
			d_rot[i] = d_rot[i] * fabs(day_len) / 2;
			n_rot[i] = n_rot[i] * fabs(day_len) / 2;
			if(d_rot[i] > d_max[i])
				d_rot[i] = d_max[i];
			if(n_rot[i] > n_max[i])
				n_rot[i] = n_max[i];
			}
		}
}
void Temp::CalcTemp(float alb, float grn)
{
int i;

	for(i = 0;i < 3;i++)
		base_temp[i] = (lumin[i] * 374.025 * alb * grn) - 273.0;
}

// ------------------------------------------------------------------------
#if 0
char *
Temp::GetLuminStr(char *buff)
{
	sprintf(buff, "               Luminosity: ");
	if(base_temp[0] == base_temp[1])
		sprintf(buff, "%.3f\n", lumin[1]);
	else
		sprintf(buff, "%.3f/%.3f/%.3f\n", lumin[0],
			lumin[1], lumin[2]);
	return(buff);
}

char *
Temp::GetBaseStr(char *buff)
{
	sprintf(buff, "         Base Temperature: ");
	if(base_temp[0] == base_temp[1])
		sprintf(buff, "%.3f%cC\n", base_temp[1], 0xf8);
	else
		sprintf(buff, "%.3f%cC/%.3f%cC/%.3f%cC\n", base_temp[0], 0xf8,
				base_temp[1], 0xf8, base_temp[2], 0xf8);
	return(buff);
}

char *
Temp::GetMaxDayModStr(char *buff)
{
	sprintf(buff, "     Maximum Day Modifier: ");
	if(base_temp[0] == base_temp[1])
		sprintf(buff, "%.3f%cC\n", d_rot[1], 0xf8);
	else
		sprintf(buff, "%.3f%cC/%.3f%cC/%.3f%cC\n", d_rot[0], 0xf8,
				d_rot[1], 0xf8, d_rot[2], 0xf8);
	return(buff);
}

char *
Temp::GetMaxNightModStr(char *buff)
{
	sprintf(buff, "   Maximum Night Modifier: ");
	if(base_temp[0] == base_temp[1])
		sprintf(buff, "%.3f%cC\n", -n_rot[1], 0xf8);
	else
		sprintf(buff, "%.3f%cC/%.3f%cC/%.3f%cC\n", -n_rot[0], 0xf8,
			-n_rot[1], 0xf8, -n_rot[2], 0xf8);
	return(buff);
}

#endif

