/*
 * File:      	gen_trade.cpp
 * Purpose:   	generate trade codes
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: gen_trade.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


#include <string.h>
#include "str_util.h"
#include "d_sect.h"


int 
main(int argc, char *argv[])
{
char u[12];
int err=0,x,y;
DetailSector *ds;
HexData *hd;
main_world *mw;
TCodes *codes;
TradeTable *tt;
unsigned long trade;

	if(argc != 3)
		err = 1;
	else {
		codes = new TCodes(argv[1]);
		ds = new DetailSector(codes);
		ds->LoadFile(argv[2]);
		tt = codes->GetTradeTable();
		
		for(x = 0;x < MAX_X_HEX;x++) {
			for(y = 0;y < MAX_Y_HEX;y++) {
				if(((hd = ds->GetHex(x, y)) != NULL) && 
						((mw = hd->world) != NULL)) {
					mw->GetUWPStr(u);
					trade = tt->CheckTrade(u);
					mw->SetTradeCodes(trade);
				}
			}
		}

		ds->WriteSec();
	}

	if(err) {
		fprintf(stderr, 
			"Usage:\n%s <codes dir> <sector file>\n", argv[0]);
	}

	return(err);
}

