/*
 * File:		trd_dlg.h
 * Purpose:		general dialogs for trade
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: trd_dlg.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/05/04 18:23:05 $" */

#ifndef TRD_DLG_H
#define TRD_DLG_H

#include "t_dlg.h"
#include "uwp_dlg.h"
#include "t_code.h"
#include "trade_table.h"

// ====================================================
// hokey way to pass stuff around
struct loc {
	int	hex_x;
	int hex_y;
	int x,y,z;					// for 3D (XXX not really supported)
};

struct imp_date {
	int day;
	int year;
};

struct conf_struct {
	char			*src_name;		// sector files
//	char			*dest_name;
	struct loc		src;
//	struct loc		dest;
	struct imp_date	init_date;
	char			*out_file;
	char			*skills[MAX_TRADE_SKILLS];
	int				levels[MAX_TRADE_SKILLS];
	bool			quiet_flag;
	bool			full_book7;		// use the bk 7 trade designation
	bool			enhanced;		// more than one spec. trade....
};


// ====================================================
class TradeDialog : public StdDialog
{
public:
	TradeDialog(wxWindow *p);
	~TradeDialog() {};

	bool GetConfig(struct conf_struct *cfg);

private:
	void OnBrowse(wxCommandEvent &event);

	wxTextCtrl		*src_sect;
	wxTextCtrl		*src_loc;
	wxTextCtrl		*init_day;
	wxTextCtrl		*init_year;
	wxTextCtrl		*admin;
	wxTextCtrl		*bribery;
	wxTextCtrl		*broker;
	wxTextCtrl		*liaison;
	wxTextCtrl		*carousing;
	wxTextCtrl		*steward;
	wxTextCtrl		*streetwise;
	wxTextCtrl		*trader;
	wxCheckBox		*b7;
	wxCheckBox		*enh;

	DECLARE_EVENT_TABLE()
};

#endif

