/*
 * File:      trade_table.h
 * Purpose:   tables to generate Traveller trade
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: trade_table.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/01/15 19:51:15 $" */


#ifndef TRADE_TABLE_H
#define TRADE_TABLE_H

#include <stdio.h>
#include "basesect.h"
#include "t_dice.h"
#include "llist.h"

#define BIG_BUFFER_SIZE			256
#define MAX_TRADE_SKILLS		9

// ====================================================
// handy struct to pass around
struct SpecTradeStruct
{
	char 	*item;
	long	purch;
	int		quantity;
	bool	ind;
};

// ====================================================
// dm class
class TradeDMs
{
public:
	TradeDMs(char *);
	~TradeDMs();

	int GetDM(char *codes);

private:
	char		code[3][3];
	int			dm[3];
};

// ====================================================
// Speculative trade entry (book 2, pg 46)
class SpecTradeEntry : public ListData
{
public:
	SpecTradeEntry(char *);
	~SpecTradeEntry();

	char *GetName(void) { return(name); };
	
	void GetThrows(int *t1, int *t2);

	void GenItem(char *world_codes, char *skills[], int levels[],
			char *item, int *quantity, bool *ind, int *value, int *ton);
private:
	int				throw1;
	int				throw2;
	char			*name;		// Trade Goods
	unsigned long	price;
	TradeDMs		*purchase;
	TradeDMs		*resale;
	int				quantity;	// number of D6
	int				mult;		// number to multiply above roll by
	bool			ind;		// individual item instead of tons
	int				tonnage;	// if above is true
};

// ----------------------------------------------------
// list of all entries
#define MAX_SPEC_SKILLS		3
class SpecTradeTable : public LinkedList
{
public:
	SpecTradeTable(char *filename);
	~SpecTradeTable();

	char *GetItem(int ndx);

	long GetResale(char *world_codes, char *item, int quantity);

	void GenItem(char *world_codes, char *skills[], int levels[],
			char *item, int *quantity, bool *ind, int *value, int *ton);

private:
	int		max_throw1,max_throw2;

};

// ====================================================
// 'bulk' table (book 7, pg 39)
// NumGen handles stuff in the form xD - yD or xD - z
//  where base = x
//  	  d_minus = y
//  	  num_minus = z
struct NumGen
{
	int		base;
	int		d_minus;
	int		num_minus;
};

#define MAX_NUMS		3
// passenger/cargo
class CargoPass
{
public:
	CargoPass(char *n, FILE *fp);
	~CargoPass();

	char *GetName(void) { return(name); };
	char *GetName(int ndx) { return(names[ndx]); };
	void GetAvail(char *skill_list[], int *skill_levels, 
			char *source_uwp, char *dest_uwp, char d_zone, int *ret_num);

private:
	void AllocString(char *dest[], char *src[]);
	void AllocInt(int dest[], char *src[]);
	void AllocGen(int ndx, char *src[]);

	char			*name;
	struct NumGen 	num_gen[11][MAX_NUMS];		// entry for pop 0-11
	char			*names[MAX_NUMS];

	int				pop_thresh_lo[MAX_NUMS];
	int				pop_dm_lo[MAX_NUMS];
	int				pop_thresh_hi[MAX_NUMS];
	int				pop_dm_hi[MAX_NUMS];

	int				r_zone_dm[MAX_NUMS];
	int				a_zone_dm[MAX_NUMS];

	char			*skills[MAX_NUMS];
};

// ====================================================
// wrapper for trade tables
class Trade
{
public:
	Trade(char *dir);
	~Trade();

	SpecTradeTable *GetSpecTrade(void) { return(spec); };
	CargoPass *GetCargo(void) { return(cargo); };
	CargoPass *GetPass(void) { return(pass); };

private:
	SpecTradeTable	*spec;
	CargoPass		*cargo;
	CargoPass		*pass;
};

// ====================================================
// list of cargo and passangers
class TradeAvail : public ListData
{
public:
	TradeAvail(int p[], int c[], int l_x, int l_y, int l_d);
	~TradeAvail();

	void GetAvailCargo(int c[]);
	void GetAvailPass(int p[]);
	void GetLoc(int *x1, int *y1);
	int GetDist(void) { return(dist); };

private:
	int			p1,p2,p3;		// count of avail pass
	int			c1,c2,c3;		// count of avail cargo
	int			x,y,z;			// location
	int			dist;
	
};

// ----------------------------------------------------
// list of spec. trade
class SpecTradeData : public ListData
{
public:
	SpecTradeData(BaseSector *sect, int x, int y, char *sks[], int lvsl[], 
					Trade *trade, bool b7);
	~SpecTradeData();

	char *GetItem(void) { return(item); };
	int GetQuantity(void) { return(quantity); };
	int GetValue(void) { return(value); };
	int GetTonnage(void) { return(tonnage); };
	bool GetIndFlag(void) { return(ind); };

private:
	// spec. trade info
	char		*item;
	int			quantity;
	bool		ind;
	int			value;
	int			tonnage;
};

// ----------------------------------------------------
// master list (above 2)
class AvailList
{
public:
	AvailList(BaseSector *sect, int x, int y, char *sks[], int lvsl[], 
					Trade *trade, bool b7, bool enhanced);
	~AvailList();

	SpecTradeData *GetSpecTrade(int ndx);
	TradeAvail *GetTradeAvail(int ndx);
	int SpecTradeCount(void) { return(spec_trade->Count()); };
	int TradeAvailCount(void) { return(trade_avail->Count()); };
	void Clear(void);

private:
	LinkedList		*spec_trade;
	LinkedList		*trade_avail;
};

#endif

