/*
 * File:    trade.h
 * Purpose:	generate Traveller trade (simple)
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: trade.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/01/15 19:51:59 $" */

#ifndef TRADE_H
#define TRADE_H

#include "wx/timer.h"
#include "wx/print.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "t_frame.h"
#include "trade_table.h"
#include "trd_dlg.h"
#include "t_dice.h"

// ====================================================
// Define a new application
class TradeApp: public wxApp
{
public:
    bool OnInit(void);

	void CleanUp(void);

	wxConfig	*config;

private:
	void ParseCommandLine(struct conf_struct *cfg, char *cfg_ptr);
	bool ParseString(char **dest, char *src);
	bool ParseLoc(struct loc *l, char *buff);
	bool ParseSkills(struct conf_struct *cfg, char *buff);
	bool ParseDate(struct imp_date *d, char *buff);
	bool CopyString(char *dest, char *src, unsigned int sz);
	void ProcessArgs(struct conf_struct *cfg, char last_arg, char *buff);
};

// ========================================================================
//  gui stuff
// display (print) handler
class TradeDisplay : public DisplayMethod
{
public:
	TradeDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
		DisplayMethod(d, x, y, len) {};
	TradeDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
	~TradeDisplay();

	int DrawTrade(Trade *trade, conf_struct *cfg, BaseSector *sect,
			AvailList *list, char *msg1=NULL, char *msg2=NULL,
			int start_count=-1, int total_count=-1);
private:
	int DrawHeader(conf_struct *cfg);
	int DrawLines(Trade *trade);
	int DrawTransport(Trade *trade, TradeAvail *ta, BaseSector *sect);

	char *FormatLocation(char *b, int x, int y, char *n, char *s);
};

// ====================================================
// print out
class PrintOut : public wxPrintout
{
public:
	PrintOut(Trade *trade, conf_struct *cfg, BaseSector *sect,
			AvailList *list);
	~PrintOut() {};

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage,
					 int *selPageFrom, int *selPageTo);

private:
	int				page_max;
	// misc references
	Trade			*trade;
	conf_struct		*cfg;
	BaseSector		*sect;
	AvailList		*avail;
};

// ========================================================================
// general canvas
class TradeCanvas : public wxScrolledWindow
{
public:
    TradeCanvas(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1,
				 long style = wxRETAINED);
	~TradeCanvas() {};

	void OnDraw(wxDC& dc);
	
};

// ========================================================================
class TradeFrame : public wxFrame
{
//friend class QuietFrame;
public:
	TradeFrame(struct conf_struct *c, char *cfg_ptr, char *data_ptr);
	~TradeFrame();

	bool OnCLose(void) { return(TRUE); };

	void Draw(wxDC *dc);

	void InitButtons(wxToolBar *tb);

private:
	void Configure(wxCommandEvent& event);
	void Generate(wxCommandEvent& event);
	void Save(wxCommandEvent& event);
	void Print(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void Exit(wxCommandEvent& event);
	
	void OnToolEnter(wxCommandEvent& event);
	void ClearEnc(void);
	void UpdateStatus(void);
	void CleanUp(void);

	void GenerateTrade(void);

	// user stuff:
	struct conf_struct	*cfg;			// reference
										//  but, we clean up the members (yuck)

	// sector & codes
	BaseSector			*sect;
	TCodes				*codes;

	// current generated trade
	AvailList			*avail;

	// trade tables:
	Trade				*trade;

	// GUI stuff:
	TradeCanvas			*canvas;

	TradeDialog			*dlg;

	DECLARE_EVENT_TABLE()
};

// ----------------------------------------------------

#endif
