/*
 * File:      trade.cpp
 * Purpose:	  generate Traveller trade (simple)
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: trade.cpp,v $ $Revision: 1.5 $ $Author: man $ $Date: 2003/04/28 00:18:04 $" */

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include <stdlib.h>
#include "trade.h"
#include "d_sect.h"
#include "t_res.h"
#include "t_help.h"

IMPLEMENT_APP(TradeApp)

//#define BIG_BUFFER_SIZE			120

// button defines
enum {
	ID_TOOLBAR = 500,
	TB_CONFIG,
	TB_GEN,
	TB_SAVE,
	TB_PRINT,
	TB_ABOUT,
	TB_EXIT,
};

#ifdef __WXGTK__
#include "bitmaps/config.xpm"
#include "bitmaps/help.xpm"
#include "bitmaps/restart.xpm"
#include "bitmaps/print.xpm"
#include "bitmaps/exit.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/cargo.xpm"
#endif

// handy references
TradeApp *app=NULL;
TradeFrame *frame = NULL;
wxFont *NormalFont = NULL;

// ===============================================================
bool
TradeApp::OnInit(void)
{
int i;
struct conf_struct *cfg;
char config_file[MAX_FILE_LENGTH];
char data_file[MAX_FILE_LENGTH];
char str[MAX_FILE_LENGTH];
wxString ptr;

	app = this;
	// order/presedence:
	//	1) command line
	//	2) resources
	//	3) program
    // initialize default cfg
	cfg = new struct conf_struct;
	cfg->src_name = /*cfg->dest_name =*/ cfg->out_file = NULL;
	cfg->src.hex_x = cfg->src.hex_y = -1;
	cfg->src.x = cfg->src.y = cfg->src.z = 
		cfg->init_date.day = cfg->init_date.year = 0;
	for(i = 0;i < MAX_TRADE_SKILLS;i++) {
		cfg->skills[i] = NULL;
		cfg->levels[i] = -1;
	}
	cfg->quiet_flag = FALSE;
	cfg->full_book7 = FALSE;
	cfg->enhanced = FALSE;

    // load general resource
	config = new wxConfig((const wxString) RESOURCE_FILE);
	wxConfigBase::Set(config);
	wxConfigBase::Get();

	// we need this one first
	sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_DATA_DIR);
	if(config->Read((const wxString) str, &ptr)) {
		strcpy(data_file, ptr.GetData());
		strcat(data_file, "/");
		strcpy(config_file, ptr.GetData());
		strcat(config_file, "/");
		sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_DATA_FILE);
		if(config->Read((const wxString) str, &ptr))
			strcat(config_file, ptr.GetData());
		else
			config_file[0] = 0;
	}

	// read command line
	ParseCommandLine(cfg, config_file);
	
	// rest of resources we care about
	sprintf(str, "/%s/%s", SECTION_TRADE, ENTRY_FULL_BOOK_7);
	if(config->Read((const wxString) str, &ptr)) {
		char *p;

		p = (char *)ptr.GetData();
		if(('1' == p[0]) || ('Y' == p[0]) || ('y' == p[0]))
			cfg->full_book7 = TRUE;
	}
	sprintf(str, "/%s/%s", SECTION_TRADE, ENTRY_TRADE_RULE);
	if(config->Read((const wxString) str, &ptr)) {
		char *p;

		p = (char *)ptr.GetData();
		if(('1' == p[0]) || ('Y' == p[0]) || ('y' == p[0]))
			cfg->enhanced = TRUE;
	}

	// create fonts
    NormalFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);

    frame = new TradeFrame(cfg, config_file, data_file);
	frame->CreateToolBar(wxNO_BORDER | wxHORIZONTAL | wxTB_DOCKABLE, 
			ID_TOOLBAR);
	frame->InitButtons(frame->GetToolBar());
#ifdef __WINDOWS__
	frame->SetIcon(wxIcon("cargo_icn"));
#endif
#ifdef __WXGTK__
	frame->SetIcon(wxIcon(cargo_xpm));
#endif
	
	frame->Show(TRUE);

	return(TRUE);
}

void
TradeApp::CleanUp(void)
{
	if(config != NULL) {
		delete wxConfigBase::Set((wxConfigBase *) NULL);
		config = NULL;
	}
}

bool
TradeApp::ParseString(char **dest, char *src)
{
    if(*dest != NULL)
	    return(FALSE);
	if(src == NULL)
	    return(TRUE);
	*dest = new char[strlen(src) + 1];
	strcpy(*dest, src);
	return(TRUE);
}

bool 
TradeApp::ParseLoc(struct loc *l, char *buff)
{
//char *ptr;
int i;
//bool plus;

//	if((ptr = strtok(buff, "-+")) != NULL) {	// 3D
//		// XXX not really ready....
//	} else { 								// normal
		i = atol(buff);
		l->hex_x = (i / 100) - 1;
		l->hex_y = (i % 100) - 1;
		return(TRUE);
//	}
//
//	return(FALSE);
}

bool 
TradeApp::ParseSkills(struct conf_struct *cfg, char *buff)
{
int i;

	for(i = 0;i < MAX_TRADE_SKILLS;i++) {
		if(cfg->levels[i] < 0) {
			cfg->levels[i] = buff[strlen(buff) - 1] - '0';
			buff[strlen(buff) - 2] = 0;
			cfg->skills[i] = new char[strlen(buff) + 1];
			strcpy(cfg->skills[i], buff);
			return(TRUE);
		}
	}

	// fell through
	return(FALSE);
}

bool 
TradeApp::ParseDate(struct imp_date *d, char *buff)
{
char *ptr;

	if((ptr = strtok(buff, "-")) != NULL) {
		*ptr = 0;
		ptr++;
		d->day = atoi(buff);
		d->year = atoi(ptr);
		return(TRUE);
	}

	return(FALSE);
}

bool
TradeApp::CopyString(char *dest, char *src, unsigned int sz)
{
    if(strlen(src) > sz)
	    return(FALSE);
	strcpy(dest, src);
	return(TRUE);
}

void
TradeApp::ParseCommandLine(struct conf_struct *cfg, char *cfg_ptr)
{
int i=1;
char buff[120], last_arg=0;

    buff[0] = 0;
    while(i < argc) {
		if('-' == argv[i][0]) {
			if(strchr("Flsdoq", argv[i][1]) == NULL) {
				fprintf(stderr, "BadOption: %c\n", argv[i][1]);
				fprintf(stderr, "Valid Options:\n"
						" -F <source sector file name>\n"
						" -l <source location>\n"
						" -s <skill-level>\n"
						" -d <start date>\n"
						" -o <file to write to>\n"
						" -q\n");
				exit(-1);
			}

			if(last_arg != 0)
				ProcessArgs(cfg, last_arg, buff);

			last_arg = argv[i][1];
			buff[0] = 0;
			if(argv[i][2] != 0)
			    strcat(buff, &argv[i][2]);
		}
		else
		    strcat(buff, argv[i]);
		i++;
	}

	if(last_arg != 0)
	    ProcessArgs(cfg, last_arg, buff);
	
	if(cfg->src_name != NULL) {
		// XXX need this stuff?
		TCodes *codes;
		DetailSector *sect=NULL;

		codes = new TCodes(cfg_ptr);
		sect = new DetailSector(codes);

		if(sect->LoadFile(cfg->src_name) > 0) {
		} else {
			fprintf(stderr, "Problem with sector file %s\n", cfg->src_name);
			exit(-3);
		}

		delete sect;
		delete codes;
	}
}

void
TradeApp::ProcessArgs(struct conf_struct *cfg, char last_arg, char *buff)
{
bool no_err=TRUE;			

    switch(last_arg) {
		case 'F':
		    no_err = ParseString(&cfg->src_name, buff);
			break;
//		case 's':
//		    no_err = ParseString(&cfg->dest_name, buff);
//			break;
		case 'l':
			no_err = ParseLoc(&cfg->src, buff);
			break;
//		case 'l':
//			no_err = ParseLoc(&cfg->dest, buff);
//			break;
		case 's':
			no_err = ParseSkills(cfg, buff);
			break;
		case 'd':
			no_err = ParseDate(&cfg->init_date, buff);
			break;
		case 'o':
		    no_err = ParseString(&cfg->out_file, buff);
			break;
		case 'q':
			cfg->quiet_flag = TRUE;
			break;
	}
			
	if(!no_err) {
		fprintf(stderr, "Problem with parameter: %c <%s>\n", last_arg, buff);
		exit(-2);
	}
}

// ===============================================================
BEGIN_EVENT_TABLE(TradeFrame, wxFrame)
	EVT_MENU(TB_CONFIG, TradeFrame::Configure)
	EVT_MENU(TB_GEN, TradeFrame::Generate)
	EVT_MENU(TB_SAVE, TradeFrame::Save)
	EVT_MENU(TB_PRINT, TradeFrame::Print)
	EVT_MENU(TB_ABOUT, TradeFrame::OnAbout)
	EVT_MENU(TB_EXIT, TradeFrame::Exit)
	EVT_TOOL_ENTER(ID_TOOLBAR, TradeFrame::OnToolEnter)
END_EVENT_TABLE()
// ---------------------------------------------------------------
#define BUILD_FRAME_WIDTH         500
#define BUILD_FRAME_HEIGHT        400
#define BUILD_PANEL_HEIGHT        80

#define MAX_STATUS_BOX		4

TradeFrame::TradeFrame(struct conf_struct *c, char *cfg_ptr, char *data_ptr) :
  wxFrame(NULL, -1, "Generate Basic Trade", 
  		wxPoint(0, 0), wxSize(BUILD_FRAME_WIDTH, BUILD_FRAME_HEIGHT))
{
int status_widths[MAX_STATUS_BOX] = { -1, 128, 64, 64 };

	// null out the dialogs (create on the fly)
	dlg = NULL;

	// now do the window stuff
	CreateStatusBar(MAX_STATUS_BOX);
	SetStatusWidths(MAX_STATUS_BOX, status_widths);

	canvas = new TradeCanvas(this);
    canvas->SetScrollbars(4, 4, 300, 1700, 0, 0);
	canvas->SetBackgroundColour(*wxWHITE);

    // grab a copy of the cfg struct 
	cfg = c;

	// load the tables
	trade = new Trade(data_ptr);

	// get the locations....
	codes = new TCodes(cfg_ptr);
	sect = new DetailSector(codes);
	avail = NULL;

	if(sect->LoadFile(cfg->src_name) > 0) {
		if(sect->GetHex(cfg->src.hex_x, cfg->src.hex_y) != NULL) {
			GenerateTrade();
		}
	}
}

TradeFrame::~TradeFrame()
{
int i;

	// yuck.  this stuff really should be clean at the app level.....
	if(cfg->src_name != NULL) {
		delete cfg->src_name;
		cfg->src_name = NULL;
	}
//	if(cfg->dest_name != NULL) {
//		delete cfg->dest_name;
//		cfg->dest_name = NULL;
//	}
	if(cfg->out_file != NULL) {
		delete cfg->out_file;
		cfg->out_file = NULL;
	}
	for(i = 0;i < MAX_TRADE_SKILLS;i++) {
		if(cfg->skills[i] != NULL) {
			delete cfg->skills[i];
			cfg->skills[i] = NULL;
		}
	}
	delete cfg;
	CleanUp();
	app->CleanUp();
}

void
TradeFrame::CleanUp(void)
{
	if(trade != NULL) {
		delete trade;
		trade = NULL;
	}
	if(sect != NULL) {
		delete sect;
		sect = NULL;
	}
	if(codes != NULL) {
		delete codes;
		codes = NULL;
	}
	if(avail != NULL) {
		delete avail;
		avail = NULL;
	}
}

// ---------------------------------------------------------------
void
TradeFrame::GenerateTrade(void)
{
	if(avail != NULL)
		delete avail;
	avail = new AvailList(sect, cfg->src.hex_x, cfg->src.hex_y, 
		cfg->skills, cfg->levels, trade, cfg->full_book7, cfg->enhanced);
}

// ---------------------------------------------------------------

void
TradeFrame::Configure(wxCommandEvent& event)
{
char buff[BIG_BUFFER_SIZE*2];

	if(NULL == dlg)
		dlg = new TradeDialog(this);

	if(dlg->GetConfig(cfg)) {
		if(avail != NULL) {
			delete avail;
			avail = NULL;
		}

		sect->Clear();
		if(sect->LoadFile(cfg->src_name) > 0) {
			HexData *hd;

			if(((hd = sect->GetHex(cfg->src.hex_x, cfg->src.hex_y)) != NULL) &&
					(hd->world != NULL)) {
				GenerateTrade();
			} else {
				sprintf(buff, "Hex %02d%02d doesn't contain a world!",
						cfg->src.hex_x, cfg->src.hex_y);
				wxMessageBox(buff, "Error",
					wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
			}
		} else  {
			sprintf(buff, "%s doesn't appear to be a sector file!",
					cfg->src_name);
			wxMessageBox(buff, "Error",
				wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
		}

		canvas->Refresh();
	}
}

void
TradeFrame::Generate(wxCommandEvent& event)
{
	cfg->init_date.day += 7;
	if(cfg->init_date.day > 365) {
		cfg->init_date.day -= 365;
		cfg->init_date.year++;
	}
	GenerateTrade();

	canvas->Refresh();
}

void
TradeFrame::Print(wxCommandEvent& event)
{
	wxPrinter *printer;
	PrintOut *print_out;
	print_out = new PrintOut(trade, cfg, sect, avail);

	printer = new wxPrinter();
	printer->Print(this, print_out, TRUE);

	delete printer;
	delete print_out;
}

void
TradeFrame::Save(wxCommandEvent& event)
{
char *s;

	if(cfg->out_file == NULL) {
		wxString ptr;

		ptr = wxFileSelector("Save Trade", 
				NULL, 
				NULL,
				NULL,
				"*.txt",
				wxSAVE | wxHIDE_READONLY,
				this);
		s = (char *) ptr.GetData();
	} else
		s = cfg->out_file;

	if((s != NULL) && (s[0] != 0)) {
		FILE *fpx;

		if((fpx = fopen(s, "a+")) != NULL) {
			TradeDisplay *td;

			td = new TradeDisplay(fpx);
			td->DrawTrade(trade, cfg, sect, avail);

			delete td;
		}
	}
}

void
TradeFrame::Exit(wxCommandEvent& event)
{
	Close(TRUE);
}

void
TradeFrame::OnAbout(wxCommandEvent& event)
{
AboutDialog *dlg;

	dlg = new AboutDialog(this);
	dlg->ShowAbout("Trade Generator");
	delete dlg;
}

// ---------------------------------------------------------------
#define MAX_BUTTONS		6

static char *long_msgs[] = {
    "Configure Program",
	"Generate New Trade",
	"Save Current",
	"Print Current",
	"About The Trade Program",
	"Exit Program" 
	};

static char *short_msgs[] = {
    "Config",
	"Generate",
	"Save",
	"Print",
	"About",
	"Exit",
	};

void 
TradeFrame::InitButtons(wxToolBar *tb)
{
int i;
int currentX = DLG_OFFSET;
#ifdef __WXMSW__
  int width = 24;
#else
  int width = 16;
#endif
wxBitmap* bm[MAX_BUTTONS];

	// Set up toolbar
	tb->SetMargins(2, 2);

#ifdef __WXMSW__
	bm[0] = new wxBitmap("icon1");
	bm[1] = new wxBitmap("icon2");
	bm[2] = new wxBitmap("icon3");
	bm[3] = new wxBitmap("icon4");
	bm[4] = new wxBitmap("icon5");
	bm[5] = new wxBitmap("icon6");
#endif
#ifdef __WXGTK__
	bm[0] = new wxBitmap(config_xpm);
	bm[1] = new wxBitmap(restart_xpm);
	bm[2] = new wxBitmap(save_xpm);
	bm[3] = new wxBitmap(print_xpm);
	bm[4] = new wxBitmap(help_xpm);
	bm[5] = new wxBitmap(exit_xpm);
#endif

	for(i = 0;i < MAX_BUTTONS;i++) {
		tb->AddTool(TB_CONFIG + i, *(bm[i]), wxNullBitmap, FALSE,
			currentX, -1, NULL, 
			short_msgs[i], long_msgs[i]);
		currentX += width + DLG_OFFSET;
		if((0 == i) || (1 == i))
			tb->AddSeparator();
	}
		
	tb->Realize();

	// Can delete the bitmaps since they're reference counted
	for (i = 0; i < MAX_BUTTONS; i++)
		delete bm[i];
}

// ---------------------------------------------------------------
void
TradeFrame::Draw(wxDC *dc)
{
TradeDisplay *td;

	td = new TradeDisplay(dc);

	td->DrawTrade(trade, cfg, sect, avail);

	delete td;
}

void
TradeFrame::ClearEnc(void)
{
}

// ---------------------------------------------------------------
void
TradeFrame::OnToolEnter(wxCommandEvent& event)
{
int i=TB_CONFIG;
bool fail=TRUE;

	while(i <= TB_EXIT)
		{
		if(event.GetSelection() == i)
			{
			wxString str;
			str.Printf("%s", long_msgs[i - TB_CONFIG]);
			SetStatusText(str, 0);
			fail = FALSE;
			break;
			}
		i++;
		}
	if(fail)
		SetStatusText("", 0);
}

// ---------------------------------------------------------------
void
TradeFrame::UpdateStatus(void)
{
//char buff[BIG_BUFFER_SIZE];

	SetStatusText("");
}

// -------------------------------------------------------------------------
// =================================================================
// ===============================================================
// ===============================================================
TradeCanvas::TradeCanvas(wxWindow *frame,
						   int x, int y, int w, int h,
						   long style) :
    wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
}

void
TradeCanvas::OnDraw(wxDC& dc)
{
	if(frame != NULL) {
		dc.Clear();
		frame->Draw(&dc);
	}
	else
	    dc.Clear();
}

// =================================================================
TradeDisplay::~TradeDisplay()
{
}

int
TradeDisplay::DrawTrade(Trade *trade, conf_struct *cfg, BaseSector *sect,
			AvailList *list, char *msg1, char *msg2,
			int start_count, int total_count)
{
bool header=TRUE;
int ret=0,i=0;
TradeAvail *ta;

	Start(msg1);
	ret += DrawHeader(cfg);

	if(NULL == list)
		return(0);
	// find first to print
	while(list->GetTradeAvail(i) != NULL) {
		i++;
		if(i > start_count)
			break;
		header = FALSE;
	}

	// print header?
	if(header) {
		char buff1[2 * BIG_BUFFER_SIZE];
		char buff2[2 * BIG_BUFFER_SIZE];
		int j=0;
		HexData *hd;
		SpecTradeData *std;

		hd = sect->GetHex(cfg->src.hex_x, cfg->src.hex_y);
		sprintf(buff1, "%d-%d Cargo and Passengers Available at:  %s", 
				cfg->init_date.day, cfg->init_date.year,
				FormatLocation(buff2, cfg->src.hex_x+1, cfg->src.hex_y+1, 
				hd->world->GetName(), sect->GetName()));
		Line(buff1);
		Line(" ");
		Line("Speculative Trade:");
		// XXX spec trade....
		while((std = list->GetSpecTrade(j)) != NULL) {
			j++;
			if(std->GetIndFlag())
				sprintf(buff1," %d (%d tons) %s at %dCr each available (%dCr).",
					std->GetQuantity(), std->GetTonnage(), std->GetItem(), 
					std->GetValue(),
					std->GetQuantity() * std->GetValue());
			else
				sprintf(buff1, " %d tons %s at %dCr per ton available (%dCr).", 
					std->GetQuantity(), std->GetItem(), std->GetValue(),
					std->GetQuantity() * std->GetValue());
			Line(buff1);
		}
		if(!j)
			Line(" None");
		Line(" ");
	}

	// print what we can
	//  (NOTE: n should already be the first one to print)
	while((ta = list->GetTradeAvail(i)) != NULL) {
		i++;
		DrawTransport(trade, ta, sect);
		ret++;
		if((total_count > -1) && (ret > total_count))
			break;
	}

	Finish(msg2);
	return(ret);
}

int 
TradeDisplay::DrawHeader(conf_struct *cfg)
{
	return(0);
}

int 
TradeDisplay::DrawLines(Trade *trade)
{
	return(0);
}

int 
TradeDisplay::DrawTransport(Trade *trade, TradeAvail *ta, BaseSector *sect)
{
char buff1[2 * BIG_BUFFER_SIZE];
char buff2[2 * BIG_BUFFER_SIZE];
int col1,col2,col3,col4,x,y,i,ret=2,pass[MAX_NUMS],car[MAX_NUMS];
HexData *hd;
CargoPass *cp;

	// sub-header stuff
	ta->GetLoc(&x, &y);
	ta->GetAvailCargo(car);
	ta->GetAvailPass(pass);
	hd = sect->GetHex(x, y);
	sprintf(buff1, "Destination:  %s (%d)",
			FormatLocation(buff2, x+1, y+1, hd->world->GetName(), 
				sect->GetName()), ta->GetDist());
	Line(buff1);

	// figure out the columns
	cp = trade->GetPass();
	col1 = 0;
	for(i = 0;i < MAX_NUMS;i++) {
		if((int)(strlen(cp->GetName(i)) + 2) > col1)
			col1 = strlen(cp->GetName(i)) + 4;
	}
	col2 = col1 + 14;
	if((int)(strlen(cp->GetName()) + 1) > col2)
		col2 = strlen(cp->GetName()) + 1;
	sprintf(buff1, "%s", cp->GetName());
	strfixsize(buff1, col2);

	cp = trade->GetCargo();
	col3 = 0;
	for(i = 0;i < MAX_NUMS;i++) {
		if((int)(strlen(cp->GetName(i)) + 2) > col3)
			col3 = strlen(cp->GetName(i)) + 2;
	}
	col3 += col2;
	col4 = col3 + 6;
	if((int)(strlen(cp->GetName()) + 1) > col4)
		col4 = strlen(cp->GetName()) + 1;
	strcat(buff1, cp->GetName());
	Line(buff1);

	// print 'em
	for(i = 0;i < MAX_NUMS;i++) {
		cp = trade->GetPass();
		sprintf(buff1, "  %s: ", cp->GetName(i));
		strfixsize(buff1, col1);
		sprintf(buff2, "%5d", pass[i]);
		strcat(buff1, buff2);
		strfixsize(buff1, col2);

		cp = trade->GetCargo();
		sprintf(buff2, "%s: ", cp->GetName(i));
		strcat(buff1, buff2);
		strfixsize(buff1, col3);
		sprintf(buff2, "%5d", car[i]);
		strcat(buff1, buff2);
		strfixsize(buff1, col4);
		Line(buff1);
		ret++;
	}
	Line(" ");

	return(ret);
}

// problems with how name, and sect name are stored.
// could fix in lib, but might break other stuff.....
char *
TradeDisplay::FormatLocation(char *buff, int x, int y, char *n, char *s)
{
char buff1[2 * BIG_BUFFER_SIZE];
char buff2[2 * BIG_BUFFER_SIZE];

	sprintf(buff1, "%s", n);
	strstrip(buff1, TRUE);
	strstrip(buff1, FALSE);
	sprintf(buff2, "%s", s);
	strstrip(buff2, TRUE);
	strstrip(buff2, FALSE);

	sprintf(buff, "%02d%02d %s/%s", x+1, y+1, buff1, buff2);
	return(buff);
}

// =================================================================
#define LINES_PER_PAGE		90
PrintOut::PrintOut(Trade *t, conf_struct *c, BaseSector *s, AvailList *l)
{
	trade = t;
	cfg = c;
	sect = s;
	avail = l;

	page_max = ((2 + avail->SpecTradeCount() + 
				((avail->TradeAvailCount() + 1) * 6)) / LINES_PER_PAGE) + 1;
}

bool
PrintOut::HasPage(int page)
{
	if(page <= page_max)
		return(TRUE);
	else
		return(FALSE);
}

void
PrintOut::GetPageInfo(int *minPage, int *maxPage,
						int *selPageFrom, int *selPageTo)
{
	*minPage = *selPageFrom = 1;
	*maxPage = *selPageTo = page_max;
}

bool 
PrintOut::OnPrintPage(int page)
{
bool ret=FALSE;
wxDC *dc;
char buff[80];

	dc = GetDC();
	if((dc) && (page > 0) && (page <= page_max)) {
		//int line_count,temp_count,i,cur_count;
		int line_count,cur_count;
		int w,h,a_h,a_w;
		float scale;
		TradeDisplay *td;

		td = new TradeDisplay(dc, 60, 20);
		// figure out how much there is to work with
		dc->GetSize(&w,&h);
		a_h = h - 55;
		a_w = w - 35;
		
		sprintf(buff, "Page %d of %d", page, page_max);

		// fairly arbitrary, i would like about 100 lines......
		scale = (float)a_h / (float)(LINES_PER_PAGE * TEXT_Y_INCR);
		dc->SetUserScale(scale, scale);
		line_count = (LINES_PER_PAGE - 4) / 6;
		cur_count = (line_count * (page -1));
		// safely(?) assume that ind. rolls and table can fit
		td->DrawTrade(trade, cfg, sect, avail,
				NULL, buff, cur_count, line_count);

		delete td;
		ret = TRUE;
	}
	return(ret);
}

