/*
 * File:    sysgen.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sysgen.h,v $ $Revision: 1.9 $ $Author: man $ $Date: 2002/04/14 17:12:56 $" */

#ifndef SYSGEN_H
#define SYSGEN_H

#include "wx/timer.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "wx/socket.h"
#include "syst.h"
#include "t_frame.h"
#include "t_code.h"
#include "sg_dlg.h"
#include "t_dice.h"
#include "sg_build.h"

#define MAX_STARS              5

// ====================================================
// Define a new application
class SysgenApp: public wxApp
{
public:
    bool OnInit(void);

	void CleanUp(void);

	TCodes		*codes;

private:
	void ParseCommandLine(struct sys_conf *cfg);
	bool ParseString(char **dest, char *src);
	bool CopyString(char *dest, char *src, unsigned int sz);
	void ProcessArgs(struct sys_conf *cfg, char last_arg, char *buff,
					 int *star_count, char **sect_file);
};

// ========================================================================
class SysGenCanvas : public wxScrolledWindow
{
public:
    SysGenCanvas(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1,
				 long style = wxRETAINED);
	~SysGenCanvas();

	void OnDraw(wxDC& dc);
	
};

// ========================================================================
class InitTimer : public wxTimer
{
public:
    InitTimer();
	~InitTimer();

	void Notify(void);
};

// ========================================================================
class BuildFrame : public wxFrame
{
public:
    BuildFrame(struct sys_conf *c);
    ~BuildFrame();

	void InitQuiet(void);
	void InitBuild(void);

	void Proceed(void);

	void Draw(wxDC *dc);

private:
	void OnSize(wxSizeEvent& event);
	
	void Cancel(wxCommandEvent& event);
	void Prev(wxCommandEvent& event);
	void Next(wxCommandEvent& event);
	void End(wxCommandEvent& event);

	void Configure(wxCommandEvent& event);
	void Star1(wxCommandEvent& event);
	void Star2(wxCommandEvent& event);
	void Star3(wxCommandEvent& event);
	void Star4(wxCommandEvent& event);
	void Star5(wxCommandEvent& event);
	void Gg(wxCommandEvent& event);
	void Belt(wxCommandEvent& event);
	void Mw(wxCommandEvent& event);
	void Save(wxCommandEvent& event);
	void Exit(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	
	int DrawStar(int ndx, wxDC *dc, int x, int y);
	int DrawOrbit(BuildOrbit *bo, wxDC *dc, int x, int y);
	
	void DrawScale(wxDC& dc, int x, int y);
	void Text(wxDC& dc);

// stuff for semi-interactive frame
	void Process(void);


	void ReflectState(void);

	void EditStars(int ndx);
	void EditOrbit(bool gg);
	void EditMW(void);

	void CleanUp(void);

// common stuff for both frames
	SystemGenerate      *gen;
    struct sys_conf  cfg;

// stuff for the interactive frame
	SysGenCanvas        *canvas;
	wxPanel				*panel;
	wxPanel				*tb_init;
	wxPanel				*tb_stars;
	wxPanel				*tb_known;
	wxPanel				*tb_mw;
	wxPanel				*tb_finish;

	ConfigDialog        *config;
    EditStarDialog      *edit_star;
	MoveOrbDialog       *move;
	SelectOrbDialog     *select;
	SelectMWDialog      *mw_sel;

// stuff for the non-interactive frame
	wxGauge				*g;
	wxStaticText		*msg;
	InitTimer			*timer;

// stuff for semi-interactive frame
	bool				done_flag;

	DECLARE_EVENT_TABLE()
};

#endif
