/*
 * File:		syst_dlg.cpp
 * Purpose:		get system params from user
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: sg_dlg.cpp,v $ $Revision: 1.11 $ $Author: man $ $Date: 2003/05/04 12:47:39 $" */

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "sg_dlg.h"

#include "string.h"
#include "str_util.h"

#define DUMMY_INIT_STR      " XXXXXXXXXXXXXX "
#define DUMMY_INIT_STR1     " XX "

// control ids
#define ID_SPEC_BTN			600
#define ID_STAR_BTN			601
#define ID_LANG_BTN			602
#define ID_RAND_CB			603
#define ID_SUPPRES_CB		604
#define ID_SDEL_BTN			605
#define ID_OADD_BTN			606
#define ID_ODEL_BTN			607
#define ID_OED_BTN			608
#define ID_RANDOM_CB1		609
#define ID_RANDOM_CB2		610
#define ID_RANDOM_CB3		611
#define ID_NONE_CB1			612
#define ID_NONE_CB2			613
#define ID_NONE_CB3			614

static wxString num_str[7] = {
    "Random",
	" 0 ",
	" 1 ",
	" 2 ",
	" 3 ",
	" 4 ",
	" 5 ",
};

// ===============================================================
BEGIN_EVENT_TABLE(ConfigDialog, wxDialog)
	EVT_BUTTON(ID_SPEC_BTN, ConfigDialog::DoSpec)
	EVT_BUTTON(ID_STAR_BTN, ConfigDialog::DoStars)
	EVT_BUTTON(ID_LANG_BTN, ConfigDialog::DoLang)
	EVT_CHECKBOX(ID_RAND_CB, ConfigDialog::DoRand)
END_EVENT_TABLE()

// ---------------------------------------------------------------
ConfigDialog::ConfigDialog(wxWindow *p, BaseTable *bt, CodeTable *at) :
    StdDialog(p, "System Configuration")
{
wxStaticText *msgs[6];

    mw = NULL;
	st = NULL;
    b_table = bt;
	a_table = at;
// text based identification
	msgs[0] = new wxStaticText(this, -1, "Name:");
	msgs[1] = new wxStaticText(this, -1, "Location:");
	msgs[2] = new wxStaticText(this, -1, "Sector:");
	msgs[3] = new wxStaticText(this, -1, "SubSector:");

	name = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	name->SetValue("");
	loc = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	loc->SetValue("");
	sect = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	sect->SetValue("");
	ss = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	ss->SetValue("");

// special control
	rand = new wxCheckBox(this, ID_RAND_CB, "Full Random",
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 3), -1));
						  
// sub-dialog control
    trav_spec = new wxButton(this, ID_SPEC_BTN, "Main World",
			wxPoint(-1, -1),
			wxSize((int) (COL_OFFSET * 2.5), -1));
	stars = new wxButton(this, ID_STAR_BTN, "Stars",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));

// some system params
	msgs[4] = new wxStaticText(this, -1, "GG:");
	msgs[5] = new wxStaticText(this, -1, "Belts:");

	gg = new wxChoice(this, -1, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 3), -1),
			7, num_str);
	belts = new wxChoice(this, -1,
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 3), -1),
			5, num_str);

	lang = new wxStaticText(this, -1, "Language: XXXXXXXXXXXXXX");
//			wxPoint(DLG_COL1, DLG_ROW6 + DLG_OFFSET),
//			wxSize(COL_OFFSET * 2, -1));
	
	lang_btn = new wxButton(this, ID_LANG_BTN, "Change",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_6 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Misc"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(2, 2, 0, 0);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_3 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "System Identification"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(4, 2, 0, 0);
    grid_sizer_1->Add(msgs[0], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(name, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msgs[1], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(loc, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msgs[2], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(sect, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msgs[3], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(ss, 0, wxALL, DLG_OFFSET);
    sizer_3->Add(grid_sizer_1, 0, 0, 0);
    sizer_2->Add(sizer_3, 0, 0, 0);
    sizer_4->Add(rand, 0, wxALL, DLG_OFFSET);
    sizer_5->Add(trav_spec, 0, wxALL, DLG_OFFSET);
    sizer_5->Add(stars, 0, wxALL, DLG_OFFSET);
    sizer_4->Add(sizer_5, 0, 0, 0);
    grid_sizer_2->Add(msgs[4], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(gg, 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(msgs[5], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(belts, 0, wxALL, DLG_OFFSET);
    sizer_6->Add(grid_sizer_2, 0, 0, 0);
    sizer_4->Add(sizer_6, 0, 0, 0);
    sizer_2->Add(sizer_4, 0, 0, 0);
    sizer_1->Add(sizer_2, 0, 0, 0);
    sizer_7->Add(lang_btn, 0, wxALL, DLG_OFFSET);
    sizer_7->Add(lang, 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_1->Add(sizer_7, 0, 0, 0);

	DoLayout(wxALL, DLG_OFFSET, sizer_1);
}

bool
ConfigDialog::GetConfig(struct sys_conf *cfg)
{
char *ptr;

    data = cfg;

	if(cfg->name != NULL)
	    name->SetValue(cfg->name);
	else
	    name->SetValue("");
	if(cfg->sect != NULL)
	    sect->SetValue(cfg->sect);
	else
	    sect->SetValue("");
	if(cfg->ssect != NULL)
	    ss->SetValue(cfg->ssect);
	else
	    ss->SetValue("");
	if(cfg->loc != NULL)
	    loc->SetValue(cfg->loc);
	else
	    loc->SetValue("");

	belts->SetSelection(cfg->belts + 1);
	gg->SetSelection(cfg->gg + 1);

#if 0
	warn->SetValue(cfg->sup_warnings);
	st_adj->SetValue(cfg->sup_star_adjust);
#endif

	rand->SetValue(cfg->full_rand);
	Rand();

	temp_lang = cfg->lang;
	if(temp_lang == NULL) {
		lang->SetLabel("Language:");
		lang_btn->SetLabel("Change");
	} else {
		char buff[120];

		sprintf(buff, "Language: %s", temp_lang->GetName());
		lang->SetLabel(buff);
		lang_btn->SetLabel("Clear");
	}
	
	if(ShowModal() == wxID_CANCEL) {
		if((temp_lang != NULL) && (temp_lang != cfg->lang))
		    delete temp_lang;
	    return(FALSE);
	}

	if(cfg->name != NULL) {
		delete cfg->name;
		cfg->name = NULL;
	}
	ptr = (char *)name->GetValue().GetData();
	cfg->name = new char[strlen(ptr)+1];
	strcpy(cfg->name, ptr);
	
	if(cfg->sect != NULL) {
		delete cfg->sect;
		cfg->sect = NULL;
	}
	ptr = (char *)sect->GetValue().GetData();
	cfg->sect = new char[strlen(ptr)+1];
	strcpy(cfg->sect, ptr);
	
	if(cfg->ssect != NULL) {
		delete cfg->ssect;
		cfg->ssect = NULL;
	}
	ptr = (char *)ss->GetValue().GetData();
	cfg->ssect = new char[strlen(ptr)+1];
	strcpy(cfg->ssect, ptr);
	
	if(cfg->loc != NULL) {
		delete cfg->loc;
		cfg->loc = NULL;
	}
	ptr = (char *)loc->GetValue().GetData();
	cfg->loc = new char[strlen(ptr)+1];
	strcpy(cfg->loc, ptr);

#if 0
	cfg->sup_warnings = warn->GetValue();
	cfg->sup_star_adjust = st_adj->GetValue();
#endif
	
	cfg->full_rand = rand->GetValue();
	if(rand->GetValue()) {
		cfg->belts = cfg->gg = -1;
		cfg->stars[0][0] = cfg->stars[1][0] = cfg->stars[2][0] = 'R';
		cfg->no_main = TRUE;
	} else {
		cfg->belts = belts->GetSelection() - 1;
		cfg->gg = gg->GetSelection() - 1;
	}

	if(cfg->lang != NULL) {
		if(temp_lang == NULL)
		    delete cfg->lang;
		else {
			if(cfg->lang != temp_lang) {
				delete cfg->lang;
				cfg->lang = temp_lang;
			}
		}
	} else {
		if(temp_lang != NULL)
		    cfg->lang = temp_lang;
	}
	
	return(TRUE);
}

// ---------------------------------------------------------------
void
ConfigDialog::DoRand(wxCommandEvent& event)
{
	Rand();
}

void
ConfigDialog::Rand(void)
{
bool state;

    state = !rand->GetValue();
	trav_spec->Enable(state);
	stars->Enable(state);
	gg->Enable(state);
	belts->Enable(state);
}

void 
ConfigDialog::DoSpec(wxCommandEvent& event)
{
    if(mw == NULL)
	    mw = new MWDialog(this, b_table, a_table);
	if(mw->GetMW(data->uwp, data->bases, data->alleg,
				 data->zone, &data->no_main,
				 b_table, a_table)) {
	}
}

void 
ConfigDialog::DoStars(wxCommandEvent& event)
{
    if(st == NULL)
	    st = new StarDialog(this);
	if(st->GetStars(data->stars[0], data->stars[1], data->stars[2])) {
	}
}

void
ConfigDialog::DoLang(wxCommandEvent& event)
{
    if(temp_lang == NULL) {
		wxString str;
		char *ptr;

		str = wxFileSelector("Language File", NULL, NULL, "lng", "*.lng",
								 0, this);
		ptr = (char *)str.GetData();
		if(ptr[0] != 0) {
			temp_lang = new WordGen(ptr);
			if(temp_lang->Valid()) {
				char buff[120];

				sprintf(buff, "Language: %s", temp_lang->GetName());
				lang->SetLabel(buff);
				lang_btn->SetLabel("Clear");
			} else {
				wxMessageBox("Bad Language File!", "Error",
							 wxOK | wxCENTRE | wxICON_EXCLAMATION,
							 this);
				delete temp_lang;
				temp_lang = NULL;
			}
		}
	} else {
		temp_lang = NULL;
		lang->SetLabel("Language:");
		lang_btn->SetLabel("Change");
	}
}

// ===============================================================
BEGIN_EVENT_TABLE(MWDialog, wxDialog)
	EVT_CHECKBOX(ID_SUPPRES_CB, MWDialog::Suppress)
END_EVENT_TABLE()
  
// ---------------------------------------------------------------
MWDialog::MWDialog(wxWindow *p, BaseTable *bt, CodeTable *at) :
    StdDialog(p, "Main World Configuration")
{
wxStaticText *dummy;
wxBoxSizer *panel_sizer;

	uwp_box = new UWPBox(this, "UWP");

	msg[0] = new wxStaticText(this, -1, "Bases");
	bases = new CodeList(this, TRUE);

	msg[1] = new wxStaticText(this, -1, "Allegance");
	alleg = new CodeList(this, TRUE);

	msg[2] = new wxStaticText(this, -1, "Zone:");
	zone = new ZoneChoice(this, TRUE);

	suppress = new wxCheckBox(this, ID_SUPPRES_CB, 
			"No Initial Main World");
	
	dummy = new wxStaticText(this, -1, "");

	wxBoxSizer* sizer_6 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(4, 2, 0, 0);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_8 = uwp_box->GetSizer();
    sizer_7->Add(sizer_8, 0, wxALL, DLG_OFFSET);

	panel_sizer = GetSizer();
	sizer_7->Add(panel_sizer, 0, wxALL, DLG_OFFSET);

    sizer_6->Add(sizer_7, 0, 0, 0);
    grid_sizer_1->Add(msg[0], 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msg[1], 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(bases, 1, wxALL, DLG_OFFSET/2);
    grid_sizer_1->Add(alleg, 1, wxALL, DLG_OFFSET/2);
    grid_sizer_1->Add(msg[2], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_1->Add(suppress, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_1->Add(zone, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_1->Add(dummy, 0, 0, 0);
    sizer_6->Add(grid_sizer_1, 0, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(sizer_6);
    sizer_6->Fit(this);
    sizer_6->SetSizeHints(this);
    Layout();
}

bool
MWDialog::GetMW(char *u, char *ba, char *a, char *z, bool *supp,
		BaseTable *bt, CodeTable *at)
{
int i;
char *ptr;

	uwp_box->SetUWP(u, UI_SECTOR);
	zone->SetZone(z[0]);
	bases->SetCode(ba, bt);
	alleg->SetCode(a, at);
	suppress->SetValue(*supp);

	uwp_box->Enable(!*supp);
	for(i = 0;i < 3;i++)
	    msg[i]->Enable(!*supp);
  	bases->Enable(!*supp);
	alleg->Enable(!*supp);
	zone->Enable(!*supp);
	
	if(ShowModal() == wxID_CANCEL)
	    return(FALSE);

	*supp = suppress->GetValue();
	if(!*supp) {
		uwp_box->GetUWP(u);
		ptr = bases->GetCode();
		ba[0] = ptr[0];
		ba[1] = 0;
		ptr= alleg->GetCode();
		a[0] = ptr[0];
		a[1] = ptr[1];
		a[2] = 0;
		z[0] = zone->GetZone();
	}

	return(TRUE);
}

void
MWDialog::Suppress(wxCommandEvent& event)
{
bool state;
int i;

    state = !suppress->GetValue();
	uwp_box->Enable(state);
	for(i = 0;i < 3;i++)
	    msg[i]->Enable(state);

	bases->Enable(state);
	alleg->Enable(state);
	zone->Enable(state);
}

// ===============================================================
BEGIN_EVENT_TABLE(StarDialog, wxDialog)
	EVT_CHECKBOX(ID_RANDOM_CB1, StarDialog::Random1)
	EVT_CHECKBOX(ID_RANDOM_CB2, StarDialog::Random2)
	EVT_CHECKBOX(ID_RANDOM_CB3, StarDialog::Random3)
	EVT_CHECKBOX(ID_NONE_CB1, StarDialog::None1)
	EVT_CHECKBOX(ID_NONE_CB2, StarDialog::None2)
	EVT_CHECKBOX(ID_NONE_CB3, StarDialog::None3)
END_EVENT_TABLE()

// ----------------------------------------------------------------
StarDialog::StarDialog(wxWindow *p) :
    StdDialog(p, "Stellar Configuration")
{
int i;
wxBoxSizer *main_sizer;
wxFlexGridSizer *gs;
wxStaticText *dummy;

	for(i = 0;i < MAX_STAR_CHOICES;i++) {
		char buff[12];

		if(i != 0)
			none[i] = new wxCheckBox(this, ID_NONE_CB1+i, "None");
		random[i] = new wxCheckBox(this, ID_RANDOM_CB1+i, "Random");
		sprintf(buff, "Star %d", i + 1);
		stars[i] = new StarBox(this, buff);
	}
	dummy = new wxStaticText(this, -1, "");


	gs = new wxFlexGridSizer(3, 3, 0, 0);
	main_sizer = new wxBoxSizer(wxVERTICAL);

	gs->Add(dummy, 0, wxALL, DLG_OFFSET/2);
	gs->Add(none[1], 0, wxALL, DLG_OFFSET/2);
	gs->Add(none[2], 0, wxALL, DLG_OFFSET/2);
	gs->Add(random[0], 0, wxALL, DLG_OFFSET/2);
	gs->Add(random[1], 0, wxALL, DLG_OFFSET/2);
	gs->Add(random[2], 0, wxALL, DLG_OFFSET/2);
	gs->Add(stars[0]->GetSizer(), 0, wxALL, DLG_OFFSET/2);
	gs->Add(stars[1]->GetSizer(), 0, wxALL, DLG_OFFSET/2);
	gs->Add(stars[2]->GetSizer(), 0, wxALL, DLG_OFFSET/2);
	main_sizer->Add(gs, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

bool
StarDialog::GetStars(char *st1, char *st2, char *st3)
{
char dummy[5] = { "B0Ia" };
int i;

    for(i = 0;i < MAX_STAR_CHOICES;i++) {
		stars[i]->SetStar(dummy);
		if(i != 0)
			none[i]->SetValue(FALSE);
		random[i]->SetValue(FALSE);
	}

	if('R' == st1[0])
		random[0]->SetValue(TRUE);
	Random(0);
	stars[0]->SetStar(st1);

	if('N' == st2[0])
		none[1]->SetValue(TRUE);
	if('R' == st2[0])
		random[1]->SetValue(TRUE);
	None(1);
	stars[1]->SetStar(st2);

	if('N' == st3[0])
		none[2]->SetValue(TRUE);
	if('R' == st3[0])
		random[2]->SetValue(TRUE);
	None(2);
	stars[2]->SetStar(st3);

	if(ShowModal() == wxID_CANCEL)
	    return(FALSE);

	if(random[0]->GetValue())
		st1[0] = 'R';
	else
		stars[0]->GetStar(st1);

	if(none[1]->GetValue())
		st2[1] = 'N';
	else if(random[1]->GetValue())
		st2[1] = 'R';
	else
		stars[1]->GetStar(st2);

	if(none[2]->GetValue())
		st3[2] = 'N';
	else if(random[2]->GetValue())
		st3[2] = 'R';
	else
		stars[2]->GetStar(st3);

	return(TRUE);
}

void 
StarDialog::None1(wxCommandEvent& event)
{
	None(0);
}

void 
StarDialog::None2(wxCommandEvent& event)
{
	None(1);
}

void 
StarDialog::None3(wxCommandEvent& event)
{
	None(2);
}

void 
StarDialog::None(int n)
{
bool state;

    state = !none[n]->GetValue();
	random[n]->Enable(state);
	stars[n]->Enable(state);
//	Random(n);
}

void 
StarDialog::Random1(wxCommandEvent& event)
{
	Random(0);
}

void 
StarDialog::Random2(wxCommandEvent& event)
{
	Random(1);
}

void 
StarDialog::Random3(wxCommandEvent& event)
{
	Random(2);
}

void 
StarDialog::Random(int n)
{
bool state;

    state = !random[n]->GetValue();
	stars[n]->Enable(state);
}


// ===============================================================
BEGIN_EVENT_TABLE(EditStarDialog, wxDialog)
	EVT_BUTTON(ID_SDEL_BTN, EditStarDialog::DoDel)
END_EVENT_TABLE()
  
// ---------------------------------------------------------------
EditStarDialog::EditStarDialog(wxWindow *p) :
    StdDialog(p, "Edit Star")
{
int i;
wxStaticText *msg[10];
wxStaticText *dummy[4];
wxBoxSizer *panel_sizer;

	star = new StarBox(this, "Star");

    msg[3] = new wxStaticText(this, -1, "Orbit:");
    msg[4] = new wxStaticText(this, -1, "Last Orbit:");
    msg[5] = new wxStaticText(this, -1, "Capt. Orbit:");
    msg[6] = new wxStaticText(this, -1, "Empty Orbit:");

	orbit = new wxTextCtrl(this, -1, DUMMY_INIT_STR1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 1, -1));
	last_orbit = new wxTextCtrl(this, -1, DUMMY_INIT_STR1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 1, -1));

	for(i = 0;i < 3;i++)
	    capt_orb[i] = new wxTextCtrl(this, -1, DUMMY_INIT_STR1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 1, -1));

	for(i = 0;i < 3;i++)
	    mt_orb[i] = new wxTextCtrl(this, -1, DUMMY_INIT_STR1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 1, -1));

	msg[7] = new wxStaticText(this, -1, 
			"'C' for orbit yields a close orbit,");
	msg[8] = new wxStaticText(this, -1, 
			"'N' for last orbit yields no orbits.");

	del = new wxButton(this, ID_SDEL_BTN, "Delete",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));

	for(i = 0;i < 4;i++)
		dummy[i] = new wxStaticText(this, -1, "");

	wxBoxSizer* sizer_10 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_13 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_14 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(4, 4, 0, 0);
    wxBoxSizer* sizer_11 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_12 = star->GetSizer();
    sizer_11->Add(sizer_12, 0, wxALL, DLG_OFFSET);
    sizer_11->Add(del, 0, wxALL, DLG_OFFSET);

	panel_sizer = GetSizer();
	sizer_11->Add(panel_sizer, 0, wxALL, DLG_OFFSET);

    sizer_10->Add(sizer_11, 0, 0, 0);
    grid_sizer_2->Add(msg[3], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(orbit, 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(dummy[0], 0, 0, 0);
    grid_sizer_2->Add(dummy[1], 0, 0, 0);
    grid_sizer_2->Add(msg[4], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(last_orbit, 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(dummy[2], 0, 0, 0);
    grid_sizer_2->Add(dummy[3], 0, 0, 0);
    grid_sizer_2->Add(msg[5], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(capt_orb[0], 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(capt_orb[1], 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(capt_orb[2], 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(msg[6], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(mt_orb[0], 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(mt_orb[1], 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(mt_orb[2], 0, wxALL, DLG_OFFSET);
    sizer_13->Add(grid_sizer_2, 0, 0, 0);
    sizer_14->Add(msg[7], 0, wxALL|wxALIGN_CENTER_VERTICAL, DLG_OFFSET);
    sizer_14->Add(msg[8], 0, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, DLG_OFFSET);
    sizer_13->Add(sizer_14, 0, 0, 0);
    sizer_10->Add(sizer_13, 0, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(sizer_10);
    sizer_10->Fit(this);
    sizer_10->SetSizeHints(this);
    Layout();
}

void
EditStarDialog::DoDel(wxCommandEvent& event)
{
int i;

    del_flag = TRUE;

	star->Enable(FALSE);

	orbit->Enable(FALSE);
	last_orbit->Enable(FALSE);

	for(i = 0;i < 3;i++) {
		capt_orb[i]->Enable(FALSE);
		mt_orb[i]->Enable(FALSE);
	}

	del->Enable(FALSE);
}

bool
EditStarDialog::GetStar(int ndx, SystemGenerate *sg)
{
int i;
int t,c,s;
char lbuff[20];
char dummy[5] = { "B0Ia" };
char *ptr;
BuildStar *bs;
bool trunc_orb=FALSE;

    bs = sg->GetStar(ndx);
  // defaults
	del_flag = FALSE;
	star->SetStar(dummy);
	orbit->SetValue("");
	last_orbit->SetValue("");
	last_orbit->Enable(TRUE);
	for(i = 0;i < 3;i++) {
		capt_orb[i]->SetValue("");
		capt_orb[i]->Enable(TRUE);
		mt_orb[i]->SetValue("");
		mt_orb[i]->Enable(TRUE);
	}

	if((bs != NULL) && (!bs->Edit())) {
		star->Enable(FALSE);
	} else {
		star->Enable(TRUE);
	}

	if(ndx == 0)
	    orbit->Enable(FALSE);
	else
	    orbit->Enable(TRUE);

	if((ndx == 0) || ((bs != NULL) && (!bs->Edit())))
	    del->Enable(FALSE);
	else
	    del->Enable(TRUE);

	if(bs != NULL) {
		t = bs->GetStarType();
		c = bs->GetStarClass();
		s = bs->GetStarSize();
		star->SetStar(&t, &c, &s);
		if(bs->GetOrbit() > -1)
		    sprintf(lbuff, "%d", bs->GetOrbit());
		else
		    sprintf(lbuff, "C");
		orbit->SetValue(lbuff);
		if(bs->GetNumOrbits() > -1)
		    sprintf(lbuff, "%d", bs->GetNumOrbits());
		else
		    sprintf(lbuff, "N");
		last_orbit->SetValue(lbuff);
		for(i = 0;i < 3;i++) {
			if(bs->GetCapt(i) > -1) {
			    sprintf(lbuff, "%d", bs->GetCapt(i));
				capt_orb[i]->SetValue(lbuff);
			}
			if(bs->GetEmpty(i) > -1) {
				sprintf(lbuff, "%d", bs->GetEmpty(i));
				mt_orb[i]->SetValue(lbuff);
			}
		}
	}

	if(ShowModal() == wxID_CANCEL)
	    return(FALSE);

	if(del_flag)
		sg->DeleteStar(ndx);
	else {
		star->GetStar(&t, &c, &s);
// warning here (also about size VII)
		if((s == 4) && ((t == 5) || ((t == 4) && (c > 4))))
		    s = 5;
		if((s == 6) && ((t < 3) || ((t == 3) && (c < 5))))
		    s = 5;
		if((bs = sg->GetStar(ndx)) == NULL) {
			bs = new BuildStar(NULL, t, c, s, TRUE, sg->GetGenUWP());
			sg->AddStar(ndx, bs);
		} else {
			bs->SetStarType(t);
			bs->SetStarClass(c);
			bs->SetStarSize(s);
		}

		if(ndx > 0) {  
			ptr = (char *)orbit->GetValue().GetData();
			if((ptr == NULL) || (ptr[0] == 'C') || (ptr[0] == 'c') ||
				 (ptr == "")) {
				  bs->SetOrbit(ORBIT_CLOSE);
				  trunc_orb = TRUE;
			} else {
				  int val;

				  val = atoi(ptr);
				  if(val < 0)
					  val = ORBIT_UNDEFINED;
				  bs->SetOrbit(val);
			}
		}

		if(trunc_orb) {
			// warnings here
			bs->SetNumOrbits(ORBIT_UNDEFINED);
			trunc_orb = TRUE;
		} else {
			ptr = (char *)last_orbit->GetValue().GetData();
			if((ptr == NULL) || (ptr[0] == 'N') || (ptr[0] == 'n') ||
			   (ptr == "")) {
				bs->SetNumOrbits(ORBIT_UNDEFINED);
				trunc_orb = TRUE;
			} else {
				int val;

				val = atoi(ptr);
				if(val < 0)
				    val = ORBIT_UNDEFINED;
				bs->SetNumOrbits(val);
			}
		}

		if(trunc_orb) {
			// warnings here
			for(i = 0;i < 3;i++) {
				bs->RemEmpty(i);
				bs->RemCapt(i);
			}
		} else {
			int val;

			for(i = 0;i < 3;i++) {
				ptr = (char *)capt_orb[i]->GetValue().GetData();
				val = atoi(ptr);
				// warnings here?
				if((val < 0) || (ptr[0] == 0))
				    val = ORBIT_UNDEFINED;
				else if(val > bs->GetNumOrbits())
				    val = bs->GetNumOrbits();
				bs->SetCapt(i, val);

				ptr = (char *)mt_orb[i]->GetValue().GetData();
				val = atoi(ptr);
				// warnings here?
				if((val < 0) || (ptr[0] == 0))
				    val = ORBIT_UNDEFINED;
				else if(val > bs->GetNumOrbits())
				    val = bs->GetNumOrbits();
				bs->SetEmpty(i, val);
			}
		}
	}

	if(sg->VerifyStarOrbits()) {
// warnings here
	}

	bs->ValidateAllOrbits();
	
	return(TRUE);
}

// ===============================================================
MoveOrbDialog::MoveOrbDialog(wxWindow *p) :
    StdDialog(p, "Delete this")
{
wxStaticText *msg[2];

    msg[0] = new wxStaticText(this, -1, "Star:");
    msg[1] = new wxStaticText(this, -1, "Orbit:");

	star = new wxChoice(this, -1,
			wxPoint(-1, -1),
			wxSize((int)(COL_OFFSET * 1.5), -1),
			5, &num_str[1]);
	orb = new wxTextCtrl(this, -1, DUMMY_INIT_STR1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET, -1));

	wxBoxSizer* sizer_4 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(2, 2, 0, 0);
    grid_sizer_1->Add(msg[0], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(star, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msg[1], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_1->Add(orb, 0, wxALL, DLG_OFFSET);
    sizer_4->Add(grid_sizer_1, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_4);
}

bool
MoveOrbDialog::GetOrbit(char *title, SystemGenerate *sg,
						int *st_ndx, int *orbit, bool sat_ok)
{
int i,j;
int star_map[MAX_STARS],star_sel;
char buff[20];

    SetTitle(title);

	j = 0;
	star->Clear();
	for(i = 0;i < MAX_STARS;i++)
	    star_map[i] = -1;
	for(i = 0;i < MAX_STARS;i++) {
		if(sg->GetStar(i) != NULL) {
			star_map[j] = i;
			if(i == *st_ndx)
			    star_sel = j;
			sprintf(buff, " %d ", i + 1);
			star->Append(buff);
			j++;
		}
	}

	if(j < 2)
	    star->Enable(FALSE);
	else
	    star->Enable(TRUE);

	while(TRUE) {
		int s,o;
		char *ptr,buff[20];

		star->SetSelection(star_sel);
		sprintf(buff, "%d", *orbit);
		orb->SetValue(buff);

		if(ShowModal() == wxID_CANCEL)
		    return(FALSE);

		s = star_map[star->GetSelection()];
		ptr = (char *)orb->GetValue().GetData();
		o = atoi(ptr);

		if(sg->OrbitAvail(s, o, sat_ok)) {
			 *st_ndx = s;
			 *orbit = o;
			 return(TRUE);
		}

		wxMessageBox("Invalid Orbit!", "Error",
					 wxOK | wxCENTRE | wxICON_EXCLAMATION);
	}
	
	return(FALSE);
}

// ===============================================================
BEGIN_EVENT_TABLE(SelectOrbDialog, wxDialog)
	EVT_BUTTON(ID_OADD_BTN, SelectOrbDialog::DoAdd)
	EVT_BUTTON(ID_ODEL_BTN, SelectOrbDialog::DoDel)
	EVT_BUTTON(ID_OED_BTN, SelectOrbDialog::DoEdit)
END_EVENT_TABLE()

// ---------------------------------------------------------------
SelectOrbDialog::SelectOrbDialog(wxWindow *p) :
    StdDialog(p, "Delete this", FALSE)
{
int w;

	w = GetBestSize().GetWidth();

    dlg = NULL;

    orbs = new wxListBox(this, -1,
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, ROW_OFFSET * 5),
			0, NULL);

	add = new wxButton(this, ID_OADD_BTN, "Add",
			wxPoint(-1, -1),
			wxSize(w, -1));
	del = new wxButton(this, ID_ODEL_BTN, "Delete",
			wxPoint(-1, -1),
			wxSize(w, -1));
	edit = new wxButton(this, ID_OED_BTN, "Edit",
			wxPoint(-1, -1),
			wxSize(w, -1));

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxVERTICAL);
    sizer_1->Add(orbs, 1, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_3->Add(add, 0, wxALL, DLG_OFFSET / 2);
    sizer_3->Add(del, 0, wxALL, DLG_OFFSET / 2);
    sizer_3->Add(edit, 0, wxALL, DLG_OFFSET / 2);
    sizer_2->Add(sizer_3, 0, wxALL, (int) (1.5 * DLG_OFFSET));

    sizer_1->Add(sizer_2, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_1, sizer_2);
}

bool
SelectOrbDialog::DoOrbSelect(char *title, struct sys_conf *cfg,
							 SystemGenerate *sg, bool gg)
{
int i,j,k;
char buff[20];

    SetTitle(title);
	Fit();
	gen = sg;
	gg_flag = gg;
	orbs->Clear();
	j = 0;
	for(i = 0;i < MAX_STARS;i++)
	    st_ndx[i] = -1;
	
	for(i = 0;i < MAX_STARS;i++) {
		BuildStar *bs;
		
		if((bs = sg->GetStar(i)) != NULL) {
			if(gg) k = MAX_GG;
			else k = MAX_BELTS;
			for(j = 0;j < k;j++) {
				int o;
				
				if(gg)
				    o = bs->GetGGOrbit(j);
				else
				    o = bs->GetBeltOrbit(j);
				if(o >= 0) {
					sprintf(buff, "%d:%d", i+1, o);
					orbs->Append(buff);
					orbits[j] = o;
					st_ndx[j] = i;
				}
			}
		}
	}

	no_add_del = TRUE;
	max = -1;
	if(gg) {
		if(cfg->gg < 0) {
		    no_add_del = FALSE;
			max = MAX_GG;
		}
	} else {
		if(cfg->belts < 0) {
		    no_add_del = FALSE;
			max = MAX_BELTS;
		}
	}

	add->Enable(!no_add_del);
	del->Enable(!no_add_del);
	CheckButtons();
	
	if(ShowModal() == wxID_CANCEL) {
		BuildStar *bs;

		for(i = 0;i < MAX_STARS;i++)
		    if((bs = sg->GetStar(i)) != NULL) {
				if(gg)
				    bs->ClearGG();
				else
				    bs->ClearBelts();
			}

		for(i = 0;i < MAX_STARS;i++) {
			if((bs = sg->GetStar(i)) != NULL) {
				for(j = 0;j < MAX_GG;j++) {
					if(i == st_ndx[j]) {
						if(gg)
						    bs->SetGGOrbit(orbits[j]);
						else
						    bs->SetBeltOrbit(orbits[j]);
						st_ndx[j] = -1;
					} 
				}
			}
		}
		
	    return(FALSE);
	}

	return(TRUE);
}

void
SelectOrbDialog::CheckButtons(void)
{
    if(!no_add_del) {
		if(orbs->Number() >= max)
		    add->Enable(FALSE);
		else
		    add->Enable(TRUE);
		if(orbs->Number() <= 0)
		    del->Enable(FALSE);
		else
		    del->Enable(TRUE);
	}
}

// ---------------------------------------------------------------
bool
SelectOrbDialog::CrackSelection(int *st, int *o)
{
char *ptr;
int i;

    if((ptr = (char *)orbs->GetStringSelection().GetData()) == NULL)
	    return(FALSE);

	i = ptr[0] - '1';
	*st = i;
	i = atoi(&ptr[2]);
	*o = i;

	return(TRUE);
}

// ---------------------------------------------------------------
void
SelectOrbDialog::DoAdd(wxCommandEvent& event)
{
int st=0,o=0;
char buff[20],*ptr;

    if(gg_flag)
	    ptr = "Add GG Orbit";
	else
	    ptr = "Add Belt Orbit";

	if(NULL == dlg);
	    dlg = new MoveOrbDialog(this);

	if(dlg->GetOrbit(ptr, gen, &st, &o)) {
		BuildStar *bs;

		if((bs = gen->GetStar(st)) != NULL) {
			if(gg_flag)
			    bs->SetGGOrbit(o);
			else
			    bs->SetBeltOrbit(o);
			sprintf(buff, "%d:%d", st + 1, o);
			orbs->Append(buff);
			CheckButtons();
		}
	}
}

void
SelectOrbDialog::DoDel(wxCommandEvent& event)
{
int st,o;
BuildStar *bs;

    if(CrackSelection(&st, &o)) {
		if((bs = gen->GetStar(st)) != NULL) {
			if(gg_flag)
			    bs->DeleteGG(o);
			else
			    bs->DeleteBelt(o);
		}
		orbs->Delete(orbs->GetSelection());
		CheckButtons();
	}
}

void
SelectOrbDialog::DoEdit(wxCommandEvent& event)
{
int st,o;
char buff[20],*ptr;;

    if(CrackSelection(&st, &o)) {
		if(gg_flag)
		    ptr = "Edit GG Orbit";
		else
		    ptr = "Edit Belt Orbit";

		if(NULL == dlg);
	    	dlg = new MoveOrbDialog(this);

		if(dlg->GetOrbit(ptr, gen, &st, &o)) {
			BuildStar *bs;

			if((bs = gen->GetStar(st)) != NULL) {
				if(gg_flag)
				    bs->DeleteGG(o);
				else
				    bs->DeleteBelt(o);
		   
				sprintf(buff, "%d:%d", st + 1, o);
				orbs->SetString(orbs->GetSelection(), buff);
				CheckButtons();
			}
		}
	}
}

// ===============================================================
SelectMWDialog::SelectMWDialog(wxWindow *p) :
    StdDialog(p, "Select Main World")
{
wxBoxSizer *bs;

    orbs = new wxListBox(this, -1,
			wxPoint(-1, -1),
			wxSize(4 * COL_OFFSET, (6 * ROW_OFFSET)),
			0, NULL);

	bs = new wxBoxSizer(wxVERTICAL);
	bs->Add(orbs, 0, wxALL | wxEXPAND, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, bs);

	map = new wxList();
}

bool
SelectMWDialog::SelectMW(SystemGenerate *sg, int *st, int *ndx, int *sat)
{
int i,j,k,sel=0,count=0,ret;
char buff[40];
OrbMapElement *ome;
wxNode *n;

	orbs->Clear();

	for(i = 0;i < MAX_STARS;i++) {
		BuildStar *bs;
		BuildOrbit *bo,*bos;
		
		if((bs = sg->GetStar(i)) != NULL) {
			j = 0;
			while((bo = bs->GetWorldOrbit(j)) != NULL) {
				AppendOrbit(bo, NULL, i, j);

				if((*st == i) && (*ndx == j) && (*sat == -1))
				    sel = count;
				count++;
				bo->FormatOrbit(buff);
				k = 0;
				while((bos = bo->GetSat(k)) != NULL) {
					AppendOrbit(bos, buff, i, j, k);
					if((*st == i) && (*ndx == j) && (*sat == k))
					    sel = count;
					count++;
					k++;
				}
				j++;
			}
		}
	}

	orbs->SetSelection(sel);
	
	ShowModal();

	i = orbs->GetSelection();
	if(i > -1) {
		n = map->Nth(i);
		ome = (OrbMapElement *) n->Data();

		*st = ome->st;
		*ndx = ome->ndx;
		*sat = ome->sat;
	}
		
	n = map->First();
	while(n != NULL) {
		ome = (OrbMapElement *) n->Data();
		delete ome;
		delete n;
		n = map->First();
	}
	
	if(wxID_CANCEL == ret)
	    return(FALSE);

	return(TRUE);
}

void
SelectMWDialog::AppendOrbit(BuildOrbit *bo, char *data, int s, int n, int a)
{
char *ptr,buff[40], buff2[10];
OrbMapElement *ome;

    ptr = bo->GetData();
	// anything but ggs or rings
	if((ptr[1] != 'm') && (ptr[1] != 'a') && (ptr[1] != 'R'))  {
		if(data == NULL)
		    sprintf(buff, "%d:%s %s", s, bo->FormatOrbit(buff2), ptr);
		else
		    sprintf(buff, "%d:%s:%s %s", s, data, bo->FormatOrbit(buff2), ptr);
		orbs->Append(buff);
		ome = new OrbMapElement(s, n, a);
		map->Append(ome);
	}
}
// ===============================================================
