/////////////////////////////////////////////////////////////////////////////
// Name:        sector.h
// Purpose:     Traveller sector mapping
// Author:      Mark A. Nodstrand
// Modified by:
// Created:     07/22/98
// Copyright: LGPL.
//            Traveller is a registered trademark of Far Future Enterprises.
// Licence:   	wxWindows license
/////////////////////////////////////////////////////////////////////////////

// RCS-ID:      rcsid[] = "$RCSfile: sector.h,v $ $Revision: 1.22 $ $Author: man $ $Date: 2003/05/04 02:36:48 $"
//
#ifndef SECTOR_H
#define SECTOR_H

// compile time features
//  how many of these can be deleted?
#define SECT_MENUS 1
#define POPUP_MENUS
#define SEPERATE_WINDOWS

#include "d_sect.h"
#include "legend.h"
#include "sect_dlg.h"
#include "srch_dlg.h"
#include "t_bm.h"
#include "t_menu.h"
#include "code_dlg.h"
#include "mtu_file.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"

// misc flags (obsolete?)
#define MODE_FLAG_LOADED		1
#define MODE_FLAG_DAT_READONLY	2
#define MODE_FLAG_SEC_READONLY	4
#define MODE_FLAG_GEN_NO_SAVE	8

#define MODE_FLAG_DAT_READONLY_NOT	0xd
#define MODE_FLAG_SEC_READONLY_NOT	0xb

// forward reference:
class SubFrame;

// ========================================================================
// Define a new application
class SectorApp: public wxApp
{
public:
    bool OnInit(void);
	virtual int OnExit(void);

private:
};

// ========================================================================
// bitmap (not really -- a way to have a graphic print out saved to a file)
//  XXX move declaration to sect_dlg.h (leave implementation in sector.cpp)
class SectorBitmap : public wxBitmap
{
public:
//	SectorBitmap(PRINT_TYPE t, SECTOR_PRINT_SOURCE s, int s, int s_x, int s_y, 
//		int e_x, int e_y, char *msg);
	SectorBitmap(PRINT_TYPE t, SECTOR_PRINT_SOURCE s, int w, int h, int s_x, int s_y, 
		int e_x, int e_y);
	~SectorBitmap();

	void DrawWhatever(wxDC &dc, char *msg=NULL, int ss=-1);

private:
	int				start_x;
	int				start_y;
	int				end_x;
	int				end_y;

//	char			*header_msg;
	PRINT_TYPE		pt;
	SECTOR_PRINT_SOURCE	ps;
//	int				ss;
};

#ifdef SEPERATE_WINDOWS
// ========================================================================
// a canvas for a listing
class SectorText : public wxScrolledWindow
{
public:
    SectorText(wxWindow *frame, 
			int x=-1, int y=-1, int w=-1, int h=-1, long style = wxRETAINED);
	~SectorText(void) {};

private:
	void OnDraw(wxDC& dc);
	void OnEvent(wxMouseEvent& event);
	void OnRightDown(wxMouseEvent &event);

	DECLARE_EVENT_TABLE()
};

// ========================================================================
// a canvas to throw detail info to
class DetailText : public wxScrolledWindow
{
public:
    DetailText(wxFrame *frame, int x, int y, int w, int h, 
		long style = wxRETAINED);
	~DetailText(void) {};

private:
	void OnDraw(wxDC& dc);
	void OnEvent(wxMouseEvent& event);

	DECLARE_EVENT_TABLE()

private:

};

typedef enum HIT_TEST_VAL {
	HT_NONE = 0,
	HT_HEX = 1,
	HT_SECT = 2,
	HT_GLOB = 3 };

// ========================================================================
// a canvas for drawing the map
class MapFrame;
class MapCanvas: public wxScrolledWindow
{
public:
    MapCanvas(wxFrame *frame, int x, int y, int w, int h, 
		long style = wxRETAINED);
    ~MapCanvas(void) {};

	// note that this can only be called once
	//  (the call removes the entry)
	bool GetLastXY(short *x_, short *y_);

private:
	// menuing helper
	HIT_TEST_VAL HitTest(long x, long y, int *r_x, int *r_y);
	int BorderHitTest(long x, long y, int *r_x, int *r_y);
	void BaseHitTest(long x, long y, int *r_x, int *r_y, int *t_x, int *t_y);

	int last_x,last_y;		// last mouse event was on this hex

	void OnDraw(wxDC& dc);
	void OnRightDown(wxMouseEvent &event);
	void OnLeftDown(wxMouseEvent &event);
	void OnMiddleDown(wxMouseEvent &event);
	void MouseMotion(wxMouseEvent &event);

	DECLARE_EVENT_TABLE()
};

// ========================================================================
// common frame
class Sub_Frame : public SubFrame
{
public:
	Sub_Frame(wxFrame *frame, const char *title,
			int x, int y, int w, int h, long s);
	~Sub_Frame();

	void MenuCheckCallBack(SubFrame *);

};

// ========================================================================
// map frame
class MapFrame : public Sub_Frame
{
public:
	MapFrame(wxFrame *frame, const char *title,
			int x, int y, int w, int h, long s);
	~MapFrame();

private:
// menuing
	void RouteMode(wxCommandEvent& event);
	void BorderMode(wxCommandEvent& event);
	void BorderMode2(wxCommandEvent& event);
	void EditBorder(wxCommandEvent& event);
	void EditRoute(wxCommandEvent& event);
	void SectorView(wxCommandEvent& event);
	void ViewMode(wxCommandEvent& event);
	void SectorNotes(wxCommandEvent& event);
	void SSectorNotes(wxCommandEvent& event);
	void EditSS(wxCommandEvent& event);
	void SearchTrade(wxCommandEvent& event);
	void SearchShort(wxCommandEvent& event);
	void SearchRange(wxCommandEvent& event);
	void SelectHex(wxCommandEvent& event);
	void ExecDetail(wxCommandEvent& event);
	void ExecEnc(wxCommandEvent& event);
	void ExecTrade(wxCommandEvent& event);
	void DoRoute(wxCommandEvent& event);
	void HexView(wxCommandEvent& event);
	void DoBorder(wxCommandEvent& event);
	void EditHex(wxCommandEvent& event);
	void AddHex(wxCommandEvent& event);
	void DelHex(wxCommandEvent& event);
	void HexNotes(wxCommandEvent& event);
//	void SelectCP(wxCommandEvent& event);
	void OnUser1(wxCommandEvent& event);
	void OnUser2(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};

// ========================================================================
// since wxGTK seems to have a problem w/ a frame w/o any sub windows
class DummyPanel : public wxPanel
{
public:
	DummyPanel(wxWindow *p);

	// override behaviour
	void OnSize(wxSizeEvent& event);

};

#else
// ========================================================================
// GP canvas.....
class SectorCanvas : public wxScrolledWindow
{
public:
	SectorCanvas(wxFrame *frame);

	void OnDraw(wxDC& dc);
	void OnRightDown(wxMouseEvent &event);
	
	DECLARE_EVENT_TABLE()

private:
};
#endif

typedef enum {
	VM_map=0,
	VM_list,
	VM_detail
} VIEW_MODE;

// ========================================================================
// main frame
typedef enum {
	MM_MAP=0,
	MM_ROUTE,
	MM_BORDER,
	MM_BORDER2
} SECTOR_MAPPING_MODE;

typedef enum {
	SN_SECT=0,
	SN_SS,
	SN_HEX
} SECTOR_NOTES;

typedef enum {
	EF_SYS=0,
	EF_ENC,
	EF_TRADE
} EXECUTE_FLAG;

class MainFrame : public wxFrame
{
public:
	MainFrame(wxFrame *frame, char *title, int x, int y, int w, int h,
			unsigned long s);
	~MainFrame();

	SectColorDialog		*sect_color_dialog;
	HexRouteDialog		*route_dialog;
#ifdef POPUP_MENUS
	// these are the popup ones:
	wxMenu *popup;
#endif
// frames we keep track of
#ifdef SEPERATE_WINDOWS
	MapFrame 		*map_frame;
	Sub_Frame 		*detail_frame;
	Sub_Frame 		*list_frame;
//	SectorText		*listing;
#else
	SectorCanvas	*canvas;
#endif

	void MenuCheckCallBack(SubFrame *);
	void SetModeMenu(void);

	void DrawDetail(wxDC& dc, HexData *hd);

	void RangeCheck(int *start_x, int *start_y, int *end_x, int *end_y);
	void DrawMap(wxDC& dc, long off_x=0, long off_y=0,
				 int start_x=-1, int start_y=-1,
				 int end_x=-1, int end_y=-1,
				 char *msg1=NULL, char *msg2=NULL);
	void DrawMapScaled(wxDC& dc, 
				 int start_x=-1, int start_y=-1,
				 int end_x=-1, int end_y=-1,
				 char *msg1=NULL, char *msg2=NULL);
	void DrawLegend(wxDC& dc);
	void DrawFormatedSS(wxDC& dc, int ss_ndx);
	void GetLegendSize(wxDC& dc, int *x, int *y);
	void GetFormatedSize(wxDC& dc, int *x, int *y);

	DetailSector *GetSector(void) { return(sect); };
	HexData *GetCurrentHex(void);
	void GetCurrentHex(short *x, short *y);

	void CalcMapSize(long *size_x, long *size_y,
                       int start_x, int start_y, int end_x, int end_y);
	int CalcWorldsOnPage(bool srch, bool list, bool hdr,
                            int lines_per_page, int page);
	int CalcPageCount(bool srch, bool list, int lines, bool hdr,
                         int s_x=-1, int s_y=-1, int e_x=-1, int e_y=-1);

	void LoadFile(char *s, bool from_command_line=FALSE);

    void OnCloseWindow(wxCloseEvent &event);
    void Draw(wxDC& dc, bool draw_bitmaps = TRUE);

	ColorArray *GetColors(void) { return(colors); };

	void InitButtons(wxToolBar *tb);

	VIEW_MODE GetViewMode(void) { return(view_mode); };

	void CreateMenus(void);
#ifdef SEPERATE_WINDOWS
	void SetSubWindows(char *, SubFrame *, int);
#endif

	CodeTable *GetAllegTable(void) { return(codes->GetAllegTable()); };
	CodeTable *GetOtherTable(void) { return(codes->GetOtherTable()); };
	BaseTable *GetBaseTable(void) { return(codes->GetBaseTable()); };

	SECTOR_MAPPING_MODE GetMapMode(void) { return(mapping_mode); };
	void SetMapMode(SECTOR_MAPPING_MODE m);
	void BorderToggle(int x, int y, HIT_TEST_VAL val);
	void BorderToggle2(int b, int x, int y);
	void RouteToggle(int x, int y, HIT_TEST_VAL val);
	void RouteEcho(int x, int y);
	void RefreshAll(void);

	Menu *GetUserSectMenu(void) { return(user_smenu); };
	Menu *GetUserHexMenu(void) { return(user_hmenu); };

	void EditNotes(SECTOR_NOTES s);

	// public event callbacks (for the map frame)
	void ExecDetail(wxCommandEvent& event) { DoExecute(EF_SYS); };
	void ExecEnc(wxCommandEvent& event) { DoExecute(EF_ENC); };
	void ExecTrade(wxCommandEvent& event) { DoExecute(EF_TRADE); };
//	void SelectCP(wxCommandEvent& event);
	void SelectHex(wxCommandEvent& event);
	void EditBorder(wxCommandEvent& event);
	void EditRoute(wxCommandEvent& event);
	void HexView(wxCommandEvent& event);
	void ToggleDetail(wxCommandEvent& event);
	void ToggleMap(wxCommandEvent& event);
	void ToggleList(wxCommandEvent& event);
	void EditSS(wxCommandEvent& event);
	void ChooseRoute(wxCommandEvent& event);
	void ChooseBorder(wxCommandEvent& event);
	void GeneralSearch(wxCommandEvent& event);
	void SectorView(wxCommandEvent& event);

	void SearchTrade(wxCommandEvent& event);
	void SearchShort(wxCommandEvent& event);
	void SearchRange(wxCommandEvent& event);

	void OnUser1(wxCommandEvent& event);
	void OnUser2(wxCommandEvent& event);

	void SectorNotes(wxCommandEvent& event) { EditNotes(SN_SECT); };
	void SSectorNotes(wxCommandEvent& event) { EditNotes(SN_SS); };
	void HexNotes(wxCommandEvent& event) { EditNotes(SN_HEX); };

	void EditHex(wxCommandEvent& event);
	void HexAdd(wxCommandEvent& event);
	void HexDel(wxCommandEvent& event);

private:
	void AddToMenu(wxMenu *mn, int id, bool tog_flag=FALSE);

	void BuildBitmapList(TCodes *codes);
	void BuildSectorBitmaps(void);
	void OnToolEnter(wxCommandEvent& event);
// 'menu' (or button) response
	void LoadFile1(wxCommandEvent& event);
	void LoadFile2(wxCommandEvent& event);
	void LoadFile3(wxCommandEvent& event);
	void LoadFile4(wxCommandEvent& event);
	void LoadFile5(wxCommandEvent& event);
	void SelectFile(wxCommandEvent& event);
	void SaveSec(wxCommandEvent& event);
	void Print(wxCommandEvent& event);
	void Config(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void Quit(wxCommandEvent& event);

	void CheckReadOnlyMenu(void);
	bool CheckCurrentHexMenu(void);

	// drawing stuff:
	void DrawRoute(wxDC& dc, int x, int y, int start_x, int start_y,
				   HexData *hd, ColorTable *ct,
				   long off_x=0, long off_y=0);

	void GetMapCoordinates(int m_x, int m_y, int *n_x, int *n_y);

	void LoadFile(const int id);

	// border stuff
	void BuildBorderMap(void);
	void DecodeBorderMap(void);

	// route stuff
	void SetMapTitle(void);

	// execute stuff
	void DoExecute(EXECUTE_FLAG ef);

#ifdef SECT_MENUS
// menus we keep track of
	wxMenu 				*file_menu;
	wxMenu 				*view_menu;
	wxMenu 				*sector_menu;
	wxMenu 				*search_menu;
	wxMenu 				*hex_menu;
	wxMenu				*sector_edit_menu;
	wxMenu				*hex_edit_menu;
#endif
	// user menu
	Menu				*user_hmenu;
	Menu				*user_smenu;

// dialogs we keep track of
	HexDialog			*hex_dialog;
	SSDialog			*ss_dialog;
	EditChoiceDialog	*ec_dialog;
	HexBorderDialog		*border_dialog;
//	CpDialog			*cp_dialog;
	PrintDialog			*print_dialog;
//	SysDialog			*system_dialog;
	TCodeDialog			*code_dialog;
	SearchDialog		*search_dlg;
	SSSelectDialog		*sss_dialog;
	EditWorldDialog		*world_dialog;
	FormatDialog		*fmt_dialog;
	
//	long				text_offset;
	unsigned short		mode;

	VIEW_MODE			view_mode;

	SECTOR_MAPPING_MODE	mapping_mode;
	int					map_mode_color;
	int					base_x_r,base_y_r;
	int					last_x_r,last_y_r;
	DrawnHex			drawn_hex;
	Legend				legend;

	// actual sector stuff
	TCodes				*codes;
	DetailSector		*sect;
	short				cur_x;
	short				cur_y;

	// misc. resources
	ColorArray			*colors;
	BitmapList			*bitmaps;

	// directory helper
	MTUFile				*dirs;

	DECLARE_EVENT_TABLE()
};

#endif

