/*
 * File:	sect_dlg.cpp
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: sect_dlg.cpp,v $ $Revision: 1.20 $ $Author: man $ $Date: 2003/05/05 03:29:03 $" */

#ifdef __GNUG__
#pragma implementation
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wx/image.h"

#ifdef _MSC_VER
#pragma warning (disable : 4244)
#endif

#include "sect_dlg.h"
#include "sector.h"
#include "stdlib.h"

#define DUMMY_BUFFER_SIZE	120

#define DUMMY_INIT_STR      " XXXXXXXXXXXXXX "

#define COLOR_WIDTH			22
#define COLOR_HEIGHT		COLOR_WIDTH

// yuch:
extern MainFrame *frame;

// --------------------------------------------------------------------------
enum {
	ECD_LIST_BOX_SIZE=200,
	ECD_NEW,
	ECD_EDIT,
	ECD_DELETE,
	ECD_CLOSE,
	ID_SYS_OPT,
	ID_LANG_BTN,
	ID_COLOR,
	ID_CLEAR,
	ID_COLOR1,
	ID_COLOR2,
	ID_COLOR3,
	ID_COLOR4,
	ID_COLOR5,
	ID_COLOR6,
	ID_ENABLE1,
	ID_ENABLE2,
	ID_ENABLE3,
	ID_ENABLE4,
	ID_ENABLE5,
	ID_ENABLE6,
	ID_WHICH,
	ID_SOURCE,
	ID_SETUP,
	ID_TOTAL,
	ID_DISCARD,
	ID_ACCEPT,
	ID_RETURN,
	ID_CODES_BTN,
	ID_VFY_BTN,
//	ID_STARS_BTN,
	ID_PORT_CH,
	ID_SIZE_CH,
	ID_ATMS_CH,
	ID_HYDR_CH,
	ID_POP_CH,
	ID_GOVT_CH,
	ID_LAW_CH,
	ID_TECH_CH,
	ID_STAR1_ENABLE,
	ID_STAR2_ENABLE,
	ID_STAR3_ENABLE,
	ID_STAR1_BTN,
	ID_STAR2_BTN,
	ID_STAR3_BTN,
	ID_FORMAT_FORMAT,
	ID_WIDE,
	ID_ROUTES_BORDERS,
	ID_FORMAT_DEFAULT,
	ID_FORMAT_UWP
};

// ==========================================================================
// edit choice dialog
BEGIN_EVENT_TABLE(EditChoiceDialog, wxDialog)
	EVT_BUTTON(ECD_NEW, EditChoiceDialog::OnNew)
	EVT_BUTTON(ECD_EDIT, EditChoiceDialog::OnEdit)
	EVT_BUTTON(ECD_DELETE, EditChoiceDialog::OnDelete)
	EVT_BUTTON(ECD_CLOSE, EditChoiceDialog::OnCloseWindow)
END_EVENT_TABLE()

EditChoiceDialog::EditChoiceDialog(wxWindow *p) :
	wxDialog(p, -1, "Delete this title",wxDefaultPosition, wxDefaultSize, 
		wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
wxButton *b[4];

	mode = CHOICE_NONE;
	color_array = NULL;

	lt = NULL;
	routes = NULL;
	ct = NULL;

	lb = new wxListBox(this, -1, 
				wxPoint(DLG_OFFSET, DLG_OFFSET),
				wxSize(ECD_LIST_BOX_SIZE, ECD_LIST_BOX_SIZE),
				0, NULL, wxLB_SINGLE | wxLB_NEEDED_SB);

	b[0] = new wxButton(this, ECD_NEW, "New",
		wxPoint(-1, -1),
		wxSize(2 * COL_OFFSET, -1));
	b[1] = new wxButton(this, ECD_EDIT, "Edit", 
		wxPoint(-1, -1),
		wxSize(2 * COL_OFFSET, -1));
	b[2] = new wxButton(this, ECD_DELETE, "Delete", 
		wxPoint(-1, -1),
		wxSize(2 * COL_OFFSET, -1));
	b[3] = new wxButton(this, ECD_CLOSE, "Close", 
		wxPoint(-1, -1),
		wxSize(2 * COL_OFFSET, -1));
	b[1]->SetDefault();

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxVERTICAL);
    sizer_1->Add(lb, 1, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_2->Add(b[0], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(b[1], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(b[2], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(b[3], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(20, 85, 1, 0, 0);
    sizer_1->Add(sizer_2, 0, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(sizer_1);
    sizer_1->Fit(this);
    sizer_1->SetSizeHints(this);
    Layout();
}

EditChoiceDialog::~EditChoiceDialog(void)
{
}

bool
EditChoiceDialog::DoRouteChoice(LinkedList *rtl, ColorArray *ca, ColorTable *c)
{
	Clear();
	color_array = ca;
	mode = CHOICE_HEX_ROUTE;
	routes = rtl;
	ct = c;
	SetTitle("Edit Routes");

	UpdateRoutes();
	ShowModal();

	routes = NULL;
	ct = NULL;
	//oops
	return(TRUE);
}

void
EditChoiceDialog::DoChoice(CHOICE_MODE m, ColorArray *ca)
{
bool ok=FALSE;
DetailSector *sect;

	color_array = ca;
	Clear();
	sect = frame->GetSector();
	if(m == CHOICE_BASES) {
		lt = frame->GetBaseTable();
		ok = TRUE;
		SetTitle("Edit Bases");
	} else if((m == CHOICE_CODES) || (m == CHOICE_ALLEG)) {
		if(m == CHOICE_ALLEG) {
			lt = frame->GetAllegTable();
			SetTitle("Edit Allegences");
		} else {
			lt = frame->GetOtherTable();
			SetTitle("Edit Misc. Codes");
		}
		ok = TRUE;
	} else if((m == CHOICE_BORDER) || (m == CHOICE_ROUTE)) {
		if(m == CHOICE_BORDER) {
			lt = sect->GetBorderTable();
			SetTitle("Edit Borders");
		} else {
			lt = sect->GetRouteTable();
			SetTitle("Edit Routes");
		}
		ok = TRUE;
	}

	if(ok) {
		Update();
		mode = m;
		ShowModal();
	}

	lt = NULL;
	routes = NULL;
	ct = NULL;
}

void
EditChoiceDialog::OnDelete(wxCommandEvent &event)
{
ListNode *n;
int ndx;

	ndx = lb->GetSelection();
	lb->Clear();

	if(mode == CHOICE_HEX_ROUTE) {
		Route *rt;

		n = routes->Nth(ndx);
		if(n != NULL) {
			rt = (Route *) n->Data();
			routes->DeleteNode(n);
			delete rt;
		}
		
		UpdateRoutes();
	} else {
		if(mode == CHOICE_BASES) {
			BaseTableEntry *bte;
	
			n = lt->Nth(ndx);
			if(n != NULL) {
				bte = (BaseTableEntry *) n->Data();
				lt->DeleteNode(n);
				delete bte;
			}
		} else if((mode == CHOICE_CODES) || (mode == CHOICE_ALLEG)) {
			CodeTableEntry *cte;
	
			n = lt->Nth(ndx);
			if(n != NULL) {
				cte = (CodeTableEntry *) n->Data();
				lt->DeleteNode(n);
				delete cte;
			}
		} else if((mode == CHOICE_BORDER) || (mode == CHOICE_ROUTE)) {
			ColorTableEntry *lte;

			n = lt->Nth(ndx);
			if(n != NULL) {
				lte = (ColorTableEntry *) n->Data();
				lt->DeleteNode(n);
				delete lte;
			}
		}
		
		Update();
	}
}

void
EditChoiceDialog::OnEdit(wxCommandEvent &event)
{
ColorTableEntry *lte;
Route *rt;
char buff[DUMMY_BUFFER_SIZE];
int ndx;

	ndx = lb->GetSelection();
	if((mode == CHOICE_BORDER) || (mode == CHOICE_ROUTE)) {
		ListNode *ln;
		ln = lt->Nth(ndx);
		lte = (ColorTableEntry *) ln->Data();
		if(frame->sect_color_dialog->EditColor(mode, color_array, lte)) {
			lte->GetFormated(buff);
			lb->SetString(ndx, buff);
		}
	}
	else if(mode == CHOICE_HEX_ROUTE) {
		ListNode *ln;

		ln = routes->Nth(ndx);
		rt = (Route *) ln->Data();
		if(frame->route_dialog->EditRoute(rt, color_array, ct)) {
			lte = ct->Find(rt->color);
			sprintf(buff, "%s: %d %d", lte->GetDesc(), rt->x+1, rt->y+1);
			lb->SetString(ndx, buff);
		}
	}
}

void
EditChoiceDialog::OnNew(wxCommandEvent &event)
{
char buff[DUMMY_BUFFER_SIZE];

		if((CHOICE_BORDER == mode) || (CHOICE_ROUTE == mode)) {
			if(frame->sect_color_dialog->NewColor(mode, color_array,
					(ColorTable *)lt)) {
				ColorTableEntry *lte;
				ListNode *ln;

				ln = lt->Last();
				lte = (ColorTableEntry *) ln->Data();
				lte->GetFormated(buff);
				AddChoice(buff);
			}
		}
		else if(CHOICE_HEX_ROUTE == mode) {
			if(frame->route_dialog->NewRoute(routes, color_array, ct)) {
				ColorTableEntry *lte;
				Route *rt;
				ListNode *ln;

				ln = routes->Last();
				rt = (Route *) ln->Data();
				lte = ct->Find(rt->color);
				if(NULL == lte)
					sprintf(buff, "U: %d %d", rt->x+1, rt->y+1);
				else
					sprintf(buff, "%s: %d %d", lte->GetDesc(), rt->x+1, rt->y+1);
				AddChoice(buff);
			}
		}
}

void
EditChoiceDialog::OnCloseWindow(wxCloseEvent &event)
{
	EndModal(wxID_CANCEL);
	Show(FALSE);
}

void
EditChoiceDialog::UpdateRoutes(void)
{
char buff[DUMMY_BUFFER_SIZE];
Route *rt;
ListNode *n;
ColorTableEntry *cte;

	n = routes->First();
	while(n != NULL)
		{
		rt = (Route *)n->Data();
		cte = ct->Find(rt->color);
		sprintf(buff, "%s: %d %d", cte->GetDesc(),rt->x+1, rt->y+1);
		AddChoice(buff);
		n = n->Next();
		}	

	lb->SetSelection(0, TRUE);
}

void
EditChoiceDialog::Update(void)
{
char buff[DUMMY_BUFFER_SIZE];

	buff[0] = ' ';
	while(buff[0] != 0)
		{
		buff[0] = 0;
		lt->GetFormated(buff);
		if(buff[0] != 0)
			AddChoice(buff);
		}	

	lb->SetSelection(0, TRUE);
}

// ==========================================================================
HexDialog::HexDialog(wxWindow *p) :
	StdDialog(p, "Select a Hex")
{
wxStaticText *msg;
wxBoxSizer *main_sizer,*extra_sizer;

	msg = new wxStaticText(this, -1, "Hex:");

	HexEdit = new wxTextCtrl(this, -1, "XXXXX",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	
	main_sizer = new wxBoxSizer(wxVERTICAL);
	extra_sizer = new wxBoxSizer(wxHORIZONTAL);
	extra_sizer->Add(msg, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
	extra_sizer->Add(HexEdit, 0, wxALL, DLG_OFFSET);
	main_sizer->Add(extra_sizer);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

bool
HexDialog::GetHex(short *x_, short *y_)
{
char buff[12];
const char *ptr;
int i;

	sprintf(buff, "%02d%02d", *x_, *y_);
	HexEdit->SetValue(buff);

	while(1)
		{
		if((i = ShowModal()) == wxID_CANCEL)
			return(FALSE);

		ptr = (HexEdit->GetValue()).GetData();
		if(sscanf(ptr, "%d", &i) == 1)
			{
			*x_ = i / 100;
			*y_ = i - (*x_ * 100);
			if((*x_ > 0) && (*x_ <= MAX_X_HEX) &&
				(*y_ > 0) && (*y_ <= MAX_Y_HEX))
				return(TRUE);
			}
		wxMessageBox("Inavalid Hex!", "Error", 
			wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
		}
	return(FALSE);
}

// ============================================================================
HexChoiceDialog::HexChoiceDialog(wxWindow *p, char *t) :
	StdDialog(p, t)
{
wxBoxSizer *main_sizer;

	lb = new wxListBox(this, -1, 
				wxPoint(-1, -1),
				wxSize(ECD_LIST_BOX_SIZE, ECD_LIST_BOX_SIZE),
				0, NULL, wxLB_SINGLE | wxLB_NEEDED_SB);

	main_sizer = new wxBoxSizer(wxVERTICAL);
	main_sizer->Add(lb, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

HexChoiceDialog::~HexChoiceDialog()
{
}

short
HexChoiceDialog::GetChoice(ColorTable *ct, bool abs_index)
{
ColorTableEntry *cte;
ListNode *n;
char *ptr;
int i=0;
short ret=-1;

	lb->Clear();
	n = ct->First();
	while(n != NULL) {
		cte = (ColorTableEntry *)n->Data();
		ptr = cte->GetDesc();
		lb->Append(ptr);
		n = n->Next();
		i++;
	}
	if(i == 0)
		wxMessageBox("No Entries to choose from", "Selection Error",
			wxOK | wxCENTRE | wxICON_EXCLAMATION);
	else {
		lb->SetSelection(0, TRUE);
		if(ShowModal() != wxID_CANCEL) {
			i = lb->GetSelection();
			if(abs_index) return(i);
			n = ct->Nth(i);
			cte = (ColorTableEntry *) n->Data();
			ret = cte->GetColor();
		}
	}
	return(ret);
}

// ===========================================================================
BEGIN_EVENT_TABLE(SectColorDialog, wxDialog)
	EVT_BUTTON(ID_COLOR, SectColorDialog::ColorEdit)
	EVT_PAINT(SectColorDialog::OnPaint)
END_EVENT_TABLE()

SectColorDialog::SectColorDialog(wxWindow *p) :
	StdDialog(p, "Delete this title")
{
wxStaticText *msg;
wxBitmap *bmp;

	color_array = NULL;
	col_sel = BLACK_COLOR_INDEX;
	bmp = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	msg = new wxStaticText(this, -1, "Title:");
	desc = new wxTextCtrl(this, -1, "XXXXXXXXXXXXXXXXXX",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 6, -1));
	sel = new wxButton(this, ID_COLOR, "Color",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	bitmap = new wxStaticBitmap(this, -1, *bmp);

	wxBoxSizer* sizer_3 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    sizer_4->Add(msg, 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_4->Add(desc, 0, wxALL, DLG_OFFSET);
    sizer_3->Add(sizer_4, 0, 0, 0);
    sizer_5->Add(sel, 0, wxALL, DLG_OFFSET);
    sizer_5->Add(bitmap, 0, wxALL, DLG_OFFSET);
    sizer_3->Add(sizer_5, 0, 0, 0);

	DoLayout(wxALL, DLG_OFFSET, sizer_3);

	delete bmp;
}

SectColorDialog::~SectColorDialog()
{
}

void
SectColorDialog::ColorEdit(wxCommandEvent &event)
{
SelectColorDialog	*sel_col_dlg;

	sel_col_dlg = new SelectColorDialog(this, color_array);
	if(sel_col_dlg->SelectColor(&col_sel)) {
		DoBitmap();
		Refresh();
	}

	delete sel_col_dlg;
}

bool
SectColorDialog::NewColor(CHOICE_MODE m, ColorArray *ca, ColorTable *ct)
{
bool ret=FALSE;

	color_array = ca;
	InitTitle(m);

	// start out black
	col_sel = BLACK_COLOR_INDEX;
	desc->SetValue("");
	DoBitmap();

	if(ShowModal() == wxID_OK) {
		wxString ptr;

		ptr = desc->GetValue();
		if((col_sel >= 0) && (col_sel < ca->GetMaxColors())) {
			ct->AddColor(col_sel, (char *)(ptr.GetData()));
			ret = TRUE;
		}
	}

	return(ret);
}

bool
SectColorDialog::EditColor(CHOICE_MODE m, ColorArray *ca, ColorTableEntry *cte)
{
bool ret=FALSE;

	color_array = ca;
	InitTitle(m);

	desc->SetValue(cte->GetDesc());
	col_sel = cte->GetColor();
	DoBitmap();

	if(ShowModal() == wxID_OK) {
		wxString ptr;

		ptr = desc->GetValue();
		if((col_sel >= 0) && (col_sel < ca->GetMaxColors())) {
			cte->SetValues(col_sel, (char *)(ptr.GetData()));
			ret = TRUE;
		}
	}

	return(ret);
}
// ---------------------------------------------------------------------------

void 
SectColorDialog::DoBitmap(void)
{
wxBitmap *l_bm;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;
wxColour *color;
	
	color = color_array->GetColor(col_sel);
	l_bm = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	m_dc.SelectObject(*l_bm);

	b = new wxBrush(*color, wxSOLID);
	m_dc.SetBrush(*b);
	p = new wxPen(*color, 1, wxSOLID);
	m_dc.SetPen(*p);

	m_dc.DrawRectangle(0, 0, COLOR_WIDTH, COLOR_HEIGHT);

	bitmap->SetBitmap(*l_bm);

	delete l_bm;
}

void
SectColorDialog::InitTitle(CHOICE_MODE m)
{
char *title;

	if(m == CHOICE_BORDER)
		title = "Edit Border";
	else
		title = "Edit Route";

	SetTitle(title);
}
// ===========================================================================
BEGIN_EVENT_TABLE(HexBorderDialog, wxDialog)
	EVT_CHECKBOX(ID_ENABLE1, HexBorderDialog::EnableCB)
	EVT_CHECKBOX(ID_ENABLE2, HexBorderDialog::EnableCB)
	EVT_CHECKBOX(ID_ENABLE3, HexBorderDialog::EnableCB)
	EVT_CHECKBOX(ID_ENABLE4, HexBorderDialog::EnableCB)
	EVT_CHECKBOX(ID_ENABLE5, HexBorderDialog::EnableCB)
	EVT_CHECKBOX(ID_ENABLE6, HexBorderDialog::EnableCB)
	EVT_BUTTON(ID_COLOR1, HexBorderDialog::ColorEdit)
	EVT_BUTTON(ID_COLOR2, HexBorderDialog::ColorEdit)
	EVT_BUTTON(ID_COLOR3, HexBorderDialog::ColorEdit)
	EVT_BUTTON(ID_COLOR4, HexBorderDialog::ColorEdit)
	EVT_BUTTON(ID_COLOR5, HexBorderDialog::ColorEdit)
	EVT_BUTTON(ID_COLOR6, HexBorderDialog::ColorEdit)
END_EVENT_TABLE()

HexBorderDialog::HexBorderDialog(wxWindow *p) :
	StdDialog(p, "Set Borders")
{
char buff[16];
int i;
wxBitmap *bmp;

	color_array = NULL;
	color_table = NULL;
	for(i = 0;i < 6;i++) {
		sprintf(buff, "Side %d", i + 1);
		enable[i] = new wxCheckBox(this, ID_ENABLE1 + i, buff);
		sel[i] = new wxButton(this, ID_COLOR1 + i, "Color",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
		bmp = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
		bitmaps[i] = new wxStaticBitmap(this, -1, *bmp);
		delete bmp;
		col_sel[i] = 0;
	}

	wxBoxSizer* sizer_10 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_11 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_12_copy = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_13_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_13_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_13_copy_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_12 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_13_copy_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_13_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_13 = new wxBoxSizer(wxHORIZONTAL);
    sizer_12->Add(enable[0], 0, wxALL, DLG_OFFSET);
    sizer_13->Add(bitmaps[0], 0, wxALL, DLG_OFFSET);
    sizer_13->Add(sel[0], 0, wxALL, DLG_OFFSET);
    sizer_12->Add(sizer_13, 0, 0, 0);
    sizer_12->Add(enable[1], 0, wxALL, DLG_OFFSET);
    sizer_13_copy->Add(bitmaps[1], 0, wxALL, DLG_OFFSET);
    sizer_13_copy->Add(sel[1], 0, wxALL, DLG_OFFSET);
    sizer_12->Add(sizer_13_copy, 0, 0, 0);
    sizer_12->Add(enable[2], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_1->Add(bitmaps[2], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_1->Add(sel[2], 0, wxALL, DLG_OFFSET);
    sizer_12->Add(sizer_13_copy_1, 0, 0, 0);
    sizer_11->Add(sizer_12, 0, 0, 0);
    sizer_12_copy->Add(enable[3], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_2->Add(bitmaps[3], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_2->Add(sel[3], 0, wxALL, DLG_OFFSET);
    sizer_12_copy->Add(sizer_13_copy_2, 0, 0, 0);
    sizer_12_copy->Add(enable[4], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_copy->Add(bitmaps[4], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_copy->Add(sel[4], 0, wxALL, DLG_OFFSET);
    sizer_12_copy->Add(sizer_13_copy_copy, 0, 0, 0);
    sizer_12_copy->Add(enable[5], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_1_copy->Add(bitmaps[5], 0, wxALL, DLG_OFFSET);
    sizer_13_copy_1_copy->Add(sel[5], 0, wxALL, DLG_OFFSET);
    sizer_12_copy->Add(sizer_13_copy_1_copy, 0, 0, 0);
    sizer_11->Add(sizer_12_copy, 0, 0, 0);
    sizer_10->Add(sizer_11, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_10);
}

HexBorderDialog::~HexBorderDialog()
{
}

bool
HexBorderDialog::GetBorders(HexData *hd, ColorArray *ca, ColorTable *ct)
{
bool ret=FALSE;
int i;
ColorTableEntry *cte;

	color_array = ca;
	color_table = ct;
	if(hd != NULL) {
		bool val;
		for(i = 0;i < 6;i++) {
			if((cte = ct->Find(hd->border_ndx[i])) != NULL) {
				col_sel[i] = cte->GetColor();
				val = TRUE;
			} else {
				col_sel[i] = BLACK_COLOR_INDEX;
				val = FALSE;
			}
			enable[i]->SetValue(val);
			sel[i]->Enable(val);
			DoBitmaps();
		}
		
		if(ShowModal() != wxID_CANCEL) {
			for(i = 0;i < 6;i++) {
				if(!enable[i]->GetValue())
					hd->border_ndx[i] = -1;
				else
					hd->border_ndx[i] = ct->GetIndex(col_sel[i]);
			}
			ret = TRUE;
		}
	}

	return(ret);
}

// ---------------------------------------------------------------------------
void
HexBorderDialog::EnableCB(wxCommandEvent &event)
{
int ndx;
bool val;

	ndx = event.GetId() - ID_ENABLE1;
	val = enable[ndx]->GetValue();
	sel[ndx]->Enable(val);
	DoBitmap(ndx);
	Refresh();
}

void
HexBorderDialog::ColorEdit(wxCommandEvent &event)
{
int ndx,sel;
HexChoiceDialog *dlg;

	ndx = event.GetId() - ID_COLOR1;
	dlg = new HexChoiceDialog(this, "Select A Border");
	if((sel = dlg->GetChoice(color_table)) > -1) {
		col_sel[ndx] = sel;
		DoBitmaps();
		Refresh();
	}

	delete dlg;
}

void 
HexBorderDialog::DoBitmaps(void)
{
int i;

	for(i = 0;i < 6;i++)
		DoBitmap(i);
}

void
HexBorderDialog::DoBitmap(int i)
{
wxBitmap *l_bm;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;
wxColour *color;
	
	if(enable[i]->GetValue())
		color = color_array->GetColor(col_sel[i]);
	else
		color = color_array->GetColor(BLACK_COLOR_INDEX);
	l_bm = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	m_dc.SelectObject(*l_bm);

	b = new wxBrush(*color, wxSOLID);
	m_dc.SetBrush(*b);
	p = new wxPen(*color, 1, wxSOLID);
	m_dc.SetPen(*p);

	m_dc.DrawRectangle(0, 0, COLOR_WIDTH, COLOR_HEIGHT);

	bitmaps[i]->SetBitmap(*l_bm);

	delete l_bm;
}

// =========================================================================
BEGIN_EVENT_TABLE(HexRouteDialog, wxDialog)
	EVT_BUTTON(ID_COLOR, HexRouteDialog::ColorEdit)
END_EVENT_TABLE()

HexRouteDialog::HexRouteDialog(wxWindow *p) :
	StdDialog(p, "Edit Route")
{
wxStaticText *msg_x,*msg_y;
wxBitmap *bmp;

	color_array = NULL;
	color_table = NULL;

	msg_x = new wxStaticText(this, -1, "X:");
	msg_y = new wxStaticText(this, -1, "Y:");
	dest_x = new wxTextCtrl(this, -1, "XXX",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 6, -1));
	dest_y = new wxTextCtrl(this, -1, "XXX",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 6, -1));
	sel = new wxButton(this, ID_COLOR, "Color",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	col_sel = BLACK_COLOR_INDEX;
	bmp = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	bitmap = new wxStaticBitmap(this, -1, *bmp);

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_8 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_6 = new wxBoxSizer(wxHORIZONTAL);
    sizer_6->Add(msg_x, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_6->Add(dest_x, 0, wxALL, DLG_OFFSET);
    sizer_2->Add(sizer_6, 0, 0, 0);
    sizer_7->Add(msg_y, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_7->Add(dest_y, 0, wxALL, DLG_OFFSET);
    sizer_2->Add(sizer_7, 0, 0, 0);
    sizer_1->Add(sizer_2, 0, 0, 0);
    sizer_8->Add(bitmap, 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_8->Add(sel, 0, wxALL, DLG_OFFSET);
    sizer_1->Add(sizer_8, 0, wxEXPAND, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_1);

	delete bmp;
}

HexRouteDialog::~HexRouteDialog()
{
}

bool
HexRouteDialog::NewRoute(LinkedList *rtl, ColorArray *ca, ColorTable *ct)
{
bool ret=FALSE;
Route *rt;
char *ptr;
int x, y;

	color_array = ca;
	color_table = ct;
	SetTitle("New Route");
	dest_x->SetValue("");
	dest_y->SetValue("");

	col_sel = BLACK_COLOR_INDEX;
	SetBitmap();

	if(ShowModal() != wxID_CANCEL) {
		ptr = (char *)dest_x->GetValue().GetData();
		x = atoi(ptr) - 1;
		
		ptr = (char *)dest_y->GetValue().GetData();
		y = atoi(ptr) - 1;
		
		rt = new Route(x, y, ct->GetIndex(col_sel));
		rtl->Append(rt);	
		
		ret = TRUE;
	}

	return(ret);
}

bool
HexRouteDialog::EditRoute(Route *rt, ColorArray *ca, ColorTable *ct)
{
bool ret=FALSE;
ColorTableEntry *cte;
char buff[12];
char *ptr;

	SetTitle("Edit Route");
	color_array = ca;
	color_table = ct;
	if(rt != NULL) {
		if((cte = ct->Find(rt->color)) == NULL)
			col_sel = BLACK_COLOR_INDEX;
		else
			col_sel = cte->GetColor();
		SetBitmap();
		
		sprintf(buff, "%d", rt->x+1);
		dest_x->SetValue(buff);

		sprintf(buff, "%d", rt->y+1);
		dest_y->SetValue(buff);

		if(ShowModal() != wxID_CANCEL) {
			rt->color = ct->GetIndex(col_sel);
			ptr = (char *)dest_x->GetValue().GetData();
			rt->x = atoi(ptr) - 1;

			ptr = (char *)dest_y->GetValue().GetData();
			rt->y = atoi(ptr) - 1;

			ret = TRUE;
		}
	}

	return(ret);
}

void
HexRouteDialog::ColorEdit(wxCommandEvent &event)
{
int sel;
HexChoiceDialog	*dlg;

	dlg = new HexChoiceDialog(this, "Select A Route");
	if((sel = dlg->GetChoice(color_table)) > -1) {
		col_sel = sel;
		SetBitmap();
		Refresh();
	}
	delete dlg;
}

void
HexRouteDialog::SetBitmap(void)
{
wxBitmap *bmp;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;
wxColour *color;

	bmp = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);

	color = color_array->GetColor(col_sel);

	m_dc.SelectObject(*bmp);

	b = new wxBrush(*color, wxSOLID);
	m_dc.SetBrush(*b);
	p = new wxPen(*color, 1, wxSOLID);
	m_dc.SetPen(*p);
	m_dc.DrawRectangle(0, 0, COLOR_WIDTH, COLOR_HEIGHT);
	bitmap->SetBitmap(*bmp);
	delete bmp;
}

// ===========================================================================
SSDialog::SSDialog(wxWindow *p) :
	StdDialog(p, "Enter Sector And Subsector Names")
{
int i;
char buff[MAX_SS];
wxStaticText *msg[MAX_SS],*s_msg;

	s_msg = new wxStaticText(this, -1, "Sector:");
	SName = new wxTextCtrl(this, -1, "XXXXXXXXXXXXXXXXX",
				wxPoint(-1, -1),
				wxSize((int)(6 * COL_OFFSET) + DLG_OFFSET, -1));

	for(i = 0;i < MAX_SS;i++) {
		sprintf(buff, "Subsector %c:", 'A' + i);
		msg[i] = new wxStaticText(this, -1, buff);
		SSNames[i] = new wxTextCtrl(this, -1, "XXXXXXXXXXXXXXXXX",
				wxPoint(-1, -1),
				wxSize((int)(3 * COL_OFFSET), -1));
	}

	wxBoxSizer* sizer_16 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_4 = new wxFlexGridSizer(8, 4, 0, 0);
    wxBoxSizer* sizer_17 = new wxBoxSizer(wxHORIZONTAL);
    sizer_17->Add(s_msg, 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_17->Add(SName, 0, wxALL, DLG_OFFSET);
    sizer_16->Add(sizer_17, 0, 0, 0);
    grid_sizer_4->Add(msg[0], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[1], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[2], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[3], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(SSNames[0], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[1], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[2], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[3], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(msg[4], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[5], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[6], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[7], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(SSNames[4], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[5], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[6], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[7], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(msg[8], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[9], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[10], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[11], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(SSNames[8], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[9], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[10], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[11], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(msg[12], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[13], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[14], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[15], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(SSNames[12], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[13], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[14], 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(SSNames[15], 0, wxALL, DLG_OFFSET);
    sizer_16->Add(grid_sizer_4, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_16);
}

bool
SSDialog::GetNames(char **s_name, char *names[])
{
int i;
char *ptr;
bool ret=FALSE;
bool test;

	SName->SetValue(*s_name);
	for(i = 0;i < MAX_SS;i++)
		SSNames[i]->SetValue(names[i]);

	if(ShowModal() == wxID_CANCEL)
		return(FALSE);

	test = FALSE;
	ptr = (char *)SName->GetValue().GetData();
	if(strcmp(*s_name, ptr) != 0) {
		ret = TRUE;
		*s_name = new char[strlen(ptr) + 1];
		strcpy(*s_name, ptr);
	}

	for(i = 0;i < MAX_SS;i++) {
		ptr = (char *)SSNames[i]->GetValue().GetData();
		if(strcmp(names[i], ptr) != 0) {
			ret = TRUE;
			names[i] = new char[strlen(ptr) + 1];
			strcpy(names[i], ptr);
		}
	}

	return(ret);
}

#if 0
// ===========================================================================
// CPDialog
BEGIN_EVENT_TABLE(CpDialog, wxDialog)
	EVT_BUTTON(ID_CLEAR, CpDialog::OnClear)
END_EVENT_TABLE()

CpDialog::CpDialog(wxWindow *p) :
	OkCancelDialog(p, "Enter CP Name")
{
wxLayoutConstraints *c;
wxStaticText *msg;

	msg = new wxStaticText(this, -1, "Name:");
	CPName = new wxTextCtrl(this, -1, "XXXXXXXXXXXXXXXXXX",
			wxPoint(-1, -1),
			wxSize((DLG_OFFSET * 20), -1));

	CreateWidgets();

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(this, wxTop, 2 * DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	msg->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(msg, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	CPName->SetConstraints(c);

	SetWidgets(CPName);
}

bool
CpDialog::GetCP(int x, int y, char **orig)
{
char buff[80];

	sprintf(buff, "Enter CP Name For %02d%02d", x, y);
	SetTitle(buff);
	if(*orig == NULL)
		CPName->SetValue("");
	else
		CPName->SetValue(*orig);

	if(ShowModal() == wxID_CANCEL)
		return(FALSE);

	*orig = (char *)CPName->GetValue().GetData();

	return(TRUE);
}

void
CpDialog::OnClear(wxCommandEvent &event)
{
	CPName->SetValue("");
}
#endif

// ===========================================================================
SectorPrintOut::SectorPrintOut(PRINT_TYPE t, SECTOR_PRINT_SOURCE s, int s_s,
							   int s_x, int s_y, int e_x, int e_y, char *msg) :
	wxPrintout()
{
	if(msg == NULL)
		header_msg = NULL;
	else {
		header_msg = new char[strlen(msg) + 1];
		strcpy(header_msg, msg);
	}
	pt = t;
	ps = s;
	ss = s_s;
	start_x = s_x;
	start_y = s_y;
	end_x = e_x;
	end_y = e_y;

	
	if((pt == PT_MAP) || (pt == PT_LEGEND))
		page_max = 1;
	else if(pt == PT_LIST)
		page_max = frame->CalcPageCount(FALSE, TRUE,
										LINES_PER_PAGE, header_msg != NULL,
										start_x, start_y, end_x, end_y);
	else if(pt == PT_DETAIL) {
		if(ps == PS_CURRENT)
			page_max = 1;
		else
			page_max = frame->CalcPageCount(TRUE, FALSE,
											LINES_PER_PAGE,
											header_msg != NULL);
	} else if(PT_FORMAT == pt) {
		if(ss < 0)
			page_max = MAX_SS;
		else
			page_max = 1;
	}
}

SectorPrintOut::~SectorPrintOut()
{
	if(header_msg != NULL)
		delete header_msg;
}


#define DEFAULT_MARGIN_X		20
#define DEFAULT_MARGIN_Y		DEFAULT_MARGIN_X

bool
SectorPrintOut::HasPage(int page)
{
	if(page <= page_max) 
		return(TRUE);
	return(FALSE);
}

void
SectorPrintOut::GetPageInfo(int *minPage, int *maxPage, int
							*selPageFrom, int *selPageTo)
{
	*minPage = *selPageFrom = 1;
	*maxPage = *selPageTo = page_max;
}

bool
SectorPrintOut::OnPrintPage(int page)
{
wxDC *dc;
int w,h;
float scale;
bool ret=FALSE;

	dc = GetDC();
	if (dc) {
		int a_h,a_w,b_h,b_w;
		float s_w,s_h;

		dc->GetSize(&w, &h);
		// should this be only for ps?
		a_h = h - 55;
		a_w = w - 35;

		if(pt == PT_MAP) {
			frame->DrawMapScaled(*dc, start_x, start_y, end_x, end_y,
					header_msg);
			ret = TRUE;
		} else if(pt == PT_LEGEND) {
			if(page == 1) {
				frame->GetLegendSize(*dc, &b_w, &b_h);
				s_w = (float) w / (float) b_w;
				s_h = (float) h / (float) b_h;
				if(s_w > s_h)
					scale = s_h;
				else
					scale = s_w;
				dc->SetUserScale(scale, scale);
				frame->DrawLegend(*dc);
				ret = TRUE;
			}
		} else if(PT_FORMAT == pt) {
			frame->GetFormatedSize(*dc, &b_w, &b_h);
			s_w = (float) w / (float) b_w;
			s_h = (float) h / (float) b_h;
			if(s_w > s_h)
				scale = s_h;
			else
				scale = s_w;
			dc->SetUserScale(scale, scale);
			if(ss >= 0)
				frame->DrawFormatedSS(*dc, ss);
			else
				frame->DrawFormatedSS(*dc, page - 1);
			ret = TRUE;
		} else if(page > 0) {
			char buff[120];
			int line_count,temp_count;
			int i,cur_count;
			MainWorldDisplay *sd;

			sd = new MainWorldDisplay(dc, 60, 20);
			sprintf(buff, "Page %d of %d", page, page_max);

			// fairly arbitrary, i would like about 100 lines......
			scale = (float)a_h / (float)(LINES_PER_PAGE * TEXT_Y_INCR);
			line_count = LINES_PER_PAGE - 2;
			if(header_msg != NULL)
				line_count -= 2;
			dc->SetUserScale(scale, scale);

			cur_count = 0;
			for(i = 1;i < page;i++)
				cur_count +=
				  frame->CalcWorldsOnPage(FALSE, pt == PT_LIST,
										  header_msg != NULL, line_count, i);

// XXX
//			temp_count =
//				  sd->DrawSectText(pt == PT_LIST, header_msg, buff,
//								   cur_count, line_count,
//								   start_x, start_y, end_x, end_y);


			if(temp_count > -1)
				cur_count += temp_count;
			else
				cur_count = -1;
	
			delete sd;
			ret = TRUE;
		}
	}

	return(ret);
}

// ===========================================================================
//static char *printer_choices[11] = {
static wxString printer_choices[] = {
	"Entire Sector",
	"Subsector",
//	"Found Worlds",
	"Current World",
	"Range" ,
	"Map",
	"List",
	"Detail",
	"Legend",
	"Formated",
// dummy one for wxchoice:
	"XXXXXXXXXXXXX"};

// ---------------------------------------------------------------------------
// --------------------------------------------------------------------------
BEGIN_EVENT_TABLE(PrintDialog, wxDialog)
	EVT_RADIOBOX(ID_WHICH, PrintDialog::OnSource)
	EVT_RADIOBOX(ID_SOURCE, PrintDialog::OnSource)
	EVT_CHECKBOX(ID_TOTAL, PrintDialog::OnSource)
	EVT_BUTTON(ID_SETUP, PrintDialog::OnSetup)
END_EVENT_TABLE()

PrintDialog::PrintDialog(wxWindow *p) :
	StdDialog(p, "Print Options")
{
int i;
wxString ptrs[MAX_SS];
wxButton *btn;
wxBoxSizer *panel_sizer;

#if wxUSE_LIBPNG
	wxImage::AddHandler( new wxPNGHandler );
#endif

#if wxUSE_LIBJPEG
	wxImage::AddHandler( new wxJPEGHandler );
#endif
	wxImage::AddHandler( new wxGIFHandler );

	g_dlg = NULL;

	for(i = 0;i < MAX_SS;i++)
		ss_names[i] = NULL;
	current = FALSE;

	setup_dialog = NULL;

	ptrs[0] = printer_choices[4];
	ptrs[1] = printer_choices[5];
	ptrs[2] = printer_choices[6];
	ptrs[3] = printer_choices[7];
	ptrs[4] = printer_choices[8];
	which = new wxRadioBox(this, ID_WHICH, "",
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs, 1, wxRA_SPECIFY_COLS);

	ptrs[0] = printer_choices[0];
	ptrs[1] = printer_choices[1];
	ptrs[2] = printer_choices[2];
	ptrs[3] = printer_choices[3];
	source = new wxRadioBox(this, ID_SOURCE, "",
			wxPoint(-1, -1),
			wxSize(-1, -1),
			4, ptrs, 1, wxRA_SPECIFY_COLS);

// next, the choice and panel
	ss_t = new wxStaticText(this, -1, "Subsector:");
	for(i = 0 ;i < MAX_SS;i++)
		ptrs[i] = printer_choices[9];
	ss = new wxChoice(this, -1, 
			wxPoint(-1, -1),
			wxSize(-1, -1),
			MAX_SS,
			ptrs);

// next, the checkbox and panel
	total = new wxCheckBox(this, ID_TOTAL, "Total Sector");

// next, the start & end texts 
	start_t = new wxStaticText(this, -1, "Start:");
	r_start = new wxTextCtrl(this, -1, "XXXXXX", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	end_t = new wxStaticText(this, -1, "End:");
	r_end = new wxTextCtrl(this, -1, "XXXXXX", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));

// finally, the buttons
	btn = new wxButton(this, ID_SETUP, "Setup", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	file = new wxCheckBox(this, -1, "Print to File");
	
	wxBoxSizer* sizer_10 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_14 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_15 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_11 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_12 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(2, 2, 0, 0);
    wxBoxSizer* sizer_13 = new wxBoxSizer(wxHORIZONTAL);
    sizer_11->Add(which, 0, wxALL, DLG_OFFSET);
    sizer_11->Add(source, 0, wxALL, DLG_OFFSET);
    sizer_12->Add(total, 0, wxALL, DLG_OFFSET);
    sizer_13->Add(ss_t, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_13->Add(ss, 0, wxALL, DLG_OFFSET);
    sizer_12->Add(sizer_13, 0, 0, 0);
    grid_sizer_2->Add(start_t, 1, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(r_start, 1, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(end_t, 1, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    grid_sizer_2->Add(r_end, 1, wxALL, DLG_OFFSET);
    sizer_12->Add(grid_sizer_2, 0, 0, 0);
    sizer_11->Add(sizer_12, 0, 0, 0);
    sizer_10->Add(sizer_11, 0, 0, 0);

	panel_sizer = GetSizer();
	sizer_14->Add(panel_sizer, 1, wxALL, DLG_OFFSET);

    sizer_15->Add(120, 20, 0, 0, 0);
    sizer_15->Add(btn, 0, wxALL, DLG_OFFSET);
    sizer_15->Add(file, 0, wxALL, DLG_OFFSET);
    sizer_14->Add(sizer_15, 0, 0, 0);
    sizer_10->Add(sizer_14, 0, 0, 0);

	SetAutoLayout(TRUE);
    SetSizer(sizer_10);
    sizer_10->Fit(this);
    sizer_10->SetSizeHints(this);
    Layout();

	Reset();
}

PrintDialog::~PrintDialog()
{
int i;

	for(i = 0;i < MAX_SS;i++) {
		if(ss_names[i] != NULL)
			delete ss_names[i];
	}
}

void
PrintDialog::OnSetup(wxCommandEvent &event)
{
	if(setup_dialog == NULL)
#ifdef __WXMSW__
		setup_dialog = new wxPrintDialog(this, & p_data);
#else
		setup_dialog = new wxGenericPrintDialog(this, & p_data);
#endif
//	setup_dialog->GetPrintData().SetSetupDialog(TRUE);
	setup_dialog->GetPrintDialogData().SetSetupDialog(TRUE);
	setup_dialog->ShowModal();
}     

void
PrintDialog::HandleControls(void)
{
int w1,w2;

	w1 = which->GetSelection();
	w2 = source->GetSelection();

	if((PT_MAP == w1) || (PT_LIST == w1) || (PT_DETAIL == w1))
		source->Enable(TRUE);
	else
		source->Enable(FALSE);

//	if((PT_LIST == w1) || (PT_DETAIL == w1))
//		file->Enable(TRUE);
//	else
//		file->Enable(FALSE);

	if(PT_FORMAT == w1) {
		p_data.SetOrientation(wxLANDSCAPE);
		total->Enable(TRUE);
	} else {
		p_data.SetOrientation(wxPORTRAIT);
		total->Enable(FALSE);
	}

	if(((w1 != PT_LEGEND) && (PS_SS == w2) && (w1 != PT_FORMAT)) || 
			((PT_FORMAT == w1) && (!total->GetValue()))) {
		ss->Enable(TRUE);
		ss_t->Enable(TRUE);
	} else {
		ss->Enable(FALSE);
		ss_t->Enable(FALSE);
	}

	if((PS_RANGE == w2) && 
		((PT_MAP == w1) || (PT_LIST == w1) || (PT_DETAIL == w1))) {
		r_start->Enable(TRUE);
		start_t->Enable(TRUE);
		r_end->Enable(TRUE);
		end_t->Enable(TRUE);
	} else {
		r_start->Enable(FALSE);
		start_t->Enable(FALSE);
		r_end->Enable(FALSE);
		end_t->Enable(FALSE);
	}

	if(!current)
		source->Enable(2, FALSE);
	else
		source->Enable(2, TRUE);
}

void
PrintDialog::OnSource(wxCommandEvent &event)
{
	HandleControls();
}

void
PrintDialog::Reset(void)
{
	which->SetSelection(0);
	source->SetSelection(0);
	r_start->SetValue("");
	r_end->SetValue("");
	ss->Clear();
	file->SetValue(FALSE);
	total->SetValue(FALSE);

	HandleControls();

	type = PT_LIST;
	src = PS_SECT;
	to_file = FALSE;
	ss_ndx = start_x = end_x = start_y = end_y = -1;
}

#define X_BASE_WIDTH	100
#define X_BASE_ADD		25
#define Y_BASE_WIDTH	88
#define Y_BASE_ADD		44

void
PrintDialog::DoPrint(void)
{
int i,s_s;
char *ptr;
FILE *fpx;
MainWorldDisplay *sd;
DetailSector *sect;
char *ptr1=NULL,*ptr2=NULL;
char buff[120];
SectorPrintOut *print_out;
wxPrinter *printer;
wxString str;

	Reset();

	source->Enable(2, FALSE);
                                     
	for(i = 0;i < MAX_SS;i++)
		ss->Append(ss_names[i]);
	ss->SetSelection(0);

	sect = frame->GetSector();
	if((i = ShowModal()) != wxID_CANCEL) {
		// build some stuff
		ptr1 = sect->GetName();
		if(ptr1 == NULL)
			sprintf(buff, "Sector: Unknown");
		else
			sprintf(buff, "Sector: %s", ptr1);
		ptr1 = new char[strlen(buff) + 1];
		strcpy(ptr1, buff);

		// grab everything
		type = (PRINT_TYPE) which->GetSelection();
		src = (SECTOR_PRINT_SOURCE) source->GetSelection();
		to_file  = file->GetValue();
		ss_ndx = ss->GetSelection();
		ptr = (char *)r_start->GetValue().GetData();
		i = atoi(ptr);
		start_x = (i / 100);
		start_y = (i - (start_x * 100));
		start_x--;
		start_y--;
		ptr = (char *)r_end->GetValue().GetData();
		i = atoi(ptr);
		end_x = i / 100;
		end_y = i - (end_x * 100);
		if(total->GetValue())
			s_s = -1;
		else
			s_s = ss_ndx;
		// do checking
		switch(src) {
			case PS_SS:
				if((ss_ndx > -1) && (ss_ndx < MAX_SS)) {
					start_x = (ss_ndx % 4) * 8;
					start_y = (ss_ndx / 4) * 10;
					end_x = start_x + 8;
					end_y = start_y + 10;
					ptr2 = sect->GetSSName(ss_ndx);
					if(ptr2 == NULL)
						sprintf(buff, "%s  Subsector: %c", ptr1, 
								ss_ndx + 'A');
					else
						sprintf(buff, "%s  Subsector: %s", ptr1, ptr2);
					delete ptr1;
					ptr1 = new char[strlen(buff) + 1];
					strcpy(ptr1, buff);
					ptr2 = NULL;
				} else
					wxMessageBox("Inavalid Subsector!", "Error", 
						wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
				break;
			case PS_RANGE:
				if((start_x >= 0) && (start_x < MAX_X_HEX) &&
					(start_y >= 0) && (start_y < MAX_Y_HEX) &&
					(end_x > 0) && (end_x <= MAX_X_HEX) &&
					(end_y > 0) && (end_y <= MAX_Y_HEX) &&
					(end_x > start_x) && (end_y > start_y)) {

					sprintf(buff, "%s  %02d%02d to %02d%02d", ptr1, 
							start_x, start_y, end_x, end_y);
					delete ptr1;
					ptr1 = new char[strlen(buff) + 1];
					strcpy(ptr1, buff);
				} else
					wxMessageBox("Inavalid Range!", "Error", 
						wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
				break;
			case PS_CURRENT:
				frame->GetCurrentHex(&start_x, &start_y);
				end_x = start_x + 1;
				end_y = start_y + 1;
				break;
			case PS_SECT:
				start_x = start_y = end_x = end_y = -1;
				break;
			default:
				type = PT_NONE;
				break;
		}
		if(PT_NONE != type) {
			if(to_file) {
				if((PT_LIST == type) || (PT_DETAIL == type)) {
					str = wxFileSelector("Print To", NULL, NULL, NULL, 
						"*.txt", wxHIDE_READONLY | wxSAVE | wxOVERWRITE_PROMPT, 
						this);
					ptr = (char *)str.GetData();
					if((NULL == ptr) || (0 == ptr[0]))
						return;

					if((fpx = fopen(ptr, "a+")) == NULL)
						return;

					sd = new MainWorldDisplay(fpx);
					if(PT_LIST == type) {
// XXX
//						sd->DrawSectText(type == PT_LIST, ptr1, ptr2, 0, 32000, 
//								start_x, start_y, end_x, end_y);
					} else {
					}
					delete sd;
				} else {
					bool use_scale=TRUE;
					char *file,*desc;
					int s_start=-1,s_end=-1;
					int width,height,o_width,o_height,g_type;
					float scale=1.0;
					SectorBitmap *bm;
					wxImage *img;
					wxMemoryDC memDC;

					// set some useful defaults
					if(PT_MAP == type) {
						s_end = 0;
						if(-1 == end_x) {
							height = ((40) * Y_BASE_WIDTH) + Y_BASE_ADD;
							width = ((32) * X_BASE_WIDTH) + X_BASE_ADD;
						} else {
							height = ((end_x - start_x) * Y_BASE_WIDTH) +
								Y_BASE_ADD;
							width = ((end_y - start_y) * X_BASE_WIDTH) +
								X_BASE_ADD;
						}
					} else if(PT_LEGEND == type) {
						s_end = 0;
						frame->GetLegendSize(memDC, &width, &height);
						height += 5;
						width += 5;
					} else if(PT_FORMAT == type) {
						frame->GetFormatedSize(memDC, &width, &height);
						height += 5;
						width += 5;
						if(s_s < 0) {
							s_start = 0;
							s_end = 16;
						} else {
							s_start = s_s;
							s_end = s_s + 1;
						}
					}
					g_type = wxBITMAP_TYPE_JPEG;
					o_width = width;
					o_height = height;

					// Find out what the user wants...
					if(NULL == g_dlg)
						g_dlg = new GraphicDialog(this);

					if(!g_dlg->GetGraphicInfo(&g_type, &use_scale,
								&width, &height, &scale, &desc))
						return;

					// ...and where to put it
					for(i = s_start;i < s_end;i++) {
						str = wxFileSelector("Print To", NULL, NULL, NULL, 
							desc,
							wxHIDE_READONLY | wxSAVE | wxOVERWRITE_PROMPT, 
							this);
						ptr = (char *)str.GetData();
						if((NULL == ptr) || (0 == ptr[0]))
							break;

						wxBeginBusyCursor();
						file = new char[strlen(ptr) + 1];
						strcpy(file, ptr);
						if(use_scale) {
							width = (int) (scale * (float)width);
							height = (int) (scale * (float)height);
						} else {
							float s_w,s_h;

							s_w = (float) width / (float) o_width;
							s_h = (float) height / (float) o_height;
							if(s_w > s_h)		// XXX shouldn't matter
								scale = s_w;
							else
								scale = s_h;
						}

						bm = new SectorBitmap(type, src, o_width, o_height,
							start_x, start_y, end_x, end_y);

						memDC.SelectObject(*bm);
						memDC.SetUserScale(scale, scale);
						bm->DrawWhatever(memDC, ptr1, i);

						memDC.SelectObject(wxNullBitmap);

						img = new wxImage(*bm);
						img->SaveFile(file, g_type);

						delete file;
						delete img;
						delete bm;
						wxEndBusyCursor();
					}
				}
			} else {
				print_out = new SectorPrintOut(type, src, s_s,
						start_x, start_y, end_x, end_y, ptr1);

// does anything need to be done here?
//				if(setup_dialog != NULL)
//					{
//					}
				
				printer = new wxPrinter();
				printer->Print(this, print_out, TRUE);

				delete printer;
				delete print_out;
			}
			if(ptr1 != NULL)
				delete ptr1;
		}
	} else {
		type = PT_NONE;
	}
}

void
PrintDialog::SetSSName(int ndx, char *n)
{
char buff[120];

	if(ss_names[ndx] != NULL)
		delete ss_names[ndx];
              
	if((n != NULL) && (n[0] != 0))
		sprintf(buff, n);
	else
    	sprintf(buff, "Subsector %c", ndx + 'A');
			
	ss_names[ndx] = new char[strlen(buff)+1];
	strcpy(ss_names[ndx], buff);	
}

void
PrintDialog::GetRange(int *s_x, int *s_y, int *e_x, int *e_y)
{
	*s_x = start_x;
	*s_y = start_y;
	*e_x = end_x;
	*e_y = end_y;
}

#if 0
// ===========================================================================
BEGIN_EVENT_TABLE(SysDialog, wxDialog)
	EVT_RADIOBOX(ID_SYS_OPT, SysDialog::OptFcn)
	EVT_BUTTON(ID_LANG_BTN, SysDialog::LangFcn)
END_EVENT_TABLE()

// ----------------------------------------------------------------------------
static wxString opts[] = {
	"Generate",
	"Edit",
	"Both" };

// ---------------------------------------------------------------------------
SysDialog::SysDialog(wxWindow *p) :
	OkCancelDialog(p, "System Configuration")
{
wxLayoutConstraints *c;
wxStaticText *msg;

	opt = new wxRadioBox(this, ID_SYS_OPT, "",
			wxPoint(-1, -1),
			wxSize(-1, -1),
			3, opts, 1, wxRA_SPECIFY_ROWS);

	lang_sel = new wxButton(this, ID_LANG_BTN, "Change",
			wxPoint(-1, -1),
			wxSize(-1, -1));
	lang = new wxStaticText(this, -1, "Language:",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 20, -1));

	msg = new wxStaticText(this, -1, "Output File:");
	out_file = new wxTextCtrl(this, -1, "XXXXXXXXXXXXXXXXXXXXXX",
			wxPoint(-1, -1),
			wxSize((DLG_OFFSET * 50), -1));

	quiet = new wxCheckBox(this, -1, "Interactive");

	CreateWidgets();

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	opt->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(opt, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, 3 * DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	quiet->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(opt, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	lang_sel->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(lang_sel, wxRight, DLG_OFFSET);
	c->top.SameAs(opt, wxBottom, 2 * DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	lang->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(lang_sel, wxBottom, 2 * DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	msg->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(msg, wxRight, DLG_OFFSET);
	c->top.SameAs(lang_sel, wxBottom, DLG_OFFSET);
	c->right.SameAs(this, wxRight, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	out_file->SetConstraints(c);

	SetWidgets(out_file);
}

void
SysDialog::LangFcn(wxCommandEvent& event)
{
    if(temp_lang == NULL) {
		wxString str;
		char *ptr;

		str = wxFileSelector("Language File", NULL, NULL, NULL, "*.lng",
				 0, this);
		ptr = (char *)str.GetData();
		if(ptr[0] != 0) {
			char buff[120];

			temp_lang = new char[strlen(ptr) + 1];
			strcpy(temp_lang, ptr);

			sprintf(buff, "Language: %s", temp_lang);
			lang->SetLabel(buff);
			lang->SetSize(-1, -1, 300, -1, wxSIZE_USE_EXISTING);
			lang_sel->SetLabel("Clear");
		}
	} else {
		delete temp_lang;
		temp_lang = NULL;
		lang->SetLabel("Language:");
		lang_sel->SetLabel("Change");
	}
}

void
SysDialog::OptFcn(wxCommandEvent& event)
{
	DoOpt();
}

void
SysDialog::DoOpt(void)
{
	if(SS_EDIT == opt->GetSelection()) {
		lang->Enable(FALSE);
		lang_sel->Enable(FALSE);
		quiet->Enable(FALSE);
	} else {
		lang->Enable(TRUE);
		lang_sel->Enable(TRUE);
		quiet->Enable(TRUE);
	}
}

bool
SysDialog::GetSysData(SYS_SEL *sel, char *lng, char *out, bool *q)
{
char buff[DUMMY_BUFFER_SIZE],*ptr;

	opt->SetSelection(*sel);
	out_file->SetValue(out);
	temp_lang = NULL;
	if((lng != NULL) && (lng[0] != 0)) {
		temp_lang = new char[strlen(lng) + 1];
		strcpy(temp_lang, lng);
		sprintf(buff, "Language: %s", lng);
	} else
		sprintf(buff, "Language:");
	lang->SetLabel(buff);
	quiet->SetValue(*q);
	DoOpt();

	if(ShowModal() == wxID_CANCEL) {
		if(NULL == temp_lang)
			delete temp_lang;
		return(FALSE);
	}

	*sel = (SYS_SEL)opt->GetSelection();
	ptr = (char *)out_file->GetValue().GetData();
	strcpy(out, ptr);
	if((temp_lang != NULL) && (temp_lang[0] != 0))
		strcpy(lng, temp_lang);
	else
		lng[0] = 0;
	*q = quiet->GetValue();

	return(TRUE);
}
#endif

// ==========================================================================
SSSelectDialog::SSSelectDialog(wxWindow *p) :
	StdDialog(p, "Select Subsector")
{
wxBoxSizer *main_sizer;

	lb = new wxListBox(this, -1, 
				wxPoint(-1, -1),
				wxSize(ECD_LIST_BOX_SIZE, ECD_LIST_BOX_SIZE),
				0, NULL, wxLB_SINGLE | wxLB_NEEDED_SB);

	main_sizer = new wxBoxSizer(wxVERTICAL);
	main_sizer->Add(lb, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

SSSelectDialog::~SSSelectDialog()
{
}

int 
SSSelectDialog::SelectSS(char **s_names)
{
int i;

	lb->Clear();
	for(i = 0;i < MAX_SS;i++)
		lb->Append(s_names[i]);

	if(ShowModal() != wxID_CANCEL)
		return(lb->GetSelection());

	return(-1);
}

// ==========================================================================
BEGIN_EVENT_TABLE(AlphaDialog, wxDialog)
	EVT_BUTTON(ID_DISCARD, AlphaDialog::Discard)
	EVT_BUTTON(ID_ACCEPT, AlphaDialog::Accept)
	EVT_BUTTON(ID_RETURN, AlphaDialog::Return)
END_EVENT_TABLE()

AlphaDialog::AlphaDialog(wxWindow *p) :
	wxDialog(p, -1, "Warning! Apha Code!", wxDefaultPosition, wxDefaultSize, 
		wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
int i;
wxStaticText *msgs[6];
wxButton *btns[3];
wxBoxSizer *main_sizer,*btn_sizer;

	msgs[0] = new wxStaticText(this, -1, 
		"In case you haven't looked at the README file, you have just");
	msgs[1] = new wxStaticText(this, -1, 
		"run through some real 'alpha' state code.  Because of this,");
	msgs[2] = new wxStaticText(this, -1, 
		"you have the option doing one of following:");
	msgs[3] = new wxStaticText(this, -1, 
		"    Accept any changes made.");
	msgs[4] = new wxStaticText(this, -1, 
		"    Discard any changes made.");
	msgs[5] = new wxStaticText(this, -1, 
		"    Return and review any changes made.");

	btns[0] = new wxButton(this, ID_ACCEPT, "Accept",
			wxPoint(-1, -1), wxSize(-1, -1));
	btns[1] = new wxButton(this, ID_DISCARD, "Discard",
			wxPoint(-1, -1), wxSize(-1, -1));
	btns[2] = new wxButton(this, ID_RETURN, "Return",
			wxPoint(-1, -1), wxSize(-1, -1));

	main_sizer = new wxBoxSizer(wxVERTICAL);
	btn_sizer = new wxBoxSizer(wxHORIZONTAL);

	for(i = 0;i < 6;i++)
		main_sizer->Add(msgs[i], 0, wxALL, DLG_OFFSET/2);
	
	for(i = 0;i < 3;i++)
		btn_sizer->Add(btns[i], 0, wxALL, DLG_OFFSET);

	main_sizer->Add(btn_sizer, 0, 0, 0);

	SetAutoLayout(TRUE);
    SetSizer(main_sizer);
    main_sizer->Fit(this);
    main_sizer->SetSizeHints(this);
    Layout();

	Centre(wxBOTH);

	ret = ADC_DISCARD;
}

AlphaDialog::~AlphaDialog()
{
}

// --------------------------------------------------------------------------
AD_CODE 
AlphaDialog::GetAlpha(void)
{
	ShowModal();
	return(ret);
}

void 
AlphaDialog::Discard(wxCommandEvent& event)
{
	ret = ADC_DISCARD;
	EndModal(0);
}

void 
AlphaDialog::Accept(wxCommandEvent& event)
{
	ret = ADC_ACCEPT;
	EndModal(0);
}

void 
AlphaDialog::Return(wxCommandEvent& event)
{
	ret = ADC_RETURN;
	EndModal(0);
}

// ===============================================================
BEGIN_EVENT_TABLE(EditWorldDialog, wxDialog)
	EVT_BUTTON(ID_CODES_BTN, EditWorldDialog::DoCodes)
	EVT_BUTTON(ID_VFY_BTN, EditWorldDialog::DoVerify)
	EVT_CHECKBOX(ID_STAR1_ENABLE, EditWorldDialog::EnableStar1)
	EVT_CHECKBOX(ID_STAR2_ENABLE, EditWorldDialog::EnableStar2)
	EVT_CHECKBOX(ID_STAR3_ENABLE, EditWorldDialog::EnableStar3)
	EVT_BUTTON(ID_STAR1_BTN, EditWorldDialog::DoStar1)
	EVT_BUTTON(ID_STAR2_BTN, EditWorldDialog::DoStar2)
	EVT_BUTTON(ID_STAR3_BTN, EditWorldDialog::DoStar3)
END_EVENT_TABLE()

static wxString num_choices[] = {
	" 0 ",
	" 1 ",
	" 2 ",
	" 3 ",
	" 4 ",
	" 5 ",
	" 6 ",
	" 7 ",
	" 8 ",
	" 9 "
};

// ---------------------------------------------------------------
EditWorldDialog::EditWorldDialog(wxWindow *p, TCodes *codes) :
    StdDialog(p, "Edit World")
{
wxStaticText *msg[7];
wxButton *btn[2];
// XXX need other tables?
CodeTable *ct;

	// create controls
	uwp_box = new UWPBox(this, "UWP", ID_PORT_CH);

	msg[0] = new wxStaticText(this, -1, "Name:");
	name = new wxTextCtrl(this, -1, DUMMY_INIT_STR,
			wxPoint(-1, -1),
			wxSize(4 * COL_OFFSET, -1));
	name->SetValue("");

	btn[0] = new wxButton(this, ID_VFY_BTN, "Verify UWP");
	btn[0]->Enable(FALSE);

	msg[1] = new wxStaticText(this, -1, "Bases:");
	bases = new CodeList(this, TRUE);

	msg[2] = new wxStaticText(this, -1, "Allegance:");
	alleg = new CodeList(this, TRUE);

	msg[3] = new wxStaticText(this, -1, "Zone:");
	zone = new ZoneChoice(this, TRUE);
	
	msg[4] = new wxStaticText(this, -1, "Pop. Ndx:");
	pop_ndx = new wxChoice(this, -1,
			wxPoint(-1, -1),
			wxSize(-1, -1),
			9,
			&num_choices[1]);
	
	msg[5] = new wxStaticText(this, -1, "Belts:");
	belts = new wxChoice(this, -1,
			wxPoint(-1, -1),
			wxSize(-1, -1),
			4,
			num_choices);

	msg[6] = new wxStaticText(this, -1, "GG:");
	gg = new wxChoice(this, -1,
			wxPoint(-1, -1),
			wxSize(-1, -1),
			6,
			num_choices);

	enable[0] = new wxCheckBox(this, ID_STAR1_ENABLE, "Star 1");
	star_btn[0] = new wxButton(this, ID_STAR1_BTN, "Edit");
	enable[1] = new wxCheckBox(this, ID_STAR1_ENABLE, "Star 2");
	star_btn[1] = new wxButton(this, ID_STAR2_BTN, "Edit");
	enable[2] = new wxCheckBox(this, ID_STAR1_ENABLE, "Star 3");
	star_btn[2] = new wxButton(this, ID_STAR3_BTN, "Edit");

	btn[1] = new wxButton(this, ID_CODES_BTN, "Codes");

	trade = new wxStaticText(this, -1, 
			"Trade: XXXXXXXXXXXXXXXXXXXXXXXX");

	wxBoxSizer* sizer_35 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_38 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_44 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_8 = new wxFlexGridSizer(3, 2, 0, 0);
    wxFlexGridSizer* grid_sizer_9 = new wxFlexGridSizer(4, 2, 0, 0);
    wxBoxSizer* sizer_41 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_43 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_6 = new wxFlexGridSizer(2, 2, 0, 0);
    wxBoxSizer* sizer_42 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_39 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_40 = uwp_box->GetSizer();
	wxStaticBoxSizer* sizer_45 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Misc."), wxHORIZONTAL);
	wxStaticBoxSizer* sizer_46 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Stars"), wxHORIZONTAL);

    sizer_39->Add(sizer_40, 0, wxALL, DLG_OFFSET);
    sizer_39->Add(btn[0], 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_38->Add(sizer_39, 0, 0, 0);
    sizer_42->Add(msg[0], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_42->Add(name, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_41->Add(sizer_42, 0, 0, 0);
    grid_sizer_6->Add(msg[1], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_6->Add(msg[2], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_6->Add(bases, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_6->Add(alleg, 0, wxALL, DLG_OFFSET/2);
    sizer_41->Add(grid_sizer_6, 0, 0, 0);
    sizer_38->Add(sizer_41, 0, 0, 0);
    sizer_41->Add(trade, 0, wxALL|wxALIGN_CENTER_VERTICAL, DLG_OFFSET);
    grid_sizer_9->Add(msg[3], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_9->Add(zone, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_9->Add(msg[4], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_9->Add(pop_ndx, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_9->Add(msg[5], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_9->Add(belts, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_9->Add(msg[6], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_9->Add(gg, 0, wxALL, DLG_OFFSET/2);
	sizer_45->Add(grid_sizer_9, 0, wxALL, DLG_OFFSET);
    sizer_44->Add(sizer_45, 0, wxALL, DLG_OFFSET);
    grid_sizer_8->Add(enable[0], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_8->Add(star_btn[0], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_8->Add(enable[1], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_8->Add(star_btn[1], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_8->Add(enable[2], 0, wxALL, DLG_OFFSET/2);
    grid_sizer_8->Add(star_btn[2], 0, wxALL, DLG_OFFSET/2);
	sizer_46->Add(grid_sizer_8, 0, wxALL, DLG_OFFSET);
    sizer_44->Add(sizer_46, 0, wxALL, DLG_OFFSET);
    sizer_43->Add(btn[1], 0, 0, 0);
    sizer_44->Add(sizer_43, 0, wxALL, DLG_OFFSET);
    sizer_38->Add(sizer_44, 0, 0, 0);
    sizer_35->Add(sizer_38, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_35);

	// extra sub-dialogs
	ct = codes->GetOtherTable();
	code_dlg = new EditCodeDialog(this, ct);
	star_dlg = new EditStarDialog(this);

	mw = NULL;
}

bool
EditWorldDialog::EditWorld(main_world *m, TCodes *codes)
{
char buff[120],*ptr;
int i;
unsigned long l,code;
ListNode *n;
BaseTable *bt;
CodeTable *at;
CodeTableEntry *cte;

	bt = codes->GetBaseTable();
	at = codes->GetAllegTable();
	// populate local stuff
	mw = m;
	code_val = mw->GetOtherCodes();
	code = mw->GetTradeCodes();
	mw->GetUWPStr(luwp);
	
	// populate controls
	uwp_box->SetUWP(luwp, UI_SECTOR);
	name->SetValue(mw->GetName());
	sprintf(buff, "%c", mw->GetBase());
	bases->SetCode(buff, bt);
	sprintf(buff, "%s", mw->GetAlleg());
	alleg->SetCode(buff, at);

	tt = codes->GetTradeTable();
	l = 1l;
	strcpy(buff, "Trade: ");
	n = tt->First();
	while(n != NULL) {
		cte = (CodeTableEntry *)n->Data();
		if(code & l) {
			strcat(buff, cte->GetCode());
			strcat(buff, " ");
		}
		l *= 2;
		n = n->Next();
	}
	trade->SetLabel(buff);

	zone->SetZone(mw->GetZone());

	pop_ndx->SetSelection(mw->GetPopNdx() - 1);
	belts->SetSelection(mw->GetNumBelts());
	gg->SetSelection(mw->GetNumGG());

	for(i = 0;i < 3;i++)
		star_type[i] = star_size[i] = star_class[i] = -1;
	for(i = 0;i < mw->GetNumStars();i++) {
		star_type[i] = mw->GetStarType(i);
		star_size[i] = mw->GetStarSize(i);
		star_class[i] = mw->GetStarClass(i);
	}
	for(i = 0;i < 3;i++) {
		if(star_type[i] < 0) {
			enable[i]->Enable(FALSE);
			enable[i]->SetValue(FALSE);
		} else {
			enable[i]->Enable(TRUE);
			enable[i]->SetValue(TRUE);
		}
	}
	DoEnable();

	// show it
	if(ShowModal() == wxID_CANCEL)
			return(FALSE);
	
	// move stuff back
	uwp_box->GetUWP(mw);
	mw->SetName((char *) name->GetValue().GetData());

	mw->SetPopNdx(pop_ndx->GetSelection() + 1);
	mw->SetNumGG(gg->GetSelection());
	mw->SetNumBelts(belts->GetSelection());
	mw->SetZone(zone->GetZone());
	ptr = bases->GetCode();
	mw->SetBase(ptr[0]);
	mw->SetAlleg(alleg->GetCode());
	mw->SetOtherCodes(code_val);

	// XXX trade codes
	mw->GetUWPStr(luwp);
	mw->SetTradeCodes(tt->CheckTrade(luwp));

	// stars
	for(i = 0;i < 3;i++) {
		if(enable[i]->GetValue())
			mw->SetStar(i, star_type[i], star_class[i], star_size[i]);
		else
			mw->SetStar(i, NULL);
	}

	return(TRUE);
}

// -------------------------------------------------------------------
void
EditWorldDialog::DoCodes(wxCommandEvent& event)
{
    code_dlg->GetCodes(&code_val);
}

void
EditWorldDialog::DoStar1(wxCommandEvent& event)
{
	DoStar(0);
}

void
EditWorldDialog::DoStar2(wxCommandEvent& event)
{
	DoStar(1);
}

void
EditWorldDialog::DoStar3(wxCommandEvent& event)
{
	DoStar(2);
}

void
EditWorldDialog::DoStar(int ndx)
{
	star_dlg->GetStar(&star_type[ndx], &star_class[ndx], &star_size[ndx]);
}

void
EditWorldDialog::EnableStar1(wxCommandEvent& event)
{
	DoEnable();
}

void
EditWorldDialog::EnableStar2(wxCommandEvent& event)
{
	DoEnable();
}

void
EditWorldDialog::EnableStar3(wxCommandEvent& event)
{
	DoEnable();
}

void
EditWorldDialog::DoEnable(void)
{
int i;

	enable[1]->Enable(enable[0]->GetValue());
	enable[2]->Enable((enable[1]->IsEnabled()) && (enable[1]->GetValue()));

	for(i = 0;i < 3;i++)
		star_btn[i]->Enable((enable[i]->IsEnabled()) && (enable[i]->GetValue()));
}

void
EditWorldDialog::DoVerify(wxCommandEvent& event)
{
// XXX this is all wrong...
#if 0
char luwp[12];

	uwp_box->CheckUWP();
	uwp_box->GetUWP(luwp);
	UpdateTrade(luwp);
#endif
}

void
EditWorldDialog::UpdateTrade(char *luwp)
{
char buff[120];
unsigned long l,code;
ListNode *n;
CodeTableEntry *cte;

	code = tt->CheckTrade(luwp);

	l = 1l;
	strcpy(buff, "Trade: ");
	n = tt->First();
	while(n != NULL) {
		cte = (CodeTableEntry *)n->Data();
		if(code & l) {
			strcat(buff, cte->GetCode());
			strcat(buff, " ");
		}
		l *= 2;
		n = n->Next();
	}
	trade->SetLabel(buff);
}

// ===============================================================
EditStarDialog::EditStarDialog(wxWindow *p) :
	StdDialog(p, "Edit Stars")
{
wxStaticBoxSizer *bs;
wxBoxSizer *sizer;

	stars = new StarBox(this);

	bs = stars->GetSizer();
	sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add(bs, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, sizer);
}

bool
EditStarDialog::GetStar(int *ty, int *cl, int *sz)
{
int t,c,s;

	if(*ty < 0) t = 0;
	else t = *ty;
	if(*cl < 0) c = 0;
	else c = *cl;
	if(*sz < 0) s = 0;
	else s = *sz;

	stars->SetStar(&t, &c, &s);

	if(wxID_CANCEL == ShowModal())
	    return(FALSE);

	stars->GetStar(ty, cl, sz);
	return(TRUE);
}

// ===============================================================
#define PANEL_SIZE_X		105
#define PANEL_SIZE_Y		95

static char *uwp_str[8] = {
	"Port",
	"Size",
	"Atmos",
	"Hydro",
	"Pop",
	"Govt",
	"Law",
	"Tech"
};

BEGIN_EVENT_TABLE(FormatDialog, wxDialog)
	EVT_CHOICE(ID_FORMAT_FORMAT, FormatDialog::OnFormat)
//	EVT_BUTTON(ID_ROUTES_BORDERS, FormatDialog::OnRouteBorder)
	EVT_BUTTON(ID_FORMAT_DEFAULT, FormatDialog::OnReset)
	EVT_CHECKBOX(ID_FORMAT_UWP, FormatDialog::OnFilter)
END_EVENT_TABLE()

FormatDialog::FormatDialog(wxWindow *p, BitmapList *b, TCodes *c,
				HexLayout *hd) :
	StdDialog(p,"Hex Layout")
{
int i;
wxButton *btn;
wxBoxSizer *panel_sizer;

	canvas = new FormatPanel(this, b, c, PANEL_SIZE_X, PANEL_SIZE_Y);

	msg = new wxStaticText(this, -1, "Format for row 0 col 0:");
	format = new wxChoice(this, ID_FORMAT_FORMAT,
				wxPoint(-1, -1),
				wxSize(DLG_OFFSET * 25, -1));
	for(i = 0;i < MAX_HEX_DISPLAY;i++)
		format->Append(hd->GetString((HEX_DISPLAY) i));
//	rb_btn = new wxButton(this, ID_ROUTES_BORDERS, "Routes and Borders");
	for(i = 0;i < 8;i++) {
		uwps[i] = new wxCheckBox(this, ID_FORMAT_UWP, uwp_str[i]);
	}
	all = new wxCheckBox(this, ID_WIDE, "Apply to Entire Sector");
	btn = new wxButton(this, ID_FORMAT_DEFAULT, "Default Settings");
	uwp_box = new wxStaticBox(this, -1, "UWP Filter");


	wxBoxSizer* sizer_21 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_24 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_27 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_26 = new wxStaticBoxSizer(uwp_box, wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_5 = new wxFlexGridSizer(2, 4, 0, 0);
    wxBoxSizer* sizer_25 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_22 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_23 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Sample Image"), wxHORIZONTAL);
    sizer_23->Add(canvas, 1, 0, 0);
    sizer_22->Add(sizer_23, 0, wxALL, DLG_OFFSET);

	panel_sizer = GetSizer();
	sizer_22->Add(panel_sizer, 0, wxALL, DLG_OFFSET);

    sizer_21->Add(sizer_22, 0, 0, 0);
    sizer_25->Add(msg, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_25->Add(format, 0, wxALL, DLG_OFFSET);
    sizer_24->Add(sizer_25, 0, 0, 0);
	for(i = 0;i < 8;i++)
    	grid_sizer_5->Add(uwps[i], 0, wxALL, DLG_OFFSET / 2);
    sizer_26->Add(grid_sizer_5, 0, 0, 0);
    sizer_24->Add(sizer_26, 1, wxALL, DLG_OFFSET);
    sizer_27->Add(all, 0, wxALL, DLG_OFFSET);
    sizer_27->Add(btn, 0, wxALL, DLG_OFFSET);
    sizer_24->Add(sizer_27, 0, 0, 0);
    sizer_21->Add(sizer_24, 1, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(sizer_21);
    sizer_21->Fit(this);
    sizer_21->SetSizeHints(this);
    Layout();

}

// ---------------------------------------------------------------
void 
FormatDialog::OnFilter(wxCommandEvent& event)
{
unsigned char mask=1,val=0;
int i;

	for(i = 0;i < 8;i++) {
		if(uwps[i]->GetValue())
			val |= mask;
		mask *= 2;
	}
	l_hl->SetUWPFilter(val);
	canvas->Refresh();
}

void 
FormatDialog::OnReset(wxCommandEvent& event)
{
	l_hl->Reset();
	canvas->Refresh();
}

//void 
//FormatDialog::OnRouteBorder(wxCommandEvent& event)
//{
//}

void 
FormatDialog::OnFormat(wxCommandEvent& event)
{
HEX_DISPLAY hd;

	hd = (HEX_DISPLAY) format->GetSelection();
	// XXX trap HD_FILTERED and run the filter dialog ???
	l_hl->SetCode(cur_x, cur_y, hd);
	canvas->Refresh();
	EnableFilter(HD_UWP_FILTERED == l_hl->GetCode(cur_x, cur_y));
}

// ---------------------------------------------------------------
void
FormatDialog::EnableFilter(bool val)
{
int i;

	for(i = 0;i < 8;i++) {
		uwps[i]->Enable(val);
	}
	uwp_box->Enable(val);
}

// callback from the canvas
void
FormatDialog::UpdateCoords(int x, int y)
{
char buff[80];

	sprintf(buff, "Format for row %d col %d:", y+1, x+1);
	msg->SetLabel(buff);
	cur_x = x;
	cur_y = y;
	format->SetSelection(l_hl->GetCode(cur_x, cur_y));
	EnableFilter(HD_UWP_FILTERED == l_hl->GetCode(cur_x, cur_y));
}

// ---------------------------------------------------------------
bool
FormatDialog::GetFormat(bool sector_wide, HexLayout *hl, bool *clear)
{
int i,j;
unsigned char mask,val;

	cur_x = cur_y = 0;
	l_hl = new HexLayout(hl);
	format->SetSelection(l_hl->GetCode(cur_x, cur_y));

	canvas->SetLayout(l_hl);
	canvas->SetCoords(cur_x, cur_y);
	UpdateCoords(cur_x, cur_y);
	mask = 1;
	val = l_hl->GetUWPFilter();
	for(i = 0;i < 8;i++) {
		uwps[i]->SetValue(mask == (val & mask));
		mask *= 2;
	}

//	rb_btn->Show(sector_wide);
	all->Show(sector_wide);
	all->SetValue(FALSE);

	if(ShowModal() == wxID_CANCEL) {
		delete l_hl;
		return(FALSE);
	}

	for(i = 0;i < MAX_LAYOUT_X;i++)
		for(j = 0;j < MAX_LAYOUT_Y;j++)
			hl->SetCode(i, j, l_hl->GetCode(i, j));
	hl->SetUWPFilter(l_hl->GetUWPFilter());
	if(sector_wide)
		*clear = all->GetValue();

	delete l_hl;
	return(TRUE);
}

// ---------------------------------------------------------------
static int x_bounds[MAX_LAYOUT_X + 1] = {
	13, 41, 63, 90
};

static int y_bounds[MAX_LAYOUT_Y + 1] = {
	2, 20, 38, 56, 74, 92
};

BEGIN_EVENT_TABLE(FormatPanel, wxScrolledWindow)
	EVT_LEFT_DOWN(FormatPanel::OnLeftDown)
END_EVENT_TABLE()

FormatPanel::FormatPanel(FormatDialog *p, BitmapList *b, TCodes *c, int w, int h) : 
		wxScrolledWindow(p, -1, wxPoint(0, 0), wxSize(w, h)) 
{
	bms = b; 
	codes = c;
	SetBackgroundColour(*wxWHITE);
	cur_x = cur_y = 0;
	parent = (FormatDialog *)p;
}

void
FormatPanel::OnDraw(wxDC& dc)
{
int x,y;

	dc.Clear();
	dc.SetBrush(*wxGREY_BRUSH);
	dc.SetPen(*wxWHITE_PEN);
	dc.DrawRectangle(x_bounds[cur_x], y_bounds[cur_y],
					x_bounds[cur_x + 1] - x_bounds[cur_x] + 1, 
					y_bounds[cur_y + 1] - y_bounds[cur_y] + 1);

	dc.SetBrush(*wxBLACK_BRUSH);
	dc.SetPen(*wxRED_PEN);
	for(x = 1;x < MAX_LAYOUT_X;x++) {
		dc.DrawLine(19 + (x * 22), 0, 19 + (x * 22), PANEL_SIZE_Y);
	}
	for(y = 1;y < MAX_LAYOUT_Y;y++) {
		dc.DrawLine(0, 2 + (y * 18), PANEL_SIZE_X, 2 + (y * 18));
	}
	dc.SetPen(*wxBLACK_PEN);

	hex.DrawDummy(dc, l_hl, bms, codes, 2, 3);
}

void 
FormatPanel::OnLeftDown(wxMouseEvent &event)
{
int x,y,temp_x=0,temp_y=0;
bool hit_x=FALSE,hit_y=FALSE;

	for(x = 0;x < (MAX_LAYOUT_X + 1);x++) {
		if((event.GetX() >= x_bounds[x]) && (event.GetX() <= x_bounds[x+1])) {
			hit_x = TRUE;
			temp_x = x;
			break;
		}
	}
	for(y = 0;y < (MAX_LAYOUT_Y + 1);y++) {
		if((event.GetY() >= y_bounds[y]) && (event.GetY() <= y_bounds[y+1])) {
			hit_y = TRUE;
			temp_y = y;
			break;
		}
	}

	if((hit_x) && (hit_y)) {
		cur_x = temp_x;
		cur_y = temp_y;
		Refresh();
		parent->UpdateCoords(cur_x, cur_y);
	}
}

