//
// File:		legend.h
// Purpose:		handle drawing of the sector legend
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: legend.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/10/03 10:48:29 $"

#ifndef LEGEND_H
#define LEGEND_H

#include "draw_hex.h"

class Legend
{
public:
	Legend() {};
	~Legend() {};

	// one common external entry point
	void DrawLegend(wxDC& dc, int init_x, int init_y, 
		int *max_x, int *max_y, bool draw, int cur_ss, 
		BaseSector *sect, BitmapList *bitmaps, TCodes *codes, 
		ColorTable *bt, ColorTable *rt, ColorArray *colors,
		HexLayout *layout);

private:
	void DrawLegendBox(wxDC& dc, int x, int y, int w, int h);
	void DrawLegendRoutesBorders(wxDC& dc, bool border, bool draw,
		int x1, int y1, int x2, int y2,
		ColorTable *ct, ColorArray *colors, int *max_x, int *max_y);
	void DrawLegendMap(wxDC& dc, bool draw, int x1, int y1, int x2, int y2,
			int cur_ss, int *max_x, int *max_y);
	void DrawSSList(wxDC& dc, bool draw, int x1, int y1, int x2, int y2,
			BaseSector *sect,
			int *max_x, int *max_y);
	void DrawHexLegend(wxDC& dc, bool draw, int x1, int y1, int x2, int y2,
			BitmapList *bitmaps, TCodes *codes, ColorArray *colors,
			HexLayout *layout, int *max_x, int *max_y);
	void DrawBorder(wxDC& dc, bool draw, int x1, int y1, int x2, int y2,
			ColorTable *ct, ColorArray *colors, int *max_x, int *max_y);
	void DrawRoutes(wxDC& dc, bool draw, int x1, int y1, int x2, int y2,
			ColorTable *ct, ColorArray *colors, int *max_x, int *max_y);

	void DrawWorldBM(wxDC& dc, char *desc, char *uwp, bool draw, 
				int x, int y, int *max_x);
	void Init(void);

	DrawnHex	drawn_hex;

};

#endif

