/*
 * File:      mtu_dlg.cpp
 * Purpose:   dialogs for MTU menu program
 * Author:    Mark A. Nordstrand
 * Created:   8/1/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: mtu_dlg.cpp,v $ $Revision: 1.13 $ $Author: man $ $Date: 2003/05/04 12:25:52 $" */

// XXX temporary:
#include "t_dlg.h"
#include "mtu_dlg.h"

#include "t_res.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "wx/image.h"
#include "wx/print.h"

#if defined(__WXGTK__) || defined(__WXMOTIF__)
#include "bitmaps/default.xpm"
#endif

// hmmm color y dependant on slider height and
//		slider x dependent on color x/width
#define COLOR_X					(2 * DLG_OFFSET)
#define COLOR_WIDTH				40
#define SLIDER_X				((2 * COLOR_X) + COLOR_WIDTH)
#define SLIDER_Y				10
#define SLIDER_SPACING			55
#define SLIDER_HEIGHT			160
#define COLOR_HEIGHT			COLOR_WIDTH
#define COLOR_Y					((SLIDER_HEIGHT - COLOR_HEIGHT) / 2 + SLIDER_Y)

#define ID_RED_SLIDER			3001
#define ID_GREEN_SLIDER			3002
#define ID_BLUE_SLIDER			3003
#define ID_LOAD_BITMAP			3004
#define ID_X_SLIDER				3005
#define ID_Y_SLIDER				3006
#define ID_Z_SLIDER				3007

// =======================================================================
typedef enum {
	COLOR_CB = 500,
	BITMAP_CB,
	NEW_CB,
	DEL_CB,
	ED_CB,
	LIST_CTRL,
	SETUP_CB,
	TOTAL_CB,
	FILE_CB
//	CANCEL_CB,
//	IMPORT_CB,
//	OVERWRITE_CB,
//	UNIFORM_CB,
//	DETAIL_CB,
//	LANG_CB,
//	BULK_CB
};

// resource editor
#if defined(__WXGTK__) || defined(__WXMOTIF__)
#define MAX_HELP_STRINGS			3
static wxString help_str[MAX_HELP_STRINGS] = {
	"gnome-help-browser",
	"kdehelp",
	"netscape"
};

// -----------------------------------------------------------------------
BEGIN_EVENT_TABLE(ResourceDialog, wxDialog)
	EVT_BUTTON(COLOR_CB, ResourceDialog::OnColor)
	EVT_BUTTON(BITMAP_CB, ResourceDialog::OnBitmap)
END_EVENT_TABLE()

ResourceDialog::ResourceDialog(wxWindow *p, wxConfig *cfg) :
	StdDialog(p, "Edit Resources")
{
wxStaticText *msg[15];
wxButton *btn[2];
wxBoxSizer *btn_sizer[2];
wxBoxSizer* main_sizer;
wxBoxSizer* bottom_sizer;

	config = cfg;
	data_dialog = NULL;
	ca = NULL;
	bl = NULL;

	msg[0] = new wxStaticText(this, -1, "Data:");
    msg[1] = new wxStaticText(this, -1, "Execute:");
    msg[2] = new wxStaticText(this, -1, "Help:");
    msg[3] = new wxStaticText(this, -1, "MTU:");
    msg[4] = new wxStaticText(this, -1, "Sector:");
    msg[5] = new wxStaticText(this, -1, "Trade:");
    msg[6] = new wxStaticText(this, -1, "System:");
    msg[7] = new wxStaticText(this, -1, "Sysgen:");
    msg[8] = new wxStaticText(this, -1, "World:");
    msg[9] = new wxStaticText(this, -1, "SecGen");
    msg[10] = new wxStaticText(this, -1, "EncTbl:");
    msg[11] = new wxStaticText(this, -1, "Editor:");
    msg[12] = new wxStaticText(this, -1, "Graphics:");
    msg[13] = new wxStaticText(this, -1, "Viewer:");
    msg[14] = new wxStaticText(this, -1, "Browser:");

    data_dir = new wxTextCtrl(this, -1, "");
    exe_dir = new wxTextCtrl(this, -1, "");
    help_dir = new wxTextCtrl(this, -1, "");
    mtu_dir = new wxTextCtrl(this, -1, "");
    sector= new wxTextCtrl(this, -1, "");
    system= new wxTextCtrl(this, -1, "");
    world= new wxTextCtrl(this, -1, "");
    enc_tbl= new wxTextCtrl(this, -1, "");
    trade= new wxTextCtrl(this, -1, "");
    sysgen= new wxTextCtrl(this, -1, "");
    sect_gen= new wxTextCtrl(this, -1, "");
    editor= new wxTextCtrl(this, -1, "");
    viewer= new wxTextCtrl(this, -1, "");
    graphics= new wxTextCtrl(this, -1, "");
    browser= new wxTextCtrl(this, -1, "");
    btn[0] = new wxButton(this, COLOR_CB, "Colors",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));
    btn[1] = new wxButton(this, BITMAP_CB, "Bitmaps",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));


    data_dir->SetSize(wxSize(300, 22));
    exe_dir->SetSize(wxSize(300, 22));
    help_dir->SetSize(wxSize(300, 22));
    mtu_dir->SetSize(wxSize(300, 22));
    sector->SetSize(wxSize(125, 22));
    trade->SetSize(wxSize(125, 22));
    system->SetSize(wxSize(125, 22));
    sysgen->SetSize(wxSize(125, 22));
    world->SetSize(wxSize(125, 22));
    sect_gen->SetSize(wxSize(125, 22));
    enc_tbl->SetSize(wxSize(125, 22));
    editor->SetSize(wxSize(125, 22));
    graphics->SetSize(wxSize(125, 22));
    viewer->SetSize(wxSize(125, 22));
    browser->SetSize(wxSize(125, 22));


    main_sizer = new wxBoxSizer(wxVERTICAL);
    bottom_sizer = new wxBoxSizer(wxHORIZONTAL);
    btn_sizer[1] = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "System Executables"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_4 = new wxFlexGridSizer(2, 4, DLG_OFFSET, DLG_OFFSET);
    wxStaticBoxSizer* sizer_6 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "MTU Executables"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_3 = new wxFlexGridSizer(4, 4, DLG_OFFSET, DLG_OFFSET);
    wxStaticBoxSizer* sizer_5 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Directories"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(4, 2, DLG_OFFSET, DLG_OFFSET);
    grid_sizer_2->Add(msg[0], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_2->Add(data_dir, 0, 0, 0);
    grid_sizer_2->Add(msg[1], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_2->Add(exe_dir, 0, 0, 0);
    grid_sizer_2->Add(msg[2], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_2->Add(help_dir, 0, 0, 0);
    grid_sizer_2->Add(msg[3], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_2->Add(mtu_dir, 0, 0, 0);
    sizer_5->Add(grid_sizer_2, 1, wxALL|wxEXPAND, DLG_OFFSET);
    main_sizer->Add(sizer_5, 1, wxALL|wxEXPAND, DLG_OFFSET);
    grid_sizer_3->Add(msg[4], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(sector, 0, 0, 0);
    grid_sizer_3->Add(msg[5], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(trade, 0, 0, 0);
    grid_sizer_3->Add(msg[6], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(system, 0, 0, 0);
    grid_sizer_3->Add(msg[7], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(sysgen, 0, 0, 0);
    grid_sizer_3->Add(msg[8], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(world, 0, 0, 0);
    grid_sizer_3->Add(msg[9], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(sect_gen, 0, 0, 0);
    grid_sizer_3->Add(msg[10], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(enc_tbl, 0, 0, 0);
    sizer_6->Add(grid_sizer_3, 1, wxALL|wxEXPAND, DLG_OFFSET);
    main_sizer->Add(sizer_6, 1, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(msg[11], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(editor, 0, 0, 0);
    grid_sizer_4->Add(msg[12], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(graphics, 0, 0, 0);
    grid_sizer_4->Add(msg[13], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(viewer, 0, 0, 0);
    grid_sizer_4->Add(msg[14], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(browser, 0, 0, 0);
    sizer_7->Add(grid_sizer_4, 1, wxALL|wxEXPAND, DLG_OFFSET);
    main_sizer->Add(sizer_7, 0, wxALL, DLG_OFFSET);

	btn_sizer[0] = GetSizer();
	bottom_sizer->Add(btn_sizer[0], 0, wxALIGN_LEFT | wxALL, DLG_OFFSET);
	// XXX don't like this:
	bottom_sizer->Add(90, DLG_OFFSET, 1, wxALL | wxEXPAND, DLG_OFFSET);

    btn_sizer[1]->Add(btn[0], 1, wxALL | wxALIGN_RIGHT, DLG_OFFSET / 2);
    btn_sizer[1]->Add(btn[1], 1, wxALL | wxALIGN_RIGHT, DLG_OFFSET / 2);
	bottom_sizer->Add(btn_sizer[1], 0, wxALIGN_RIGHT | wxALL, 2 * DLG_OFFSET);
    main_sizer->Add(bottom_sizer, 0, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(main_sizer);
    main_sizer->Fit(this);
    main_sizer->SetSizeHints(this);
    Layout();
}

ResourceDialog::~ResourceDialog()
{
}

bool
ResourceDialog::GetResources(void)
{
bool ret;
char str[MAX_FILE_LENGTH];
//wxConfig *config;
wxString ptr;

	// load resources;
//	config = new wxConfig((const wxString) RESOURCE_FILE);
//	wxConfigBase::Set(config);
//	wxConfigBase::Get();

	// find the data dir
	sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_DATA_DIR);
	if(config->Read((const wxString) str, &ptr))
		data_dir->SetValue(ptr);
	else
		data_dir->SetValue("");

	// find the exe dir
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_DIR);
	if(config->Read((const wxString) str, &ptr))
		exe_dir->SetValue(ptr);
	else
		exe_dir->SetValue("");

	// find the help dir
	sprintf(str, "/%s/%s", SECTION_HELP, ENTRY_HELP_DIR);
	if(config->Read((const wxString) str, &ptr))
		help_dir->SetValue(ptr);
	else
		help_dir->SetValue("");

	// find the help dir
	sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_MTU_DIR);
	if(config->Read((const wxString) str, &ptr))
		mtu_dir->SetValue(ptr);
	else
		mtu_dir->SetValue("");

	// find the sector file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SECTOR);
	if(config->Read((const wxString) str, &ptr))
		sector->SetValue(ptr);
	else
		sector->SetValue("");

	// find the sysgen file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SYSGEN);
	if(config->Read((const wxString) str, &ptr))
		sysgen->SetValue(ptr);
	else
		sysgen->SetValue("");

	// find the system file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SYSTEM);
	if(config->Read((const wxString) str, &ptr))
		system->SetValue(ptr);
	else
		system->SetValue("");

	// find the world file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_WORLD);
	if(config->Read((const wxString) str, &ptr))
		world->SetValue(ptr);
	else
		world->SetValue("");

	// find the enc. table file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_ENC_TBL);
	if(config->Read((const wxString) str, &ptr))
		enc_tbl->SetValue(ptr);
	else
		enc_tbl->SetValue("");

	// find the star gen. file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_TRADE);
	if(config->Read((const wxString) str, &ptr))
		trade->SetValue(ptr);
	else
		trade->SetValue("");

	// find the sec gen. file
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SECGEN);
	if(config->Read((const wxString) str, &ptr))
		sect_gen->SetValue(ptr);
	else
		sect_gen->SetValue("");

	// find the editors
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_EDITOR);
	if(config->Read((const wxString) str, &ptr))
		editor->SetValue(ptr);
	else
		editor->SetValue("");

	// find the text viewer
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_VIEWER);
	if(config->Read((const wxString) str, &ptr))
		viewer->SetValue(ptr);
	else
		viewer->SetValue("");

	// find the graphics viewer
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_GRAPHICS);
	if(config->Read((const wxString) str, &ptr))
		graphics->SetValue(ptr);
	else
		graphics->SetValue("");

	// find the help command
	sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_BROWSER);
	if(config->Read((const wxString) str, &ptr))
		browser->SetValue(ptr);
	else
		browser->SetValue("");

	if(ShowModal() != wxID_CANCEL) {
		// data dir
		sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_DATA_DIR);
		config->Write((const wxString) str, data_dir->GetValue());

		// exe dir
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_DIR);
		config->Write((const wxString) str, exe_dir->GetValue());

		// help dir
		sprintf(str, "/%s/%s", SECTION_HELP, ENTRY_HELP_DIR);
		config->Write((const wxString) str, help_dir->GetValue());

		// help dir
		sprintf(str, "/%s/%s", SECTION_DATA, ENTRY_MTU_DIR);
		config->Write((const wxString) str, mtu_dir->GetValue());

		// sector file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SECTOR);
		config->Write((const wxString) str, sector->GetValue());

		// sysgen file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SYSGEN);
		config->Write((const wxString) str, sysgen->GetValue());

		// system file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SYSTEM);
		config->Write((const wxString) str, system->GetValue());

		// world file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_WORLD);
		config->Write((const wxString) str, world->GetValue());

		// enc. table file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_ENC_TBL);
		config->Write((const wxString) str, enc_tbl->GetValue());

		// star gen. file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_TRADE);
		config->Write((const wxString) str, trade->GetValue());

		// sect gen. file
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_SECGEN);
		config->Write((const wxString) str, sect_gen->GetValue());

		// editors
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_EDITOR);
		config->Write((const wxString) str, editor->GetValue());
		
		// text viewer
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_VIEWER);
		config->Write((const wxString) str, viewer->GetValue());

		// graphics viewer
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_GRAPHICS);
		config->Write((const wxString) str, graphics->GetValue());

		// browser
		sprintf(str, "/%s/%s", SECTION_EXECUTE, ENTRY_BROWSER);
		config->Write((const wxString) str, browser->GetValue());

		if(bl != NULL)
			bl->Save(config);
		if(ca != NULL)
			ca->WriteColors(config);
		ret = TRUE;
	} else {
		ret = FALSE;
	}

	// clean up and exit
	config->Flush();
	if(bl != NULL) {
		delete bl;
		bl = NULL;
	}
	if(ca != NULL) {
		delete ca;
		ca = NULL;
	}

	return(ret);
}

void 
ResourceDialog::OnColor(wxCommandEvent& event)
{
	ca = new ColorArray(config);
	if(NULL == data_dialog)
		data_dialog = new ResourceDataDialog(this);
	if(data_dialog->GetColors(ca)) {
	}
}

void 
ResourceDialog::OnBitmap(wxCommandEvent& event)
{
	bl = new BitmapList(config);
	if(NULL == data_dialog)
		data_dialog = new ResourceDataDialog(this);
	if(data_dialog->GetBitmaps(bl)) {
	}
}

// =======================================================================
BEGIN_EVENT_TABLE(ResourceDataDialog, wxDialog)
	EVT_BUTTON(NEW_CB, ResourceDataDialog::OnNew)
	EVT_BUTTON(DEL_CB, ResourceDataDialog::OnDel)
	EVT_BUTTON(ED_CB, ResourceDataDialog::OnEdit)
	EVT_LIST_ITEM_SELECTED(LIST_CTRL, ResourceDataDialog::OnSelected)
END_EVENT_TABLE()

ResourceDataDialog::ResourceDataDialog(wxWindow *p) :
	StdDialog(p, "Delete this", FALSE)
{
int w;

	w = GetBestSize().GetWidth();

	color_dialog = NULL;
	bitmap_dialog = NULL;
	images = new wxImageList(BITMAP_SIZE, BITMAP_SIZE, TRUE);

	bm = new BitmapControl(this, LIST_CTRL);
	edit_c = new wxButton(this, ED_CB, "Edit",
			wxPoint(-1, -1),
			wxSize(w, -1));
	delete_c = new wxButton(this, DEL_CB, "Delete",
			wxPoint(-1, -1),
			wxSize(w, -1));
	new_c = new wxButton(this, NEW_CB, "New",
			wxPoint(-1, -1),
			wxSize(w, -1));

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxVERTICAL);
    sizer_1->Add(bm, 1, wxALL, DLG_OFFSET);
    sizer_3->Add(edit_c, 0, wxALL, DLG_OFFSET / 2);
    sizer_3->Add(delete_c, 0, wxALL, DLG_OFFSET / 2);
    sizer_3->Add(new_c, 0, wxALL, DLG_OFFSET / 2);
    sizer_2->Add(sizer_3, 0, wxALL, (int) (1.5 * DLG_OFFSET));

    sizer_1->Add(sizer_2, 0, 0, 0);
	DoLayout(wxALL, DLG_OFFSET, sizer_1, sizer_2);
}

ResourceDataDialog::~ResourceDataDialog()
{
	delete images;
}

// ------------------------------------------------------------------------
bool
ResourceDataDialog::GetBitmaps(BitmapList *bl)
{
	SetTitle("Edit Bitmaps");

	if(NULL == bitmap_dialog)
		bitmap_dialog = new EditBitmapDialog(this);
	ed = RE_BITMAP;
	bls = bl;
//	DisplayBitmaps(bls);
	bm->DisplayBitmaps(bls);

	edit_c->Enable(TRUE);
	if(ShowModal() != wxID_CANCEL) {
		return(FALSE);
	}

	return(TRUE);
}

bool
ResourceDataDialog::GetColors(ColorArray *c)
{
	SetTitle("Edit Custom Colors");

	// this seems the best time to do this......
	if(NULL == color_dialog)
		color_dialog = new EditColorDialog(this);
	ed = RE_COLOR;
	colors = c;
	DisplayColors(c);

	edit_c->Enable(TRUE);
	if(ShowModal() != wxID_CANCEL) {
		return(FALSE);
	}

	return(TRUE);
}

// ------------------------------------------------------------------------
void
ResourceDataDialog::DisplayColors(ColorArray *c)
{
int i=BASE_COLORS,j=0;		// don't edit the base colors
wxBitmap *bitmap;
wxColour *clr;
wxMemoryDC dc;

	bm->DeleteAllItems();
	bm->SetSingleStyle(wxLC_ICON);
	images->RemoveAll();
	for(i = BASE_COLORS;i < TOTAL_COLORS;i++) {
		wxPen *p;
		wxBrush *b;

//		if(c->GetName(i) == NULL)
//			continue;
		if((clr = c->GetColor(i)) != NULL) {
			p = new wxPen(*clr, 1, wxSOLID);
			b = new wxBrush(*clr, wxSOLID);
		} else {
			continue;
			p = new wxPen("BLACK", 1, wxSOLID);
			b = new wxBrush("BLACK", wxSOLID);
		}
//fprintf(stderr, "%d: %s %d %d %d\n", i, c->GetName(i), 
//	clr->Red(), clr->Green(), clr->Blue());
		bitmap = new wxBitmap(BITMAP_SIZE, BITMAP_SIZE);
		dc.SelectObject(*bitmap);
		dc.Clear();
		dc.SetBrush(*b);
		dc.SetPen(*p);
		dc.DrawRectangle( 0, 0, BITMAP_SIZE, BITMAP_SIZE);
		images->Add(*bitmap);
		dc.SelectObject(wxNullBitmap);
		delete p;
		delete b;
		delete bitmap;
		j++;
	}

	bm->SetImageList(images, wxIMAGE_LIST_NORMAL);
//	for(i = BASE_COLORS;i < TOTAL_COLORS;i++) {
	for(i=0; i < j; i++) {
		char buff[15],*ptr;
//		char *ptr;
		wxString str;

		if((ptr = c->GetName(i + BASE_COLORS)) == NULL) {
//		if((ptr = c->GetName(i)) == NULL) {
//			continue;
			sprintf(buff, "Custom %d", i + 1);
			ptr = buff;
		} 
		str.Printf("%s", ptr);
		bm->InsertItem(i, ptr, i);
	}
}

// ------------------------------------------------------------------------
void
ResourceDataDialog::OnNew(wxCommandEvent& event)
{
	if(RE_COLOR == ed) {		// adding colors
		wxColour *c;
		char *n;
		
		c = new wxColor(0, 0, 0);
		n = "New Color";
		if((n = color_dialog->EditColor(c, n)) != NULL) {
			colors->AddColor(c->Red(), c->Green(), c->Blue(), n);
			delete n;
			DisplayColors(colors);
		}
		delete c;
	} else {					// adding bitmaps
		NamedBitmap *nb;
		wxBitmap *bitmap;

		bitmap = new wxBitmap(default_xpm);
		nb = new NamedBitmap(bitmap, "Default");
		if(bitmap_dialog->EditBitmap(nb)) {
			bls->Append(nb);
			delete bitmap;
//			DisplayBitmaps(bls);
			bm->DisplayBitmaps(bls);
		} else {
			delete nb;
		}
	}
}

void 
ResourceDataDialog::OnDel(wxCommandEvent& event)
{
int i;

//	if((i = GetSelection()) > -1) {
	if((i = bm->GetSelection()) > -1) {
		if(RE_COLOR == ed) {		// deleting colors
			colors->DeleteColor(i + BASE_COLORS);
			DisplayColors(colors);
		} else {					// deleting bitmaps
			NamedBitmap *nb;

			nb = bls->GetNth(i);
    		bls->DeleteObject(nb);
//			DisplayBitmaps(bls);
			bm->DisplayBitmaps(bls);
		}
	}
}

void 
ResourceDataDialog::OnEdit(wxCommandEvent& event)
{
int i;

//	if((i = GetSelection()) > -1) {
	if((i = bm->GetSelection()) > -1) {
		if(RE_COLOR == ed) {		// editing colors
			wxColour *c;
			char *n;
//			bool flag=FALSE;
		
			if((c = colors->GetColor(i + BASE_COLORS)) == NULL) {
				return;
//				c = new wxColor(0, 0, 0);
//				flag = TRUE;
			}
			if((n = colors->GetName(i + BASE_COLORS)) == NULL)
				n = "New Color";
			if((n = color_dialog->EditColor(c, n)) != NULL) {
				colors->EditColor(i, c->Red(), c->Green(), c->Blue(), n);
//				delete n;
				DisplayColors(colors);
			}
//			if(flag) delete c;
		} else {					// editing bitmaps
			bitmap_dialog->EditBitmap(bls->GetNth(i));
//			DisplayBitmaps(bls);
			bm->DisplayBitmaps(bls);
		}
	}
}

//int
//ResourceDataDialog::GetSelection(void)
//{
//int i;
//
//	for(i = 0; i < bm->GetItemCount();i++) {
//		if(bm->GetItemState(i, wxLIST_STATE_SELECTED))
//			return(i);
//	}
//	return(-1);
//}

void 
ResourceDataDialog::OnSelected(wxListEvent& WXUNUSED(event))
{
int i;

	if(RE_COLOR == ed) {
//		i = GetSelection();
		i = bm->GetSelection();
		if(colors->GetName(i + BASE_COLORS) == NULL)
			edit_c->Enable(FALSE);
		else
			edit_c->Enable(TRUE);
	}
}

#endif
// ==================================================================
BEGIN_EVENT_TABLE(EditBitmapDialog, wxDialog)
	EVT_BUTTON(ID_LOAD_BITMAP, EditBitmapDialog::OnLoad)
END_EVENT_TABLE()

// ------------------------------------------------------------------
EditBitmapDialog::EditBitmapDialog(wxWindow *p) :
	StdDialog(p, "Edit Bitmap")
{
wxStaticText *msg;
wxButton *btn;
wxBitmap *l_bm;

	l_bm = new wxBitmap(default_xpm);
	btn = new wxButton(this, ID_LOAD_BITMAP, "Load");

	msg = new wxStaticText(this, -1, "Name:");
	name = new wxTextCtrl(this, -1, "",
		wxPoint(-1, -1),
		wxSize(2 * (SLIDER_SPACING), -1));

	bm = new wxStaticBitmap(this, -1, *l_bm);

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(1, 2, 5, 5);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(1, 2, 5, 5);
    grid_sizer_2->Add(btn, 0, 0, 0);
    grid_sizer_2->Add(bm, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_1->Add(grid_sizer_2, 0, wxALL, 5);
    grid_sizer_1->Add(msg, 0, wxALIGN_BOTTOM, 0);
    grid_sizer_1->Add(name, 0, 0, 0);
    sizer_1->Add(grid_sizer_1, 0, wxALL, 5);

	DoLayout(wxALL, DLG_OFFSET, sizer_1);

	delete l_bm;
}

EditBitmapDialog::~EditBitmapDialog()
{
}

void 
EditBitmapDialog::OnLoad(wxCommandEvent& event)
{
char *ptr,*file;
wxString str;

	file = bitmap->GetFilename();
	str = wxFileSelector("Load Bitmap", NULL, file, NULL,
		"*.xpm",  wxHIDE_READONLY | wxOPEN | wxFILE_MUST_EXIST, this);
	ptr = (char *)str.GetData();
fprintf(stderr, "----><%s>\n", ptr);
	if((NULL == ptr) || (0 == ptr[0]))
		return;

	bitmap->SetFilename(ptr);

	bm->SetBitmap(*bitmap->GetBM());

	Refresh();
}

bool
EditBitmapDialog::EditBitmap(NamedBitmap *nb)
{
int ret;

	if(nb->GetFilename() != NULL) {
		bitmap = new NamedBitmap(nb->GetFilename(), nb->GetName());
		name->SetValue(nb->GetName());
		bm->SetBitmap(*bitmap->GetBM());
	} else {
		bitmap = new NamedBitmap(nb->GetBM(), nb->GetName());
		name->SetValue("Default");
		bm->SetBitmap(*bitmap->GetBM());
	}

	while(TRUE) {
		ret = ShowModal();

		if(wxID_CANCEL == ret) {
			delete bitmap;
			return(FALSE);
		}

		if(bitmap->GetFilename() == NULL) {
			continue;
		}
		nb->SetName((char *)name->GetValue().GetData());
		nb->SetFilename(bitmap->GetFilename());
		delete bitmap;

		return(TRUE);
	}
	return(TRUE);
}

// ==================================================================
BEGIN_EVENT_TABLE(EditColorDialog, wxDialog)
	EVT_SLIDER(ID_RED_SLIDER, EditColorDialog::OnSlider)
	EVT_SLIDER(ID_GREEN_SLIDER, EditColorDialog::OnSlider)
	EVT_SLIDER(ID_BLUE_SLIDER, EditColorDialog::OnSlider)
END_EVENT_TABLE()

// ------------------------------------------------------------------
EditColorDialog::EditColorDialog(wxWindow *p) :
	StdDialog(p, "Edit Color")
{
wxStaticText *msg;
wxBitmap *l_bm;

	widget = new wxColour(0, 0, 0);
	l_bm = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	bitmap = new wxStaticBitmap(this, -1, *l_bm);

	red = new wxSlider(this, ID_RED_SLIDER, 0, 0, 255,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);
	green = new wxSlider(this, ID_GREEN_SLIDER, 0, 0, 255,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);
	blue = new wxSlider(this, ID_BLUE_SLIDER, 0, 0, 255,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);

	msg = new wxStaticText(this, -1, "Name:");
	name = new wxTextCtrl(this, -1, "",
		wxPoint(-1, -1),
		wxSize(3 * (SLIDER_SPACING), -1));

	wxBoxSizer* sizer_3 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_3 = new wxFlexGridSizer(1, 2, DLG_OFFSET, DLG_OFFSET);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    sizer_4->Add(bitmap, 0, wxALL|wxALIGN_CENTER_VERTICAL, DLG_OFFSET);
    sizer_4->Add(red, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_4->Add(green, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_4->Add(blue, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_3->Add(sizer_4, 0, 0, 0);
    grid_sizer_3->Add(msg, 0, wxALIGN_BOTTOM, 0);
    grid_sizer_3->Add(name, 2, 0, 0);
    sizer_3->Add(grid_sizer_3, 0, wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, sizer_3);

	delete l_bm;
}

EditColorDialog::~EditColorDialog()
{
	delete widget;
}

// hmmmmmm
char *
EditColorDialog::EditColor(wxColour *c, char *n)
{
char *ret;

	widget->Set(c->Red(), c->Green(), c->Blue());
	red->SetValue(c->Red());
	green->SetValue(c->Green());
	blue->SetValue(c->Blue());
	name->SetValue(n);
	SetColor();

	if(ShowModal() == wxID_CANCEL)
		return(NULL);

	ret = new char[strlen(name->GetValue().GetData()) + 1];
	strcpy(ret, name->GetValue().GetData());
	c->Set(widget->Red(), widget->Green(), widget->Blue());
	return(ret);
}

void
EditColorDialog::SetColor(void)
{
wxBitmap *l_bm;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;

	l_bm = new wxBitmap(COLOR_WIDTH, COLOR_HEIGHT);
	m_dc.SelectObject(*l_bm);

	b = new wxBrush(*widget, wxSOLID);
	m_dc.SetBrush(*b);
	p = new wxPen(*widget, 1, wxSOLID);
	m_dc.SetPen(*p);

	m_dc.DrawRectangle(0, 0, COLOR_WIDTH, COLOR_HEIGHT);

	bitmap->SetBitmap(*l_bm);

	delete l_bm;
}

// ------------------------------------------------------------------
void
EditColorDialog::OnSlider(wxCommandEvent& WXUNUSED(event))
{
	if((NULL == red) || (NULL == green) || (NULL == blue))
		return;
    
	wxClientDC dc(this);
	widget->Set(red->GetValue(), green->GetValue(), blue->GetValue());
	Refresh();
}

// =======================================================================
ChooseDialog::ChooseDialog(wxWindow *p) :
	StdDialog(p, "Select A Universe")
{
wxBoxSizer *main_sizer;

	lb = new wxListBox(this, -1, 
		wxPoint(DLG_OFFSET, DLG_OFFSET),
		wxSize(200, 200),
		0, NULL, wxLB_SINGLE | wxLB_NEEDED_SB);

	main_sizer = new wxBoxSizer(wxVERTICAL);
	main_sizer->Add(lb, 0, wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

ChooseDialog::~ChooseDialog()
{
}

int
ChooseDialog::GetUniverseChoice(UList *ul)
{
UListData *uld;
char *ptr;
int i=0;

	SetTitle("Select A Universe");
	lb->Clear();
	while((uld = (UListData *)ul->NthData(i)) != NULL) {
		ptr = uld->GetDesc();
		lb->Append(ptr);
		i++;
	}

	return(GetChoice(i));
}

int
ChooseDialog::GetSectorChoice(SectorList *sl)
{
SectorData *sd;
char buff[120];
int i=0;

	SetTitle("Select A Sector");
	lb->Clear();
	while((sd = (SectorData *)sl->NthData(i)) != NULL) {
		sprintf(buff, "(%d %d) %s", sd->GetX(), sd->GetY(), sd->GetDesc());
		lb->Append(buff);
		i++;
	}

	return(GetChoice(i));
}

int 
ChooseDialog::GetChoice(int count)
{
int ret=-1;

	if(0 == count)
		wxMessageBox("No Entries to choose from", "Selection Error",
			wxOK | wxCENTRE | wxICON_EXCLAMATION);
	else {
		lb->SetSelection(0, TRUE);
		if(ShowModal() != wxID_CANCEL) {
			ret = lb->GetSelection();
		}
	}
	return(ret);
}

// =======================================================================
BEGIN_EVENT_TABLE(ViewDialog, wxDialog)
	EVT_BUTTON(wxID_APPLY, ViewDialog::OnApply)
END_EVENT_TABLE()

wxString ht_msg[3] = {
	"None",
	"Area",
	"War"
};

// ------------------------------------------------------------------
ViewDialog::ViewDialog(wxWindow *p) :
	ApplyDialog(p, "Set View Parameters")
{

	names = new wxCheckBox(this, -1, "Show Sector Names");
	routes = new wxCheckBox(this, -1, "Show Sector Routes");
	borders = new wxCheckBox(this, -1, "Show Sector Borders");
//	named = new wxCheckBox(this, -1, "Show Named Sectors");
//	undetailed = new wxCheckBox(this, -1, "Show Undetailed Sectors");
	ht = new wxRadioBox(this, -1, "Hard Times",
		wxPoint(-1, -1),
		wxSize(-1, -1),
		3, ht_msg, 1, wxRA_SPECIFY_ROWS);

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    sizer_1->Add(names, 0, wxALL, DLG_OFFSET / 2);
    sizer_1->Add(routes, 0, wxALL, DLG_OFFSET / 2);
    sizer_1->Add(borders, 0, wxALL, DLG_OFFSET / 2);
    sizer_1->Add(ht, 0, wxALL, DLG_OFFSET / 2);
	DoLayout(wxALL, DLG_OFFSET, sizer_1);
}

ViewDialog::~ViewDialog()
{
}

bool
ViewDialog::GetView(unsigned long f, HARD_TIMES_VIEW htv)
{
bool ret;

	if(f & FLAG_SECT_NAME)
		names->SetValue(TRUE);
	else
		names->SetValue(FALSE);
	if(f & FLAG_SECT_ROUTES)
		routes->SetValue(TRUE);
	else
		routes->SetValue(FALSE);
	if(f & FLAG_SECT_BORDERS)
		borders->SetValue(TRUE);
	else
		borders->SetValue(FALSE);
//	if(f & FLAG_SECT_NAMED)
//		named->SetValue(TRUE);
//	else
//		named->SetValue(FALSE);
//	if(f & FLAG_SECT_UNDETAILED)
//		undetailed->SetValue(TRUE);
//	else
//		undetailed->SetValue(FALSE);

	ht->SetSelection(htv);

	if(ShowModal() != wxID_CANCEL) {
		HandleCallBack();
		ret = TRUE;
	} else {
		// reset to original values
		main_frame_callback(f, htv, 0.0, 0, 0, 0);
		ret = FALSE;
	}

	return(ret);
}

void
ViewDialog::OnApply(wxCommandEvent& event)
{
	HandleCallBack();
}

// kludgy way to handle getting the info back to the application
//  (best I can come up with in light of having an apply button)
void
ViewDialog::HandleCallBack(void)
{
unsigned long f=0l;
HARD_TIMES_VIEW htv;

	if(names->GetValue())
		f |= FLAG_SECT_NAME;
	if(routes->GetValue())
		f |= FLAG_SECT_ROUTES;
	if(borders->GetValue())
		f |= FLAG_SECT_BORDERS;
//	if(named->GetValue())
//		f |= FLAG_SECT_UNDETAILED;
//	if(undetailed->GetValue())
//		f |= FLAG_SECT_UNDETAILED;
	htv = (HARD_TIMES_VIEW)ht->GetSelection();
	main_frame_callback(f, htv, 0.0, 0, 0, 0);
}

// =======================================================================
BEGIN_EVENT_TABLE(View3DDialog, wxDialog)
	EVT_BUTTON(wxID_APPLY, View3DDialog::OnApply)
END_EVENT_TABLE()

// ------------------------------------------------------------------
View3DDialog::View3DDialog(wxWindow *p) :
	ApplyDialog(p, "Set View Parameters")
{
wxStaticText *msg;

	msg = new wxStaticText(this, -1, "Scale:");

	names_3d = new wxCheckBox(this, -1, "Show Star Names");
	detailed = new wxCheckBox(this, -1, "Show Detailed Stars");
	routes_3d = new wxCheckBox(this, -1, "Show Routes");
	color = new wxCheckBox(this, -1, "Color Stellar Type");

	scale = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));

	x = new wxSlider(this, ID_X_SLIDER, 0, 0, 360,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);
	y = new wxSlider(this, ID_Y_SLIDER, 0, 0, 360,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);
	z = new wxSlider(this, ID_Z_SLIDER, 0, 0, 360,
			wxPoint(-1, -1),
			wxSize(-1, SLIDER_HEIGHT), 
			wxVERTICAL | wxSL_LABELS);

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_4 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Rotation"), wxHORIZONTAL);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_3 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Parameters"), wxHORIZONTAL);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_6 = new wxBoxSizer(wxHORIZONTAL);
    sizer_5->Add(names_3d, 0, wxALL, DLG_OFFSET / 2);
    sizer_5->Add(detailed, 0, wxALL, DLG_OFFSET / 2);
    sizer_5->Add(routes_3d, 0, wxALL, DLG_OFFSET / 2);
    sizer_5->Add(color, 0, wxALL, DLG_OFFSET / 2);
    sizer_6->Add(msg, 0, wxALIGN_BOTTOM, 0);
    sizer_6->Add(scale, 0, wxEXPAND, 0);
    sizer_5->Add(sizer_6, 0, wxALL, DLG_OFFSET);
    sizer_3->Add(sizer_5, 1, 0, 0);
    sizer_2->Add(sizer_3, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_1->Add(sizer_2, 0, 0, 0);
    sizer_7->Add(x, 0, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_7->Add(y, 0, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_7->Add(z, 0, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_4->Add(sizer_7, 1, wxEXPAND, 0);
    sizer_1->Add(sizer_4, 1, wxALL | wxEXPAND, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, sizer_1, sizer_2);
}

View3DDialog::~View3DDialog()
{
}

bool
View3DDialog::GetView(unsigned long f, HARD_TIMES_VIEW v,
				float s, int x_, int y_, int z_)
{
bool ret;
char buff[24];

	htv = v;
	if(f & FLAG_SECT_3D_NAME)
		names_3d->SetValue(TRUE);
	else
		names_3d->SetValue(FALSE);
	if(f & FLAG_SECT_3D_DETAILED)
		detailed->SetValue(TRUE);
	else
		detailed->SetValue(FALSE);
	if(f & FLAG_SECT_3D_ROUTES)
		routes_3d->SetValue(TRUE);
	else
		routes_3d->SetValue(FALSE);
	if(f & FLAG_SECT_3D_COLOR)
		color->SetValue(TRUE);
	else
		color->SetValue(FALSE);

	sprintf(buff, "%.2f", s);
	scale->SetValue(buff);

	x->SetValue(x_);
	y->SetValue(y_);
	z->SetValue(z_);

	if(ShowModal() != wxID_CANCEL) {
		HandleCallBack();
		ret = TRUE;
	} else {
		// reset to original values
		main_frame_callback(f, htv, s, x_, y_, z_);
		ret = FALSE;
	}

	return(ret);
}

void
View3DDialog::OnApply(wxCommandEvent& event)
{
	HandleCallBack();
}

void
View3DDialog::HandleCallBack(void)
{
unsigned long f=0l;
float s;
int x_,y_,z_;

	if(names_3d->GetValue())
		f |= FLAG_SECT_3D_NAME;
	if(detailed->GetValue())
		f |= FLAG_SECT_3D_DETAILED;
	if(routes_3d->GetValue())
		f |= FLAG_SECT_3D_ROUTES;
	if(color->GetValue())
		f |= FLAG_SECT_3D_COLOR;
	s = atof(scale->GetValue().GetData());
	x_ = x->GetValue(); 
	y_ = y->GetValue();
	z_ = z->GetValue();
	main_frame_callback(f, htv, s, x_, y_, z_);
}


// =======================================================================
BEGIN_EVENT_TABLE(PrintDialog, wxDialog)
	EVT_BUTTON(SETUP_CB, PrintDialog::OnSetup)
	EVT_CHECKBOX(TOTAL_CB, PrintDialog::OnTotal)
	EVT_CHECKBOX(FILE_CB, PrintDialog::OnFile)
END_EVENT_TABLE()

static bool handler_added=FALSE;

// -----------------------------------------------------------------------
PrintDialog::PrintDialog(wxWindow *p) :
	StdDialog(p, "Print Options")
{
int i;
wxButton *btn;
wxBoxSizer *panel_sizer;

	if(!handler_added) {
#if wxUSE_LIBPNG
		wxImage::AddHandler( new wxPNGHandler );
#endif

#if wxUSE_LIBJPEG
		wxImage::AddHandler( new wxJPEGHandler );
#endif
		wxImage::AddHandler( new wxGIFHandler );
		handler_added = TRUE;
	}

	setup_dialog = NULL;
	g_dlg = NULL;
	msgs[0] = new wxStaticText(this, -1, "Min X:");
	msgs[1] = new wxStaticText(this, -1, "Min Y:");
	msgs[2] = new wxStaticText(this, -1, "Max X:");
	msgs[3] = new wxStaticText(this, -1, "Max Y:");

	for(i = 0;i < 4;i++) 
	 	ranges[i] = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	total = new wxCheckBox(this, TOTAL_CB, "All Sectors");
	file = new wxCheckBox(this, FILE_CB, "Print To File");
	scale = new wxCheckBox(this, -1, "Scale To Single Page");

	btn = new wxButton(this, SETUP_CB, "Setup",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));

	wxBoxSizer* sizer_8 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_11 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_9 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Ranges"), wxHORIZONTAL);
    wxBoxSizer* sizer_10 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(2, 4, DLG_OFFSET, DLG_OFFSET);
    sizer_8->Add(scale, 0, wxALL, DLG_OFFSET);
    sizer_10->Add(total, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msgs[0], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_1->Add(ranges[0], 0, 0, 0);
    grid_sizer_1->Add(msgs[2], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_1->Add(ranges[2], 0, 0, 0);
    grid_sizer_1->Add(msgs[1], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_1->Add(ranges[1], 0, 0, 0);
    grid_sizer_1->Add(msgs[3], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_1->Add(ranges[3], 0, 0, 0);
    sizer_10->Add(grid_sizer_1, 0, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_9->Add(sizer_10, 1, wxEXPAND, 0);
    sizer_8->Add(sizer_9, 0, wxALL, DLG_OFFSET);
    sizer_8->Add(file, 0, wxALL, DLG_OFFSET);

	panel_sizer = GetSizer();
	sizer_11->Add(panel_sizer, 0, wxALL, DLG_OFFSET);

	// XXX here's a hardcode I don't care for....
    sizer_11->Add(30, 20, 0, 0, 0);
    sizer_11->Add(btn, 0, wxALL | wxALIGN_RIGHT, DLG_OFFSET * 2);
    sizer_8->Add(sizer_11, 0, 0, 0);

	// due to the order of sizers creation, we do this crap here
    SetAutoLayout(TRUE);
    SetSizer(sizer_8);
    sizer_8->Fit(this);
    sizer_8->SetSizeHints(this);
    Layout();
}

PrintDialog::~PrintDialog()
{
}

bool 
PrintDialog::DoPrintOut(UListData *sectors, int default_x, int default_y)
{
int width,height;
int start_x,start_y,end_x,end_y;
MTUPrintOut *print_out;
wxPrinter *printer;
SectorList *sl;
char lbuff[20];

	sl = sectors->GetSectors();
	sprintf(lbuff, "%d", sl->GetMinX());
	ranges[0]->SetValue(lbuff);
	sprintf(lbuff, "%d", sl->GetMinY());
	ranges[1]->SetValue(lbuff);
	sprintf(lbuff, "%d", sl->GetMaxX());
	ranges[2]->SetValue(lbuff);
	sprintf(lbuff, "%d", sl->GetMaxY());
	ranges[3]->SetValue(lbuff);

	scale->SetValue(FALSE);
	file->SetValue(FALSE);
	total->SetValue(TRUE);
	CheckControls();

	if(wxID_CANCEL == ShowModal())
		return(FALSE);

	if(total->GetValue()) {
		start_x = sl->GetMinX();
		start_y = sl->GetMinY();
		end_x = sl->GetMaxX();
		end_y = sl->GetMaxY();
	} else {
		start_x = atoi(ranges[0]->GetValue());
		start_y = atoi(ranges[1]->GetValue());
		end_x = atoi(ranges[2]->GetValue());
		end_y = atoi(ranges[3]->GetValue());
	}

	if(file->GetValue()) {
		bool use_scale=TRUE;
		char *ptr,*file,*desc;
		int g_type,o_width,o_height;
		float scale=1.0;
		MTUBitmap *bm;
		wxImage *img;
		wxMemoryDC memDC;
		wxString str;

		if(NULL == g_dlg)
			g_dlg = new GraphicDialog(this);

		g_type = wxBITMAP_TYPE_JPEG;
		o_width = width = default_x * (end_x - start_x + 1) + 10;
		o_height = height = default_y * (end_y - start_y + 1) + 10;
		if(!g_dlg->GetGraphicInfo(&g_type, &use_scale, &width, &height, 
					&scale, &desc))
			return(FALSE);

		str = wxFileSelector("Print To", NULL, NULL, NULL, 
			desc, wxHIDE_READONLY | wxSAVE | wxOVERWRITE_PROMPT, this);
		ptr = (char *)str.GetData();
		if((NULL == ptr) || (0 == ptr[0]))
			return(FALSE);

		wxBeginBusyCursor();
		file = new char[strlen(ptr) + 1];
		strcpy(file, ptr);
		if(use_scale) {
			width = (int) (scale * (float)width);
			height = (int) (scale * (float)height);
		} else {
			float s_w,s_h;

			s_w = (float) width / (float) o_width;
			s_h = (float) height / (float) o_height;
			if(s_w > s_h)		// XXX shouldn't matter
				scale = s_w;
			else
				scale = s_h;
		}
		bm = new MTUBitmap(width, height);
		memDC.SelectObject(*bm);
		memDC.SetUserScale(scale, scale);
		bm->Draw(memDC, start_x, start_y, end_x, end_y);
		img = new wxImage(*bm);
		img->SaveFile(file, g_type);

		delete img;
		delete file;
		delete bm;
		wxEndBusyCursor();
	} else {
		print_out = new MTUPrintOut(start_x, start_y, end_x, end_y,
				&p_data, scale->GetValue());
		printer = new wxPrinter();
		printer->Print(this, print_out, TRUE);

		delete printer;
		delete print_out;
	}

	return(TRUE);
}

// ----------------------------------------------------------------------------
void 
PrintDialog::OnTotal(wxCommandEvent &event)
{
	CheckControls();
}

void 
PrintDialog::OnFile(wxCommandEvent &event)
{
	CheckControls();
}

void 
PrintDialog::OnSetup(wxCommandEvent &event)
{
	if(setup_dialog == NULL)
#ifdef __WXMSW__
		setup_dialog = new wxPrintDialog(this, & p_data);
#else
		setup_dialog = new wxGenericPrintDialog(this, & p_data);
#endif
//	setup_dialog->GetPrintData().SetSetupDialog(TRUE);
	setup_dialog->GetPrintDialogData().SetSetupDialog(TRUE);
	setup_dialog->ShowModal();
}

void
PrintDialog::CheckControls(void)
{
int i;
bool val;

	val = !total->GetValue();
	for(i = 0;i < 4;i++) {
		msgs[i]->Enable(val);
		ranges[i]->Enable(val);
	}
	if(file->GetValue())
		scale->Enable(FALSE);
	else
		scale->Enable(TRUE);
}

// =======================================================================
BEGIN_EVENT_TABLE(Print3DDialog, wxDialog)
	EVT_BUTTON(SETUP_CB, Print3DDialog::OnSetup)
END_EVENT_TABLE()

// -----------------------------------------------------------------------
Print3DDialog::Print3DDialog(wxWindow *p) :
	StdDialog(p, "Print Options")
{
wxButton *btn;

	if(!handler_added) {
#if wxUSE_LIBPNG
		wxImage::AddHandler( new wxPNGHandler );
#endif

#if wxUSE_LIBJPEG
		wxImage::AddHandler( new wxJPEGHandler );
#endif
		wxImage::AddHandler( new wxGIFHandler );
		handler_added = TRUE;
	}

	setup_dialog = NULL;
	g_dlg = NULL;
	file = new wxCheckBox(this, -1, "Print To File");
	btn = new wxButton(this, SETUP_CB, "Setup",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));

	wxBoxSizer* sizer_12 = new wxBoxSizer(wxVERTICAL);
    sizer_12->Add(file, 0, wxALL, 5);
    sizer_12->Add(btn, 0, wxALL, 5);

	DoLayout(wxALL, DLG_OFFSET, sizer_12);
}

Print3DDialog::~Print3DDialog()
{
}

bool 
Print3DDialog::DoPrintOut(UListData *sectors, int default_x, int default_y)
{
int width,height;
MTUPrintOut *print_out;
wxPrinter *printer;
Sector3D *sl;
wxString str;

	file->SetValue(FALSE);

	if(wxID_CANCEL == ShowModal())
		return(FALSE);

	sl = sectors->Get3DSector();

	if(file->GetValue()) {
		bool use_scale=FALSE;
		char *ptr,*file,*desc;
		int g_type,o_width,o_height;
		float scale=1.0;
		MTUBitmap *bm;
		wxImage *img;
		wxMemoryDC memDC;

		if(NULL == g_dlg)
			g_dlg = new GraphicDialog(this);

		g_type = wxBITMAP_TYPE_JPEG;
		o_width = width = default_x;
		o_height = height = default_y;
		if(!g_dlg->GetGraphicInfo(&g_type, &use_scale, &width, &height, 
					&scale, &desc))
			return(FALSE);

		str = wxFileSelector("Print To", NULL, NULL, NULL, 
			desc, wxHIDE_READONLY | wxSAVE | wxOVERWRITE_PROMPT, this);
		ptr = (char *)str.GetData();
		if((NULL == ptr) || (0 == ptr[0]))
			return(FALSE);

		wxBeginBusyCursor();
		file = new char[strlen(ptr) + 1];
		strcpy(file, ptr);
		if(use_scale) {
			width = (int) (scale * (float)width);
			height = (int) (scale * (float)height);
		} else {
			float s_w,s_h;

			s_w = (float) width / (float) o_width;
			s_h = (float) height / (float) o_height;
			if(s_w > s_h)		// XXX shouldn't matter
				scale = s_w;
			else
				scale = s_h;
		}
		bm = new MTUBitmap(width, height);
		memDC.SelectObject(*bm);
		memDC.SetUserScale(scale, scale);
		bm->Draw(memDC);
		img = new wxImage(*bm);
		img->SaveFile(file, g_type);

		delete img;
		delete file;
		delete bm;
		wxEndBusyCursor();
	} else {
		print_out = new MTUPrintOut();
		printer = new wxPrinter();
		printer->Print(this, print_out, TRUE);

		delete printer;
		delete print_out;
	}

	return(TRUE);
}

// ----------------------------------------------------------------------------
void 
Print3DDialog::OnSetup(wxCommandEvent &event)
{
	if(setup_dialog == NULL)
#ifdef __WXMSW__
		setup_dialog = new wxPrintDialog(this, & p_data);
#else
		setup_dialog = new wxGenericPrintDialog(this, & p_data);
#endif
//	setup_dialog->GetPrintData().SetSetupDialog(TRUE);
	setup_dialog->GetPrintDialogData().SetSetupDialog(TRUE);
	setup_dialog->ShowModal();
}

