
/*
 * File:      map.cpp
 * Purpose:	  generate Traveller world maps 
 * Author:	
 * Created:	
 * Updated:	
 * Copyright:	
 */



#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

#define BAD_LAYOUT_CODE

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include <stdlib.h>
#include "map.h"
#include "basesect.h"
#include "t_dlg.h"
#include "t_res.h"

IMPLEMENT_APP(MapApp)

#define BIG_BUFFER_SIZE			120

// button defines
#define ID_TOOLBAR				500
#define TB_CONFIG				600
#define TB_GEN					601
#define TB_SAVE					602
#define TB_PRINT				603
#define TB_EXIT					604

// ---------------------------------------------------------------
#define MAP_FRAME_WIDTH         810
#define MAP_FRAME_HEIGHT        490
#define MAP_PANEL_HEIGHT        80

#ifdef __WXGTK__
#include "bitmaps/config.xpm"
#include "bitmaps/restart.xpm"
#include "bitmaps/print.xpm"
#include "bitmaps/exit.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/critter.xpm"

#include "bitmaps/dir_0.xpm"
#include "bitmaps/dir_1.xpm"
#include "bitmaps/dir_2.xpm"
#include "bitmaps/dir_3.xpm"
#include "bitmaps/dir_4.xpm"
#include "bitmaps/dir_5.xpm"
#endif

// ========================================================================
#define HEX_X_1					0
#define HEX_X_2					0
#define HEX_X_3					11
#define HEX_X_4					22
#define HEX_X_5					22
#define HEX_X_6					11
#define HEX_X_7					5
#define HEX_X_8					5

#define HEX_Y_1					19
#define HEX_Y_2					6
#define HEX_Y_3					0
#define HEX_Y_4					6
#define HEX_Y_5					19
#define HEX_Y_6					25
#define HEX_Y_7					22
#define HEX_Y_8					3

#define HEX_WIDTH				HEX_X_4
#define HEX_HALF_WIDTH			(HEX_WIDTH / 2)
#define HEX_Y_SEGMENT1			HEX_Y_5
#define HEX_Y_SEGMENT2			(HEX_Y_5 - HEX_Y_4)
#define HEX_Y_SEGMENT3			(HEX_Y_4 - HEX_Y_3)
#define HEX_HEIGHT				HEX_Y_6

#define HEX_X_CENTER			HEX_X_6
#define HEX_Y_CENTER			(HEX_Y_6 / 2)

#define MAP_LEFT_X				0
#define MAP_TOP_Y				0
#define MAP_RIGHT_X				(HEX_X_5 * ISO_MAP_MAX_X)
#define MAP_BOTTOM_Y			((10 * (HEX_HEIGHT + HEX_Y_SEGMENT2)) + HEX_Y_SEGMENT1)

#define MAP_SEGMENT				(MAP_RIGHT_X / 10)
#define MAP_SEGMENT_TOP			(MAP_RIGHT_X / 5)
#define MAP_SEGMENT_BOTTOM		(MAP_SEGMENT_TOP / 2)
#define MAP_FOLD				(MAP_BOTTOM_Y / 3)


// handy reference
MapFrame *frame = NULL;
//QuietFrame *qframe = NULL;
wxFont *NormalFont = NULL;

// ===============================================================
bool
MapApp::OnInit(void)
{
//struct conf_struct  cfg;
char config_file[MAX_FILE_LENGTH];
char temp_str[MAX_FILE_LENGTH];
char *cfg_ptr,*temp_ptr;

    // load general resource
    config_file[0] = 0;
    cfg_ptr = NULL;
#if 0
    wxGetResource(SECTION_DATA, ENTRY_DATA_DIR, &cfg_ptr, 
			CART_RESOURCE_FILE);
	if(temp_ptr != NULL)
		{
		sprintf(config_file, cfg_ptr);

		delete cfg_ptr;
		cfg_ptr = NULL;
		wxGetResource(SECTION_DATA, ENTRY_DATA_FILE, &cfg_ptr,
				CART_RESOURCE_FILE);
		if(cfg_ptr != NULL)
			{
			strcat(config_file, cfg_ptr);
			delete cfg_ptr;
			}
		}
#endif
#if 0
	// other init.
	// order/presedence:
	//	1) command line
	//	2) resources
	//	3) program
    // initialize default cfg
    cfg.name = NULL;
	cfg.sect = NULL;
	cfg.ssect = NULL;
	cfg.loc = NULL;
	cfg.uwp = "A0000000";
	cfg.method = EG_FULL;
	cfg.ter = TER_Beach;
	cfg.trav_version = TV_T4;			// default to T4
	cfg.out_file = NULL;
	cfg.die_size = 6;
	cfg.num_die = 1;
	cfg.table_1d6 = new char[strlen(DEFAULT_1D6) + 1];
	sprintf(cfg.table_1d6, DEFAULT_1D6);
	cfg.table_2d6 = new char[strlen(DEFAULT_2D6) + 1];
	sprintf(cfg.table_2d6, DEFAULT_2D6);
	cfg.table_1d20 = new char[strlen(DEFAULT_D20) + 1];
	sprintf(cfg.table_1d20, DEFAULT_D20);
	cfg.quiet_mode = FALSE;
	cfg.no_sleep = FALSE;

#if 0
	// load resources
    wxGetResource(SECTION_ENCOUNTER, ENTRY_METHOD, 
				(int *) &cfg.method, CART_RESOURCE_FILE);
    temp_ptr = NULL;
    if(wxGetResource(SECTION_ENCOUNTER, ENTRY_TRAV_VER, &temp_ptr, 
			CART_RESOURCE_FILE))
		{
		if(strcmp(temp_ptr, "CT") == 0)
			{
			cfg.trav_version = TV_CT;
			cfg.die_size = 6;
			cfg.num_die = 2;
			}
		else if(strcmp(temp_ptr, "MT") == 0)
			{
			cfg.trav_version = TV_MT;
			cfg.die_size = 6;
			cfg.num_die = 2;
			}
		else if(strcmp(temp_ptr, "TNE") == 0)
			{
			cfg.trav_version = TV_TNE;
			cfg.die_size = 20;
			cfg.num_die = 1;
			}
		else if(strcmp(temp_ptr, "T4") == 0)
			{
			cfg.trav_version = TV_T4;
			cfg.die_size = 6;
			cfg.num_die = 2;
			}
		}
    if(temp_ptr != NULL) delete temp_ptr;

    temp_ptr = NULL;
	if(wxGetResource(SECTION_ENCOUNTER, ENTRY_DICE, &temp_ptr, 
			CART_RESOURCE_FILE))
		{
		if(strcmp(temp_ptr, "2D6") == 0)
			{
			cfg.die_size = 6;
			cfg.num_die = 2;
			}
		else if(strcmp(temp_ptr, "1D6") == 0)
			{
			cfg.die_size = 6;
			cfg.num_die = 1;
			}
		else if(strcmp(temp_ptr, "1D20") == 0)
			{
			cfg.die_size = 20;
			cfg.num_die = 1;
			}
		}
    if(temp_ptr != NULL) delete temp_ptr;

    temp_ptr = NULL;
    if(wxGetResource(SECTION_ENCOUNTER, ENTRY_TABLE_1D6, &temp_ptr,
			CART_RESOURCE_FILE))
		{
		if((strspn(temp_ptr, "SHOC") == strlen(temp_ptr)) &&
				(6 == strlen(temp_ptr)))
			{
			delete cfg.table_1d6;

			cfg.table_1d6 = new char[strlen(temp_ptr) + 1];
			strcpy(cfg.table_1d6, temp_ptr);
			}
		}
	if(temp_ptr != NULL) delete temp_ptr;

    temp_ptr = NULL;
    if(wxGetResource(SECTION_ENCOUNTER, ENTRY_TABLE_2D6, &temp_ptr,
			CART_RESOURCE_FILE))
		{
		if((strspn(temp_ptr, "SHOC") == strlen(temp_ptr)) &&
				(11 == strlen(temp_ptr)))
			{
			delete cfg.table_2d6;

			cfg.table_2d6 = new char[strlen(temp_ptr) + 1];
			strcpy(cfg.table_2d6, temp_ptr);
			}
		}
	if(temp_ptr != NULL) delete temp_ptr;

    temp_ptr = NULL;
    if(wxGetResource(SECTION_ENCOUNTER, ENTRY_TABLE_D20, &temp_ptr,
			CART_RESOURCE_FILE))
		{
		if((strspn(temp_ptr, "SHOC") == strlen(temp_ptr)) &&
				(20 == strlen(temp_ptr)))
			{
			delete cfg.table_1d20;

			cfg.table_1d20 = new char[strlen(temp_ptr) + 1];
			strcpy(cfg.table_1d20, temp_ptr);
			}
		}
	if(temp_ptr != NULL) delete temp_ptr;

	// read command line
	ParseCommandLine(&cfg, config_file);
#endif
#endif
	// create fonts
    NormalFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);

//    frame = new MapFrame(&cfg, config_file);
    frame = new MapFrame();
	frame->CreateToolBar(wxNO_BORDER | wxHORIZONTAL | wxTB_DOCKABLE, 
			ID_TOOLBAR);
	frame->InitButtons(frame->GetToolBar());

	frame->Show(TRUE);

	return(TRUE);
}

MapApp::MapApp(void) :
  wxApp()
{
}
#if 0
bool
MapApp::ParseString(char **dest, char *src)
{
    if(*dest != NULL)
	    return(FALSE);
	if(src == NULL)
	    return(TRUE);
	*dest = new char[strlen(src) + 1];
	strcpy(*dest, src);
	return(TRUE);
}

bool
MapApp::CopyString(char *dest, char *src, unsigned int sz)
{
    if(strlen(src) > sz)
	    return(FALSE);
	strcpy(dest, src);
	return(TRUE);
}

void
MapApp::ParseCommandLine(struct conf_struct *cfg, char *cfg_ptr)
{
int i=1,star_count=0;
char *ptr, buff[120], last_arg=0;
char *sect_file=NULL;
sector *sect=NULL;

    buff[0] = 0;
    while(i < argc)
	    {
		if('-' == argv[i][0]) 
		    {
			if(strchr("nSsluFoVItadNq", argv[i][1]) == NULL)
			    {
				fprintf(stderr, "BadOption: %c\n", argv[i][1]);
				fprintf(stderr, "Valid Options:\n"
						" -n <system name>\n"
						" -S <Sector Name>\n"
						" -s <Subsector name>\n"
						" -l <location>\n"
						" -u <world UWP>\n"
						" -F <sector file>\n"
						" -o <output file>\n"
						" -V <Traveller version>\n"
						" These three mutually exlusive:\n"
						" -I <terrain type> (individual roll)\n"
						" -t <terrain type> (individual table)\n"
						" -a (all tables - default)\n"
						" -d <dice format>\n"
						" -T <table format>\n"
						// "-N undocumented: no sleep\n"
						" -q\n");
				exit(-1);
				}

			if(last_arg != 0)
			    {
				ProcessArgs(cfg, last_arg, buff, star_count, &sect_file);
				}

			last_arg = argv[i][1];
			buff[0] = 0;
			if(argv[i][2] != 0)
			    strcat(buff, &argv[i][2]);
			}
		else
		    strcat(buff, argv[i]);
		i++;
		}

	if(last_arg != 0)
	    ProcessArgs(cfg, last_arg, buff, star_count, &sect_file);
	
	if(sect_file != NULL)
	    {
		if(cfg->loc == NULL)
		    {
			fprintf(stderr, "No location.\n");
			exit(-4);
			}
		
		sect = new sector(cfg_ptr);

		if(sect->load_file(sect_file) > 0)
		    {
			int i,j,x,y;
			HexData *hex;

			i = atol(cfg->loc);
			x = i / 100;
			y = i % 100;
			hex = sect->get_hex(x - 1,y - 1);
			if(hex == NULL)
			    {
				fprintf(stderr, "Problem with location %s.\n", cfg->loc);
				exit(-5);
				}
			ParseString(&cfg->name, hex->world->GetName(buff));
			ParseString(&cfg->sect, sect->GetName());
			i = (((x - 1) / 8)) + (((y - 1) / 10) * 4);
			ParseString(&cfg->ssect, sect->GetSSName(i));
			cfg->uwp[0] = hex->world->get_port();
			cfg->uwp[1] = hex->world->get_size();
			cfg->uwp[2] = hex->world->get_atmos();
			cfg->uwp[3] = hex->world->get_hydro();
			cfg->uwp[4] = hex->world->get_pop();
			cfg->uwp[5] = hex->world->get_govt();
			cfg->uwp[6] = hex->world->get_law();
			cfg->uwp[7] = hex->world->get_tech();
			}
		else
		    {
			fprintf(stderr, "Problem with sector file %s\n", sect_file);
			exit(-3);
			}

		delete sect;
		delete sect_file;
		}
}

bool
MapApp::ParseTerrain(TERRAIN_TYPE *t, char *src)
{
EncTerrain ter;
int i;

	for(i = 0;i < MAX_TERRAIN;i++)
		{
		if(strcmp(ter.GetTerrain((TERRAIN_TYPE) i), src) == 0)
			{
			*t = (TERRAIN_TYPE) i;
			return(TRUE);
			}
		}

	return(FALSE);
}

void
MapApp::ProcessArgs(struct conf_struct *cfg, char last_arg, char *buff,
					   int star_count, char **sect_file)
{
bool no_err=TRUE;			
char *ptr=NULL;

    switch(last_arg)
	    {
		case 'n':
		    no_err = ParseString(&cfg->name, buff);
			break;
		case 'S':
		    no_err = ParseString(&cfg->sect, buff);
			break;
		case 's':
		    no_err = ParseString(&cfg->ssect, buff);
			break;
		case 'l':
		    no_err = ParseString(&cfg->loc, buff);
			break;
		case 'u':
		    no_err = CopyString(cfg->uwp, buff, 8);
			break;
		case 'F':
		    no_err = ParseString(sect_file, buff);
			break;
		case 'o':
		    no_err = ParseString(&cfg->out_file, buff);
			break;
		case 'd':
			no_err = ParseString(&ptr, buff);
			if(no_err)
				{
				if(strcmp(ptr, "1D6") == 0)
					{
					cfg->die_size = 6;
					cfg->num_die = 1;
					}
				else if(strcmp(ptr, "2D6") == 0)
					{
					cfg->die_size = 6;
					cfg->num_die = 2;
					}
				else if(strcmp(ptr, "1D20") == 0)
					{
					cfg->die_size = 20;
					cfg->num_die = 1;
					}
				else
					no_err = FALSE;
				}
			if(no_err)
				{
				delete ptr;
				ptr = NULL;
				}
			break;
		case 'V':
			no_err = ParseString(&ptr, buff);
			if(no_err)
				{
				if(strcmp(ptr, "CT") == 0)
					cfg->trav_version = TV_CT;
				else if(strcmp(ptr, "MT") == 0)
					cfg->trav_version = TV_MT;
				else if(strcmp(ptr, "TNE") == 0)
					cfg->trav_version = TV_TNE;
				else if(strcmp(ptr, "T4") == 0)
					cfg->trav_version = TV_T4;
				else
					no_err = FALSE;
				}
			if(no_err)
				{
				delete ptr;
				ptr = NULL;
				}
			break;
		case 'I':
			no_err = ParseTerrain(&cfg->ter, buff);
			cfg->method = EG_SINGLE_ROLL;
			break;
		case 't':
			no_err = ParseTerrain(&cfg->ter, buff);
			cfg->method = EG_SINGLE_TABLE;
			break;
		case 'a':
			cfg->method = EG_FULL;
			break;
		case 'T':
			{
			int l;

			if(6 == cfg->die_size)
				{
				if(1 == cfg->num_die)
					{
					l = 6;
					no_err = ParseString(&cfg->table_1d6, buff);
					ptr = cfg->table_1d6;
					}
				else
					{
					l = 11;
					no_err = ParseString(&cfg->table_2d6, buff);
					ptr = cfg->table_2d6;
					}
				}
			else
				{
				l = 20;
				no_err = ParseString(&cfg->table_1d20, buff);
				ptr = cfg->table_1d20;
				}

			if(no_err)
				{
				if((strspn(ptr, "SHOC") != strlen(ptr)) ||
					(l != (int)strlen(ptr)))
					no_err = FALSE;
				}
			break;
			}
		case 'N':
		    cfg->no_sleep = TRUE;
		    break;
		}
			
	if(!no_err)
	  {
		fprintf(stderr, "Problem with parameter: %c\n", last_arg);
		exit(-2);
	  }
}
#endif
// ===============================================================
#if 0
MapFrame::MapFrame(struct conf_struct *c, char *cfg_ptr,
				int w, int h) :
  wxFrame(NULL, -1, "Generate Animal Encounters", 
  		wxPoint(0, 0), wxSize(w, h))
{
int i;
wxBitmap *bitmaps[15];
wxIcon *map_icon = NULL;

    // copy the cfg struct 
    cfg.name = c->name;
	cfg.sect = c->sect;
	cfg.ssect = c->ssect;
	cfg.loc = c->loc;
	cfg.uwp = "\0\0\0\0\0\0\0\0";
	strcpy(cfg.uwp, c->uwp);
	cfg.method = c->method;
	cfg.ter = c->ter;
	cfg.trav_version = c->trav_version;
	cfg.out_file = c->out_file;
	cfg.die_size = c->die_size;
	cfg.num_die = c->num_die;
	cfg.table_1d6 = c->table_1d6;
	cfg.table_2d6 = c->table_2d6;
	cfg.table_1d20 = c->table_1d20;
	cfg.quiet_mode = c->quiet_mode;
	cfg.no_sleep = c->no_sleep;

	tables = NULL;
	table = NULL;
	enc = NULL;

	// Give it an icon
#ifdef __WXMSW__
	map_icon = new wxIcon("map_icn");
#endif
#ifdef __WXGTK__
	map_icon = new wxIcon(critter_xpm);
#endif
	SetIcon(map_icon);
}

MapFrame::~MapFrame()
{
	CleanUp();
}

void
MapFrame::CleanUp(void)
{
	if(cfg.name != NULL)
	    delete cfg.name;
	if(cfg.sect != NULL)
	    delete cfg.sect;
	if(cfg.ssect != NULL)
	    delete cfg.ssect;
	if(cfg.loc != NULL)
	    delete cfg.loc;
	if(cfg.out_file != NULL)
	    delete cfg.out_file;
	if(cfg.table_1d6 != NULL)
	    delete cfg.table_1d6;
	if(cfg.table_2d6 != NULL)
	    delete cfg.table_2d6;
	if(cfg.table_1d20 != NULL)
	    delete cfg.table_1d20;
	if(tables != NULL)
		delete tables;
	if(table != NULL)
		delete table;
	if(enc != NULL)
		delete enc;
	cfg.name = cfg.sect = cfg.ssect = cfg.loc = cfg.out_file = 
			cfg.table_1d6 = cfg.table_2d6 = cfg.table_1d20 = NULL;
	tables = NULL;
	table = NULL;
	enc = NULL;
}

int
MapFrame::CalcTableCount(void)
{
	// the '3' should represent a larger font for the title (when it works)
	return(3 + (cfg.die_size * cfg.num_die) - (cfg.num_die - 1) + 1);
}
#endif
// ===============================================================
#if 0
static char *state_msgs[] = {
  "Determining star presences and system features.",
  "Editing stars.",
  "Placing known components.",
  "Selecting main world.",
  "System finished." };
#endif
// ===============================================================
BEGIN_EVENT_TABLE(MapFrame, wxFrame)
	EVT_SIZE(MapFrame::MapFrame::OnSize)
	EVT_BUTTON(TB_CONFIG, MapFrame::Configure)
	EVT_BUTTON(TB_GEN, MapFrame::Generate)
	EVT_BUTTON(TB_SAVE, MapFrame::Save)
	EVT_BUTTON(TB_PRINT, MapFrame::Print)
	EVT_BUTTON(TB_EXIT, MapFrame::Exit)
END_EVENT_TABLE()

// ---------------------------------------------------------------
//MapFrame::MapFrame(struct conf_struct *c, char *cfg_ptr) :
//	MapFrame(c, cfg_ptr, MAP_FRAME_WIDTH, MAP_FRAME_HEIGHT)
MapFrame::MapFrame() :
  wxFrame(NULL, -1, "Mapping", 
  		wxPoint(0, 0), wxSize(MAP_FRAME_WIDTH, MAP_FRAME_HEIGHT))
{
int i;
wxBitmap *bitmaps[5];
wxIcon *map_icon = NULL;

	// null out the dialogs (create on the fly)
//	dlg = NULL;
	axis = 0;
	rotation = 0;
	view = MV_PLATES;
#ifdef PLATE_GROW_CODE
	plate_mag = 0;
#endif

	base_map = new IsoMap();
//	plates = new FlatMap();
//	plates->NewBlob(4);
//	plates->NewBlob(2);
//
//	temp code
base_map->SetPlates(8);
base_map->DoPlateCollision();

	dir_bms[0] = new wxBitmap(dir_0_xpm);
	dir_bms[1] = new wxBitmap(dir_1_xpm);
	dir_bms[2] = new wxBitmap(dir_2_xpm);
	dir_bms[3] = new wxBitmap(dir_3_xpm);
	dir_bms[4] = new wxBitmap(dir_4_xpm);
	dir_bms[5] = new wxBitmap(dir_5_xpm);

	// now do the window stuff
	CreateStatusBar(2);

	canvas = new MapCanvas(this);
    canvas->SetScrollbars(4, 4, 300, 1700, 0, 0);
	canvas->SetBackgroundColour(*wxWHITE);

	ViewStatus();
#if 0
	// Give it an icon
#ifdef __WXMSW__
	map_icon = new wxIcon("map_icn");
#endif
#ifdef __WXGTK__
	map_icon = new wxIcon(critter_xpm);
#endif
	SetIcon(map_icon);
#endif
#if 0
	// Set up toolbar
#ifdef __WXMSW__
	bitmaps[0] = new wxBitmap("icon1");
	bitmaps[1] = new wxBitmap("icon2");
	bitmaps[2] = new wxBitmap("icon3");
	bitmaps[3] = new wxBitmap("icon4");
	bitmaps[4] = new wxBitmap("icon5");
#endif
#ifdef __WXGTK__
	bitmaps[0] = new wxBitmap(config_xpm);
	bitmaps[1] = new wxBitmap(restart_xpm);
	bitmaps[2] = new wxBitmap(save_xpm);
	bitmaps[3] = new wxBitmap(print_xpm);
	bitmaps[4] = new wxBitmap(exit_xpm);
#endif
	tool_bar = new MapPanel(this);

	new wxBitmapButton(tool_bar, TB_CONFIG, bitmaps[0],
			wxPoint((DLG_OFFSET * 1) + (SML_BTN_SIZE * 0), DLG_ROW1),
			wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	new wxBitmapButton(tool_bar, TB_GEN, bitmaps[1],
			wxPoint((DLG_OFFSET * 1) + (SML_BTN_SIZE * 1), DLG_ROW1),
			wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	new wxBitmapButton(tool_bar, TB_SAVE, bitmaps[2],
			wxPoint((DLG_OFFSET * 1) + (SML_BTN_SIZE * 2), DLG_ROW1),
			wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	new wxBitmapButton(tool_bar, TB_PRINT, bitmaps[3],
			wxPoint((DLG_OFFSET * 1) + (SML_BTN_SIZE * 3), DLG_ROW1),
			wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	new wxBitmapButton(tool_bar, TB_EXIT, bitmaps[4],
			wxPoint((DLG_OFFSET * 1) + (SML_BTN_SIZE * 4), DLG_ROW1),
			wxSize(SML_BTN_SIZE, SML_BTN_SIZE));

	OnSize(wxSizeEvent(wxSize(-1, -1), -1));

	for(i = 0;i < 5;i++)
		delete bitmaps[i];
#endif
}

#define MAX_BUTTONS		5

static char *long_msgs[] = {
    "Configure Program",
	"Generate New Map",
	"Save Current",
	"Print Current",
	"Exit Program" 
	};

static char *short_msgs[] = {
    "Config",
	"Generate",
	"Save",
	"Print",
	"Exit",
	};

void 
MapFrame::InitButtons(wxToolBar *tb)
{
int i;
int currentX = DLG_OFFSET;
#ifdef __WXMSW__
  int width = 24;
#else
  int width = 16;
#endif
wxBitmap* bm[MAX_BUTTONS];

	// Set up toolbar
	tb->SetMargins(2, 2);

#ifdef __WXMSW__
	bm[0] = new wxBitmap("icon1");
	bm[1] = new wxBitmap("icon2");
	bm[2] = new wxBitmap("icon3");
	bm[3] = new wxBitmap("icon4");
	bm[4] = new wxBitmap("icon5");
#endif
#ifdef __WXGTK__
	bm[0] = new wxBitmap(config_xpm);
	bm[1] = new wxBitmap(restart_xpm);
	bm[2] = new wxBitmap(save_xpm);
	bm[3] = new wxBitmap(print_xpm);
	bm[4] = new wxBitmap(exit_xpm);
#endif

	for(i = 0;i < MAX_BUTTONS;i++) {
		tb->AddTool(TB_CONFIG + i, *(bm[i]), wxNullBitmap, FALSE,
			currentX, -1, NULL, 
			short_msgs[i], long_msgs[i]);
		currentX += width + DLG_OFFSET;
		if((0 == i) || (1 == i))
			tb->AddSeparator();
	}
		
	tb->Realize();

	// Can delete the bitmaps since they're reference counted
	for (i = 0; i < MAX_BUTTONS; i++)
		delete bm[i];
}

MapFrame::~MapFrame()
{
//	CleanUp();
}

void
MapFrame::Configure(wxCommandEvent& event)
{
#if 0
	if(NULL == dlg)
		dlg = new MapDialog(this);

	if(dlg->GetConfig(&cfg))
		canvas->Refresh();
#endif
}

void
MapFrame::Generate(wxCommandEvent& event)
{
#if 0
char *ptr;

	ClearEnc();
	if((1 == cfg.die_size) && (20 == cfg.num_die))
		ptr = cfg.table_1d20;
	else if((1 == cfg.die_size) && (6 == cfg.num_die))
		ptr = cfg.table_2d6;
	else 
		ptr = cfg.table_1d6;

	switch(cfg.method)
		{
		case EG_SINGLE_ROLL:
			{
			int i;
			Dice *dice;

			dice = new Dice(6, 2, 0);
			i = dice->Roll(cfg.die_size, cfg.num_die);
			delete dice;
			
			enc = new AnimalEncounter(cfg.ter, ptr[i],
					cfg.uwp);
			break;
			}
		case EG_SINGLE_TABLE:
			{
			table = new EncounterTable(cfg.ter, cfg.uwp,
							cfg.die_size, cfg.num_die, 
							ptr);
			break;
			}
		case EG_FULL:
			{
			tables = new EncounterTables(cfg.uwp,
							cfg.die_size, cfg.num_die, 
							ptr);
			break;
			}
		}
	canvas->Refresh();
#endif
}

void
MapFrame::Print(wxCommandEvent& event)
{
#if 0
	wxPrinter *printer;
	PrintOut *print_out;
	print_out = new PrintOut(&cfg);

	printer = new wxPrinter();
	printer->Print(this, print_out, TRUE);

	delete printer;
	delete print_out;
#endif
}

void
MapFrame::Save(wxCommandEvent& event)
{
#if 0
char *s;

	if((enc != NULL) || (table != NULL) || (tables != NULL))
		{
		if(cfg.out_file == NULL)
			s = wxFileSelector("Save Encounter", 
				NULL, 
				NULL,
				"*.txt",
				"*.txt",
				wxSAVE | wxOVERWRITE_PROMPT | wxHIDE_READONLY,
				this);
		else
			s = cfg.out_file;

		if(s != NULL)
			{
			FILE *fpx;

			if((fpx = fopen(s, "a+")) != NULL)
				{
				MapDisplay *ed;

				ed = new MapDisplay(fpx);
				if(enc != NULL)
					ed->DrawEnc(enc, &cfg);
				else if(table != NULL)
					ed->DrawTable(table, &cfg);
				else if(tables != NULL)
					ed->DrawTables(tables, &cfg);

				delete ed;
				}
			}
		}
#endif
}

void
MapFrame::Exit(wxCommandEvent& event)
{
	Close(TRUE);
}

// ---------------------------------------------------------------
// drawing code
void
MapFrame::Draw(wxDC *dc)
{
	DrawBaseMap(dc);
}

#define MAX_LINES				16

static int hex_x_array[7] =
	{ HEX_X_6, HEX_X_7, HEX_X_1, HEX_X_2, HEX_X_8, HEX_X_3, HEX_X_6 };

static int hex_y_array[7] =
	{ HEX_Y_6, HEX_Y_7, HEX_Y_1, HEX_Y_2, HEX_Y_8, HEX_Y_3, HEX_Y_6 };

struct LinePairs {
	int x,y;
};

static struct LinePairs start[MAX_LINES] = {
	{ 0,               1 * MAP_FOLD },
	{ 0,               2 * MAP_FOLD },
	{ 0 * MAP_SEGMENT, 0 },
	{ 2 * MAP_SEGMENT, 0 },
	{ 4 * MAP_SEGMENT, 0 },
	{ 6 * MAP_SEGMENT, 0 },
	{ 8 * MAP_SEGMENT, 0 },
	{ 0 * MAP_SEGMENT, 2 * MAP_FOLD },
	{ 4 * MAP_SEGMENT, 0 },
	{ 6 * MAP_SEGMENT, 0 },
	{ 8 * MAP_SEGMENT, 0 },
	{10 * MAP_SEGMENT, 0 },

	{10 * MAP_SEGMENT, 2 * MAP_FOLD },
	{ 2 * MAP_SEGMENT, 0 },
	{ 0,               0 },
	{ MAP_RIGHT_X,     0 }
};

static struct LinePairs end[MAX_LINES] = {
	{ MAP_RIGHT_X,     1 * MAP_FOLD },
	{ MAP_RIGHT_X,     2 * MAP_FOLD },
	{ 3 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 5 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 7 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 9 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{10 * MAP_SEGMENT, 2 * MAP_FOLD },
	{ 1 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 1 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 3 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 5 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 7 * MAP_SEGMENT, MAP_BOTTOM_Y },

	{ 9 * MAP_SEGMENT, MAP_BOTTOM_Y },
	{ 0 * MAP_SEGMENT, 2 * MAP_FOLD },
	{ 0,               2 * MAP_FOLD },
	{ MAP_RIGHT_X,     2 * MAP_FOLD }
};

#define SINE60		.8660

void
MapFrame::DrawBaseMap(wxDC *dc)
{
bool stat;
int i,j,k,f,x,y,plate_no,tmp_x,long_ndx;
MapHex *mh;
TectPlate *tp;
wxPen *p;

	for(f = 0;f < MAX_FACES;f++) {
		for(i = 0;i < MAP_FACE_MAX_X;i++) {
			for(j = 0;j < MAP_FACE_MAX_Y;j++) {
				if((mh = base_map->GetHex(f, i, j)) != NULL) {
					stat = base_map->XlatCoords(f, i, j, axis, 
							rotation, &x, &y);
//fprintf(stderr, "%d (%d %d) a:%d r:%d ---> (%d %d) %d\n", f, i, j, axis, rotation, x, y, stat);
					if(!stat)
						continue;

					switch(view) {
						case MV_BLANK:
							// nothing to do...
							break;
						case MV_PLATES:
							plate_no = mh->GetPlateNo();
							DrawFilledHex(dc, x, y, plate_no);
							if((0 == x) && ((y & 1) == 0))
								DrawFilledHex(dc, x + 35, y, plate_no);
							else {
								if(base_map->CheckPair(x, y, &tmp_x))
									DrawFilledHex(dc, tmp_x, y, plate_no);
							}
							break;
						case MV_ALTITUDE:
							break;
						case MV_HEX:
							break;
						case MV_LONG:
							if(!base_map->XlatCoords(f, i, j, 
											axis, rotation, &x, &y))
								continue;
							if((f & 3) == 0) {
								long_ndx = j + 1;
							} else if((f & 3) == 1) {
								long_ndx = 5 - j + 8;
							} else if((f & 3) == 2) {
								long_ndx = j + 8;
							} else if((f & 3) == 3) {
								long_ndx = 5 - j + 15;
							}
							DrawFilledHex(dc, x, y, long_ndx);
							break;
					}
				}
			}
		}
	}

	for(i = 0;i < MAX_VERTICES;i++) {
		if((mh = base_map->GetHex(VERTEX_FACE_INDEX, i, 
						VERTEX_FACE_INDEX)) != NULL) {
			stat = base_map->XlatCoords(VERTEX_FACE_INDEX, i, 
					VERTEX_FACE_INDEX, axis, rotation, &x, &y);
//fprintf(stderr, "%d (%d %d) a:%d r:%d ---> (%d %d) %d no:%d\n", VERTEX_FACE_INDEX, i, VERTEX_FACE_INDEX, axis, rotation, x, y, stat, mh->GetPlateNo());
			if(!stat)
				continue;

			switch(view) {
				case MV_BLANK:
					// nothing to do...
					break;
				case MV_PLATES:
					plate_no = mh->GetPlateNo();
					DrawFilledVertex(dc, x, y, plate_no);
					break;
				case MV_ALTITUDE:
					break;
				case MV_HEX:
					break;
				case MV_LONG:
					if(!base_map->XlatCoords(VERTEX_FACE_INDEX, i, 
							VERTEX_FACE_INDEX, axis, rotation, &x, &y))
						continue;
					if(N_VERTEX_INDEX == i) 
						long_ndx = 0;
					else if(S_VERTEX_INDEX == i)
						long_ndx = 21;
					else if( i < S_VERTEX_INDEX)
						long_ndx = 7;
					else 
						long_ndx = 14;
					DrawFilledVertex(dc, x, y, long_ndx);
					break;
			}
		}
	}

	// done with 'stuff'
	// draw the hex overlay
	p = wxThePenList->FindOrCreatePen(wxColour(0, 0, 0), 1, wxSOLID);
	dc->SetPen(*p);
	dc->SetBrush(*wxTRANSPARENT_BRUSH);

	for(i = 0;i < ISO_MAP_MAX_X;i++) {
		for(j = 0;j < ISO_MAP_MAX_Y;j++) {
			x = (i * HEX_WIDTH) + HEX_HALF_WIDTH;
			y = j * (HEX_HEIGHT - HEX_Y_SEGMENT3);
			if((j & 1) == 0)
				x += HEX_HALF_WIDTH;

			for(k = 0;k < 5;k++) {
				dc->DrawLine(MAP_LEFT_X + hex_x_array[k] + x, 
							MAP_TOP_Y + hex_y_array[k] + y, 
							MAP_LEFT_X + hex_x_array[k+1] + x, 
							MAP_TOP_Y + hex_y_array[k+1] + y);
			}
		}
	}

	// backfill
	DoBackfill(dc);

	// draw the lines
	p = wxThePenList->FindOrCreatePen(wxColour(0, 0, 0), 1, wxSOLID);
	dc->SetPen(*p);
	for(i = 0; i < MAX_LINES;i++)
		dc->DrawLine(MAP_LEFT_X + HEX_X_CENTER + start[i].x,
					MAP_TOP_Y + HEX_Y_CENTER + start[i].y, 
					MAP_LEFT_X + HEX_X_CENTER + end[i].x,
					MAP_TOP_Y + HEX_Y_CENTER + end[i].y);

	if(MV_PLATES == view) {
		// draw the plate direction bm
		i = 0;
		while((tp = base_map->GetPlate(i)) != NULL) {
			int dir,x1,y1;

			tp->GetCenter(&f, &x, &y);
			dir = tp->GetDirection();
			if(base_map->XlatCoords(f, x, y, axis, rotation, &x1, &y1)) {
				x1 *= HEX_WIDTH;
				if((y1 & 1)) {
					x1 += HEX_HALF_WIDTH;
				} 
				y1 *= (HEX_HEIGHT - HEX_Y_SEGMENT3);
				dir += base_map->GetRotation(f, axis);
				if(dir >= 6)
					dir -= 6;
				dc->DrawBitmap(*dir_bms[dir], 
						MAP_LEFT_X + HEX_X_CENTER + x1 - 8,
						MAP_TOP_Y + HEX_Y_CENTER + y1 - 8,
						TRUE);
			}
			i++;
		}
	}

}

// just a means to make sure poles and the end vertex are 
// drawn multiple times
void 
MapFrame::DrawFilledVertex(wxDC *dc, int x, int y, int ndx)
{
int i;

	if(y < 1) {
		for(i = 0;i < 6;i++)
			DrawFilledHex(dc, i * 7, y, ndx);
	} else if(y > 14) {
		for(i = 0;i < 5;i++)
			DrawFilledHex(dc, 3 + (i * 7), y, ndx);
	} else {
		if((0 == x) && (14 == y))
			DrawFilledHex(dc, 35, y, ndx);
		DrawFilledHex(dc, x, y, ndx);
	}
}

void 
MapFrame::DrawFilledHex(wxDC *dc, int x, int y, int ndx)
{
// yuch
static unsigned char color_array[24][3] = {
	{ 150, 0, 0 },
	{ 0, 150, 0 },
	{ 0, 0, 150 },
	{ 150, 150, 0 },
	{ 150, 0, 150 },
	{ 0, 150, 150 },
	{ 185, 0, 0 },
	{ 0, 185, 0 },
	{ 0, 0, 185 },
	{ 185, 185, 0 },
	{ 185, 0, 185 },
	{ 0, 185, 185 },
	{ 220, 0, 0 },
	{ 0, 220, 0 },
	{ 0, 0, 220 },
	{ 220, 220, 0 },
	{ 220, 0, 220 },
	{ 0, 220, 220 },
	{ 255, 0, 0 },
	{ 0, 255, 0 },
	{ 0, 0, 255 },
	{ 255, 255, 0 },
	{ 255, 0, 255 },
	{ 0, 255, 255 }
};
int x1,y1;
wxPen *p;


	x1 = (x * HEX_WIDTH);
	y1 = y * (HEX_HEIGHT - HEX_Y_SEGMENT3);
	if((y & 1)) {
		x1 += HEX_HALF_WIDTH;
	} 

	if(ndx >= 0) {
		p = wxThePenList->FindOrCreatePen(
				wxColour(color_array[ndx][0],
						color_array[ndx][1],
						color_array[ndx][2]),
						1, wxSOLID);
		dc->SetPen(*p);
		dc->SetBrush(wxBrush(
						wxColour(color_array[ndx][0],
								color_array[ndx][1],
								color_array[ndx][2]),
								wxSOLID));
	} else {
		p = wxThePenList->FindOrCreatePen(wxColour(0, 0, 0), 1, wxSOLID);
		dc->SetPen(*p);
		if(ndx < -1)
			dc->SetBrush(wxBrush(wxColour(255, 255, 255), wxSOLID));
		else
			dc->SetBrush(wxBrush(wxColour(0, 0, 0), wxSOLID));
	}

	// XXX ech! more hardcodes.....
	DrawFilledTriangle(dc,
			MAP_LEFT_X + HEX_X_CENTER + x1,
			MAP_TOP_Y + HEX_Y_CENTER + y1 - 11,
			MAP_LEFT_X + HEX_X_CENTER + x1 - 10,
			MAP_TOP_Y + HEX_Y_CENTER + y1 - 6,
			MAP_LEFT_X + HEX_X_CENTER + x1 + 10,
			MAP_TOP_Y + HEX_Y_CENTER + y1 - 6);

	dc->DrawRectangle(MAP_LEFT_X + HEX_X_CENTER + x1 - HEX_X_3,
					MAP_TOP_Y + HEX_Y_CENTER + y1 - HEX_Y_4,
					HEX_X_5,
					HEX_Y_5 - HEX_Y_2 + 1);


	DrawFilledTriangle(dc,
			MAP_LEFT_X + HEX_X_CENTER + x1,
			MAP_TOP_Y + HEX_Y_CENTER + y1 + 12,
			MAP_LEFT_X + HEX_X_CENTER + x1 + 10,
			MAP_TOP_Y + HEX_Y_CENTER + y1 + 8,
			MAP_LEFT_X + HEX_X_CENTER + x1 - 10,
			MAP_TOP_Y + HEX_Y_CENTER + y1 + 8);
}

void 
MapFrame::DrawFilledTriangle(wxDC *dc, int x1, int y1, int x2, int y2,
					int x3, int y3)
{
int i,j;
int xp[3],yp[3];
int xc,xmax,xmin,yc,ymin,ymax;

	xp[0] = x1;
	yp[0] = y1;
	xp[1] = x2;
	yp[1] = y2;
	xp[2] = x3;
	yp[2] = y3;

//fprintf(stderr, "--->");
//for(i = 0;i < 3;i++)
//fprintf(stderr, "(%d %d) ", xp[i] - (MAP_LEFT_X + HEX_X_CENTER + x1),
//				yp[i] - (MAP_TOP_Y + HEX_Y_CENTER + y1));
//fprintf(stderr, "\n");
	xmin = ymin = INT_MAX;
	xmax = ymax = 0;
	for(i = 0;i < 3;i++) {
		if(xp[i] < xmin)
			xmin = xp[i];
		if(yp[i] < ymin)
			ymin = yp[i];
		if(xp[i] > xmax)
			xmax = xp[i];
		if(yp[i] > ymax)
			ymax = yp[i];
	}
	xc = xmin + ((xmax - xmin) / 2);
	yc = ymin + ((ymax - ymin) / 2);
	xc = xmax - ((xmax - xmin) / 2);
	yc = ymax - ((ymax - ymin) / 2);

//fprintf(stderr, "min(%d %d) max(%d %d) cen(%d %d)\n", 
//		xmin, ymin, xmax, ymax, xc, yc);
	while((xmin <= xc) || (ymin <= yc) || (xmax >= xc) || (ymax >= yc)) {
		for(i = 0;i < 3;i++) {
			j = i - 1;
			if(j < 0)
				j = 2;
			dc->DrawLine(xp[i], yp[i], xp[j], yp[j]);
//fprintf(stderr, "(%d %d) (%d %d) ", 
//	xp[i] - (MAP_LEFT_X + HEX_X_CENTER + x1),
//	yp[i] - (MAP_TOP_Y + HEX_Y_CENTER + y1),
//	xp[j] - (MAP_LEFT_X + HEX_X_CENTER + x1),
//	yp[j] - (MAP_TOP_Y + HEX_Y_CENTER + y1));
		}
//fprintf(stderr, "\n");
		for(i = 0;i < 3;i++) {
			if(xp[i] < xc)
				xp[i]++;
			else if(xp[i] > xc)
				xp[i]--;
			if(yp[i] < yc)
				yp[i]++;
			else if(yp[i] > yc)
				yp[i]--;
		}

		xmin++;
		ymin++;
		xmax--;
		ymax--;
	}
}

void
MapFrame::DoBackfill(wxDC *dc)
{
int x1,y1,i;
wxPen *p;

	// XXX yech, more hardcodes...
	p = wxThePenList->FindOrCreatePen(wxColour(255, 255, 255), 1, 
			wxSOLID);
	dc->SetPen(*p);
	dc->SetBrush(wxBrush(wxColour(255, 255, 255), wxSOLID));
	dc->DrawRectangle(0, 0, HEX_HALF_WIDTH, ISO_MAP_MAX_Y * HEX_Y_7);
	dc->DrawRectangle(HEX_HALF_WIDTH + ISO_MAP_MAX_X * HEX_WIDTH,
					0, HEX_HALF_WIDTH, ISO_MAP_MAX_Y * HEX_Y_7);
	dc->DrawRectangle(0, 0, HEX_HALF_WIDTH + ISO_MAP_MAX_X * HEX_WIDTH,
					HEX_Y_6 / 2);
	dc->DrawRectangle(0, (ISO_MAP_MAX_Y + 1) * (HEX_Y_5 - 1) - 1,
					HEX_HALF_WIDTH + ISO_MAP_MAX_X * HEX_WIDTH,
					HEX_Y_6 / 2);

	for(i = 0;i < 5;i++) {
		x1 = (3 + (i * 7)) * HEX_WIDTH + HEX_WIDTH / 2;
		y1 = 7 * (HEX_HEIGHT - HEX_Y_SEGMENT3);
		DrawFilledTriangle(dc,
					MAP_LEFT_X + HEX_X_CENTER + x1 - 0,
					MAP_TOP_Y + HEX_Y_CENTER + y1,
					MAP_LEFT_X + HEX_X_CENTER + x1 - 77,
					MAP_TOP_Y + HEX_Y_CENTER + y1 - 134,
					MAP_LEFT_X + HEX_X_CENTER + x1 + 77,
					MAP_TOP_Y + HEX_Y_CENTER + y1 - 134);
		x1 = ((i * 7)) * HEX_WIDTH;
		y1 = 14 * (HEX_HEIGHT - HEX_Y_SEGMENT3);
		DrawFilledTriangle(dc,
					MAP_LEFT_X + HEX_X_CENTER + x1 - 0,
					MAP_TOP_Y + HEX_Y_CENTER + y1,
					MAP_LEFT_X + HEX_X_CENTER + x1 - 77,
					MAP_TOP_Y + HEX_Y_CENTER + y1 + 134,
					MAP_LEFT_X + HEX_X_CENTER + x1 + 77,
					MAP_TOP_Y + HEX_Y_CENTER + y1 + 134);
	}
	// extra one...
	x1 = ((i * 7)) * HEX_WIDTH;
	y1 = 14 * (HEX_HEIGHT - HEX_Y_SEGMENT3);
	DrawFilledTriangle(dc,
				MAP_LEFT_X + HEX_X_CENTER + x1 - 0,
				MAP_TOP_Y + HEX_Y_CENTER + y1,
				MAP_LEFT_X + HEX_X_CENTER + x1 - 77,
				MAP_TOP_Y + HEX_Y_CENTER + y1 + 134,
				MAP_LEFT_X + HEX_X_CENTER + x1 + 77,
				MAP_TOP_Y + HEX_Y_CENTER + y1 + 134);
}

#if 0
void
MapFrame::XlatCoords(int b_x, int b_y, int *x, int *y)
{
	*x = b_x;
	*y = b_y;
	// XXX need to do axis
	if(rotation) {
//		if(rotation & 1) {
//			*x += (((rotation / 2) * 7) + 3);
//			if(!(b_y & 1))
//				(*x)++;
//			*y += 7;
//		} else {
			*x += ((rotation) * 7);
//		}
		if(*x < 0)
			*x += (ISO_MAP_MAX_X);
		if(*x >= ISO_MAP_MAX_X)
			*x -= (ISO_MAP_MAX_X);
		if(*y < 0)
			*y += (ISO_MAP_MAX_Y);
		if(*y >= ISO_MAP_MAX_Y)
			*y -= (ISO_MAP_MAX_Y);
	}
}
#endif

void
MapFrame::IncRot(int n_off)
{
	rotation += n_off;
	while(rotation >= MAX_ROTATION)
		rotation -= MAX_ROTATION;
	while(rotation < 0)
		rotation += MAX_ROTATION;
	canvas->Refresh();
	ViewStatus();
}

void
MapFrame::HomeRot(void)
{
	rotation = 0;
	canvas->Refresh();
	ViewStatus();
}

void 
MapFrame::IncAxis(int n)
{
	axis += n;
	while(axis >= MAX_AXIS)
		axis -= MAX_AXIS;
	while(axis < 0)
		axis += MAX_AXIS;
	canvas->Refresh();
	ViewStatus();
}

void
MapFrame::HomeAxis(void)
{
	axis = 0;
	canvas->Refresh();
	ViewStatus();
}

void
MapFrame::IncView(void)
{
	switch(view) {
		case MV_BLANK:
			view = MV_PLATES;
			break;
		case MV_PLATES:
			view = MV_ALTITUDE;
			break;
		case MV_ALTITUDE:
			view = MV_BLANK;
			break;
		case MV_HEX:
			view = MV_BLANK;
			break;
		case MV_LONG:
			view = MV_BLANK;
			break;
	}

	canvas->Refresh();
	ViewStatus();
}

void
MapFrame::DecView(void)
{
	switch(view) {
		case MV_BLANK:
			view = MV_ALTITUDE;
			break;
		case MV_PLATES:
			view = MV_BLANK;
			break;
		case MV_ALTITUDE:
			view = MV_PLATES;
			break;
		case MV_HEX:
			view = MV_BLANK;
			break;
		case MV_LONG:
			view = MV_BLANK;
			break;
	}

	canvas->Refresh();
	ViewStatus();
}

#ifdef PLATE_GROW_CODE
void
MapFrame::ExpandPlate(void)
{
	plate_mag++;
	base_map->ExpandPlates(plate_mag);
	canvas->Refresh();
}
#endif

void
MapFrame::ViewStatus(void)
{
char lbuff[512];

	sprintf(lbuff, "Axis: %d  Rotation: %d  ", axis+1, rotation+1);
	switch(view) {
		case MV_BLANK:
			strcat(lbuff, "Blank");
			break;
		case MV_PLATES:
			strcat(lbuff, "Tectonic Plates");
			break;
		case MV_ALTITUDE:
			strcat(lbuff, "Altitude");
			break;
		case MV_HEX:
			strcat(lbuff, "hex");
			break;
		case MV_LONG:
			strcat(lbuff, "long");
			break;
	}
	SetStatusText(lbuff, 1);
}

#if 0
// plates
#define MAX_PLATES				5
#define RESOLUTION				4
#define MAX_X_					((MAP_RIGHT_X - MAP_LEFT_X) / RESOLUTION)
#define MAX_Y_					((MAP_BOTTOM_Y - MAP_TOP_Y) / RESOLUTION)

static int t[MAX_X_][MAX_Y_];
static bool init=FALSE;
static int plate_size[MAX_PLATES] = { 400, 400, 400, 400, 400 };


void
InitPlates(void)
{
int x, y;
int plate_ndx;
int action = 0;

	for(i = 0;i < MAX_X_;i++)
		for(j = 0;j < MAX_Y_;j++)
			t[i][j] = 0;

	RandomPoint(*x, *y);

	plate_ndx = MAX_PLATES - 1;
	for(i = 0;i < (MAX_PLATES - 1);i++);
		{
		k = plate_size[i];
		while(k > 0)
			{
			switch(action & 7)
				{
				case 0:
					last_x--;
					break;
				case 1:
					last_y--;
					break;
				case 2:
					last_y++;
					break;
				case 3:
					last_x++;
					break;
				case 4:
					last_x--;
					last_y--;
					break;
				case 5:
					last_x--;
					last_y++;
					break;
				case 6:
					last_x++;
					last_y--;
					break;
				case 7:
					last_x++;
					last_y++;
					break;
				}
			action++;
			if(last_x < 0) last_x = MAX_X_ - 1;
			if(last_y < 0) last_y = MAX_Y_ - 1;
			if(last_x > MAX_X_) last_x = 0;
			if(last_y > MAX_Y_) last_y = 0;
			if(t[last_x][last_y] != 0)
				continue;

			t[last_x][last_y] = plate_ndx;
			k--;
			}
		plate_ndx++;
		}

	init = TRUE;
}
#endif
// ---------------------------------------------------------------
void
MapFrame::ClearEnc(void)
{
#if 0
	if(tables != NULL)
		{
		delete tables;
		tables = NULL;
		}
	if(table != NULL)
		{
		delete table;
		table = NULL;
		}
	if(enc != NULL)
		{
		delete enc;
		enc = NULL;
		}
#endif
}
// ---------------------------------------------------------------
// ---------------------------------------------------------------
void
MapFrame::UpdateStatus(void)
{
char buff[BIG_BUFFER_SIZE];

	SetStatusText("");
}

// -------------------------------------------------------------------------
// Reposition the toolbar and child subwindow
void
MapFrame::OnSize(wxSizeEvent& event)
{
int x, y, tb_height;

    if(NULL == tool_bar)
	    {
		wxFrame::OnSize(event);
		return;
		}

	GetClientSize(&x, &y);

	tb_height = (2 * DLG_OFFSET) + SML_BTN_SIZE;

	tool_bar->SetSize(0, 0, x, tb_height);

	canvas->SetSize(0, tb_height, x, y - tb_height);
}

// -------------------------------------------------------------------------
// =================================================================
// ===============================================================
// ===============================================================
BEGIN_EVENT_TABLE(MapCanvas, wxScrolledWindow)
	EVT_KEY_DOWN(MapCanvas::OnKeyDown)
END_EVENT_TABLE()

// -------------------------------------------------------------------------
MapCanvas::MapCanvas(wxWindow *frame,
						   int x, int y, int w, int h,
						   long style) :
    wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
}

void
MapCanvas::OnDraw(wxDC& dc)
{
	if(frame != NULL) {
		dc.Clear();
		frame->Draw(&dc);
	} else
	    dc.Clear();
}

void
MapCanvas::OnKeyDown(wxKeyEvent& event)
{
	switch(event.KeyCode()) {
#ifdef PLATE_GROW_CODE
		case '0':
			frame->ExpandPlate();
			break;
#endif
		case '1':
			frame->IncAxis(-1);
			break;
		case '2':
			frame->HomeAxis();
			break;
		case '3':
			frame->IncAxis(1);
			break;
		case '4':
			frame->DecView();
			break;
		case '5':
			// yuch, 2 redraws....
			frame->HomeAxis();
			frame->HomeRot();
			break;
		case '6':
			frame->IncView();
			break;
		case '7':
			frame->IncRot(-1);
			break;
		case '8':
			frame->HomeRot();
			break;
		case '9':
			frame->IncRot(1);
			break;
		default:
			event.Skip();
			break;
	}
}

// =================================================================
#if 0
static char *btn_msgs[] = {
    "Configure Program",
	"Generate New Encounter(s)",
	"Save Current",
	"Print Current",
	"Exit Program" };
#endif
// =================================================================
MapPanel::MapPanel(wxWindow *frame, int x, int y, int w, int h) :
	wxPanel(frame, -1, wxPoint(x, y), wxSize(w, h))
{
}

MapPanel::~MapPanel()
{
}

// =================================================================
#if 0
MapDisplay::~MapDisplay()
{
}

int 
MapDisplay::DrawMap(AnimalEncounter *ae, conf_struct *cfg,
			char *msg1, char *msg2,
			int start_count, int total_count)
{
int ret=0,count=0;

	Start(msg1);

// pretty sure we don't need a line check here
	ret += DrawHeader(cfg, cfg->ter, FALSE);
	ret += DrawLine(ae, cfg->trav_version);

	Finish(msg2);
	return(ret);
}

int 
MapDisplay::DrawTable(EncounterTable *et, conf_struct *cfg,
			char *msg1, char *msg2,
			int start_count, int total_count)
{
int i;
int ret=0,count=0;

	Start(msg1);

// as w/ the single line, I'm pretty sure the check isn't neccasary
	DrawSingleTable(et, cfg, cfg->ter);

	Finish(msg2);
	return(frame->CalcTableCount());
}

int 
MapDisplay::DrawTables(EncounterTables *et, conf_struct *cfg,
			char *msg1, char *msg2,
			int start_count, int total_count)
{
int i, table_count;
int ret=0,count=0;

	table_count = frame->CalcTableCount();

	Start(msg1);

	for(i = 0;i < MAX_TERRAIN;i++)
		{
		if((count >= start_count) && (ret < total_count))
			{
			DrawSingleTable(et->GetTable((TERRAIN_TYPE) i), cfg, 
						(TERRAIN_TYPE) i);
			ret += table_count;
			}
		count++;
		}

	Finish(msg2);
	return(table_count);
}

int
MapDisplay::DrawSingleTable(EncounterTable *at, conf_struct *cfg, 
		TERRAIN_TYPE t)
{
int i=0,j;
AnimalEncounter *ae;

	DrawHeader(cfg, t);

	j = cfg->num_die;
	while((ae = at->GetEnc(i)) != NULL)
		{
		DrawLine(ae, cfg->trav_version, j);
		i++;
		j++;
		}
	Line(" ");

	return(frame->CalcTableCount());
}


int 
MapDisplay::DrawLine(AnimalEncounter *ae, TRAV_VER v, int die_roll)
{
char buff1[2 * BIG_BUFFER_SIZE];
char buff2[2 * BIG_BUFFER_SIZE];
char buff3[20];

	ae->GetEnc(v, buff1);
	if(die_roll < 0) strcpy(buff2, buff1);
	else 
		{
		sprintf(buff3, "%d", die_roll);
		strfixsize(buff3, 4);
		if(die_roll < 10)
			strrot(buff3, 1, TRUE);
		sprintf(buff2, "%s%s", buff3, buff1);
		}
	Line(buff2);
	return(1);
}

int 
MapDisplay::DrawHeader(conf_struct *cfg, TERRAIN_TYPE t, bool table)
{
MapTerrain ter;
char buff[BIG_BUFFER_SIZE];
char buff1[BIG_BUFFER_SIZE];

	if(table)
		sprintf(buff, "Encounter Table for ");
	else
		sprintf(buff, "Encounter for ");

	if(cfg->name != NULL)
		strcat(buff, cfg->name);
	sprintf(buff1, " (%s), %s Terrain", cfg->uwp, ter.GetTerrain(t));
	strcat(buff, buff1);
	if(cfg->loc != NULL)
		{
		sprintf(buff1, "        %s ", cfg->loc);
		if(cfg->sect != NULL)
			strcat(buff1, cfg->sect);
		strcat(buff, buff1);
		}
	Header1(buff);

	ter.GetEncHeader(cfg->trav_version, buff, table);
	Header2(buff);

	return(2);
}
#endif
// =================================================================
#define LINES_PER_PAGE		90
//PrintOut::PrintOut(conf_struct *c)
PrintOut::PrintOut()
{
#if 0
	cfg = c;
	if((frame->GetTable() != NULL) || (frame->GetEnc() != NULL))
		page_max = 1;
	else
		{
		int i,j;

		i = LINES_PER_PAGE / frame->CalcTableCount();
		page_max = MAX_TERRAIN / i;
		if(MAX_TERRAIN % i)  page_max++;
//fprintf(stderr, "i: %d  count: %d  max1: %d  max2:%d\n", i,
//	frame->CalcTableCount(), MAX_TERRAIN, page_max);
		}
#endif
}

bool
PrintOut::HasPage(int page)
{
#if 0
	if(page <= page_max)
		return(TRUE);
	else
		return(FALSE);
#endif
	return(FALSE);
}

void
PrintOut::GetPageInfo(int *minPage, int *maxPage,
						int *selPageFrom, int *selPageTo)
{
#if 0
	*minPage = *selPageFrom = 1;
	*maxPage = *selPageTo = page_max;
#endif
}

bool 
PrintOut::OnPrintPage(int page)
{
#if 0
wxDC *dc;
bool ret=FALSE;
char buff[80];

	dc = GetDC();
	if((dc) && (page > 0) && (page <= page_max))
		{
		int line_count,temp_count,i,cur_count;
		int w,h,a_h,a_w;
		float scale;
		MapDisplay *ed;
		EncounterTables *tables=NULL;
		EncounterTable *table=NULL;
		AnimalEncounter *enc;

#ifdef __WXGTK__
		wxSetAFMPath("/usr/wxGTK/misc/afm/");
#endif
		// figure out how much there is to work with
		dc->GetSize(&w,&h);
		a_h = h - 55;
		a_w = w - 35;
		
		ed = new MapDisplay(dc, 60, 20);
		sprintf(buff, "Page %d of %d", page, page_max);

		// fairly arbitrary, i would like about 100 lines......
		scale = (float)a_h / (float)(LINES_PER_PAGE * TEXT_Y_INCR);
		line_count = LINES_PER_PAGE - 4;
		dc->SetUserScale(scale, scale);
		cur_count = ((LINES_PER_PAGE / frame->CalcTableCount())) *
						(page - 1);

		// safely(?) assume that ind. rolls and table can fit
		if((enc = frame->GetEnc()) != NULL)
			{
			ed->DrawEnc(enc, cfg, NULL, buff);
			}
		else if((table = frame->GetTable()) != NULL)
			{
			ed->DrawTable(table, cfg, NULL, buff);
			}
		else if((tables = frame->GetTables()) != NULL)
			{
//fprintf(stderr, "page: %d cur:%d  line:%d\n", page, cur_count, line_count);
			ed->DrawTables(tables, cfg, NULL, buff, 
						cur_count, line_count);
			}

		delete ed;
		ret = TRUE;
		}

	return(ret);
#endif
	return(FALSE);
}

