/*
 * File:      	hex.h
 * Purpose:   	hexes and sub-hexes
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-1999 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: hex.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/04/26 20:29:14 $" */



#ifndef HEX_H
#define HEX_H

#ifdef DEBUG_HEX
#include "stdio.h"
#endif

#ifndef TRUE
#define TRUE ((bool) 1)
#endif
#ifndef FALSE
#define FALSE ((bool) 0)
#endif
#ifndef NULL
#define NULL 0
#endif

// ---------------------------------------------------------------------------
typedef enum MAP_OBJECT_TYPE {
	MOT_SUB_HEX=0,
	MOT_MAP_HEX,		// top level hex
	MOT_FACE_EVEN,
	MOT_FACE_ODD,
	MOT_MAP
};

// forward references
class Hex;
class MapHex;
class MapFace;
class IsoMap;

// ---------------------------------------------------------------------------
// lowest level/primative
class MapObject
{
friend class Hex;
friend class MapHex;
friend class MapFace;
friend class IsoMap;
public:
	MapObject(MapObject *p, MAP_OBJECT_TYPE t);
	virtual ~MapObject();

	MapObject *GetParent(void) { return(parent); };
	MAP_OBJECT_TYPE GetType(void) { return(type); };

private:
	MAP_OBJECT_TYPE			type;
	MapObject				*parent;
};

// ---------------------------------------------------------------------------
#define MAX_SUB_HEXES_X		4
#define MAX_SUB_HEXES_Y		5

typedef enum HEX_TYPE {
	HT_WHOLE=0,
	HT_N_VERTEX,
	HT_S_VERTEX,
	HT_N_POLE,
	HT_S_POLE
};

typedef enum GET_HEX_RET {
	GHR_ERR=-1,
	GHR_OK=0,
	GHR_RELATIVE 		// ...or, off current hex
};

// hexagon
class Hex : MapObject
{
friend class MapHex;
public:
	Hex(MapObject *p, HEX_TYPE t, int d);
	// special ctor for MapHex
	Hex(MapObject *p, HEX_TYPE t);
	virtual ~Hex();

	Hex *GetSubHex(int x, int y);

	int GetAltitude(void) { return(altitude); };
	unsigned long GetFeatures(void) { return(features); };
	unsigned long GetUserFeatures(void) { return(user_features); };
	int GetPlateNo(void) { return(plate); };

	void SetAltitude(int a) { altitude = a; };
	void SetPlateNo(int p) { plate = p; };

	void SetFeatures(unsigned long f) { features = f; };
	void SetUserFeatures(unsigned long f) { user_features = f; };

	void AddFeatures(unsigned long f) { features |= f; };
	void AddUserFeatures(unsigned long f) { user_features |= f; };

	HEX_TYPE GetHexType(void) { return(hex_type); };

#ifdef DEBUG_HEX
	void DumpHex(void);
#endif

	GET_HEX_RET GetAdjHex(int n_x, int n_y, int dir, int *x, int *y, int *d);
	GET_HEX_RET GetNewCoord(int n_x, int n_y, int dir, int mag, 
			int *x, int *y, int *d, int *m);

private:
	void CommonInit(HEX_TYPE t, int d);
	bool OffHexCheck(int *x, int *y, int *d);

	int					plate;

	int					depth;
	HEX_TYPE			hex_type;

//	bool				sub_hex;
	// NOTE: (draw it out if you can't visualize it)
	// in general the following hexes are NULL:
	// 	[0][0],[3][0],[0][4],[3][4]
	// for a vertice opening N, the following will also be NULL
	//  [1][0],[2][0],[1][1]
	// for a vertice opening S, the following will also be NULL
	// 	[1][4],[2][4],[1][3]
	// ([2][2] is, of course another vertex.....)
	Hex					*hexes[MAX_SUB_HEXES_X][MAX_SUB_HEXES_Y];

	int					altitude;
	unsigned long		features;
	unsigned long		user_features;
};

// ---------------------------------------------------------------------------
class MapHex : public Hex
{
public:
	MapHex(MapObject *p, HEX_TYPE t);
	~MapHex();

	void SetAdj(int dir, int f, int x, int y);
	bool GetAdj(int dir, int *f, int *x, int *y);

	void SetAlt(int dir, int move, int vel, int adj_move, int adj_vel);

private:
	// XXX move this back to hex?
	// maybe, but it's meaning would be different.....
	int					adj[6][3];
	// average altitude on each face
	int					alt[6];
};


#endif

