
/*
 * File:      uwp.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: uwp.cpp,v $ $Revision: 1.4 $ $Author: man $ $Date: 2003/05/17 02:45:12 $" */

#include <stdio.h>
#include <string.h>
#include "uwp.h"

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

// =======================================================================
// should be 'X'
#define DEFAULT_PORT		-1
							//0123456789
char *port_digit::port_str = "ABCDEFGHXY";

port_digit::port_digit()
{
	val = DEFAULT_PORT;
	allow_spaceport = 0;
}

port_digit::port_digit(port_digit *p)
{
	val = p->get_port_val();
	allow_spaceport = p->AllowSpaceport();
}

port_digit::port_digit(short s, short flag)
{
	allow_spaceport = flag;
	set_port_val(s);
}

port_digit::port_digit(char c, short flag)
{
	allow_spaceport = flag;
	set_port(c);
}

port_digit::~port_digit()
{
}

void
port_digit::set_port(char c)
{
short s;

	s = xlat_digit(c);
	set_port_val(s);
}

void
port_digit::set_port_val(short s)
{
	if(s < 0) {
		val = DEFAULT_PORT;
		return;
	}
	
	s = check_spaceport(s);

	val = s;
}

short
port_digit::check_spaceport(short s)
{
	if((s > (int)strlen(port_str)) || (s < -1))
		s = (int)strlen(port_str);

	if(allow_spaceport)
		return(s);

	if(s == 9)
		return(8);
	if(s == 7)
		return(4);
	if(s == 6)
		return(3);
//	if(s == 5)
		return(1);
}

short
port_digit::xlat_digit(char c)
{
int i;

	for(i = 0;i < (int)strlen(port_str);i++)
		if(c == port_str[i])
			return(i);

	return(DEFAULT_PORT);
}

int
port_digit::is_spaceport(void)
{
	if((val == 5) || (val == 6) || (val == 7) || (val == 9))
		return(1);
	else 
		return(0);
}
// -------------------------------------------------------------------------
char *port_desc::quality[10] = { 
	"Excellent",
	"Good",
	"Routine",
	"Poor",
	"Frontier",
	"No",
	"Good",
	"Poor",
	"Primitive",
	"No" 
};

char *port_desc::yards[10] = { 
	"Starships",
	"Spaceships",
	"No",
	"No",
	"No",
	"No",
	"No",
	"No",
	"No",
	"No" 
};

char *port_desc::repair[10] = { 
	"Overhaul",
	"Overhaul",
	"Major Damage",
	"Minor Damage",
	"No",
	"No",
	"Minor Damage",
	"Superficial",
	"No",
	"No" 
};

char *port_desc::fuel[10] = { 
	"Refined",
	"Refined",
	"Unrefined",
	"Unrefined",
	"No",
	"No",
	"Unrefined",
	"Unrefined",
	"No",
	"No" 
};

port_desc::port_desc(short s, short flag) :
	port_digit(s, flag)
{
}

port_desc::port_desc(char c, short flag) :
	port_digit(c, flag)
{
}

port_desc::~port_desc()
{
}

char *
port_desc::get_full_desc(char *buff)
{
    if(val < 0)
	    sprintf(buff, " No port");
	else {
		char *ptr;
		
		if(is_spaceport())
		    ptr = "spaceport";
		else
		    ptr = "starport";
		
		sprintf(buff,
		 "Class %c %s; %s quality, %s construction, %s repair, %s fuel",
		        get_port(), ptr, get_quality(), get_yards(),
				get_repair(), get_fuel());
	}
	
	return(buff);
};

// =======================================================================
// mechanism to handle no, low, mod, high, extreme characteristics
uwp_digit::uwp_digit() :
    t_hex()
{
int i;

	for(i = 0;i < MAX_INDEX;i++)
		ndx_vals[i] = -1;
}

uwp_digit::uwp_digit(uwp_digit *u) :
		t_hex(u)
{
int i;

	for(i = 0;i < MAX_INDEX;i++)
		ndx_vals[i] = u->GetNdx(i);
}

uwp_digit::uwp_digit(short s, T_HEX_TYPE t, short a, short b, short c,
					 short d, short e, short f, short g) :
	t_hex(s, t)
{
	construct_index(a, b, c, d, e);
}
uwp_digit::uwp_digit(char ch, T_HEX_TYPE t, short a, short b, short c,
					 short d, short e, short f, short g) :
	t_hex(ch, t)
{
	construct_index(a, b, c, d, e);
}
uwp_digit::~uwp_digit() 
{
}

void 
uwp_digit::construct_index(short a, short b, short c, short d, short e)
{
	ndx_vals[0] = a;
	ndx_vals[1] = b;
	ndx_vals[2] = c;
	ndx_vals[3] = d;
	ndx_vals[4] = e;
}

short 
uwp_digit::get_index(void)
{
int i;

	for(i = 0;i < MAX_INDEX;i++) {
		if(get_t_hex_val() <= ndx_vals[i])
			return(i);
	}
	return(0);
}

// =========================================================================
char *uwp_soc_digit::simple[5] = { 
	"No",
	"Low",
	"Mod",
	"High",
	"Extreme" 
};

uwp_soc_digit::uwp_soc_digit(short s, T_HEX_TYPE t, short a, short b,
							 short c, short d, short e, short f, short g) :
	uwp_digit(s, t, a, b, c, d, e, f, g)
{
}
uwp_soc_digit::uwp_soc_digit(char ch, T_HEX_TYPE t, short a, short b,
							 short c, short d, short e, short f, short g) :
	uwp_digit(ch, t, a, b, c, d, e, f, g)
{
}

uwp_soc_digit::~uwp_soc_digit()
{
}

int
uwp_soc_digit::str_valid(char *buff)
{
    if(get_t_hex_val() < 0) {
		sprintf(buff, "   None");
		return(0);
	}

	return(1);
}

// ==========================================================================
char *size_desc::simple[6] = { 
	"Planetoid Belt",											// 0
	"Very Small",												// 1
	"Small",													// 2
	"Medium",													// 3
	"Large",													// 4
	"Gas Giant" 											// 5
};

char *size_desc::desc[15] = { 
	"Astroid/Planetoid Belt; Multiple bodies under 200Km",	// 0: 0=>0
	"Small (1600Km); 800Km to 2399Km",						// 1: 1=>2
	"Small (4800Km); 2400Km to 3999Km",						// 2: 1=>2
	"Small (3200Km); 4000Km to 5599Km",						// 3: 1=>2
	"Medium (6400Km); 5600Km to 7199Km",						// 4: 2=>3
	"Medium (8000Km); 7200Km to 8799Km",						// 5: 2=>3
	"Medium (9600Km); 8800Km to 10399Km",						// 6: 2=>3
	"Medium (11200Km); 10400Km to 11999Km",					// 7: 2=>3
	"Large (12800Km); 12000Km to 13599Km",					// 8: 3=>4
	"Large (14400Km); 13600Km to 15199Km",					// 9: 3=>4
	"Large (16000Km); 15200Km to 16799Km",					// A: 3=>4
	"Very Small (400Km); 200Km to 799Km",						// S: 4=>1
	"Planetoid Ring; Multiple bodies under 1Km",				// R: 5=>0
// not sure how to handle these yet:
	"Small Gas Giant",										//  : 6=>5
	"Large Gas Giant"										//  : 6=>5
};

// NOTE NOTE NOTE
// this has unusual(ly bad) behavior:
//	if created w/ a code (ie. a letter/char), it will not allow GG's
//	if created w/ a number/value, it will allow GG's
size_desc::size_desc(short s) :
	uwp_digit(s, T_HEX_SIZE_GG, 0, 3, 7, 10, 11, 12, 14)
{
}
size_desc::size_desc(char c) :
	uwp_digit(c, T_HEX_SIZE, 0, 3, 7, 10, 11, 12, 14)
{
}

size_desc::~size_desc()
{
}

short 
size_desc::get_true_index(void)
{
short i;

	switch(get_index()) {
		default:
		case 5:
		case 0:
			i = 0;
			break;
		case 1:
			i = 2;
			break;
		case 2:
			i = 3;
			break;
		case 3:
			i = 4;
			break;
		case 4:
			i = 1;
			break;
		case 6:
			i = 5;
			break;
	}

	return(i);
}

void 
size_desc::get_short_desc(char * buff)
{
int i;

	i = get_true_index();

	if(i > 4)
		sprintf(buff, "Size: %s", simple[i]);
	else
		sprintf(buff, "Size: %c; %s", get_t_hex(), simple[i]);
}
char *
size_desc::get_full_desc(char * buff)
{
	if(get_t_hex_val() > 12)
		sprintf(buff, "%s", desc[get_t_hex_val()]);
	else
		sprintf(buff, "%c; %s", get_t_hex(), desc[get_t_hex_val()]);

	return(buff);
}

float 
size_desc::get_radius_km(void)
{
float ret=0.0;

    switch(get_t_hex_val()) {
		case 0:
		    ret = 100.0;
			break;
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
		case 10:
		    ret = get_t_hex_val() * 800.0;
			break;
		case 11:
		    ret = 200.0;
			break;
		case 12:
		    ret = 0.5;
			break;
		case 13:
		    ret = 7200.0;
			break;
		case 14:
		    ret = 8000.0;
			break;
	}

    return(ret);
}
int
size_desc::is_gg(void)
{
    if((get_t_hex_val() == SIZE_SMALL_GG) ||
	   (get_t_hex_val() == SIZE_LARGE_GG))
	    return(1);
	else
	    return(0);
}

// =========================================================================
char *atmos_desc::simple[5] = { 
	"Vacuum",
	"Thin",
	"Standard",
	"Dense",
	"Exotic" 
};

char *atmos_desc::desc[16] = { 
	"Vacuum",
	"Trace",
	"Very Thin",
	"Very Thin",
	"Thin",
	"Thin",
	"Standard",
	"Standard",
	"Dense",
	"Dense",
	"Exotic",
	"Corrosive",
	"Insidious",
	"Dense, High",
	"Ellipsoid",
	"Thin, Low" 
};

atmos_desc::atmos_desc(short s) :
	uwp_digit(s, T_HEX_HEX, 3, 5, 7, 9, 15)
{
}

atmos_desc::atmos_desc(char c) :
	uwp_digit(c, T_HEX_HEX, 3, 5, 7, 9, 15)
{
}

atmos_desc::~atmos_desc()
{
}

void 
atmos_desc::get_short_desc(char *buff)
{
	sprintf(buff, "%c; %s", get_t_hex(), simple[get_index()]);
}

char *
atmos_desc::get_full_desc(char *buff)
{
	sprintf(buff, "%c; %s", get_t_hex(), desc[get_t_hex_val()]);
	if(is_tainted())
		strcat(buff, ", Tainted");

	return(buff);
}

int 
atmos_desc::is_tainted(void)
{
	switch(get_t_hex()) {
		case 2:
		case 4:
		case 7:
		case 9:
			return(1);
		default:
			return(0);
	}
}

// ==========================================================================
char *hydro_desc::simple[4] = { 
	"Desert",
	"Dry",
	"Wet",
	"Water"
};

hydro_desc::hydro_desc(short s) :
	uwp_digit(s, T_HEX_TEN, 0, 3, 8, 10)
{
}

hydro_desc::hydro_desc(char c) :
	uwp_digit(c, T_HEX_TEN, 0, 3, 8, 10)
{
}

hydro_desc::~hydro_desc()
{
}

void 
hydro_desc::get_short_desc(char *buff)
{
	sprintf(buff, "%c; %s World", get_t_hex(), simple[get_index()]);
}

char *
hydro_desc::get_full_desc(char *buff)
{
	sprintf(buff, "%c; %s World(%d0%%)", get_t_hex(), simple[get_index()],
			get_t_hex_val());

	return(buff);
}

// ===========================================================================
char *pop_desc::desc[11] = { 
	"less than 10",
	"tens",
	"hundreds",
	"thousands",
	"ten thousands",
	"hundred thousands",
	"millions",
	"ten millions",
	"hundred millions",
	"billions",
	"ten billions"
};

pop_desc::pop_desc(short s) :
    uwp_soc_digit(s, T_HEX_TEN, 3, 8, 10)
{
}

pop_desc::pop_desc(char c) :
    uwp_soc_digit(c, T_HEX_TEN, 3, 8, 10)
{
}

pop_desc::~pop_desc()
{
}

void 
pop_desc::get_short_desc(char *buff)
{
    if(str_valid(buff))
  	    sprintf(buff, "%c; %s", get_t_hex(), simple[get_index() + 1]);
}

char *
pop_desc::get_full_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s(%s)", get_t_hex(), simple[get_index() + 1],
			desc[get_t_hex_val()]);

	return(buff);
}

// ===========================================================================
char *govt_desc::simple[16] = { 
	"No Government Structure",
	"Company/Corporation",
	"Particpating Democracy",
	"Self-Perpetuating Democracy",
	"Representative Democracy",
	"Feudal Technocracy",
	"Captive Government",
	"Balkanization",
	"Civil Service Bureaucracy",
	"Impersonal Bureaucracy",
	"Charismatic Dictator",
	"Non-Charismatic Dictator",
	"Charismatic Oligarchy",
	"Religious Dictatorship",
	"Religious Autocracy",
	"Totalitarian Oligarchy" };

char *govt_desc::desc[16] = { 
	"No Government Structure",
	"Company/Corporation",
	"Particpating Democracy",
	"Self-Perpetuating Democracy",
	"Representative Democracy",
	"Feudal Technocracy",
	"Captive Government",
	"Balkanization",
	"Civil Service Bureaucracy",
	"Impersonal Bureaucracy",
	"Charismatic Dictator",
	"Non-Charismatic Dictator",
	"Charismatic Oligarchy",
	"Religious Dictatorship",
	"Religious Autocracy",
	"Totalitarian Oligarchy" 
};

govt_desc::govt_desc(short s) :
    uwp_soc_digit(s, T_HEX_HEX, 3, 8, 10)
{
}

govt_desc::govt_desc(char c) :
    uwp_soc_digit(c, T_HEX_HEX, 3, 8, 10)
{
}

govt_desc::~govt_desc()
{
}

void 
govt_desc::get_short_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s", get_t_hex(), simple[get_t_hex_val()]);
}

char *
govt_desc::get_full_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s, %s", get_t_hex(), simple[get_t_hex_val()],
			desc[get_t_hex_val()]);

	return(buff);
}

// =====================================================================
char *law_desc::desc[22] = { 
	"No Prohibitions",
	"Body Pitols, Explosives, Poison Gas Prohibited",
	"Portable Energy Weapons Prohibited",
	"Machineguns, Automatic Rifles Prohibited",
	"Light Assault Weapons Prohibited",
	"Personal Concealable Weapons Prohibited",
	"All Firearems Except Shotguns Prohibited",
	"Shotguns Prohibited",
	"Blade Weapons Controlled; No Open Display",
	"Weapon Possesion Outside the Home Prohibited",
	"Weapon Possesion Prohibited",
	"Rigid Control of Civilian Movement",
	"Unrestricted Invasion of Privacy",
	"Paramilitary Law Enforcement",
	"Full-Fledged Police State",
	"All Facets of Daily Life Rigidly COntrolled",
	"Severe Punishment for Petty Infractions",
	"Legalized Oppressive Practices",
	"Routinely Oppressive and Restrictive",
	"Excessively Oppressive and Restrictive",
	"Totally Oppressive and Restrictive" 
};

law_desc::law_desc(short s) :
    uwp_soc_digit(s, T_HEX_21, 0, 3, 7, 9, 22)
{
}

law_desc::law_desc(char c) :
    uwp_soc_digit(c, T_HEX_21, 0, 3, 7, 9, 22)
{
}

law_desc::~law_desc()
{
}

void 
law_desc::get_short_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s Law", get_t_hex(), simple[get_index()]);
}

char *
law_desc::get_full_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s(%s)", get_t_hex(), desc[get_t_hex_val()],
			simple[get_index()]);

	return(buff);
}

// =========================================================================
char *tech_desc::simple[7] = { 
	"Pre-Industrial",
	"Industrial",
	"Pre-Stellar",
	"Early Stellar",
	"Average Stellar",
	"High Stellar",
	"Extreme Stellar"
};

char *tech_desc::desc[22] = { 
	"Primitve",
	"Bronze, Iron",
	"Printing Press",
	"Internal Combustion",
	"Mass Production",
	"Nuclear Power",
	"Miniture Electronics",
	"Superconductors",
	"Fusion Power",
	"Jump Drive",
	"Large Jump Drive",
	"Sophisticated Robots",
	"Holo Data Storage",
	"Antigrav Cities",
	"Anagathics",
	"Global Terraforming",
	"X",
	"X",
	"X",
	"X"
};

char *tech_desc::era[22] = { 
	"Stone Age",
	"Middle Ages",
	"circa 1600",
	"circa 1800",
	"circa 1900",
	"circa 1930",
	"circa 1950",
	"circa 1970",
	"circa 1990",
	"circa 2010",
	"circa 2100",
	"X",
	"X",
	"The Imperium",
	"X",
	"X",
	"X",
	"X",
	"X",
	"X",
	"The Ancients" 
};

tech_desc::tech_desc(short s) :
    uwp_soc_digit(s, T_HEX_21, 3, 5, 8, 10, 13, 16, 22)
{
}

tech_desc::tech_desc(char c) :
    uwp_soc_digit(c, T_HEX_21, 3, 5, 8, 10, 13, 16, 22)
{
}

tech_desc::~tech_desc()
{
}

void 
tech_desc::get_short_desc(char *buff)
{
    if(str_valid(buff))
	    sprintf(buff, "%c; %s", get_t_hex(), simple[get_index()]);
}

char *
tech_desc::get_full_desc(char *buff)
{
    if(str_valid(buff)) {
	    get_short_desc(buff);
		if(desc[get_t_hex_val()][0] != 'X') {
			strcat(buff, "(");
			strcat(buff, desc[get_t_hex_val()]);
			strcat(buff, ")");
		}
		if(era[get_t_hex_val()][0] != 'X') {
			strcat(buff, ", ");
			strcat(buff, era[get_t_hex_val()]);
		}
	}

	return(buff);
}

// =======================================================================
uwp::uwp()
{
	port = NULL;
	size = NULL;
	atmos = NULL;
	hydro = NULL;
	pop = NULL;
	govt = NULL;
	law = NULL;
	tech = NULL;
}

uwp::uwp(uwp *u)
{
    port = new port_desc(u->get_port());
	size = new size_desc(u->get_size());
	atmos = new atmos_desc(u->get_atmos());
	hydro = new hydro_desc(u->get_hydro());
	pop = new pop_desc(u->get_pop());
	govt = new govt_desc(u->get_govt());
	law = new law_desc(u->get_law());
    tech = new tech_desc(u->get_tech());
}

// NOTE NOTE NOTE
//  this only will handle planets (not stars)
uwp::uwp(char *str)
{
int i;

	if(strchr("ABCDEFGHXY", str[0]) == NULL) {		// gg?
		if(strchr(str, 'm'))						// small?
			size = new size_desc((short) 13);
		else
			size = new size_desc((short) 14);
		port = new port_desc(' ');
		atmos = new atmos_desc(' ');
		hydro = new hydro_desc(' ');
		pop = new pop_desc(' ');
		govt = new govt_desc(' ');
		law = new law_desc(' ');
		tech = new tech_desc(' ');
	} else {
		i = 0;
		port = new port_desc(str[i++]);
		if(str[i] == '-')
			i++;
		if(str[i] == 'S') {
		    size = new size_desc((short)SIZE_SMALL);
			i++;
		} else if(str[i] == 'R') {
			size = new size_desc((short)SIZE_RING);
			i++;
		} else
		    size = new size_desc(str[i++]);
		atmos = new atmos_desc(str[i++]);
		hydro = new hydro_desc(str[i++]);
		if((str[i] != ' ') && (str[i] != 0)) {
			pop = new pop_desc(str[i++]);
			govt = new govt_desc(str[i++]);
			law = new law_desc(str[i++]);
			if(str[i] == '-')
				i++;
			tech = new tech_desc(str[i++]);
		} else {
			pop = new pop_desc(' ');
			govt = new govt_desc(' ');
			law = new law_desc(' ');
			tech = new tech_desc(' ');
		}
	}
}

uwp::~uwp()
{
	if(port != NULL);
		delete port;
	if(size != NULL);
		delete size;
	if(atmos != NULL);
		delete atmos;
	if(hydro != NULL);
		delete hydro;
	if(pop != NULL);
		delete pop;
	if(govt != NULL);
		delete govt;
	if(law != NULL);
		delete law;
	if(tech != NULL);
		delete tech;
}

int 
uwp::is_gg(void)
{
    return(size->is_gg());
}

char 
uwp::get_port(void)
{
    return(port->get_port());
}

short 
uwp::get_port_val(void)
{
    return(port->get_port_val());
}

void 
uwp::GetUWPStr(char *buff)
{
	if(is_gg()) {
		if(size->get_t_hex_val() == 13)
			sprintf(buff, " SGG     ");
		else
			sprintf(buff, " LGG     ");
	} else
		sprintf(buff, "%c-%c%c%c%c%c%c%c", port->get_port(),
			get_uwp_char(size), get_uwp_char(atmos), get_uwp_char(hydro),
			get_uwp_char(pop), get_uwp_char(govt), get_uwp_char(law), 
			get_uwp_char(tech));
}

void 
uwp::get_full_uwp_str(char *buff)
{
char l_buff[80];

	buff[0] = 0;

	port->get_full_desc(l_buff);
	strcat(buff, l_buff);

	get_full_uwp_desc(size, buff);
	get_full_uwp_desc(atmos, buff);
	get_full_uwp_desc(hydro, buff);
	get_full_uwp_desc(pop, buff);
	get_full_uwp_desc(govt, buff);
	get_full_uwp_desc(law, buff);
	get_full_uwp_desc(tech, buff);
}

void 
uwp::get_full_uwp_desc(uwp_digit *src, char *buff)
{
char l_buff[80];

	if(src != NULL) {
		src->get_full_desc(l_buff);
		strcat(buff, l_buff);
	}
}

char 
uwp::get_uwp_char(uwp_digit *src)
{
    return(src->get_t_hex());
}

short 
uwp::get_uwp_val(uwp_digit *src)
{
    return(src->get_t_hex_val());
}

bool 
uwp::SetPort(char c)
{
	port->set_port(c);
	return(TRUE);
}

bool 
uwp::SetSize(char c)
{
	size->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetAtmos(char c)
{
	atmos->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetHydro(char c)
{
	hydro->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetPop(char c)
{
	pop->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetGovt(char c)
{
	govt->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetLaw(char c)
{
	law->set_t_hex(c);
	return(TRUE);
}

bool 
uwp::SetTech(char c)
{
	tech->set_t_hex(c);
	return(TRUE);
}


