// File:        tech_gen.cpp
// Purpose:     methods for generating technology
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: tech_gen.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/11/02 01:20:27 $"

#include "tech_gen.h"

GenTech::GenTech(TECH_GEN tg, int n, int x)
{
	method = tg;
	min = n;
	max = x;
	dice = new Dice();
//fprintf(stderr, "GenTech(%d, %d, %d)\n", tg, n, x);
}

GenTech::~GenTech()
{
	delete dice;
}

char
GenTech::Generate(char *uwp, int ext_dm, bool mw)
{
int roll,dm;
char ret;

	dm = ext_dm;
	if(TG_NO_DM == method) dm = 0;
	if(TG_VALUE == method) {
		roll = min;
	} else {
    	if(mw) {
			if(TG_FLAT_RANGE == method) {
				roll = min + dice->Roll((max - min + 1), 1) - 1;
			} else if(TG_RANGE == method) {
				int i;

				i = ((max - min + 2) / 2);
				roll = dice->Roll(i, 2);
			} else {
				roll = dice->Roll(6, 1);
			}
			if('A' == uwp[0]) roll += 6;
			if('B' == uwp[0]) roll += 4;
			if('C' == uwp[0]) roll += 2;
			if('X' == uwp[0]) roll -= 3;
			if(('S' == uwp[1]) || (uwp[1] < '3')) roll += 2;
			else if(uwp[1] < '4') roll++;
			if((uwp[2] < '4') || (uwp[2] > '9')) roll++;
			if(uwp[3] == '9') roll++;
			else if(uwp[3] > '9') roll += 2;
			if(uwp[4] < '6') roll++;
			else if('9' == uwp[4]) roll += 2;
			else if(uwp[4] > '9') roll += 4;
			if(('0' == uwp[5]) || ('5' == uwp[5])) roll++;
			if('D' == uwp[5]) roll -= 2;
		} else {
			if(uwp[7] > '9') roll = uwp[7] - 'A' + 10 - 1;
			else roll = uwp[7] - '0' - 1;
			roll += dm;
		}
	}

	if(TG_DM == method) roll += min;
	if(TG_MIN_MAX == method) {
		if(roll < min) roll = min;
		if(roll > max) roll = max;
	}

	// convert to a traveller code
	if(roll < 0) ret = '0';
	else if(roll < 10) ret = roll + '0';
	else ret = roll - 10 + 'A';

    return(ret);
}

