
/*
 * File:    t_word.cpp
 * Purpose:	traveller word generator
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_word.cpp,v $ $Revision: 1.5 $ $Author: man $ $Date: 2000/10/11 02:44:17 $" */

#include <stdio.h>
#define __USE_GNU
#include <string.h>
#include <ctype.h>
#include "str_util.h"
#include "t_word.h"

#define BIG_BUFFER_SIZE  180

WordGen::WordGen(WordCase c)
{
    Init(c);
}

WordGen::WordGen(char *config_file, WordCase c)
{
    Init(c);
	valid = LoadFile(config_file);
}

WordGen::~WordGen()
{
    if(name != NULL)
	    delete name;
	if(die != NULL)
	    delete die;
}

void
WordGen::Init(WordCase c)
{
int i,j,k,l;

    name = NULL;
	vowel_flag = ' ';
    _case = c;
	die = new Dice(6, 1, 0);
	valid = FALSE;
	
	for(i = 0;i < TABLE_SIZE;i++) {
		for(j = 0;j < TABLE_SIZE;j++) {
			for(k = 0;k < TABLE_SIZE;k++) {
				for(l = 0;l < TABLE_ENTRY_SIZE;l++) {
					base_table.entry[j].line[k].word[l] = 
					  alt_table.entry[j].line[k].word[l] = 
					  init_table[i].entry[j].line[k].word[l] =
					  vow_table[i].entry[j].line[k].word[l] =
					  end_table[i].entry[j].line[k].word[l] = 0;
				}
			}
		}
	}
}

bool
WordGen::LoadFile(char *n)
{
int i;
bool ret=FALSE;
char buffer[BIG_BUFFER_SIZE];
FILE *fpx;
struct WORD_TABLE *tbl;

    if((fpx = fopen(n, "r")) != NULL) {
		while(TRUE) {
			// make sure the buffer is cleared
			for(i = 0;i < BIG_BUFFER_SIZE;i++)
			    buffer[i] = 0;
			// load a line
			if(fgets(buffer, BIG_BUFFER_SIZE, fpx) == NULL)
			    break;

			if((buffer[0] == ' ') || (buffer[0] == 0) ||
			   (buffer[0] == '\n') || (buffer[0] == '#'))
			    continue;

			if(buffer[strlen(buffer) - 1] == '\n')
			    buffer[strlen(buffer) - 1] = 0;
			
			if(strcasestr(buffer, "Language:"))
			    ParseName(buffer);
			else if(strcasestr(buffer, "Flag:"))
			    ParseFlag(buffer);
			else {
				i = buffer[1] - '1';
				tbl = NULL;

				if(toupper(buffer[0]) == 'S') {
					if(i == 0)
					    tbl = &base_table;
					else if (i == 1)
					    tbl = &alt_table;
				} else {
					if((i < 0) || (i > 5))
					    continue;
					if(toupper(buffer[0] == 'I'))
					    tbl = &init_table[i];
					else if(toupper(buffer[0] == 'V'))
					    tbl = &vow_table[i];
					else if(toupper(buffer[0] == 'E'))
					    tbl = &end_table[i];
				}
				if(tbl != NULL)
				    ParseTable(buffer, tbl);
			}
		}
		ret = TRUE;
	}

	return(ret);
}

bool
WordGen::ParseName(char *buff)
{
    if((buff = ParseData(buff)) == NULL)
	    return(FALSE);

	if(name != NULL)
	    delete name;
	name = new char[strlen(buff) + 1];
	strcpy(name, buff);
	return(TRUE);
}

bool
WordGen::ParseFlag(char *buff)
{
    if((buff = ParseData(buff)) == NULL)
	    return(FALSE);

	vowel_flag = buff[0];
	return(TRUE);
}

char *
WordGen::ParseData(char *buff)
{
char *ptr;

    ptr = strchr(buff, ':');
	if(ptr == NULL)
	    return(NULL);
	ptr++;

	while((*ptr == ' ') && (*ptr != '\n') && (*ptr != 0))
	    ptr++;

	if((*ptr == '\n') || (*ptr == 0))
	    return(NULL);
	
	return(ptr);
}

bool
WordGen::ParseTable(char *buff, struct WORD_TABLE *tbl)
{
int i,j,k,l;

    if((buff = ParseData(buff)) == NULL)
	    return(FALSE);

    l = 0;
    for(i = 0;i < TABLE_SIZE;i++) {
		for(j = 0;j < TABLE_SIZE;j++) {
			for(k = 0;k < (TABLE_ENTRY_SIZE - 1);k++) {
				char c;

				c = buff[l++];
				if((isalpha(c)) || c == ' ')
				    tbl->entry[i].line[j].word[k] = c;
				else
				    tbl->entry[i].line[j].word[k] = 0;
			}
			tbl->entry[i].line[j].word[k] = 0;
			strstrip(tbl->entry[i].line[j].word, TRUE);
			if(tbl->entry[i].line[j].word[0] == 0)
			    strfixsize(tbl->entry[i].line[j].word, 1);
		}
	}
	return(TRUE);
} 

char *
WordGen::GenerateWord(char *buff)
{
int i,j;
int d1,d2;

    buff[0] = 0;
    d1 = die->Roll() - 1;
	d2 = die->Roll() - 1;
	j = die->Roll();

	CatSylb(buff, alt_table.entry[d1].line[d2].word);

	for(i = 0;i < j;i++) {
		d1 = die->Roll() - 1;
		d2 = die->Roll() - 1;

		CatSylb(buff, base_table.entry[d1].line[d2].word);
	}

	if(_case == WORD_UPPER) {
		for(i = 0;i < (int)strlen(buff);i++)
		    buff[i] = toupper(buff[i]);
	} else if(_case == WORD_LOWER) {
		for(i = 0;i < (int)strlen(buff);i++)
		    buff[i] = tolower(buff[i]);
	} else
	    strmixed(buff);

	return(buff);
}

void
WordGen::CatSylb(char *buff, char *format)
{
int i,j=0;

   for(i = 0;i < 3;i++) {
	   if(j) continue;
	   switch(format[i]) {
		   case 'C': {
			   CatConst(buff, i);
			   break;
		   }
		   case 'V': {
			   CatVowel(buff);
			   break;
		   }
		   default: {
			   j = 1;
			   break;
		   }
	   }
   }
}

void
WordGen::CatConst(char *buff, int flag)
{
int d1,d2,d3;

   d1 = die->Roll() - 1;
   d2 = die->Roll() - 1;
   d3 = die->Roll() - 1;
   
   if(flag)
	   strcat(buff, end_table[d1].entry[d2].line[d3].word);
   else
	   strcat(buff, init_table[d1].entry[d2].line[d3].word);
}

void
WordGen::CatVowel(char *buff)
{
char *ptr,dummy=0;
int d1,d2,d3;

   d1 = die->Roll() - 1;
   d2 = die->Roll() - 1;
   d3 = die->Roll() - 1;

   ptr = vow_table[d1].entry[d2].line[d3].word;

   strcat(buff, ptr);
}
