
/*
 * File:      
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

// rcsid[] = "$RCSfile: t_hex.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/05/17 02:45:12 $"

// t_hex.cpp
//  travel hex values

// special cases:
//	pop: allow space (ie. no pop)
//			but, has a flag since that may be an invalid condition
//	size: in addition to 0-A, allow S (very small) and R (ring)
//			the real difficulty is with GG's
//			i can save a number (say 13 for SGG and 14 for LGG),
//			but what should the code be? (blank?)
//			and how can it be implemented w/o a big kludge?


#include "t_hex.h"
//  					 0123456789012345678901234567890123456789
char *t_hex::val_str  = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
char *t_hex::size_str = "0123456789ASR  ";
//char *t_hex::space_str= "0123456789A ";

t_hex::t_hex(t_hex *t)
{
	type = t->GetType();
	val = t->get_t_hex_val();
}

t_hex::t_hex()
{
	val = -1;
	type = T_HEX_FULL;
}

t_hex::t_hex(short s, T_HEX_TYPE v)
{
	type = v;
	set_t_hex_val(s);
}

t_hex::t_hex(char c, T_HEX_TYPE v)
{
	type = v;
	set_t_hex(c);
}

t_hex::~t_hex()
{
}

char t_hex::get_t_hex(void) 
{
    if((val < 0) || (val > get_max()))
	    return(' ');
	if(type == T_HEX_SIZE_GG)
		return(size_str[val]);
	return(val_str[val]); 
};

void t_hex::set_t_hex(char c)
{
short s;

	s = xlat_digit(c);
	if(s < 0)
	    set_t_hex_val(-1);
	else
	    set_t_hex_val(s);
}

void t_hex::set_t_hex_val(short s)
{
int j;

	j = get_max();
	if(s < 0)
		s = -1;
	if(s > j)
		s = j;
	val = s;
}


short t_hex::get_max(void)
{
	switch(type)
		{
		case T_HEX_FULL:
			return(34);
//		case T_HEX_FULL_SPACE:
//			return(MAX_T_HEX);
		case T_HEX_SIZE:
			return(15);
//		case T_HEX_SIZE_EXT:
//			return(12);
		case T_HEX_SIZE_GG:
			return(14);
		case T_HEX_TEN:
			return(11);
//		case T_HEX_TEN_SPACE:
//			return(11);
		case T_HEX_HEX:
			return(16);
//		case T_HEX_HEX_SPACE:
//			return(16);
  		case T_HEX_21:
			return(22);
//  		case T_HEX_21_SPACE:
//			return(23);
		}

	// quiet the compiler.....
	return(0);
}

short t_hex::xlat_digit(char c)
{
int i;
char *ptr;

	switch(type)
		{
		case T_HEX_SIZE:
		case T_HEX_SIZE_GG:
			ptr = size_str;
			break;
//		case T_HEX_SPACE:
//			ptr = space_str;
//			break;
		case T_HEX_TEN:
		case T_HEX_HEX:
		case T_HEX_21:
		case T_HEX_FULL:
		default:
			ptr = val_str;
			break;
		}

	for(i = 0; i < strlen(ptr);i++)
		{
		if(c == ptr[i])
			return(i);
		}
	
	return(-1);		// is the best way?
}
