/*
 * File:      t_help.h
 * Purpose:   header for MTU help stuff
 * Author:    Mark A. Nordstrand
 * Created:   8/2/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2003 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_help.cpp,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/05/05 03:30:41 $" */

#include <string.h>
#include "t_help.h"
#include "t_res.h"
#include "wx/statline.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"

#ifndef __WXMSW__
#include "bitmaps/trav-logo.xpm"
#endif

AboutDialog::AboutDialog(wxWindow *parent) :
	wxDialog(parent, -1, "Delete this",  wxDefaultPosition, wxDefaultSize, 
		wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
int i;
wxStaticText *msg[8];
wxStaticLine *line[2];
wxButton *btn;
wxStaticBitmap *bmp;
wxBoxSizer *s;

#ifndef __WXMSW__
	wxIcon icon(trav_logo_xpm);
#else
	// XXX ???
#endif
	bmp = new wxStaticBitmap(this, -1, icon);
//	line[0] = new wxStaticLine(this, -1);
	line[1] = new wxStaticLine(this, -1);
	btn = new wxButton(this, wxID_OK, "Ok", 
		wxPoint(-1, -1), wxSize(2 * COL_OFFSET, -1));

	msg[0] = new wxStaticText(this, -1, 
		"  The Traveller game in all forms is owned by and a registered");
	msg[1] = new wxStaticText(this, -1, 
		"  trademark of Far Future Enterprises.  Copyright 1977 - 2003 ");
	msg[2] = new wxStaticText(this, -1, 
		"  Far Future Enterprises.  Any use of Far Future Enterprises's");
	msg[3] = new wxStaticText(this, -1, 
		"  copyrighted material or trademarks anywhere within this ");
	msg[4] = new wxStaticText(this, -1, 
		"  program and its data files should not be viewed as a ");
	msg[5] = new wxStaticText(this, -1, 
		"  challenge to those copyrights or trademarks.");
	msg[6] = new wxStaticText(this, -1, 
		"  Additionally, information with respect to the source code is");
	msg[7] = new wxStaticText(this, -1,
		"  in src/COPYING which you may wish to review.");

	s = new wxBoxSizer(wxVERTICAL);
	s->Add(bmp, 0, wxCENTER | wxALL, DLG_OFFSET);
//	s->Add(line[0], 1, wxGROW | wxALL, DLG_OFFSET);
	for(i = 0;i < 6;i++)
		s->Add(msg[i], 0, wxLEFT, DLG_OFFSET / 2);
	s->Add(line[1], 1, wxGROW | wxALL, DLG_OFFSET);
	for(i = 6;i < 8;i++)
		s->Add(msg[i], 0, wxLEFT, DLG_OFFSET / 2);
	s->Add(btn, 0, wxCENTER | wxALL, DLG_OFFSET * 2);

	SetAutoLayout(TRUE);
	btn->SetDefault();

	s->Fit(this);
	s->SetSizeHints(this);
	SetSizer(s);

	Centre(wxBOTH);
}

AboutDialog::~AboutDialog()
{
}

void
AboutDialog::ShowAbout(char *name)
{
char buffer[256];

	sprintf(buffer, "About: %s (MTU)", name);
	SetTitle(buffer);

	ShowModal();
}

// ==========================================================================
// temp defines (move to t_res.h)
#define SECTION_HELP			"Help"
#define ENTRY_HELP_DIR			"Dir"
#define ENTRY_HELP_VIEWER		"Viewer"
THelp::THelp()
{
wxConfig *config;
wxString ptr;
char str[MAX_FILE_LENGTH];

	str[0] = 0;
	// load resources
	config = new wxConfig((const wxString) RESOURCE_FILE);
	wxConfigBase::Set(config);
	wxConfigBase::Get();

	// grab the location of the help files
	sprintf(str, "/%s/%s", SECTION_HELP, ENTRY_HELP_DIR);
	if(config->Read((const wxString) str, &ptr)) {
		strcpy(str, ptr.GetData());
	}
	Initialize(str);

	// grab the viewer to use
	sprintf(str, "/%s/%s", SECTION_HELP, ENTRY_HELP_VIEWER);
	if(config->Read((const wxString) str, &ptr)) {
		strcpy(str, ptr.GetData());
	}
	if(strstr(str, "netscape") == NULL)
		SetViewer(str);
	else
		SetViewer(str, wxHELP_NETSCAPE);
	app_id = -1;
}

THelp::~THelp()
{
}

void
THelp::BuildMenu(wxMenuBar *menu_bar, int a)
{
wxMenu *m;

	m = new wxMenu;
    m->Append(T_HELP_APP, "&Help");
    m->Append(T_HELP_MTU, "&Help on MTU");
	m->Append(T_HELP_TRAVELLER, "&Help on Traveller");
    m->AppendSeparator();
    m->Append(T_HELP_SEARCH, "&Search help...");
    m->AppendSeparator();
    m->Append(T_HELP_ABOUT, "&About");

	menu_bar->Append(m, "&Help");

	app_id = a;
}

bool
THelp::ResolveMenu(wxWindow *parent, int id)
{
bool ret=FALSE;

	switch(id) {
		case T_HELP_APP:
			if(app_id > -1)
				DisplaySection(app_id);
			ret = TRUE;
			break;
		case T_HELP_MTU:
			DisplaySection(HI_MTU);
			ret = TRUE;
			break;
		case T_HELP_TRAVELLER:
			DisplaySection(HI_TRAVELLER);
			ret = TRUE;
			break;
		case T_HELP_SEARCH: {
			wxString key = wxGetTextFromUser("Search for?",
					"Search help for keyword", "", parent);
			if(!key.IsEmpty()) KeywordSearch(key);
			ret = TRUE;
			break;
		}
		case T_HELP_ABOUT: {
			AboutDialog *dlg;

			dlg = new AboutDialog(parent);
			dlg->ShowAbout("mtu");
			delete dlg;

			ret = TRUE;
			break;
		}
	}

	return(ret);
}

