
/*
 * File:      
 * Purpose:   dice.cpp
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_dice.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */



#include <stdlib.h>
#include <time.h>
#include "t_dice.h"

char Dice::seeded=0;

Dice::Dice()
{
    Seed();
	SetDice();
}

Dice::Dice(unsigned char Size, unsigned char Num, char Mod)
{
    Seed();
    SetDice(Size, Num, Mod);
};

void
Dice::Seed(void)
{
	if(!seeded)
		{
		srand((int)(time(NULL) & 0xffff));
		seeded++;
		SetDice();
		}
}

void
Dice::SetDice(unsigned char Size, unsigned char Num, char Mod)
{

	DieSize = Size;
	DieNumber = Num;
	DieMod = Mod;
}

int
Dice::Roll(void)
{
int i,r,s;

	s = DieMod;
	for(i=0; i<DieNumber; i++)
		{
		r = rand();
		s += (r % DieSize) + 1;
		}

	return(s);
}

int
Dice::Roll(unsigned char Size, unsigned char Num, char Mod)
{
	SetDice(Size, Num, Mod);
	return(Roll());
}


