/*
 * File:      str_util.c
 * Purpose:   misc string utilities
 * Author:
 * Created:
 * Updated:
 * Copyright:
 */

/* rcsid[] = "$RCSfile: str_util.c,v $ $Revision: 1.6 $ $Author: man $ $Date: 2000/02/02 01:47:50 $" */

#include <string.h>
#include <ctype.h>
#include "str_util.h"

/* ========================================================================
 *  strfixsize - fix the size of string by truncating or extending
 */
char *strfixsize(char *str, int size)
{
int i;
int len;

    len = strlen(str);
    if(size > len) 
		{
        for(i = len;i < size; i++) 
			*(str+i) = ' ';
        *(str + i)='\0';
    	}
    else 
        *(str + size)='\0';

    return(str);
}

/* ========================================================================
 *  strstrip - removing leading or trailing chars off of a string
 */
char *strstrip(char *str, int leading)
{
	if(!leading)
		{
    	char *ptr1,*ptr2;

    	ptr1 = ptr2 = str;
    	while(isspace(*ptr1)) ptr1++;
    	while(*ptr1) *ptr2++ = *ptr1++;
    	*ptr2 = '\0';
		}
	else
		{
    	int i;

    	for(i = strlen(str) - 1;isspace(str[i]) && i >= 0;i--) ;
    	str[i+1] = '\0';
		}
	
	return(str);
}

/* ========================================================================
 *  strrot - rotate a string
 */
char *strrot(char *str, int count, int right)
{
int i,j;
char temp;

	if(right)
		{
		int len;

        len = strlen(str) - 1;
        for(j = 0;j < count;j++) 
			{
            temp = *(str+len);
            for(i = len;i > 0;i--) 
				*(str + i) = *(str + i - 1);
            *(str) = temp;
			}
		}
	else
		{
        for(j = 0;j < count;j++) 
			{
            temp = *(str);
            for(i = 0;*(str + i);i++) 
				*(str + i) = *(str + i + 1);
            *(str + i - 1) = temp;
        	}
		}

	return(str);
}

/* ========================================================================
 *  strmixed - convert string to mixed case
 */
char *strmixed(char *str)
{
int i,len;

	len = strlen(str);
    for(i = 0;i < len; i++)
		{
		char c;

		if(0 == i)
			c = ' ';		/* force a special character */
		else
			c = str[i - 1];

		if((' ' == c) || ('-' == c) || ('_' == c) || (',' == c) || 
				('.' == c))
			str[i] = toupper(str[i]);
		else
			{
			str[i] = tolower(str[i]);
			}
		}

    return(str);
}

/* ========================================================================
 *  stupid_file_name_cmp - compare strings ignoring '/' and '\\'
 *    (seems required for putting file names into a wxGTK menu --
 *    GTK or wxGTK issue????)
 */
int
stupid_file_name_cmp(char *s1, char *s2)
{
	while((*s1 != 0) && (*s2 != 0)) {
		if(('/' == *s1) || ('\\' == *s1)) {
			if((*s2 != '/') && (*s2 != '\\'))
				break;
		} else if(*s1 != *s2)
			break;

		if(('\\' == *s1) && ('\\' == s1[1])) s1++;
		if(('\\' == *s2) && ('\\' == s2[1])) s2++;
		s1++;
		s2++;
	}

	return(*s1 - *s2);
}

