/*
 * File:	srch_dlg.cpp
 * Purpose:	misc searching dialogs
 * Author:	Mark A. Nordstrand
 * Created:	6/18/2000
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: srch_dlg.cpp,v $ $Revision: 1.7 $ $Author: man $ $Date: 2003/05/02 21:45:39 $" */

#include <libgen.h>
#include "srch_dlg.h"

#if defined (__WXGTK__) || defined(__WXMOTIF__)
#include "bitmaps/f_rev.xpm"
#include "bitmaps/rev.xpm"
#include "bitmaps/fwd.xpm"
#include "bitmaps/f_fwd.xpm"
#include "bitmaps/attr.xpm"
#include "bitmaps/mag.xpm"
#include "bitmaps/print.xpm"
#endif

// ===============================================================
// dummy buffers......
#define MAX_BUFFER_NUM		8
#define MAX_BUFFER_LEN		24
#define MAX_FILE_LEN		256

enum {
	BTN_ID_FIRST=701,
	BTN_ID_PREV,
	BTN_ID_NEXT,
	BTN_ID_LAST,
	BTN_ID_TRADE,
	BTN_ID_SHORT,
	BTN_ID_RANGE,
	BTN_ID_DETAIL,
	BTN_ID_LIST,
	BTN_ID_PRINT,
	BTN_ID_CLOSE,
	BTN_ID_SETUP
};

// ===============================================================
static wxString dummy_buffers[MAX_BUFFER_NUM];//[MAX_BUFFER_LEN];

static const wxString HeaderStr[8] = {
	"Port:       ",
	"Size:       ",
	"Atmosphere: ",
	"Hydrosphere:",
	"Population: ",
	"Government: ",
	"Law Level:  ",
	"Technology: "
};

static const wxString RangeHeaderStr[] = {
	"Port:",
	"Size:",
	"Atmos:",
	"Hydro:",
	"Pop:",
	"Govt:",
	"Law:",
	"Tech:",
	"GG:",
	"Belts:",
	"Number:",
	"Type:",
	"Class:",
	"Size:"
};

static char *port_str[] = {
	"Any",
	"A Excellent",
	"B Good",
	"C Routine",
	"D Poor",
	"E Frontier",
	"X None"
};

static char *size_str[] = {
	"Any",
	"Asteroid",
	"Small",
	"Medium",
	"Large"
};

static char *atmos_str[] = {
	"Any",
	"Vacuum",
	"Thin",
	"Standard",
	"Dense",
	"Exotic"
};

static char *hydro_str[] = {
	"Any",
	"Desert World",
	"Dry World",
	"Wet World",
	"Water World"
};

static char *pop_str[] = {
	"Any",
	"Incidental",
	"Low",
	"Moderate",
	"High"
};

static char *govt_str[] = {
	"Any",
	"None",
	"Low",
	"Moderate",
	"High",
	"Extreme"
};

static char *law_str[] = {
	"Any",
	"None",
	"Low",
	"Moderate",
	"High",
	"Extreme"
};

static char *tech_str[] = {
	"Any",
	"Pre-Industrial",
	"Industrial",
	"Pre-Stellar",
	"Early Stellar",
	"Average Stellar",
	"High Stellar",
	"Extreme Stellar"
};

SearchShortDialog::SearchShortDialog(wxWindow *p) :
	StdDialog(p, "Search For Short Codes")
{
int i;
wxString ptrs[8];
wxStaticText *msg[8];
wxBoxSizer *bs;
wxFlexGridSizer *gs;

	msg[0] = new wxStaticText(this, -1, "Port:");
	msg[1] = new wxStaticText(this, -1, "Size:");
	msg[2] = new wxStaticText(this, -1, "Atmos:");
	msg[3] = new wxStaticText(this, -1, "Hydro:");
	msg[4] = new wxStaticText(this, -1, "Pop:");
	msg[5] = new wxStaticText(this, -1, "Govt:");
	msg[6] = new wxStaticText(this, -1, "Law:");
	msg[7] = new wxStaticText(this, -1, "Tech:");

	for(i = 0;i < 7;i++)
		ptrs[i] = port_str[i];
	choices[0] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			7, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = size_str[i];
	choices[1] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = atmos_str[i];
	choices[2] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = hydro_str[i];
	choices[3] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = pop_str[i];
	choices[4] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = govt_str[i];
	choices[5] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = law_str[i];
	choices[6] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 8;i++)
		ptrs[i] = tech_str[i];
	choices[7] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			8, ptrs);

	bs = new wxBoxSizer(wxVERTICAL);
	gs = new wxFlexGridSizer(2, DLG_OFFSET, DLG_OFFSET);
	bs->Add(gs, 1, wxGROW | wxALL, DLG_OFFSET);
	for(i = 0;i < 8;i++) {
		gs->Add(msg[i], 0, wxALIGN_BOTTOM, DLG_OFFSET);
		gs->Add(choices[i], 1, wxALIGN_CENTER_VERTICAL | wxGROW, DLG_OFFSET);
	}

	DoLayout(wxALL, DLG_OFFSET, bs);
}

wxString
SearchShortDialog::GetHeaderStr(int ndx)
{
	return(HeaderStr[ndx]);
}

wxString
SearchShortDialog::GetChoiceStr(int ndx)
{
wxString ptr;

	if((ndx >= 0) && (ndx < 8)) {
		ptr = choices[ndx]->GetStringSelection();
//		if((sel >= 0) && (sel < choices->Number(ndx))
//			{
//			ptr = choices->GetString(sel);
//			}
	}

	return(ptr);
}

bool 
SearchShortDialog::GetShortSearch(MinClass *min, MaxClass *max)
{
int i;

	if(ShowModal() != wxID_CANCEL) {
		i = choices[0]->GetSelection();
		if(i > 0) {
			if(i < 5) {
				min->SetPort(i - 1);
				max->SetPort(i - 1);
			} else {
				min->SetPort(8);
				max->SetPort(8);
			}
		}

		i = choices[1]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetSize(0);
					max->SetSize(0);
					break;
				case 2:
					min->SetSize(1);
					max->SetSize(4);
					break;
				case 3:
					min->SetSize(5);
					max->SetSize(7);
					break;
				case 4:
					min->SetSize(8);
					max->SetSize(10);
					break;
			}
		}

		i = choices[2]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetAtmos(0);
					max->SetAtmos(3);
					break;
				case 2:
					min->SetAtmos(4);
					max->SetAtmos(5);
					break;
				case 3:
					min->SetAtmos(6);
					max->SetAtmos(7);
					break;
				case 4:
					min->SetAtmos(8);
					max->SetAtmos(9);
					break;
				case 5:
					min->SetAtmos(10);
					max->SetAtmos(15);
					break;
			}
		}

		i = choices[3]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetHydro(0);
					max->SetHydro(0);
					break;
				case 2:
					min->SetHydro(1);
					max->SetHydro(3);
					break;
				case 3:
					min->SetHydro(4);
					max->SetHydro(8);
					break;
				case 4:
					min->SetHydro(9);
					max->SetHydro(10);
					break;
			}
		}

		i = choices[4]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetPop(0);
					max->SetPop(2);
					break;
				case 2:
					min->SetPop(3);
					max->SetPop(5);
					break;
				case 3:
					min->SetPop(6);
					max->SetPop(8);
					break;
				case 4:
					min->SetPop(9);
					max->SetPop(10);
					break;
			}
		}

		i = choices[5]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetGovt(0);
					max->SetGovt(0);
					break;
				case 2:
					min->SetGovt(1);
					max->SetGovt(3);
					break;
				case 3:
					min->SetGovt(4);
					max->SetGovt(7);
					break;
				case 4:
					min->SetGovt(8);
					max->SetGovt(9);
					break;
				case 5:
					min->SetGovt(10);
					max->SetGovt(24);
					break;
			}
		}

		i = choices[6]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetLaw(0);
					max->SetLaw(0);
					break;
				case 2:
					min->SetLaw(1);
					max->SetLaw(3);
					break;
				case 3:
					min->SetLaw(4);
					max->SetLaw(7);
					break;
				case 4:
					min->SetLaw(8);
					max->SetLaw(9);
					break;
				case 5:
					min->SetLaw(10);
					max->SetLaw(24);
					break;
			}
		}

		i = choices[7]->GetSelection();
		if(i > 0) {
			switch(i) {
				case 1:
					min->SetTech(0);
					max->SetTech(3);
					break;
				case 2:
					min->SetTech(4);
					max->SetTech(5);
					break;
				case 3:
					min->SetTech(6);
					max->SetTech(8);
					break;
				case 4:
					min->SetTech(9);
					max->SetTech(10);
					break;
				case 5:
					min->SetTech(11);
					max->SetTech(13);
					break;
				case 6:
					min->SetTech(14);
					max->SetTech(16);
					break;
				case 7:
					min->SetTech(17);
					max->SetTech(24);
				break;
				}
		}
		return(TRUE);
	}

	return(FALSE);
}

void 
SearchShortDialog::BuildChoice(int ndx, const wxString& title, 
								const wxString& str1, const wxString& str2, 
								const wxString& str3, const wxString& str4, 
								const wxString& str5, const wxString& str6, 
								const wxString& str7, const wxString& str8)
{
int i,j=1;
//char *dummy_ptr[MAX_BUFFER_NUM] =
wxString dummy_ptr[MAX_BUFFER_NUM] =
				{ dummy_buffers[0],
				  dummy_buffers[1],
				  dummy_buffers[2],
				  dummy_buffers[3],
				  dummy_buffers[4],
				  dummy_buffers[5],
				  dummy_buffers[6],
				  dummy_buffers[7]};

	if(ndx & 1)
#ifdef __WINDOWS__
		j = 95;
#endif
#ifdef __WXGTK__
		j = 115;
#endif
	else
		j = 5;

	i = BuildBuffers(str1, str2, str3, str4, str5, str6, str7, str8);
//	choices[ndx] = new wxChoice(this, NULL, title, j, -1, -1, -1, 
//		i, dummy_ptr, wxFIXED_LENGTH);
	wxStaticText(this, -1, title);
	choices[ndx] = new wxChoice(this, -1, wxPoint(j, -1), wxSize(-1, -1),
			i, dummy_ptr);
	choices[ndx]->SetSelection(0);

////	if(ndx & 1)
////		NewLine();
}

int 
SearchShortDialog::BuildBuffers(const wxString& str1, const wxString& str2, 
								const wxString& str3, const wxString& str4, 
								const wxString& str5, const wxString& str6, 
								const wxString& str7, const wxString& str8)
{
int i,j=0,k=0;

	if((i = BuildBuffer(dummy_buffers[0], str1)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[1], str2)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[2], str3)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[3], str4)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[4], str5)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[5], str6)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[6], str7)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[7], str8)) > j)
		j = i;

	for(i = 0;i < MAX_BUFFER_NUM;i++) {
		if(dummy_buffers[i].Len() > 0)
			k++;
		dummy_buffers[i].Pad(j - dummy_buffers[i].Len());
//		if(strlen(dummy_buffers[i]) > 0)
//			k++;
//		strfixsize(dummy_buffers[i], j);
	}

	return(k);
}

int 
SearchShortDialog::BuildBuffer(wxString& dest, const wxString& src)
{
//	if(src == NULL) {
	if(src.Len() == 0) {
		dest.Truncate(0);
		return(0);
	} else {
		dest = src;
		return(dest.Len());
	}
}

// ===============================================================
static char general_str[22][4] = {
	" 0 ",
	" 1 ",
	" 2 ",
	" 3 ",
	" 4 ",
	" 5 ",
	" 6 ",
	" 7 ",
	" 8 ",
	" 9 ",
	" A ",
	" B ",
	" C ",
	" D ",
	" E ",
	" F ",
	" G ",
	" H ",
	" J ",
	" K ",
	" L ",
	" X " };

static char type_str[7][4] = {
	" O ",
	" B ",
	" A ",
	" F ",
	" G ",
	" K ",
	" M " };

static char star_size_str[7][6] = {
	" Ia  ",
	" Ib  ",
	" II  ",
	" III ",
	" IV  ",
	" V   ",
	" VI  "};

static char zone_str[4][8] = {
	" Any ",
	" Green ",
	" Amber ",
	" Red   "};

static wxString dummy_ptr[22];

SearchRangeDialog::SearchRangeDialog(wxWindow *p) :
	StdDialog(p, "Search For Worlds")
{
//char *dummy_ptr[22];
int i,max;
//wxStaticBox *box[4];
wxStaticText *min_msg[3],*max_msg[3];
wxStaticText *uwp_msg[8],*star_msg[4],*misc_msg[3],*sys_msg[2];
wxStaticText *dummy[3];
//wxBoxSizer *bs[3];
//wxStaticBoxSizer *bx[4];
//wxFlexGridSizer *gs[4];

	for(i = 0;i < 22;i++)
		dummy_ptr[i] = general_str[i];

//	box[0] = new wxStaticBox(this, -1, "UWP");
//	box[1] = new wxStaticBox(this, -1, "Stars");
//	box[2] = new wxStaticBox(this, -1, "System");
//	box[3] = new wxStaticBox(this, -1, "Misc.");

	dummy[0] = new wxStaticText(this, -1, "");
	dummy[1] = new wxStaticText(this, -1, "");
	dummy[2] = new wxStaticText(this, -1, "");

	min_msg[0] = new wxStaticText(this, -1, "Min");
	min_msg[1] = new wxStaticText(this, -1, "Min");
	min_msg[2] = new wxStaticText(this, -1, "Min");
	max_msg[0] = new wxStaticText(this, -1, "Max");
	max_msg[1] = new wxStaticText(this, -1, "Max");
	max_msg[2] = new wxStaticText(this, -1, "Max");

	uwp_msg[0] = new wxStaticText(this, -1, "Port:");
	uwp_msg[1] = new wxStaticText(this, -1, "Size:");
	uwp_msg[2] = new wxStaticText(this, -1, "Atmos:");
	uwp_msg[3] = new wxStaticText(this, -1, "Hydro:");
	uwp_msg[4] = new wxStaticText(this, -1, "Pop:");
	uwp_msg[5] = new wxStaticText(this, -1, "Govt:");
	uwp_msg[6] = new wxStaticText(this, -1, "Law:");
	uwp_msg[7] = new wxStaticText(this, -1, "Tech:");

	sys_msg[0] = new wxStaticText(this, -1, "GG:");
	sys_msg[1] = new wxStaticText(this, -1, "Belts:");

	star_msg[0] = new wxStaticText(this, -1, "Number:");
	star_msg[1] = new wxStaticText(this, -1, "Type:");
	star_msg[2] = new wxStaticText(this, -1, "Class:");
	star_msg[3] = new wxStaticText(this, -1, "Size:");

	misc_msg[0] = new wxStaticText(this, -1, "Bases:");
	misc_msg[1] = new wxStaticText(this, -1, "Zone:");
	misc_msg[2] = new wxStaticText(this, -1, "Alleg:");

	for(i = 0;i < MAX_CHOICES;i++) {
		max = InitArray(i, dummy_ptr);

		min_choices[i] = new wxChoice(this, -1, 
				wxPoint(-1, -1), wxSize((int)(COL_OFFSET * 1.75), -1),
				max, dummy_ptr);
		min_choices[i]->SetSelection(0);

		max_choices[i] = new wxChoice(this, -1, 
				wxPoint(-1, -1), wxSize((int)(COL_OFFSET * 1.75), -1),
				max, dummy_ptr);
		max_choices[i]->SetSelection(max-1);
		}

	bases = new wxTextCtrl(this, -1, " X ");
	bases->SetValue("");

	max = InitArray(-1, dummy_ptr);
	zones = new wxChoice(this, -1, 
			wxPoint(-1, -1),
			wxSize(-1, -1), max, dummy_ptr);
	zones->SetSelection(0);

	alleg = new wxTextCtrl(this, -1, " XX ");
	alleg->SetValue("");

	// do layout
	wxBoxSizer* sizer_13 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_9 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_12 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Misc"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_4 = new wxFlexGridSizer(3, 2, DLG_OFFSET, DLG_OFFSET);
    wxStaticBoxSizer* sizer_11 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Stars"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_3 = new wxFlexGridSizer(5, 3, DLG_OFFSET, DLG_OFFSET);
    wxStaticBoxSizer* sizer_10 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "System"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_2 = new wxFlexGridSizer(3, 3, DLG_OFFSET, DLG_OFFSET);
    wxBoxSizer* sizer_14 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_8 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "UWP"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(9, 3, DLG_OFFSET, DLG_OFFSET);
    grid_sizer_1->Add(dummy[0], 0, 0, 0);
    grid_sizer_1->Add(min_msg[0], 0, 0, 0);
    grid_sizer_1->Add(max_msg[0], 0, 0, 0);
	for(i = 0;i < 8;i++) {
    	grid_sizer_1->Add(uwp_msg[i], 0, wxALIGN_BOTTOM, 0);
    	grid_sizer_1->Add(min_choices[i], 0, 0, 0);
    	grid_sizer_1->Add(max_choices[i], 0, 0, 0);
	}
    sizer_8->Add(grid_sizer_1, 0, wxALL, DLG_OFFSET);
    sizer_14->Add(sizer_8, 1, wxEXPAND, 0);
    sizer_13->Add(sizer_14, 0, wxALL, DLG_OFFSET);
    grid_sizer_2->Add(dummy[1], 0, 0, 0);
    grid_sizer_2->Add(min_msg[1], 0, 0, 0);
    grid_sizer_2->Add(max_msg[1], 0, 0, 0);
	for(i = 8;i < 10;i++) {
    	grid_sizer_2->Add(sys_msg[i - 8], 0, wxALIGN_BOTTOM, 0);
    	grid_sizer_2->Add(min_choices[i], 0, 0, 0);
    	grid_sizer_2->Add(max_choices[i], 0, 0, 0);
	}
    sizer_10->Add(grid_sizer_2, 0, wxALL, DLG_OFFSET);
    sizer_9->Add(sizer_10, 0, wxALL, DLG_OFFSET);
    grid_sizer_3->Add(dummy[2], 0, 0, 0);
    grid_sizer_3->Add(min_msg[2], 0, 0, 0);
    grid_sizer_3->Add(max_msg[2], 0, 0, 0);
	for(i = 10;i < 14;i++) {
    	grid_sizer_3->Add(star_msg[i - 10], 0, wxALIGN_BOTTOM, 0);
    	grid_sizer_3->Add(min_choices[i], 0, 0, 0);
    	grid_sizer_3->Add(max_choices[i], 0, 0, 0);
	}
    sizer_11->Add(grid_sizer_3, 0, wxALL, DLG_OFFSET);
    sizer_9->Add(sizer_11, 0, wxALL, DLG_OFFSET);
    grid_sizer_4->Add(misc_msg[0], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(bases, 0, 0, 0);
    grid_sizer_4->Add(misc_msg[1], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(zones, 0, 0, 0);
    grid_sizer_4->Add(misc_msg[2], 0, wxALIGN_BOTTOM, 0);
    grid_sizer_4->Add(alleg, 0, 0, 0);
    sizer_12->Add(grid_sizer_4, 0, wxALL, DLG_OFFSET);
    sizer_9->Add(sizer_12, 0, wxALL, DLG_OFFSET);
    sizer_13->Add(sizer_9, 0, wxEXPAND, 0);

	DoLayout(wxALL | wxALIGN_CENTER_VERTICAL, DLG_OFFSET, sizer_13, sizer_14);
}

wxString 
SearchRangeDialog::GetChoiceStr(bool max, int ndx)
{
	if(max)
		return(max_choices[ndx]->GetStringSelection());
	else
		return(min_choices[ndx]->GetStringSelection());
}

bool 
SearchRangeDialog::GetRangeSearch(MinClass *n, MaxClass *x, CompareClass *comp)
{
int i;
int min,max;
//char *ptr;
wxString s;

	if(ShowModal() != wxID_CANCEL) {
		for(i = 0;i < MAX_CHOICES;i++) {
			min = min_choices[i]->GetSelection();
			max = max_choices[i]->GetSelection();
			switch(i) {
				case 0:
					if(min < 5)
						n->SetPort(min);
					else
						n->SetPort(8);
					if(max < 5)
						x->SetPort(max);
					else
						x->SetPort(8);
					break;
				case 1:
					n->SetSize(min);
					x->SetSize(max);
					break;
				case 2:
					n->SetAtmos(min);
					x->SetAtmos(max);
					break;
				case 3:
					n->SetHydro(min);
					x->SetHydro(max);
					break;
				case 4:
					n->SetPop(min);
					x->SetPop(max);
					break;
				case 5:
					n->SetGovt(min);
					x->SetGovt(max);
					break;
				case 6:
					n->SetLaw(min);
					x->SetLaw(max);
					break;
				case 7:
					n->SetTech(min);
					x->SetTech(max);
					break;
				case 8:
					n->SetNumGG(min);
					x->SetNumGG(max);
					break;
				case 9:
					n->SetNumBelt(min);
					x->SetNumBelt(max);
					break;
				case 10:
					n->SetNumStar(min);
					x->SetNumStar(max);
					break;
				case 11:
					n->SetStarType(min);
					x->SetStarType(max);
					break;
				case 12:
					n->SetStarClass(min);
					x->SetStarClass(max);
					break;
				case 13:
					n->SetStarSize(min);
					x->SetStarSize(max);
					break;
			}
		}
		
		s = bases->GetValue();
		if((s.c_str()[0] != 0) && (s.c_str()[0] != ' '))
			comp->SetBases(s.c_str()[0]);

		i = zones->GetSelection();
		if(i == 1)
			comp->SetZone(' ');
		else if(i == 2)
			comp->SetZone('A');
		else if(i == 3)
			comp->SetZone('R');

		s = bases->GetValue();
		if((s.c_str()[0] != 0) && (s.c_str()[0] != ' '))
			comp->SetAlleg(s.c_str());
		return(TRUE);
	}

	return(FALSE);
}

int 
SearchRangeDialog::InitArray(int which, wxString ptrs[])
{
int i;

	switch(which) {
		// # of stars
		case 10: {
			for(i = 0;i < 4;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// star type
		case 11: {
			for(i = 0;i < 7;i++)
				ptrs[i] = type_str[i];
			break;
		}
		// star class
		case 12: {
			for(i = 0;i < 10;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// star size
		case 13: {
			for(i = 0;i < 7;i++)
				ptrs[i] = star_size_str[i];
			break;
		}
		// port
		case 0: {
			ptrs[0] = general_str[10];
			ptrs[1] = general_str[11];
			ptrs[2] = general_str[12];
			ptrs[3] = general_str[13];
			ptrs[4] = general_str[14];
			ptrs[5] = general_str[21];
			i = 6;
			break;
		}
		// size
		case 1:
		// hydro
		case 3:
		// pop
		case 4: {
			for(i = 0;i < 11;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// atmos
		case 2:
		// govt
		case 5: {
			for(i = 0;i < 16;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// law
		case 6:
		// tech
		case 7: {
			for(i = 0;i < 21;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// gg
		case 8: {
			for(i = 0;i < 6;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// belts
		case 9: {
			for(i = 0;i < 4;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// zone
		default: {
			for(i = 0;i < 4;i++)
				ptrs[i] = zone_str[i];
			break;
		}
	}

	return(i);
}

// ===============================================================
SearchTradeDialog::SearchTradeDialog(wxWindow *p, TCodes *codes) :
	StdDialog(p, "Search For Trade Codes")
{
char *ptr;
int i,max_trade=0,max_syst=0,max_other=0;
ListNode *n;
SimpleCodeTable *ct;
CodeTableEntry *cte;
wxStaticBox *box[3];
wxBoxSizer *bs;

	for(i = 0;i < MAX_TRADE_CB;i++)
		cb_s[i] = cb_t[i] = cb_o[i] = NULL;

	box[0] = new wxStaticBox(this, -1, "Trade");
	box[1] = new wxStaticBox(this, -1, "System");
	box[2] = new wxStaticBox(this, -1, "Other");

	// trade
	ct = codes->GetTradeTable();
	n = ct->First();
	while(n != NULL) {
		cte = (CodeTableEntry *) n->Data();
		ptr = cte->GetCode();
		cb_t[max_trade] = new wxCheckBox(this, -1, ptr);
		n = n->Next();
		max_trade++;
	}

	// system
	ct = codes->GetSystTable();
	n = ct->First();
	while(n != NULL) {
		cte = (CodeTableEntry *) n->Data();
		ptr = cte->GetCode();
		cb_s[max_syst] = new wxCheckBox(this, -1, ptr);
		n = n->Next();
		max_syst++;
	}

	// other
	ct = codes->GetOtherTable();
	n = ct->First();
	while(n != NULL) {
		cte = (CodeTableEntry *) n->Data();
		ptr = cte->GetCode();
		cb_o[max_other] = new wxCheckBox(this, -1, ptr);
		n = n->Next();
		max_other++;
	}

	bs = new wxBoxSizer(wxVERTICAL);
	bs->Add(LayoutBox(box[0], cb_t, max_trade), 0, 
					wxCENTER | wxALL, DLG_OFFSET);
	bs->Add(LayoutBox(box[1], cb_s, max_syst), 0, 
					wxCENTER | wxALL, DLG_OFFSET);
	bs->Add(LayoutBox(box[2], cb_o, max_other), 0, 
					wxCENTER | wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, bs);
}

wxStaticBoxSizer *
SearchTradeDialog::LayoutBox(wxStaticBox *box, wxCheckBox *cb[], int max)
{
int i;
wxStaticBoxSizer *bs;
wxFlexGridSizer *gs;

	bs = new wxStaticBoxSizer(box, wxVERTICAL);
	gs = new wxFlexGridSizer(4, DLG_OFFSET, DLG_OFFSET);
	bs->Add(gs, 0, wxALL, DLG_OFFSET);

	for(i = 0;i < max;i++) {
		gs->Add(cb[i], i % 4, wxALIGN_LEFT | wxALIGN_TOP);
	}

	return(bs);
}

bool
SearchTradeDialog::GetTradeSearch(unsigned long *t, unsigned long *s, 
		unsigned long *o)
{
unsigned long l=0l,m=1l;
int i;

	if(wxID_CANCEL == ShowModal())
		return(FALSE);

	l=0l;
	m=1l;
	for(i = 0;i < MAX_TRADE_CB;i++) {
		if(cb_t[i] != NULL) {
			if(cb_t[i]->GetValue())
				l |= m;
			m *= 2;
		}
	}
	*t = l;

	l=0l;
	m=1l;
	for(i = 0;i < MAX_TRADE_CB;i++) {
		if(cb_s[i] != NULL) {
			if(cb_s[i]->GetValue())
				l |= m;
			m *= 2;
		}
	}
	*s = l;

	l=0l;
	m=1l;
	for(i = 0;i < MAX_TRADE_CB;i++) {
		if(cb_o[i] != NULL) {
			if(cb_o[i]->GetValue())
				l |= m;
			m *= 2;
		}
	}
	*o = l;

	return(TRUE);
}

// =========================================================================
CompareClass::CompareClass()
{
	bases = 0;
	zone = 0;
	alleg = NULL;
}

CompareClass::~CompareClass()
{
	Reset();
}

bool 
CompareClass::Ok(base_planet *mw)
{
bool ret=TRUE;
char *ptr;

	if(bases != 0) {
		if(bases != mw->GetBase())
			ret = FALSE;
	}
	if(zone != 0) {
		if(zone != mw->GetZone())
			ret = FALSE;
	}
	if(alleg != NULL) {
		ptr = mw->GetAlleg();
		if(ptr == NULL)
			ret = FALSE;
		else if(strcmp(alleg, ptr))
			ret = FALSE;
	}

	return(ret);
}

void 
CompareClass::Reset(void)
{
	bases = 0;
	zone = 0;
	if(alleg != NULL)
		delete alleg;
	alleg = NULL;
}

void 
CompareClass::SetAlleg(const char *a)
{
	if(alleg != NULL)
		delete alleg;
	
	alleg = new char[strlen(a) + 1];
	strcpy(alleg, a);
}

// ===============================================================
void 
MinMaxClass::Reset()
{
	port = -1;;
	size = -1;;
	atmos = -1;;
	hydro = -1;;
	pop = -1;;
	govt = -1;;
	law = -1;;
	tech = -1;;
	
	num_gg = -1;;
	num_belt = -1;;
	
	num_star = -1;;
	star_type = -1;;
	star_size = -1;;
	star_class = -1;;
}

bool 
MinMaxClass::CompareVal(bool less_than, short b_val, short c_val)
{
bool ret=TRUE;

	if(c_val > -1) {
		// yes, the actual check is backwards
		//	but, look at the return val
		if(less_than) {
			if(b_val > c_val)
				ret = FALSE;
		}
		else {
			if(b_val < c_val)
				ret = FALSE;
		}
	}
	
	return(ret);
}

bool 
MinMaxClass::Ok(base_planet *mw)
{
bool ret=TRUE;

	if(!Test(mw->get_port_val(), port))
		ret = FALSE;
		
	if(!Test(mw->get_size_val(), size))
		ret = FALSE;
		
	if(!Test(mw->get_atmos_val(), atmos))
		ret = FALSE;
		
	if(!Test(mw->get_hydro_val(), hydro))
		ret = FALSE;
		
	if(!Test(mw->get_pop_val(), pop))
		ret = FALSE;
		
	if(!Test(mw->get_govt_val(), govt))
		ret = FALSE;
		
	if(!Test(mw->get_law_val(), law))
		ret = FALSE;
		
	if(!Test(mw->get_tech_val(), tech))
		ret = FALSE;

	return(ret);
}

bool
MinMaxClass::Ok(short p, short b, short g, BaseStar *stars[])
{
int i,j;
bool ret=TRUE,temp_bool;
int temp;

#ifdef DEBUG_SEARCH_2
fprintf(stderr, "2:p%d(%d)b%d(%d)g%d(%d)", p, -1, b, num_belt, g, num_gg);
#endif
	// does it make sense to search for pop index????
	if((num_gg > -1 ) && (!Test(g, num_gg)))
		ret = FALSE;
		
	if((num_belt > -1) && (!Test(g, num_belt)))
		ret = FALSE;

	j = 0;
	for(i = 0;i < 3;i++) {
		if((stars[i] != NULL) && (stars[i]->GetStarType() > -1)) 
			j++;
	}

	if((j > 0) && (!Test(j, num_star)))
		ret = FALSE;

	temp_bool = FALSE;
	for(i = 0;i < 3;i++) {
		if(temp_bool == TRUE)
			continue;
		temp = 0;
		if(NULL == stars[i])
			continue;
		if(Test(stars[i]->GetStarType(), star_type))
			temp |= 1;
		if(Test(stars[i]->GetStarSize(), star_size))
			temp |= 2;
		if(Test(stars[i]->GetStarClass(), star_class))
			temp |= 4;
		if((temp & 7) == 7)
			temp_bool = TRUE;
	}

	if((j > 0) && (!temp_bool))
		ret = FALSE;
		
	return(ret);
}

// ===============================================================
MinClass::MinClass() :
	MinMaxClass()
{
}

MaxClass::MaxClass() :
	MinMaxClass()
{
}

// ===============================================================
BaseFound::BaseFound(int x_, int y_) :
	ListData()
{
	x = x_;
	y = y_;
}

// ---------------------------------------------------------------
// simplest case:  data from a sector file in a universe
FoundEntry::FoundEntry(int u_x, int u_y, int x_, int y_) :
	BaseFound(x_, y_)
{
	sec_x = u_x;
	sec_y = u_y;
}

void 
FoundEntry::GetValues(int *u_x, int *u_y, int *x_, int *y_,int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4)
{
	*u_x = sec_x;
	*u_y = sec_y;
	*x_ = x;
	*y_ = y;
	*z_ = *orb1 = *orb2 = *orb3 = *orb4 = -1;
}

// ---------------------------------------------------------------
// more complex case:  data from a system file from a sector file 
// in a universe
FoundSystemEntry::FoundSystemEntry(int u_x, int u_y, int x_, int y_,
			int orb1, int orb2, int orb3, int orb4, 
			planet *p_, int pn, int be, int g, BaseStar *st[]) :
	FoundEntry(u_x, u_y, x_, y_)
{
int i;

	orbs[0] = orb1;
	orbs[1] = orb2;
	orbs[2] = orb3;
	orbs[3] = orb4;
	p = new planet(p_);
	pop_index = pn;
	belts = be;
	gg = g;
	for(i = 0;i < SEARCH_STARS;i++) {
		if(st[i] != NULL)
			stars[i] = new BaseStar(st[i]);
		else
			stars[i] = NULL;
	}
}

FoundSystemEntry::~FoundSystemEntry()
{
int i;

	delete p;
	for(i = 0;i < SEARCH_STARS;i++) {
		if(stars[i] != NULL)
			delete stars[i];
	}
}

void 
FoundSystemEntry::GetValues(int *u_x, int *u_y, int *x_, int *y_,int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4)
{ 
	FoundEntry::GetValues(u_x, u_y, x_, y_, z_, orb1, orb2, orb3, orb4);
	*orb1 = orbs[0];
	*orb2 = orbs[1];
	*orb3 = orbs[2];
	*orb4 = orbs[3];
}

bool 
FoundSystemEntry::GetSysInfo(int *pn, int *be, int *g, BaseStar *st[])
{
int i;

	*pn = pop_index;
	*be = belts;
	*g = gg;

	for(i = 0;i < SEARCH_STARS;i++)
		st[i] = stars[i];

	return(TRUE);
}

// ---------------------------------------------------------------
// finally, handling 3D
Found3DEntry::Found3DEntry(int x_, int y_, int z_,
			int orb1, int orb2, int orb3, int orb4, 
			planet *p_, int pn, int be, int g, BaseStar *st[]) :
	FoundSystemEntry(-1, -1, x_, y_, orb1, orb2, orb3, orb4, p_, pn, be, g, st)
{
	z = z_;
}

void 
Found3DEntry::GetValues(int *u_x, int *u_y, int *x_, int *y_,int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4)
{
	FoundSystemEntry::GetValues(u_x, u_y, x_, y_, z_, orb1, orb2, orb3, orb4);
	*z_ = z;
}

// ===============================================================
FoundList::FoundList() :
	LinkedList()
{
	index = 0;
}

FoundList::~FoundList()
{
	Clear();
}

void 
FoundList::Clear(void)
{
ListNode *n;
BaseFound *bf;
FoundEntry *fe;
Found3DEntry *f3;
FoundSystemEntry *fs;

	n = First();
	while(n != NULL) {
		bf = (BaseFound *)n->Data();
		switch(bf->GetType()) {
			case FT_NORMAL:
				fe = (FoundEntry *)bf;
				delete fe;
				break;
			case FT_3D:
				f3 = (Found3DEntry *)bf;
				delete f3;
				break;
			case FT_SYSTEM:
				fs = (FoundSystemEntry *)bf;
				delete fs;
				break;
		}
		DeleteNode(n);
		n = First();
	}

	index = 0;
}

BaseFound *
FoundList::GetCurrent(void)
{
ListNode *n;

	n = Nth(index);
	if(n != NULL) {
		return((BaseFound *) n->Data());
	}

	return(NULL);
}

FOUND_TYPE
FoundList::GetCurrentType(void)
{
BaseFound *bf;

	if((bf = GetCurrent()) != NULL)
		return(bf->GetType());
	return(FT_NORMAL);					// no, but has best error handling...
}

bool 
FoundList::GetValues(int *u_x, int *u_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4)
{
ListNode *n;
FoundEntry *fe;

	n = Nth(index);
	if(n != NULL) {
		fe = (FoundEntry *) n->Data();
		fe->GetValues(u_x, u_y, x_, y_, z_, orb1, orb2, orb3, orb4);
		return(TRUE);
	}
	return(FALSE);
}

bool 
FoundList::GetCurrent(int *u_x, int *u_y, int *x, int *y, int *z,
				int *orb1, int *orb2, int *orb3, int *orb4)
{
	return(GetValues(u_x, u_y, x, y, z, orb1, orb2, orb3, orb4));
}

planet *
FoundList::GetCurrentPlanet(void)
{
BaseFound *bf;

	if((bf = GetCurrent()) != NULL)
		return(bf->GetPlanet());
	return(NULL);
}

bool
FoundList::GetCurrentSysInfo(int *pn, int *be, int *gg, BaseStar **st)
{
BaseFound *bf;

	if((bf = GetCurrent()) != NULL)
		return(bf->GetSysInfo(pn, be, gg, st));
	return(FALSE);
}

bool 
FoundList::SetFirst(void)
{
	if(index > 0) {
		index = 0;
		return(TRUE);
	}
	return(FALSE);
}

bool 
FoundList::SetPrev(void)
{
	if(index > 0) {
		index--;
		return(TRUE);
	}
	return(FALSE);
}

bool 
FoundList::SetNext(void)
{
	if(index < (Count() - 1)) {
		index++;
		return(TRUE);
	}
	return(FALSE);
}

bool 
FoundList::SetLast(void)
{
	if(index < (Count() - 1)) {
		index = Count() - 1;
		return(TRUE);
	}
	return(FALSE);
}


// ===============================================================
BEGIN_EVENT_TABLE(SearchDialog, wxDialog)
	EVT_BUTTON(BTN_ID_FIRST, SearchDialog::DoFirst)
	EVT_BUTTON(BTN_ID_PREV, SearchDialog::DoPrev)
	EVT_BUTTON(BTN_ID_NEXT, SearchDialog::DoNext)
	EVT_BUTTON(BTN_ID_LAST, SearchDialog::DoLast)
	EVT_BUTTON(BTN_ID_TRADE, SearchDialog::DoTrade)
	EVT_BUTTON(BTN_ID_SHORT, SearchDialog::DoShort)
	EVT_BUTTON(BTN_ID_RANGE, SearchDialog::DoRange)
	EVT_BUTTON(BTN_ID_DETAIL, SearchDialog::DoDetail)
	EVT_BUTTON(BTN_ID_LIST, SearchDialog::DoList)
	EVT_BUTTON(BTN_ID_PRINT, SearchDialog::DoPrint)
	EVT_BUTTON(BTN_ID_CLOSE, SearchDialog::DoClose)
	EVT_BUTTON(wxID_CANCEL, SearchDialog::DoClose)
END_EVENT_TABLE()

#define MAX_BUTTONS			4
// ---------------------------------------------------------------
SearchDialog::SearchDialog(wxWindow *p) :
		wxDialog(p, -1, "Delete this Title", 
			wxPoint(-1, -1), wxSize(550, 340), 
			wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
int i;
wxBitmap *bm[MAX_BITMAP_BTNS];
wxButton *btn2[MAX_BUTTONS];

	// simple initialization
	mins = new MinClass();
	maxs = new MaxClass();
	comp = new CompareClass();
	trades = other = system = 0l;
	mode = SEARCH_NONE;
	found = new FoundList();
	trade_dlg = NULL;
	short_dlg = NULL;
	range_dlg = NULL;
	print_dlg = NULL;
	max_sect = 0;
	detail = FALSE;
	sect = NULL;
	sectors = NULL;

#ifdef __WXMSW__
	bm[0] = new wxBitmap("icon1");
	bm[1] = new wxBitmap("icon2");
	bm[2] = new wxBitmap("icon3");
	bm[3] = new wxBitmap("icon4");
	bm[4] = new wxBitmap("icon5");
	bm[5] = new wxBitmap("icon6");
	bm[6] = new wxBitmap("icon7");
#else
	bm[0] = new wxBitmap(f_rev_xpm);
	bm[1] = new wxBitmap(rev_xpm);
	bm[2] = new wxBitmap(fwd_xpm);
	bm[3] = new wxBitmap(f_fwd_xpm);
	bm[4] = new wxBitmap(attr_xpm);
	bm[5] = new wxBitmap(mag_xpm);
	bm[6] = new wxBitmap(print_xpm);
#endif

	msg = new wxStaticText(this, -1, "Displaying 0 of xxxxxxxxxxxx");
	btn1[0] = new wxBitmapButton(this, BTN_ID_FIRST, *bm[0],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[1] = new wxBitmapButton(this, BTN_ID_PREV, *bm[1],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[2] = new wxBitmapButton(this, BTN_ID_NEXT, *bm[2],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[3] = new wxBitmapButton(this, BTN_ID_LAST, *bm[3],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[4] = new wxBitmapButton(this, BTN_ID_DETAIL, *bm[4],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[5] = new wxBitmapButton(this, BTN_ID_LIST, *bm[5],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	btn1[6] = new wxBitmapButton(this, BTN_ID_PRINT, *bm[6],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));

	btn2[0] = new wxButton(this, BTN_ID_TRADE, "Trade");
	btn2[1] = new wxButton(this, BTN_ID_SHORT, "Short");
	btn2[2] = new wxButton(this, BTN_ID_RANGE, "Range");
	btn2[3] = new wxButton(this, wxID_CANCEL, "Close");

	sys = new wxCheckBox(this, -1, "Check System Files (next pass)");

	for(i = 0;i < MAX_BITMAP_BTNS;i++)
		delete bm[i];

	text = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1), wxSize(100, 250), 
			wxTE_MULTILINE | wxTE_READONLY | wxTE_AUTO_SCROLL | wxVSCROLL);

	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    sizer_4->Add(btn1[0], 0, 0, 0);
    sizer_4->Add(btn1[1], 0, 0, 0);
    sizer_4->Add(btn1[2], 0, 0, 0);
    sizer_4->Add(btn1[3], 0, 0, 0);
    sizer_3->Add(sizer_4, 0, wxALL, DLG_OFFSET);
    sizer_5->Add(btn1[4], 0, wxALL, DLG_OFFSET);
    sizer_5->Add(btn1[5], 0, wxALL, DLG_OFFSET);
    sizer_5->Add(btn1[6], 0, wxALL, DLG_OFFSET);
    sizer_5->Add(msg, 0, wxALL | wxALIGN_CENTER_VERTICAL, DLG_OFFSET);
    sizer_3->Add(sizer_5, 1, 0, 0);
    sizer_1->Add(sizer_3, 0, 0, 0);
    sizer_2->Add(btn2[0], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(btn2[1], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(btn2[2], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(btn2[3], 0, wxALL, DLG_OFFSET);
    sizer_2->Add(sys, 1, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_1->Add(sizer_2, 0, wxEXPAND, 0);
    sizer_1->Add(text, 1, wxALL | wxEXPAND, DLG_OFFSET);
    SetAutoLayout(TRUE);
    SetSizer(sizer_1);
    sizer_1->Fit(this);
    sizer_1->SetSizeHints(this);
    Layout();
}

SearchDialog::~SearchDialog()
{
	delete mins;
	delete maxs;
	delete comp;
	delete found;
}

// ---------------------------------------------------------------
// these are the main entry points.....
void
SearchDialog::Search(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d)
{
	mode = SEARCH_NONE;
	sect = s;
	sectors = ul;
	codes = c;
	dirs = d;
	CheckSystem();
	ResetSearch();
	ReflectState();
	ShowModal();
	ResetSearch();
}

void 
SearchDialog::SearchTrade(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d)
{
	mode = SEARCH_NONE;
	sect = s;
	sectors = ul;
	codes = c;
	dirs = d;
	CheckSystem();
	ResetSearch();
	if(NULL == trade_dlg)
		trade_dlg = new SearchTradeDialog(this, codes);
	if(trade_dlg->GetTradeSearch(&trades, &system, &other)) {
		mode = SEARCH_TRADE;
		Search();
		ReflectState();
		ShowModal();
		ResetSearch();
	}
}

void 
SearchDialog::SearchRange(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d)
{
	mode = SEARCH_NONE;
	sect = s;
	sectors = ul;
	codes = c;
	dirs = d;
	CheckSystem();
	ResetSearch();
	if(NULL == range_dlg)
		range_dlg = new SearchRangeDialog(this);
	if(range_dlg->GetRangeSearch(mins, maxs, comp)) {
		mode = SEARCH_RANGE;
		Search();
		ReflectState();
		ShowModal();
		ResetSearch();
	}
}

void 
SearchDialog::SearchShort(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d)
{
	mode = SEARCH_NONE;
	sect = s;
	sectors = ul;
	codes = c;
	dirs = d;
	CheckSystem();
	ResetSearch();
	if(NULL == short_dlg)
		short_dlg = new SearchShortDialog(this);
	if(short_dlg->GetShortSearch(mins, maxs)) {
		mode = SEARCH_SHORT;
		Search();
		ReflectState();
		ShowModal();
		ResetSearch();
	}
}


// ---------------------------------------------------------------
void 
SearchDialog::CheckSystem()
{
	sys->SetValue(FALSE);
	if((sectors != NULL) && (sectors->Get3DSector() != NULL)) {
		sys->Show(FALSE);
	} else {
		sys->Show(TRUE);
	}
}

void 
SearchDialog::ResetSearch(void)
{
	found->Clear();
	
	mins->Reset();
	maxs->Reset();
	comp->Reset();
	trades = other = system = 0l;
	mode = SEARCH_NONE;
	text->Clear();
}

void
SearchDialog::ReflectState(void)
{
char *name,buff[120];
int i,sec_x,sec_y,x,y;
SearchDisplay *sd;
BaseSector *s;

	if(sect != NULL) {
		name = sect->GetName();
	} else if(sectors != NULL) {
		name = sectors->GetDesc();
	} else {
		name = "";
	}
	switch(mode) {
		case SEARCH_NONE:
			sprintf(buff, "Search (%s)", name);
			break;
		case SEARCH_RANGE:
			sprintf(buff, "Range Search (%s)", name);
			break;
		case SEARCH_TRADE:
			sprintf(buff, "Trade Search (%s)", name);
			break;
		case SEARCH_SHORT:
			sprintf(buff, "Short Search (%s)", name);
			break;
	}
	SetTitle(buff);

	if(found->Count() < 1) {
		for(i = 0;i < MAX_BITMAP_BTNS;i++)
			btn1[i]->Enable(FALSE);
		sprintf(buff, "No worlds found!");
	} else {
		for(i = 0;i < MAX_BITMAP_BTNS-2;i++)
			btn1[i]->Enable(detail);
		btn1[5]->Enable(!detail);
		btn1[6]->Enable(TRUE);
		if(detail) {
			if(found->GetIndex() < 1) {
				btn1[0]->Enable(FALSE);
				btn1[1]->Enable(FALSE);
			}
			if(found->GetIndex() >= (found->Count() - 1)) {
				btn1[2]->Enable(FALSE);
				btn1[3]->Enable(FALSE);
			}
			sprintf(buff, "Displaying %ld of %d", found->GetIndex() + 1,
					found->Count());
		} else {
			sprintf(buff, "Displaying %d", found->Count());
		}
	}
	msg->SetLabel(buff);

	sd = new SearchDisplay(text);
	text->Clear();
	sd->Start();

	if(detail) {
		int z,orbs[4];
		HexData *hd=NULL;

		name = NULL;
		found->GetCurrent(&sec_x, &sec_y, &x, &y, &z,
					&orbs[0], &orbs[1], &orbs[2], &orbs[3]);
		if(found->GetCurrentType() == FT_NORMAL) {
			if(sect != NULL) {
				s = sect;
			} else if(sectors != NULL) {
				s = sectors->GetSector(sec_x, sec_y);
			}
			if(s != NULL) {
				hd = s->GetHex(x, y);
				name = s->GetName();
				sd->DrawDetail(hd, codes, name);
			}
		} else {
			sd->DrawSystemDetail(found->GetCurrent(), codes, NULL, NULL);
		}
	} else {
		sd->Draw(FALSE, found, dirs, codes, sect, sectors, max_sect);
	}
	delete sd;
}

bool
SearchDialog::Search(void)
{
bool ret=FALSE;

	wxBeginBusyCursor();
	if(sect != NULL)
		// NOTE: if this is the case, the dirs should be left alone.
		ret = Search(-1, -1, sect);
	else if(sectors->Get3D()){
		ret = Search3D();
	} else {
		SectorData *sd;
		SectorList *sl;
		ListNode *n;

		sl = sectors->GetSectors();
		n = sl->First();
		while(n != NULL) {
			BaseSector *bs;

			sd = (SectorData *)n->Data();
			if(sd->GetSector() != NULL) {
				bs = sd->GetSector();
				if((bs != NULL) && (bs->GetName() != NULL)) {
//					dirs->SetSect(sd->GetFileName());
//fprintf(stderr, "checking <%s>: %d\n", sd->GetSector()->GetName(),
//	strlen(sd->GetSector()->GetName()));
					// format helper
					if((int) strlen(bs->GetName()) > max_sect) {
						max_sect = (int) strlen(bs->GetName());
//fprintf(stderr, "max_sect now %d\n", max_sect);
					}
				}
				if(Search(sd->GetX(), sd->GetY(), sd->GetSector()))
					ret = TRUE;
//				dirs->ClearSect();
			}
			n = sl->Next();
		}
	}

	wxEndBusyCursor();
	if(!ret) {
		wxMessageBox("No Worlds Found.", "Search Error", 
			wxCENTRE | wxOK | wxICON_EXCLAMATION);
		mode = SEARCH_NONE;
	}

	return(ret);
}

bool 
SearchDialog::Search(int u_x, int u_y, BaseSector *s)
{
bool ret=FALSE;
char buffer[MAX_FILE_LEN];
int x,y,i;
HexData *hd;
FoundEntry *fe;
#ifdef DEBUG_SEARCH_0
bool f1, f2, f3, f4, f5, f6;

fprintf(stderr, "=======================\n");
fprintf(stderr, "Searching %s (%d %d)\n", s->GetName(), u_x, u_y);
#endif

	strcpy(buffer, s->GetSecName());
	dirname(buffer);
	for(x = 0; x < MAX_X_HEX;x++) {
		for(y = 0; y < MAX_Y_HEX;y++) {
			if(((hd = s->GetHex(x, y)) != NULL) && (hd->world != NULL)) {
				BaseStar *stars[3];
				char filename[MAX_FILE_LEN];

				for(i = 0;i < 3;i++)
					stars[i] = hd->world->GetStar(i);
#ifdef DEBUG_SEARCH_0
fprintf(stderr, "(%d %d): ", x, y);
				f1 = mins->Ok(hd->world);
				f2 = maxs->Ok(hd->world);
				f3 = mins->Ok(hd->world->GetPopNdx(), hd->world->GetNumBelts(),
							hd->world->GetNumGG(), stars);
				f4 = maxs->Ok(hd->world->GetPopNdx(), hd->world->GetNumBelts(),
							hd->world->GetNumGG(), stars);
				f5 = comp->Ok(hd->world);
				f6 = TradeOk(hd->world);
fprintf(stderr, " %d%d%d%d%d%d\n", f1, f2, f3, f4, f5, f6);
#endif
				if((mins->Ok(hd->world)) && (maxs->Ok(hd->world)) &&
					(mins->Ok(hd->world->GetPopNdx(), hd->world->GetNumBelts(),
							hd->world->GetNumGG(), stars)) &&
					(maxs->Ok(hd->world->GetPopNdx(), hd->world->GetNumBelts(),
							hd->world->GetNumGG(), stars)) &&
					(comp->Ok(hd->world)) && (TradeOk(hd->world))) {
					ret = TRUE;
					fe = new FoundEntry(u_x, u_y, x, y);					
					found->Append(fe);
				}
				if(sys->GetValue()) {
					sprintf(filename, "%s/sys/%02d%02d.sys", buffer, 
								x + 1, y + 1);
					if(SearchSystemFile(filename, FALSE, u_x, u_y, x, y, -1))
						ret = TRUE;
				}
			}
		}
	}

	return(ret);
}

bool
SearchDialog::Search3D(void)
{
bool ret=FALSE;
int x,y,z;
Sector3D *s;

	if((s = sectors->Get3DSector()) != NULL) {
		ListNode *n;
		Star3D *star;
		char buffer[MAX_FILE_LEN],filename[MAX_FILE_LEN];

		strcpy(buffer, s->GetFileName());
		dirname(buffer);
		n = s->First();
		while(n != NULL) {
			star = (Star3D *)n->Data();
			x = star->GetX();
			y = star->GetY();
			z = star->GetZ();

			sprintf(filename, "%s/sys/x%dy%dz%d.sys", buffer, x, y, z);
			if(SearchSystemFile(filename, TRUE, -1, -1, x, y, z))
				ret = TRUE;
			n = s->Next();
		}
	}

	return(ret);
}

bool
SearchDialog::SearchSystemFile(char *name, bool for_3d, int u_x, int u_y, 
				int x, int y, int z)
{
bool stat=FALSE;
char buff1[MAX_FILE_LEN];
int b=0,g=0;
System *sys;
BaseStar *bs[3] = { NULL, NULL, NULL };
PrimOrbit *po;

	sys = new System(codes);
// XXX	dirs->GetSysDir(buff);
	sprintf(buff1, "%s", name);
	sys->LoadFile(buff1);

//fprintf(stderr, "<%s> (%d %d) (%d %d %d)\n", buff1, u_x, u_y, x, y, z);
	po = sys->GetPrimOrbit();
	if(po != NULL) {
		SearchSystem1(po, bs, &b, &g);
		if(SearchSystem2(po, bs, b, g, for_3d, u_x, u_y, x, y, z))
			stat = TRUE;
	}

	delete sys;
	return(stat);
}

// first pass, total gg's, belts, and grab primary and companion stars
void
SearchDialog::SearchSystem1(BaseOrbit *bo, BaseStar *bs[],
				int *belts, int *gg)
{
int orb=0;
BaseOrbit *lbo;

	switch(bo->GetEnumType()) {
		case OT_STAR:
			if(bo->GetOrbMask() & (ORBIT_IS_PRIMARY | ORBIT_ORBITS_PRIMARY)) {
				int i;
				StarOrbit *so;

				so = (StarOrbit *)bo;
				for(i = 0;i < 3;i++) {
					if(NULL == bs[i]) {
						bs[i] = so->GetStar();
						break;
					}
				}
			}
			break;
		case OT_GG:
			(*gg)++;
			break;
		case OT_BELT:
			(*belts)++;
		default:
			break;
	}

	while((lbo = bo->GetNthOrbit(orb)) != NULL) {
		SearchSystem1(lbo, bs, belts, gg);
		orb++;
	}
}

// second pass, now we do the real checks
bool
SearchDialog::SearchSystem2(BaseOrbit *bo, BaseStar *bs[], int belts, int gg,
			bool for_3d, int u_x, int u_y, int x, int y, int z)
{
bool stat=FALSE;
int orb=0;
BaseOrbit *lbo;
planet *p=NULL;

	switch(bo->GetEnumType()) {
		case OT_BELT:
		case OT_WORLD:
			p = ((WorldOrbit *)bo)->GetWorld();
			break;
		case OT_SATILLITE:
			p = ((SatOrbit *)bo)->GetSat();
			break;
		default:
			break;
	}

	if(p != NULL) {
		if((mins->Ok(p)) && (maxs->Ok(p)) && (mins->Ok(0, belts, gg, bs)) &&
				(maxs->Ok(0, belts, gg, bs)) && (comp->Ok(p)) && 
				(TradeOk(p, p->GetSysFlags()))) {
			int orbs[4];

			stat = TRUE;
			bo->GetOrbitArray(orbs);
			if(for_3d) {
				Found3DEntry *f3;

				f3 = new Found3DEntry(x, y, z, orbs[0], orbs[1], orbs[2],
						orbs[3], p, 0, belts, gg, bs);
				found->Append(f3);
			} else {
				FoundSystemEntry *fs;

				fs = new FoundSystemEntry(u_x, u_y, x, y,
						orbs[0], orbs[1], orbs[2], orbs[3], p, 0, belts, gg,bs);
				found->Append(fs);
			}
		}
	}

	while((lbo = bo->GetNthOrbit(orb)) != NULL) {
		if(SearchSystem2(lbo, bs, belts, gg, for_3d, u_x, u_y, x, y, z))
			stat = TRUE;
		orb++;
	}

	return(stat);
}

// -------------------------------------------------------------------------
bool
SearchDialog::TradeOk(base_planet *mw, unsigned long sys_flags)
{
bool ret=TRUE;

#ifdef DEBUG_SEARCH_3
fprintf(stderr, "3:T%x(%x)O%x(%x)S%x(%x)",
		mw->GetTradeCodes(), trades,
		mw->GetOtherCodes(), other,
		sys_flags, system);
#endif
	if(trades != 0l) {
		if((mw->GetTradeCodes() & trades) != trades)
			ret = FALSE;
	}

	if(other != 0l) {
		if((mw->GetOtherCodes() & other) != other)
			ret = FALSE;
	}

	if(system != 0l) {
		if((sys_flags & system) != system)
			ret = FALSE;
	}

	return(ret);
}

// ---------------------------------------------------------------
void 
SearchDialog::DoFirst(wxCommandEvent &event)
{
	if(found->SetFirst())
		ReflectState();
}

void 
SearchDialog::DoPrev(wxCommandEvent &event)
{
	if(found->SetPrev())
		ReflectState();
}

void 
SearchDialog::DoNext(wxCommandEvent &event)
{
	if(found->SetNext())
		ReflectState();
}

void 
SearchDialog::DoLast(wxCommandEvent &event)
{
	if(found->SetLast())
		ReflectState();
}

void 
SearchDialog::DoDetail(wxCommandEvent &event)
{
	detail = FALSE;
	ReflectState();
}

void 
SearchDialog::DoList(wxCommandEvent &event)
{
	detail = TRUE;
	ReflectState();
}

void 
SearchDialog::DoPrint(wxCommandEvent &event)
{
	if(NULL == print_dlg)
		print_dlg = new SearchPrintDialog(this);

	print_dlg->DoPrint(detail, found, dirs, sect, sectors, codes, max_sect);
}

void 
SearchDialog::DoTrade(wxCommandEvent &event)
{
	ResetSearch();
	if(NULL == trade_dlg)
		trade_dlg = new SearchTradeDialog(this, codes);
	if(trade_dlg->GetTradeSearch(&trades, &system, &other)) {
		mode = SEARCH_TRADE;
		Search();
		ReflectState();
	}
}

void 
SearchDialog::DoShort(wxCommandEvent &event)
{
	ResetSearch();
	if(NULL == short_dlg)
		short_dlg = new SearchShortDialog(this);
	if(short_dlg->GetShortSearch(mins, maxs)) {
		mode = SEARCH_SHORT;
		Search();
		ReflectState();
	}
}

void 
SearchDialog::DoRange(wxCommandEvent &event)
{
	ResetSearch();
	if(NULL == range_dlg)
		range_dlg = new SearchRangeDialog(this);
	if(range_dlg->GetRangeSearch(mins, maxs, comp)) {
		mode = SEARCH_RANGE;
		Search();
		ReflectState();
	}
}

void 
SearchDialog::DoClose(wxCommandEvent &event)
{
	EndModal(wxID_CANCEL);
	Show(FALSE);
}

// this is kinda hideous, but there is no good way for a DisplayMethod
//	to know this stuff......
int 
SearchDialog::DrawHeader(SearchDisplay *sd)
{
char buff[120];
unsigned long t;
int i;
char *ptr1;
char lbuff[20];
int ret_count=0;

	switch(mode) {
		case SEARCH_RANGE: {
			sprintf(buff, "Search for Ranges (%d worlds):", found->Count());
			sd->Line(buff);
			sd->Line("UWP     Min Max    Stars:  Min  Max");
			for(i = 0;i < 10;i++) {
				sprintf(buff, RangeHeaderStr[i]);
				strfixsize(buff, 8);
				strcat(buff, range_dlg->GetChoiceStr(FALSE, i));
				strfixsize(buff, 12);
				strcat(buff, range_dlg->GetChoiceStr(TRUE, i));
				strfixsize(buff, 19);
				if(i < 4) {
					strcat(buff, RangeHeaderStr[i+10]);
					strfixsize(buff, 27);
					strcat(buff, range_dlg->GetChoiceStr(FALSE, i+10));
					strfixsize(buff, 32);
					strcat(buff, range_dlg->GetChoiceStr(TRUE, i+10));
				}
				else if(i == 5) {
					strcat(buff, "Bases:");
					strfixsize(buff, 27);
					lbuff[0] = comp->GetBases();
					lbuff[1] = 0;
					strcat(buff, lbuff);
				}
				else if(i == 6) {
					strcat(buff, "Zone:");
					strfixsize(buff, 27);
					lbuff[0] = comp->GetZone();
					lbuff[1] = 0;
					strcat(buff, lbuff);
				}
				else if(i == 7) {
					strcat(buff, "Bases:");
					strfixsize(buff, 27);
					ptr1 = comp->GetAlleg();
					if(ptr1 != NULL)
						strcat(buff, ptr1);
				}

				sd->Line(buff);
			}
			ret_count = 12;
			break;
		}
		case SEARCH_TRADE: {
			// XXX need other!!!
			sprintf(buff, "Search for Trade Codes (%d worlds):",
					found->Count());
			sd->Line(buff);
			ret_count = 1;
			t = 1;
			for(i = 0;i < MAX_TRADE_CB;i++) {
				if(t & trades) {
					sd->FormatCode(codes->GetTradeTable(), t, buff);
					sd->Line(buff);
					ret_count++;
				}
				t *= 2;
			}
			sd->Line(" ");
			ret_count++;
			break;
		}
		case SEARCH_SHORT: {
			sprintf(buff, "Search for Simple Codes (%d worlds):",
					found->Count());
			sd->Line(buff);
			for(i = 0;i < 8;i++) {
				sprintf(buff, "%s %s", 
							short_dlg->GetHeaderStr(i).c_str(),
							short_dlg->GetChoiceStr(i).c_str());
				sd->Line(buff);
			}
			ret_count = 9;
			break;
		}
		case SEARCH_NONE:
			// ????
			break;
	}
	sd->Line("========================");
	sd->Line(" ");
	ret_count += 2;

	return(ret_count);
}

int 
SearchDialog::GetHeaderCount(void)
{
int ret_count=0;
unsigned long t;
int i;

	switch(mode) {
		case SEARCH_RANGE:
			ret_count = 12;
			break;
		case SEARCH_TRADE:
			// XXX need other!!!
			ret_count = 1;
			t = 1;
			for(i = 0;i < MAX_TRADE_CB;i++) {
				if(t & trades)
					ret_count++;
				t *= 2;
			}
			ret_count++;
			break;
		case SEARCH_SHORT:
			ret_count = 9;
			break;
		case SEARCH_NONE:
			// ????
			break;
	}
	ret_count += 2;
	
	return(ret_count);
}

// number of lines of detail
int
SearchDialog::GetLineCount(void)
{
	return(23);
}

// ===============================================================
BEGIN_EVENT_TABLE(SearchPrintDialog, wxDialog)
	EVT_BUTTON(BTN_ID_SETUP, SearchPrintDialog::DoSetup)
END_EVENT_TABLE()

// ---------------------------------------------------------------
SearchPrintDialog::SearchPrintDialog(wxWindow *p) :
		StdDialog(p, "Search Print")
{
wxButton *btn;
wxBoxSizer *main_sizer;

	setup_dialog = NULL;
	to_file = new wxCheckBox(this, -1, "Print to file");
	headers = new wxCheckBox(this, -1, "Print headers");
	detail = new wxCheckBox(this, -1, "Print details");
	btn = new wxButton(this, BTN_ID_SETUP, "Setup",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));

	main_sizer = new wxBoxSizer(wxVERTICAL);
    main_sizer->Add(to_file, 0, wxALL, DLG_OFFSET / 2);
    main_sizer->Add(headers, 0, wxALL, DLG_OFFSET / 2);
    main_sizer->Add(detail, 0, wxALL, DLG_OFFSET / 2);
    main_sizer->Add(btn, 0, wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

SearchPrintDialog::~SearchPrintDialog()
{
}

// ---------------------------------------------------------------
void 
SearchPrintDialog::DoSetup(wxCommandEvent &event)
{
	if(setup_dialog == NULL)
#ifdef __WXMSW__
		setup_dialog = new wxPrintDialog(this, & p_data);
#else
		setup_dialog = new wxGenericPrintDialog(this, & p_data);
#endif
	setup_dialog->GetPrintDialogData().SetSetupDialog(TRUE);
	setup_dialog->ShowModal();
}

void 
SearchPrintDialog::DoPrint(bool d, FoundList *f, MTUFile *dirs,
					BaseSector *s, UListData *ul, TCodes *c, int max_sect)
{
	detail->SetValue(d);
	if(wxID_CANCEL == ShowModal())
		return;

	if(to_file->GetValue()) {
		char *ptr;
		SearchDisplay *sd;
		FILE *fpx;
		wxString str;

		str = wxFileSelector("Print To", NULL, NULL, NULL, 
					"*.txt", wxHIDE_READONLY | wxSAVE | wxOVERWRITE_PROMPT, 
					this);
		ptr = (char *)str.GetData();
		if((NULL == ptr) || (0 == ptr[0]))
			return;

		if((fpx = fopen(ptr, "a+")) == NULL)
			return;

		sd = new SearchDisplay(fpx);
		if(headers->GetValue()) {
			SearchDialog *parent;

			parent = (SearchDialog *)GetParent();
			parent->DrawHeader(sd);
		}
		sd->Draw(detail->GetValue(), f, dirs, c, s, ul, max_sect);
		delete sd;
	} else {
		SearchPrintout *print_out;
		wxPrinter *printer;

		print_out = new SearchPrintout((SearchDialog *)GetParent(), 
			detail->GetValue(), headers->GetValue(), f, dirs,
			s, ul, c, max_sect);
		printer = new wxPrinter();
		printer->Print(GetParent(), print_out, TRUE);

		delete printer;
		delete print_out;
	}
}

// ===============================================================
#define LINES_PER_PAGE	90
SearchPrintout::SearchPrintout(SearchDialog *p, bool d, bool h, FoundList *f, 
				MTUFile *di, BaseSector *s, UListData *ul, TCodes *c, int m) :
		wxPrintout()
{
int count,lines_per_world,worlds_per_page,worlds_page1;

	parent = p;
	detail = d;
	headers = h;
	cur_count = 0;
	fl = f;
	dirs = di;
	bs = s;
	uld = ul;
	codes = c;
	max_sect = m;

	count = p->GetCount();
	if(detail)
		lines_per_world = p->GetLineCount();
	else
		lines_per_world = 1;

	worlds_per_page = LINES_PER_PAGE /  lines_per_world;

	page_max = 0;
	if(headers) {
		// need to recalc for page 1
		worlds_page1 = (LINES_PER_PAGE - p->GetHeaderCount()) / lines_per_world;
		count -= worlds_page1;
//		worlds_per_page -= worlds_page1;
		page_max = 1;
	}
	page_max += count / worlds_per_page;
	if(count % worlds_per_page)
		page_max++;

//fprintf(stderr, "c:%d d:%d lpw:%d wpp:%d wp1:%d max:%d\n",
//	count,detail,lines_per_world,worlds_per_page,worlds_page1, page_max);
}

SearchPrintout::~SearchPrintout()
{
}

bool
SearchPrintout::HasPage(int page)
{
	if(page <= page_max) 
		return(TRUE);
	return(FALSE);
}

void
SearchPrintout::GetPageInfo(int *minPage, int *maxPage, int
							*selPageFrom, int *selPageTo)
{
	*minPage = *selPageFrom = 1;
	*maxPage = *selPageTo = page_max;
}

bool
SearchPrintout::OnPrintPage(int page)
{
bool ret=FALSE;
wxDC *dc;

	dc = GetDC();
	if (dc) {
		char buff[120];
		int line_count=0,temp_count=0,w,h,a_h,a_w;
		float scale;
		SearchDisplay *sd;

		dc->GetSize(&w, &h);

		// should this be only for ps?
		a_h = h - 55;
		a_w = w - 35;

		sd = new SearchDisplay(dc, 60, 20);
		sprintf(buff, "Page %d of %d", page, page_max);

		scale = (float) a_h / (float) (LINES_PER_PAGE * TEXT_Y_INCR);
//fprintf(stderr, "h:%d d:%d --> %f\n", a_h, (LINES_PER_PAGE * TEXT_Y_INCR),
//	scale);

		dc->SetUserScale(scale, scale);

		if((1 == page) && (headers)) {
			line_count = parent->DrawHeader(sd);
		}

		if(detail)
			temp_count = LINES_PER_PAGE / parent->GetLineCount();
		else
			temp_count = LINES_PER_PAGE;

		temp_count -= line_count;

		cur_count += sd->Draw(detail, fl, dirs, codes, bs, uld, max_sect,
					cur_count, temp_count);

//fprintf(stderr, "page %d(%d): lc:%d tc:%d cur_count:%d s:%f\n",
//	page, detail, line_count, temp_count, cur_count, scale);

		sd->Line(buff);

		delete sd;
		ret = TRUE;
	}
	return(ret);
}

// ===============================================================
int 
SearchDisplay::Draw(bool detail, FoundList *f, MTUFile *dirs, TCodes *codes, 
		BaseSector *s, UListData *uld, int max_sect, int start, int count)
{
char *sect_name=NULL;
int i=0,tot=0,sec_x,sec_y,x,y;
int z,orbs[4];
int last_x=-1,last_y=-1;
BaseSector *bs;
BaseFound *bf;
ListNode *n;

//fprintf(stderr, "--->max_sect:%d\n", max_sect);
	if(max_sect > 0)
		sect_name = new char[max_sect + 2];
	bs = s;					// default
	n = f->First();
	while(n != NULL) {
		bf = (BaseFound *)n->Data();
		bf->GetValues(&sec_x, &sec_y, &x, &y, &z,
					&orbs[0], &orbs[1], &orbs[2], &orbs[3]);
		if((last_x != sec_x) || (last_y != sec_y)) {
			if(uld != NULL) {
				bs = uld->GetSector(sec_x, sec_y);
				if(sect_name != NULL) {
					sprintf(sect_name, "%s:", bs->GetName());
					strfixsize(sect_name, max_sect + 1);
				}
			}
			last_x = sec_x;
			last_y = sec_y;
		}
		if((i >= start) && ((count < 0) || (i <= (start + count)))) {
			switch(bf->GetType()) {
				case FT_NORMAL: {
					if(detail) {
						HexData *hd=NULL;

						if(bs != NULL)
							hd = bs->GetHex(x, y);
						DrawDetail(hd, codes, sect_name);
					} else
						DrawLine(bs, x, y, sect_name);
					tot++;
					break;
				}
				case FT_3D: {
					char buff[120],buff1[256];
					Sector3D *sect3d;

					if((sect3d = uld->Get3DSector()) != NULL) {
						if(detail) {
							DrawSystemDetail(bf, codes, sect_name, NULL);
						} else {
							DetailStar *ds;
							Star3D *star;

							if(sect_name != NULL)
								sprintf(buff1, "%s", sect_name);
							else 
								buff1[0] = 0;
							sprintf(buff, " x%0d.%0d y%0d.%0d z%0d.%0d ",
								x / 10, x % 10, y / 10, y % 10, z / 10, z % 10);
							strcat(buff1, buff);
							if(((star = sect3d->Find(x, y, z)) != NULL) && 
									((ds = star->GetStar(0)) != NULL)) {
								ds->GetName(buff);
								strcat(buff1, buff);
							}
							FormatSystemOrbit(buff, orbs);
							strcat(buff1, buff);

							Line(buff1);
						}
	
						tot++;
					}
					break;
				}
				case FT_SYSTEM: {
					char buff[120],buff1[256],*l_name=NULL;
					HexData *hd=NULL;

					buff1[0] = 0;
					if(bs != NULL) {
						hd = bs->GetHex(x, y);
						if((hd != NULL) && (hd->world != NULL))
							l_name = hd->world->GetName();
					}
					if(detail) {
						DrawSystemDetail(bf, codes, sect_name, l_name);
					} else {
						if(sect_name != NULL)
							strcat(buff1, sect_name);
							strcat(buff1, " ");
						if(l_name != NULL) {
							strcat(buff1, l_name);
							strcat(buff1, " ");
						}
						sprintf(buff, "%02d%02d", x + 1, y + 1);
						strcat(buff1, buff);
						FormatSystemOrbit(buff, orbs);
						strcat(buff1, buff);

						Line(buff1);
					}
					tot++;
					break;
				}
			}
		}

		// NOTE:  detail doesn't come through here unless it's for
		//        the print out.....
		if(detail) {
			Line("------------------------");
			Line(" ");
		}
		i++;
		n = f->Next();
	}

	if(sect_name != NULL)
		delete sect_name;
	
	return(tot);
}

void 
SearchDisplay::FormatSystemOrbit(char *buff, int *orbs)
{
char lbuff[24];
int j;

	buff[0] = 0;
	for(j = 0;j < 4;j++) {
		if(orbs[j] >= 0) {
			sprintf(lbuff, ":%0d.%0d", orbs[j] / 10, orbs[j] % 10);
			strcat(buff, lbuff);
		} else 
			break;
	}
}

int 
SearchDisplay::DrawSystemDetail(BaseFound *bf, TCodes *c, char *sect_name, 
				char *l_name)
{
char buff[120],buff1[256];
int ret=0;
int sec_x, sec_y,x,y,z,orbs[SEARCH_ORBS],pop_ndx,gg,belts;
BaseStar *st[SEARCH_STARS];
planet *p;

	bf->GetValues(&sec_x, &sec_y, &x, &y, &z, &orbs[0], &orbs[1], &orbs[2],
			&orbs[3]);
	p = bf->GetPlanet();
	bf->GetSysInfo(&pop_ndx, &belts, &gg, st);

	if(sect_name != NULL)
		sprintf(buff1, "Location:  %s:", sect_name);
	else
		sprintf(buff1, "Location:  ");
	if(l_name != NULL) {
		strcat(buff1, l_name);
		strcat(buff1, ":");
	}

	if(bf->GetType() == FT_3D) {
		sprintf(buff, "x%0d.%0d y%0d.%0d z%0d.%0d ",
			x / 10, x % 10, y / 10, y % 10, z / 10, z % 10);
		strcat(buff1, buff);
	} else {
		sprintf(buff, "%02d%02d", x + 1, y + 1);
		strcat(buff1, buff);
	}
	ret++;
	FormatSystemOrbit(buff, orbs);
	strcat(buff1, buff);
	Line(buff1);

	ret += DrawBaseDetail(p, c);
	sprintf(buff, "%c", p->GetBase());
	ret += DrawCode("   Bases:", c->GetBaseTable(), buff);
	ret += DrawCode("   Trade:", c->GetTradeTable(), p->GetTradeCodes());
	ret += DrawCode("   Other:", c->GetOtherTable(), p->GetOtherCodes());
	ret += DrawCode("  System:", c->GetSystTable(), p->GetSysFlags());
	ret += DrawZone(p->GetZone());
	ret += DrawCode("   Alleg:", c->GetAllegTable(), p->GetAlleg());
	ret += DrawOtherDetail(pop_ndx, gg, belts);
	ret = 1 + DrawStarDetail(st[0], st[1], st[2]);

	return(ret);
}

