// File:        sg_cmd.cpp
// Purpose:     commands between sectgen and sysgen
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: sg_cmd.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"

#include "sg_cmd.h"
#include "wx/msgdlg.h"

#define SOCKET_BUFFER_SIZE		512

//#define DEBUG_SOCK
#ifdef DEBUG_SOCK
#define CLIENT_STRING "Client: "
#define SERVER_STRING "Server: "
#endif

// ===========================================================================
struct Responses
{
	RESPONSE_COMMANDS	cmd;
	char				*str;
};

struct Responses resp[] = {
	{ RCMD_NAME, "Name:" },
	{ RCMD_UWP, "UWP:" },
	{ RCMD_GG, "GG:" },
	{ RCMD_BELTS, "Belts:" },
	{ RCMD_STAR, "Stars:" },
	{ RCMD_DONE, "Done" },
	{ RCMD_ERROR, NULL }
};

// ===========================================================================
GenServer::GenServer(wxWindow *p, int id, int cport)
{
char buffer[256];
wxIPV4address addr;

	sock = NULL;
#ifdef DEBUG_SOCK
	fprintf(stderr, "%sYes, we're a server (%d).\n", SERVER_STRING, cport);
#endif
	addr.Service(cport);
	server = new wxSocketServer(addr);
	if(!server->Ok()) {
		sprintf(buffer, "Cannot connect port %d on host %s!  Quitting.",
			cport, "localhost");
		wxMessageBox(buffer, "Sysgen Alert !", wxCENTRE | wxICON_EXCLAMATION);
		delete server;
		server = NULL;
    	return;
  	}

	server->SetEventHandler(*p, id);
	server->SetNotify(wxSOCKET_CONNECTION_FLAG);
	server->Notify(TRUE);
}

GenServer::~GenServer()
{
#ifdef DEBUG_SOCK
	fprintf(stderr, "%sGoing away.\n", SERVER_STRING);
#endif
	if(server != NULL)
		delete server;
}

bool 
GenServer::HandleServerEvent(wxWindow *p, int id, wxSocketEvent& event)
{
wxSocketBase *s;

#ifdef DEBUG_SOCK
	fprintf(stderr, "%sOnServerEvent().\n", SERVER_STRING);
#endif
	if(event.GetSocketEvent() != wxSOCKET_CONNECTION) {
		wxMessageBox("Unexpected socket event, quiting", "Sysgen Alert !", 
			wxCENTRE | wxICON_EXCLAMATION);
		return(FALSE);
	}

	s = server->Accept(FALSE);

	if(NULL == s) {
		wxMessageBox("Couldn't eccept a new connection.", "Sysgen Alert !", 
			wxCENTRE | wxICON_EXCLAMATION);
		return(FALSE);
	}

	s->SetEventHandler(*p, id);
	s->SetNotify(wxSOCKET_INPUT_FLAG | wxSOCKET_LOST_FLAG);
	s->Notify(TRUE);
	return(TRUE);
}

PRIMARY_COMMANDS 
GenServer::GetCommand(wxSocketEvent& event)
{
#ifdef DEBUG_SOCK
	fprintf(stderr, "%sGetCommand(P)", SERVER_STRING);
#endif
	sock = event.GetSocket();
	switch(event.GetSocketEvent()) {
		case wxSOCKET_INPUT: {
			unsigned char c;

			sock->SetNotify(wxSOCKET_LOST_FLAG);
			sock->Read(&c, 1);

#ifdef DEBUG_SOCK
	fprintf(stderr, " command 0x%x.\n", c);
#endif

			sock->SetNotify(wxSOCKET_LOST_FLAG | wxSOCKET_INPUT_FLAG);
			return((PRIMARY_COMMANDS) c);
			break;
		}
	}
#ifdef DEBUG_SOCK
	fprintf(stderr, " ERROR\n");
	exit(-1);
#endif
	return(PCMD_ERROR);
}

SYSTEM_GEN_COMMANDS
GenServer::GetCommand(void)
{
unsigned char c;

#ifdef DEBUG_SOCK
	fprintf(stderr, "%sGetCommand(S)", SERVER_STRING);
#endif
	sock->Read(&c, 1);
#ifdef DEBUG_SOCK
	fprintf(stderr, " command 0x%x.\n", c);
#endif
	return((SYSTEM_GEN_COMMANDS) c);
}

void 
GenServer::SendGG(int g)
{
char lbuff[5];

	sprintf(lbuff, "%d", g);
	SendResp(RCMD_GG, lbuff);
}

void 
GenServer::SendBelts(int b)
{
char lbuff[5];

	sprintf(lbuff, "%d", b);
	SendResp(RCMD_BELTS, lbuff);
}

void 
GenServer::SendResp(RESPONSE_COMMANDS cmd, char *str)
{
char buff[SOCKET_BUFFER_SIZE];

#ifdef DEBUG_SOCK
	fprintf(stderr, "%sSendResp() c:0x%x", SERVER_STRING, cmd);
	if(str != NULL) fprintf(stderr, " <%s>", str);
	fprintf(stderr, "\n");
#endif
	if(str != NULL)
		sprintf(buff, "%s%s\n", resp[cmd - RCMD_NAME].str, str);
	else
		sprintf(buff, "%s\n", resp[cmd - RCMD_NAME].str);
	sock->WriteMsg(buff, strlen(buff));
}

void 
GenServer::GrabParam(char **dest)
{
char buff[SOCKET_BUFFER_SIZE];
size_t len;

	if(*dest != NULL) {
		delete *dest;
		*dest = NULL;
	}

	len = sock->ReadMsg(buff, SOCKET_BUFFER_SIZE).LastCount();
	buff[len-1] = 0;		// there is a new-line
	len = strlen(buff);
#ifdef DEBUG_SOCK
	fprintf(stderr, "%sGrabParam(): (%d) ", SERVER_STRING, len);
#endif
	*dest = new char[len + 1];
	strcpy(*dest, buff);
#ifdef DEBUG_SOCK
	fprintf(stderr, "<%s>\n", *dest);
#endif
}


// ===========================================================================
GenClient::GenClient(wxWindow *p, int id, int c_port)
{
wxIPV4address addr;

#ifdef DEBUG_SOCK
	fprintf(stderr, "%s (%d)\n", CLIENT_STRING, c_port);
#endif
	sock = new wxSocketClient();
	sock->SetEventHandler(*p, id);
	sock->SetNotify(wxSOCKET_CONNECTION_FLAG |
			wxSOCKET_INPUT_FLAG | wxSOCKET_LOST_FLAG);
	sock->Notify(TRUE);

	addr.Hostname("localhost");			// always runs local
	addr.Service(c_port);
	sock->Connect(addr, FALSE);
	sock->WaitOnConnect(10);

	if(!sock->IsConnected()) {
		char buff[SOCKET_BUFFER_SIZE];

		sock->Close();
		sprintf(buff, "Cannot connect port %d on host %s!  Quitting.",
			c_port, "localhost");
		wxMessageBox(buff, "Secgen Alert !", wxCENTRE | wxICON_EXCLAMATION);
	}
}

GenClient::~GenClient()
{
#ifdef DEBUG_SOCK
	fprintf(stderr, "%sGoing away.\n", CLIENT_STRING);
#endif
	if(sock != NULL) {
		sock->Close();
		delete sock;
	}
}

void 
GenClient::WriteCmd(char pc, char *str)
{
char buff[SOCKET_BUFFER_SIZE];

#ifdef DEBUG_SOCK
	fprintf(stderr, "%sWriteCmd() 0x%x: ", CLIENT_STRING, pc);
	if(str != NULL) fprintf(stderr, "<%s>", str);
	fprintf(stderr, "\n");
#endif
	sprintf(buff, "%c", pc);
	sock->Write(buff, 1);
	if(str != NULL) {
		sprintf(buff, "%s\n", str);
		sock->WriteMsg(buff, strlen(buff));
	}
}

RESPONSE_COMMANDS
GenClient::ReadResponse(char *dest)
{
int i=0;
size_t len;
char buff[SOCKET_BUFFER_SIZE];

#ifdef DEBUG_SOCK
	fprintf(stderr, "%sReadResponse()", CLIENT_STRING);
#endif
	len = sock->ReadMsg(buff, SOCKET_BUFFER_SIZE).LastCount();
	buff[len-1] = 0;		// there is a new-line
	while(resp[i].str != NULL) {
		if(strncmp(buff, resp[i].str, strlen(resp[i].str)) == 0) {
			strcpy(dest, &buff[strlen(resp[i].str)]);
#ifdef DEBUG_SOCK
			fprintf(stderr, "%s <%s>\n", resp[i].str, dest);
#endif
			return(resp[i].cmd);
		}
		i++;
	}

#ifdef DEBUG_SOCK
	fprintf(stderr, "ERROR! <%s>\n", buff);
	exit(-1);
#endif
	return(RCMD_ERROR);
}

void
GenClient::Quit(void)
{
	WriteCmd(PCMD_QUIT);
	sock->Close();
	delete sock;
	sock = NULL;
}

void
GenClient::SendPort(char p)
{
char buff[12];

	sprintf(buff, "%c", p);
	WriteCmd((char) SCMD_PORT, buff);
}

