/*
 * File:		sectdisp.h
 * Purpose:		general purpose sector related printing.
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sectdisp.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2001/12/02 18:18:39 $" */

#include "sectdisp.h"

// =========================================================================
BasePlanetDisplay::BasePlanetDisplay(wxDC *d, int x, int y, int len) :
	DisplayMethod(d, x, y, len)
{
}

BasePlanetDisplay::BasePlanetDisplay(FILE *fpx, int len) : 
	DisplayMethod(fpx, len) 
{
}

BasePlanetDisplay::BasePlanetDisplay(wxTextCtrl *t, int len) : 
	DisplayMethod(t, len) 
{
}

BasePlanetDisplay::~BasePlanetDisplay()
{
}

char *
BasePlanetDisplay::FormatCode(SimpleCodeTable *ct, unsigned long code, char *buff)
{
unsigned long test=1l;
ListNode *n;
CodeTableEntry *cte;
int i=0;

	buff[0] = 0;

	n = ct->First();
	while((n != NULL) && (test != 0)) {
		cte = (CodeTableEntry *)n->Data();
		if(code & test) {
			if(i != 0)
				strcat(buff, "; ");
			strcat(buff, cte->GetCode());
			strcat(buff, ": ");			
			strcat(buff, cte->GetDesc());
			i++;
		}
		test *= 2;
		n = n->Next();
	}

	return(buff);
}

// bases or alleg.
char *
BasePlanetDisplay::FormatCode(SimpleCodeTable *table, char *code, char *buff)
{
char buff1[120],*ptr1;

	buff[0] = 0;

	sprintf(buff1, "%s", code);
	ptr1 = table->GetDesc(buff1);
	if(ptr1 != NULL)
		sprintf(buff, "%s; %s", code, ptr1);
	else {
		if(strcmp("  ", code))
		    sprintf(buff, "%s; Unknown", code);
		else
		    sprintf(buff, "Unknown");
	}
	
	return(buff);
}

char *
BasePlanetDisplay::FormatZone(char code, char *buff)
{
	buff[0] = 0;
	if((code == 'R') || (code == 'r'))
		sprintf(buff, "Red");
	else if((code == 'A') || (code == 'a'))
		sprintf(buff, "Amber");
	else
		sprintf(buff, "Green");

	return(buff);
}

int
BasePlanetDisplay::DrawBaseDetail(base_planet *bp, TCodes *codes)
{
char buff[120]; 
char buff1[120];
char *ptr1,*ptr2;

	if(bp != NULL) {
		sprintf(buff, "    Name:  %s", bp->GetName());
		Line(buff);
		ptr1 = bp->GetPortDesc(buff1);
		ptr2 = SplitLine(ptr1);
		sprintf(buff, "    Port:  %s", ptr1);
		Line(buff);
		sprintf(buff, "           %s", ptr2);
		Line(buff);

		sprintf(buff, "    Size:  %s", bp->GetSizeDesc(buff1));
		Line(buff);
		sprintf(buff, "   Atmos:  %s", bp->GetAtmosDesc(buff1));
		Line(buff);
		sprintf(buff, "   Hydro:  %s", bp->GetHydroDesc(buff1));
		Line(buff);
		sprintf(buff, "     Pop:  %s", bp->GetPopDesc(buff1));
		Line(buff);
		sprintf(buff, "    Govt:  %s", bp->GetGovtDesc(buff1));
		Line(buff);
		sprintf(buff, "     Law:  %s", bp->GetLawDesc(buff1));
		Line(buff);
		sprintf(buff, "    Tech:  %s", bp->GetTechDesc(buff1));
		Line(buff);
	} else {
		Line("    Name:  %s");
		Line("    Port:  %s");
		Line("           %s");
		Line("    Size:  %s");
		Line("   Atmos:  %s");
		Line("   Hydro:  %s");
		Line("     Pop:  %s");
		Line("    Govt:  %s");
		Line("     Law:  %s");
		Line("    Tech:  %s");
	}

	return(10);
}

int
BasePlanetDisplay::DrawCode(char *title, SimpleCodeTable *ct, char *code)
{
char buff[120];
char buff1[120];

	FormatCode(ct, code, buff1);
	sprintf(buff, "%s  %s", title, buff1);
	Line(buff);

	return(1);
}

int
BasePlanetDisplay::DrawCode(char *title, SimpleCodeTable *ct, 
			unsigned long code)
{
char buff[120];
char buff1[120];
char *ptr1,*ptr2;

	ptr1 = FormatCode(ct, code, buff1);
	ptr2 = SplitLine(ptr1);
	sprintf(buff, "%s  %s", title, ptr1);
	Line(buff);
	sprintf(buff, "           %s", ptr2);
	Line(buff);

	return(2);
}

int
BasePlanetDisplay::DrawZone(char zone)
{
char buff[120];
char buff1[120];

	sprintf(buff, "    Zone:  %s", FormatZone(zone, buff1));
	Line(buff);

	return(1);
}

// no, BasePlanet won't need these, but SearchDialog will.....
int 
BasePlanetDisplay::DrawOtherDetail(int pop_ndx, int gg, int belts)
{
char buff[120];

	sprintf(buff, " Pop ndx: %d  # GG: %d  # Belts: %d", pop_ndx, gg, belts);
	Line(buff);
	return(1);
}

int
BasePlanetDisplay::DrawStarDetail(BaseStar *bs1, BaseStar *bs2, BaseStar *bs3)
{
char buff[120];
char buff1[38];
char buff2[38];
char buff3[38];

	sprintf(buff, " Stars");
	Line(buff);
			
	sprintf(buff1, "            ");
	sprintf(buff2, "            ");
	sprintf(buff3, "            ");
	if(bs1 != NULL) {
		bs1->GetStarStr(buff1);
		strfixsize(buff1, 6);
	}
	if(bs2 != NULL) {
		bs2->GetStarStr(buff2);
		strfixsize(buff2, 6);
	}
	if(bs3 != NULL) {
		bs3->GetStarStr(buff3);
		strfixsize(buff3, 6);
	}

	sprintf(buff, "    Type:  %c     %c     %c", buff1[0], buff2[0], buff3[0]);
	Line(buff);
			
	sprintf(buff, "    Size:  %c     %c     %c", buff1[1], buff2[1], buff3[1]);
	Line(buff);

	sprintf(buff, "   Class:  %s  %s  %s", &buff1[2], &buff2[2], &buff3[2]);
	Line(buff);

	return(4);
}

// =========================================================================
MainWorldDisplay::MainWorldDisplay(wxDC *d, int x, int y, int len) :
	BasePlanetDisplay(d, x, y, len)
{
}

MainWorldDisplay::MainWorldDisplay(FILE *fpx, int len) : 
	BasePlanetDisplay(fpx, len) 
{
}

MainWorldDisplay::MainWorldDisplay(wxTextCtrl *t, int len) :
	BasePlanetDisplay(t, len)
{
}

MainWorldDisplay::~MainWorldDisplay()
{
}


int
MainWorldDisplay::DrawDetail(HexData *hd, TCodes *codes, char *sect_name)
{
bool ok=FALSE;
char buff[120];
int ret;
main_world *mw;

	if(hd != NULL) {
		if((mw = hd->world) != NULL) {
			BaseStar *bs1,*bs2,*bs3;

			if(sect_name != NULL)
				sprintf(buff, "Location:  %s:%02d%02d", sect_name,
						mw->GetLocX(), mw->GetLocY());
			else
				sprintf(buff, "Location:  %02d%02d", mw->GetLocX(), 
						mw->GetLocY());
			Line(buff);
			ret = 1 + DrawBaseDetail(mw, codes);
			sprintf(buff, "%c", mw->GetBase());
			ret += DrawCode("   Bases:", codes->GetBaseTable(), buff);
			ret += DrawCode("   Trade:", codes->GetTradeTable(), 
						mw->GetTradeCodes());
			ret += DrawCode("   Other:", codes->GetOtherTable(), 
						mw->GetOtherCodes());
			ret += DrawZone(mw->GetZone());
			ret += DrawCode("   Alleg:", codes->GetAllegTable(),
						mw->GetAlleg());
			ret += DrawOtherDetail(mw->GetPopNdx(), mw->GetNumGG(), 
						mw->GetNumBelts());
			bs1 = mw->GetStar(0);
			bs2 = mw->GetStar(1);
			bs3 = mw->GetStar(2);
			ret = 1 + DrawStarDetail(bs1, bs2, bs3);
			ok = TRUE;
		} else if(hd->cp != NULL) {
			sprintf(buff, "CP %s", hd->cp);
			Line(buff);
			Line(" ");
			ret = 2;

			ok = TRUE;
		}
	}

	if(!ok) {
		ret = 1 + DrawBaseDetail(NULL, codes);
		ret += DrawCode("   Bases:", codes->GetBaseTable(), " ");
		ret += DrawCode("   Trade:", codes->GetTradeTable(), 0ul);
		ret += DrawCode("   Other:", codes->GetOtherTable(), 0ul);
		ret += DrawZone(' ');
		ret += DrawCode("   Alleg:", codes->GetAllegTable(), " ");
		ret += DrawOtherDetail(0, 0, 0);
		ret = 1 + DrawStarDetail(NULL, NULL, NULL);
	}


	return(23);
}

bool
MainWorldDisplay::DrawLine(BaseSector *bs, int x, int y, char *sect_name)
{
char buff1[256];
char buff2[256];

	buff1[0] = 0;
	bs->GetListing(x, y, buff1);
	if(buff1[0] != 0) {
		if(sect_name != NULL)
			sprintf(buff2, "%s %s", sect_name, buff1);
		else
			sprintf(buff2, "%s", buff1);

		Line(buff2);
		return(TRUE);
	}

	return(FALSE);
}

