
/*
 * File:      llist.cpp
 * Purpose:   first attempt at a generac linked list class.....
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: llist.cpp,v $ $Revision: 1.6 $ $Author: man $ $Date: 2000/07/15 14:24:55 $" */



// ?? needed for NULL ??
#include <stdio.h>
#include "llist.h"

// ============================================================================
ListData::ListData()
{
}

ListData::~ListData()
{
#ifdef LLIST_DEBUG
	fprintf(stderr, "Destroying ListData\n");
#endif
}

// ============================================================================
ListNode::ListNode()
{
	next = prev = NULL;
	data = NULL;
}

ListNode::ListNode(ListData *ld)
{
	next = prev = NULL;
	data = ld;
}

ListNode::~ListNode()
{
#ifdef LLIST_DEBUG
	fprintf(stderr, "Destroying ListNode\n");
#endif
//	if(data != NULL)
//		delete data;
}

// ============================================================================
LinkedList::LinkedList()
{
	head = tail = current = NULL;
	count = 0;
}

//LinkedList::LinkedList(ListNode *d)
//{
//	head = tail = current = d;
//	count = 1;
//}

LinkedList::~LinkedList()
{
	RemoveAll();
}

// ---------------------------------------------------------------------------
// list manipulation
int
LinkedList::RemoveAll(void)
{
ListNode *ln;
#ifdef LLIST_DEBUG
int i=0;
#endif

	current = ln = head;
	while(ln != NULL) {
#ifdef LLIST_DEBUG
fprintf(stderr, "Removing %d\n", i++);
#endif
		Remove(0);
		ln = head;
	}

	return(1);
}

int
LinkedList::Remove(int ndx)
{
ListNode *dl,*dl_n,*dl_p;

	dl = Nth(ndx);
	if(dl != NULL) {
		dl_n = dl->Next();
		dl_p = dl->Prev();

		// take care of current
		if(current == dl) {
			if(dl_n != NULL)
				current = dl_n;
			else
				current = dl_p;
		}
		// take care of head
		if(head == dl) {
			if(dl_n != NULL)
				head = dl_n;
			else
				head = NULL;
		}
		// take care of tail
		if(tail == dl) {
			if(dl_p != NULL)
				tail = dl_p;
			else
				tail = NULL;
		}
		delete dl;

		// fix up the links
		if(dl_n != NULL)
			dl_n->SetPrev(dl_p);

		if(dl_p != NULL)
			dl_p->SetNext(dl_n);

		count--;
	}

	return(1);
}

int 
LinkedList::Append(ListData *ptr)
{
ListNode *ln;

	ln = new ListNode(ptr);
	if(NULL == tail) {
//		dl = new ListNode(NULL, ptr);
		head = tail = current = ln;
	} else {
//		dl = new ListNode(tail, ptr);
		tail->SetNext(ln);
		ln->SetPrev(tail);
		tail = ln;
		current = ln;
	}
	count++;

	return(count);
}

bool 
LinkedList::Insert(ListData *ptr, ListNode *n)
{
ListNode *n_p,*new_n;

	if(n != NULL) {
		if(NULL == head) {
			Append(ptr);
			return(TRUE);
		} else {
			new_n = new ListNode(ptr);
			n_p = n->Prev();
			n->SetPrev(new_n);
			new_n->SetNext(n);
			new_n->SetPrev(n_p);
			if(n_p != NULL) {
				n_p->SetNext(new_n);
			} else {
				head = new_n;
			}
			return(TRUE);
		} 
	} 

	return(FALSE);
}

int 
LinkedList::Insert(ListData *ptr, int ndx)
{
ListNode *dl;

	if(ndx < 0)
		Append(ptr);
	else {
		ListNode *dl_n,*dl_p;

		if((dl_n = Nth(ndx)) != NULL) {
			dl = new ListNode(ptr);
			dl_p = dl_n->Prev();
			dl_n->SetPrev(dl);
			if(dl_p != NULL) {
				dl_p->SetNext(dl);
			} else {
				head = dl;
			}
			current = dl;
			dl->SetNext(dl_n);
			dl->SetPrev(dl_p);
		} else
			Append(ptr);
	}

	return(count);
}


// ---------------------------------------------------------------------------
// data manipulation
ListNode *
LinkedList::Next(void)
{
	if((current != NULL) && (current->Next() != NULL)) {
		current = current->Next();
		return(current);
	}

	return(NULL);
}

ListNode *
LinkedList::Prev(void)
{
	if((current != NULL) && (current->Prev() != NULL)) {
		current = current->Prev();
		return(current);
	}

	return(NULL);
}

ListNode *
LinkedList::First(void)
{
	current = head;
	return(current);
}

ListNode *
LinkedList::Last(void)
{
	current = tail;
	return(current);
}

ListNode *
LinkedList::Nth(int n)
{
int l_count=0;
ListNode *dl;

	// quick out:
	if(n > count)
		return(NULL);

	if(n < 0)
		return(current);

	dl = head;
	while(dl != NULL) {
		if(l_count == n)
			return(dl);

		l_count++;
		dl = dl->Next();
	}

	return(NULL);
}


// ---------------------------------------------------------------------------
// internal data manipulation
ListData *
LinkedList::CurrentData(void)
{
	if(NULL == current)
		return(NULL);

	return(current->GetData());
}

ListData *
LinkedList::NthData(int n)
{
ListNode *dl;

	if((dl = Nth(n)) != NULL)
		return(dl->GetData());

	return(NULL);
}

// ----------------------------------------------------------------------------
bool
LinkedList::DeleteNode(ListNode *node_to_delete)
{
ListNode *n;
bool ret=FALSE;

//fprintf(stderr, "\n=============== before:\n");
//Dump(stderr);
	n = head;
	while(n != NULL) {
		if(n == node_to_delete) {
			ListNode *n_n,*n_p;

			n_n = n->Next();
			n_p = n->Prev();
			if(n_p != NULL)
				n_p->SetNext(n_n);
			if(n_n != NULL)
				n_n->SetPrev(n_p);

			if(n == current) {
				if(head != NULL)
					current = head;
				else 
					current = n_n;
			}
			if(n == head)
				head = n_n;
			if(n == tail)
				tail = n_p;

			delete n;
			count--;
			ret = TRUE;
			break;
		}
		n = n->Next();
	}
//fprintf(stderr, "\n=============== after:\n");
//Dump(stderr);
//fprintf(stderr, "\n\n");
	return(ret);
}

// ============================================================================
#ifdef LLIST_DEBUG
void
ListNode::Dump(FILE *fpx)
{
	fprintf(fpx, "(0x%x): next:0x%x prev:0x%x data:0x%x\n", 
			this, next, prev, data);
}

void
LinkedList::Dump(FILE *fpx)
{
ListNode *dl;

	fprintf(fpx, "head:0x%x tail:0x%x current:0x%x count:%d\n", 
		head, tail, current, count);

	current = dl = head;
	while(dl != NULL) {
		dl->Dump(fpx);
		dl = Next();
	}
}

#endif
