
/*
 * File:      d_sect.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: d_sect.cpp,v $ $Revision: 1.19 $ $Author: man $ $Date: 2002/10/07 20:26:48 $" */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "str_util.h"

#include "d_sect.h"

#define CFG_HEADER_STR1             "################################################################################"
#define CFG_HEADER_STR2             "##"
#define CFG_TITLE                   "sector program config file"

// ==========================================================================
DetailSector::DetailSector(TCodes *tc) :
	BaseSector(tc)
{
}

DetailSector::~DetailSector()
{
}

// ==========================================================================
HexData *
DetailSector::AddOrGetHex(int x, int y)
{
	if(hexes[x][y] == NULL)
		hexes[x][y] = new HexData();
	return(hexes[x][y]);
}

// ==========================================================================
HexData *
DetailSector::CopyHex(int x, int y, HexData *hd)
{
	return(hexes[x][y] = new HexData(hd));
}

// ==========================================================================
void 
DetailSector::WriteDat(TCodes *codes)
{
int i,j,x,y;
FILE *fpx;
Route *rt;
LinkedList *list;
ListNode *n;
ColorTableEntry *cte;
CodeTable *ct;
BaseTable *bt;
TCodes *c;
HexLayout *hl;

	if((fpx = fopen(dat_name, "w+")) != NULL) {
		c = codes;

		// name section
		if(name != NULL) {
			WriteHeader(fpx, "Name", "N:Name");
			fprintf(fpx, "N:%s\n", name);
			if(alt_name != NULL)
				fprintf(fpx, "M:%s\n", alt_name);
		}
		fprintf(fpx, "\n\n");

		// the section formally known as CP section
		WriteHeader(fpx, "CP", "P:Hex:Name:Description:Bitmap");
		for(x = 0;x < MAX_X_HEX;x++) {
			for(y = 0;y < MAX_Y_HEX;y++) {
				if((hexes[x][y] != NULL) && (hexes[x][y]->cp != NULL)) {
					fprintf(fpx, "P:%02d%02d:", x+1, y+1);
					if(hexes[x][y]->cp->GetTitle() != NULL)
						fprintf(fpx, "%s", hexes[x][y]->cp->GetTitle());
					fprintf(fpx, ":");
					if(hexes[x][y]->cp->GetDesc() != NULL)
						fprintf(fpx, "%s", hexes[x][y]->cp->GetDesc());
					fprintf(fpx, ":");
					if(hexes[x][y]->cp->GetBM() != NULL)
						fprintf(fpx, "%s", hexes[x][y]->cp->GetBM());
					fprintf(fpx, "\n");
				}
			}
		}
		fprintf(fpx, "\n\n");

		// subsector section
		WriteHeader(fpx, "Subsector", "S:ndx(A-P):name");
		for(i = 0;i < MAX_SS;i++) {
			if(ss_names[i] != NULL)
				fprintf(fpx, "S:%c:%s\n", 'A'+i, ss_names[i]);
		}
		fprintf(fpx, "\n\n");
		// caption section
		WriteHeader(fpx, "Title", "T:which(R or B):color index:caption");
		//  borders
		n = border_list->First();
		while(n != NULL) {
			cte = (ColorTableEntry *)n->Data();
			fprintf(fpx, "T:B:%d:%s\n", cte->GetColor(), cte->GetDesc());
			n = n->Next();
		}
		//  routes
		n = route_list->First();
		while(n != NULL) {
			cte = (ColorTableEntry *)n->Data();
			fprintf(fpx, "T:R:%d:%s\n", cte->GetColor(), cte->GetDesc());
			n = n->Next();
		}
		fprintf(fpx, "\n\n");

		// border section
		WriteHeader(fpx, "Border", "B:hex:side(0-5):border index");
		for(x = 0;x < MAX_X_HEX;x++) {
			for(y = 0;y < MAX_Y_HEX;y++) {
				if(hexes[x][y] != NULL) {
					for(i = 0;i < 6;i++) {
						if((cte = border_list->Find(hexes[x][y]->border_ndx[i])) != NULL)
							fprintf(fpx, "B:%02d%02d:%d:%d\n",
								x+1, y+1, i, hexes[x][y]->border_ndx[i]);
					}
				}
			}
		}
		fprintf(fpx, "\n\n");

		// route section
		WriteHeader(fpx, "Route", 
				"R:source:destination x:destination y:route index");
		for(x = 0;x < MAX_X_HEX;x++) {
			for(y = 0;y < MAX_Y_HEX;y++) {
				if(hexes[x][y] != NULL) {
					if((list = hexes[x][y]->routes) != NULL) {
						n = list->First();
						while(n != NULL) {
							rt = (Route *)n->Data();
							if((cte = route_list->Find(rt->color)) != NULL)
								fprintf(fpx, "R:%02d%02d:%d:%d:%d\n",
									x+1, y+1, rt->x+1,rt->y+1, rt->color);
							n = n->Next();
						}
					}
				}
			}
		}
		fprintf(fpx, "\n\n");

		// alleg section
		WriteHeader(fpx, "Allegiance", "A:co:text");
		ct = codes->GetAllegTable();
		n = ct->First();
		while(n != NULL) {
			CodeTableEntry *cte;

			cte = (CodeTableEntry *)n->Data();
			if(cte->IsLocal()) {
				fprintf(fpx, "A:%s:%s\n", cte->GetCode(), cte->GetDesc());
			}
			n = n->Next();
		}

		fprintf(fpx, "\n\n");

		// base section
		WriteHeader(fpx, "Bases", "E:c:text:1st bitmap:2nd bitmap(optional)");
		bt = codes->GetBaseTable();
		n = bt->First();
		while(n != NULL) {
			BaseTableEntry *bte;
			char *ptr;

			bte = (BaseTableEntry *)n->Data();
			if(bte->IsLocal()) {
				ptr = bte->GetCode();
				fprintf(fpx, "E:%c:%s:%s", ptr[0], bte->GetDesc(),
						bte->GetName(0));
				if(bte->GetName(1) != NULL) 
					fprintf(fpx, ":%s", bte->GetName(1));
				fprintf(fpx, "\n");
			}
			n = n->Next();
		}
		fprintf(fpx, "\n\n");

		// layout section
		WriteHeader(fpx, "Layout", 
					"L:<coord x:coord hex y:>hex x: hex y:code<:filter>");
		for(x = -1;x < MAX_X_HEX;x++) {
			for(y = -1;y < MAX_X_HEX;y++) {
				for(i = 0;i < MAX_LAYOUT_X;i++) {
					for(j = 0;j < MAX_LAYOUT_Y;j++) {
						hl = NULL;
						if((-1 == x) && (-1 == y))
							hl = &layout;
						else if(((x != -1) && (y != -1)) &&
							((hexes[x][y] != NULL) &&
								(hexes[x][y]->layout != NULL)))
							hl = hexes[x][y]->layout;

						if((hl != NULL) && (!hl->IsDefault(i, j))) {
							fprintf(fpx, "L:");
							if((x != -1) && (y != -1))
								fprintf(fpx, "%d:%d:", x, y);
							fprintf(fpx, "%d:%d:%d", i, j, hl->GetCode(i, j));
							if(HD_UWP_FILTERED == hl->GetCode(i, j))
								fprintf(fpx, ":%d", hl->GetUWPFilter());
							fprintf(fpx, "\n");
						}
					}
				}
			}
		}
		fprintf(fpx, "\n\n");

		// route/border filter section
//		WriteHeader(fpx, "Route/Border Filter", "V:{R|B}:{color ndx}:{0|1}");
//		fprintf(fpx, "\n\n");








		fclose(fpx);
	}
}

void 
DetailSector::WriteSec(void)
{
int x,y;
FILE *fp;
char buffer[120];

	BuildParseParams();
	if((fp = fopen(sec_name, "w+")) != NULL) {
		WriteSecHeader(fp);
		for(x = 0;x < MAX_X_HEX;x++) {
			for(y = 0;y < MAX_Y_HEX;y++) {
				buffer[0] = 0;
				GetListing(x, y, buffer);
				if(buffer[0] != 0)
					fprintf(fp, "%s\n", buffer);
			}
		}
		fclose(fp);
	}
}

// ==========================================================================
int 
DetailSector::GetCount(int start_x, int start_y, int end_x, int end_y)
{
int x,y;
int ret=0;

	for(x = start_x;x < end_x;x++) {
		for(y = start_y;y < end_y;y++) {
			if((hexes[x][y] != NULL) && (hexes[x][y]->world != NULL))
				ret++;
		}
	}

	return(ret);
}

// ==========================================================================
void 
DetailSector::WriteHeader(FILE *fpx, char *sect_str, char *format_str)
{
	fprintf(fpx, "%s\n", CFG_HEADER_STR1);
	fprintf(fpx, "%s\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s %s section\n", CFG_HEADER_STR2, sect_str);
	fprintf(fpx, "%s format:\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s %s\n", CFG_HEADER_STR2, format_str);
	fprintf(fpx, "%s\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s\n", CFG_HEADER_STR1);
}

// ==========================================================================
char *
DetailSector::FormatBase(char code, char *buff)
{
char buff1[12],*ptr1;

	buff[0] = 0;

	sprintf(buff1, "%c", code);
	ptr1 = codes->GetBaseTable()->GetDesc(buff1);

	if(ptr1 != NULL)
		sprintf(buff, "%c; %s", code, ptr1);
	
	return(buff);
}

char *
DetailSector::FormatCode(SimpleCodeTable *ct, unsigned long code, char *buff)
{
unsigned long test=1l;
ListNode *n;
CodeTableEntry *cte;
int i=0;

	buff[0] = 0;

	n = ct->First();
	while((n != NULL) && (test != 0)) {
		cte = (CodeTableEntry *)n->Data();
		if(code & test) {
			if(i != 0)
				strcat(buff, "; ");
			strcat(buff, cte->GetCode());
			strcat(buff, ": ");			
			strcat(buff, cte->GetDesc());
			i++;
		}
		test *= 2;
		n = n->Next();
	}

	return(buff);
}

char *
DetailSector::FormatZone(char code, char *buff)
{
	buff[0] = 0;
	if((code == 'R') || (code == 'r'))
		sprintf(buff, "Red");
	else if((code == 'A') || (code == 'a'))
		sprintf(buff, "Amber");
	else
		sprintf(buff, "Green");

	return(buff);
}

char *
DetailSector::FormatAlleg(char *code, char *buff)
{
char buff1[12],*ptr1;

	buff[0] = 0;

	sprintf(buff1, "%s", code);
	ptr1 = codes->GetAllegTable()->GetDesc(buff1);

	if(ptr1 != NULL)
		sprintf(buff, "%s; %s", code, ptr1);
	else {
		if(strcmp("  ", code))
		    sprintf(buff, "%s; Unknown", code);
		else
		    sprintf(buff, "Unknown");
	}
	
	return(buff);
}

// ==========================================================================
void 
DetailSector::SetSecName(char *buff)
{
	if(sec_name != NULL) {
		delete sec_name;
		sec_name = NULL;
	}

	sec_name = new char[strlen(buff) + 1];
	strcpy(sec_name, buff);
}

void 
DetailSector::SetDatName(char *buff)
{
	if(dat_name != NULL) {
		delete dat_name;
		dat_name = NULL;
	}

	dat_name = new char[strlen(buff) + 1];
	strcpy(dat_name, buff);
}


// ==========================================================================
void 
DetailSector::BuildParseParams(void)
{
int x,y;
size_t min=16,min1=12;
HexData *hd;
char lbuff[120];

	// determine longest name and longest code strings
	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			if(((hd = GetHex(x, y)) != NULL) && (hd->world != NULL)) {
				if((hd->world->GetName() != NULL) &&
					(strlen(hd->world->GetName()) > min)) {
					min = strlen(hd->world->GetName());
				}
				GetCodeStr(hd->world, lbuff);
				if(strlen(lbuff) > min1)
					min1 = strlen(lbuff);
			}
		}
	}

	// set parse_params
	min++;
	parse_params[0] = min;		// name
	min++;
	parse_params[1] = min;		// hex
	min += 5;
	parse_params[2] = min;		// uwp
	min += 11;
	parse_params[3] = min;		// bases
	min += 2;
	parse_params[4] = min;		// codes
	min += (3 + min1);
	parse_params[5] = min;		// zone
	min += 2;
	parse_params[6] = min;		// pbg
	min += 3;
	parse_params[7] = min;		// alleg
	min += 3;
	parse_params[8] = min;		// stars
	min += 20;
	parse_params[9] = min;
}

void
DetailSector::WriteSecHeader(FILE *fp)
{
	fprintf(fp, "\nThe data in the sector text file is laid out in column format:\n\n");
	fprintf(fp, " 1-%d: Name\n", parse_params[0]);
	fprintf(fp, "%d-%d: HexNbr\n", parse_params[1]+1, parse_params[1]+4);
	fprintf(fp, "%d-%d: UWP\n", parse_params[2]+1, parse_params[2]+9);
	fprintf(fp, "   %d: Bases\n", parse_params[3]);
	fprintf(fp, "%d-%d: Codes & Comments\n",parse_params[4],parse_params[5]-2);
	fprintf(fp, "   %d: Zone\n", parse_params[5]+2);
	fprintf(fp, "%d-%d: PBG\n", parse_params[6]+2, parse_params[6]+4);
	fprintf(fp, "%d-%d: Allegiance\n", parse_params[7]+3, parse_params[7]+4);
	fprintf(fp, "%d-%d: Stellar Data\n\n", parse_params[8]+3, parse_params[9]+2);
	fprintf(fp, "....+....1....+....2....+....3....+....4....+....5....+....6....+....7....+....8\n");
}

