/*
 * File:      mtu.cpp
 * Purpose:   MTU menu program
 * Author:    Mark A. Nordstrand
 * Created:   8/1/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: code_dlg.cpp,v $ $Revision: 1.11 $ $Author: man $ $Date: 2003/05/02 21:45:39 $" */

#include "t_res.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "code_dlg.h"

#if defined(__WXGTK__) || defined(__WXMOTIF__)
#include "bitmaps/blank_b.xpm"
#endif

// =======================================================================
// some macros for sizes for TCodeDialog
#define FRAME_WIDTH		((6 * DLG_OFFSET) + (6 * COL_OFFSET))
#define FRAME_HEIGHT	350

#define PANEL_WIDTH		FRAME_WIDTH
#define PANEL_HEIGHT	((2 * DLG_OFFSET) + (2 * ROW_OFFSET))

#define TAB_WIDTH		FRAME_WIDTH
#define TAB_HEIGHT		(FRAME_HEIGHT - PANEL_HEIGHT)

#define LIST_WIDTH		(TAB_WIDTH - (3 * DLG_OFFSET))
#define LIST_HEIGHT		(TAB_HEIGHT - (2 * DLG_OFFSET) - 40)

#define BTN_ROW1		(TAB_HEIGHT + (2 * DLG_OFFSET))
#define BTN_ROW2		(BTN_ROW1 + (2 * DLG_OFFSET) + ROW_OFFSET)

#define BTN_COL1		DLG_OFFSET
#define BTN_COL2		((COL_OFFSET * 2) + (2 * DLG_OFFSET))
#define BTN_COL3		((COL_OFFSET * 4) + (3 * DLG_OFFSET))

// Tab ids for TCodeDialog
#define TAB_BASES			0
#define TAB_ALLEG			1
#define TAB_SECTOR			2
#define TAB_SYSTEM			3
#define TAB_OTHER			4

// general control id's
#define ID_BASE1_CB		500
#define ID_BASE1_BTN	(ID_BASE1_CB + 1)
#define ID_BASE2_CB		(ID_BASE1_BTN + 1)
#define ID_BASE2_BTN	(ID_BASE2_CB + 1)
#define ID_NEW			(ID_BASE2_BTN + 1)
#define ID_EDIT			(ID_NEW + 1)
#define ID_DEL			(ID_EDIT + 1)


// =======================================================================
BitmapControl::BitmapControl(wxWindow *p, wxWindowID i) :
	wxListCtrl(p, i, wxPoint(0, 0), wxSize(200, 200),
		wxLC_SMALL_ICON | wxSUNKEN_BORDER | wxLC_SINGLE_SEL)
{
	images = new wxImageList(BITMAP_SIZE, BITMAP_SIZE, TRUE);
}

BitmapControl::~BitmapControl()
{
	delete images;
}

int
BitmapControl::GetSelection(void)
{
int i;

	for(i = 0; i < GetItemCount();i++) {
		if(GetItemState(i, wxLIST_STATE_SELECTED)) {
			return(i);
		}
	}
	return(-1);
}

void
BitmapControl::SetSelection(int s)
{
int i;

	for(i = 0;i < GetItemCount();i++) {
		if(i == s)
			SetItemState(i, 1, wxLIST_STATE_SELECTED);
		else
			SetItemState(i, 0, wxLIST_STATE_SELECTED);
	}
}

void
BitmapControl::DisplayBitmaps(BitmapList *bl)
{
int i=0;
wxBitmap *bitmap;

	DeleteAllItems();
	SetSingleStyle(wxLC_ICON);
	images->RemoveAll();
	while(bl->GetNth(i) != NULL) {
		bitmap = bl->NthBM(i);
		images->Add(*bitmap);
		i++;
	}

	i = 0;
	SetImageList(images, wxIMAGE_LIST_NORMAL);
	while(bl->GetNth(i) != NULL) {
		char buff[15],*ptr;
		wxString str;

		if((ptr = bl->NthName(i)) == NULL) {
			sprintf(buff, "Bitmap %d", i + 1);
			ptr = buff;
		}
		str.Printf("%s", ptr);
		InsertItem(i, ptr, i);
		i++;
	}
}

// =======================================================================
// =======================================================================
SelectBitmapDialog::SelectBitmapDialog(wxWindow *p) :
	StdDialog(p, "Select a Bitmap")
{
wxBoxSizer *main_sizer;

	bm = new BitmapControl(this, -1);

	main_sizer = new wxBoxSizer(wxVERTICAL);
	main_sizer->Add(bm, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

SelectBitmapDialog::~SelectBitmapDialog()
{
}

int
SelectBitmapDialog::GetBitmap(BitmapList *b, int i)
{
	bm->DisplayBitmaps(b);
	if(ShowModal() == wxID_CANCEL)
		return(-1);

	return(bm->GetSelection());
}

// =======================================================================
// code editor
BaseCodeDialog::BaseCodeDialog(wxWindow *p) :
	StdDialog(p, "Delete this title")
{
wxStaticText *msg1, *msg2;

	msg1 = new wxStaticText(this, -1, "Code:");
	msg2 = new wxStaticText(this, -1, "Caption:");
	CodeEdit = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET, -1));
	CaptEdit = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 4, -1));

	code_sizer = new wxFlexGridSizer(2, 2, DLG_OFFSET, DLG_OFFSET);

	code_sizer->Add(msg1, 0, wxALIGN_BOTTOM, 0);
    code_sizer->Add(CodeEdit, 0, 0, 0);
    code_sizer->Add(msg2, 0, wxALIGN_BOTTOM, 0);
    code_sizer->Add(CaptEdit, 0, 0, 0);
}

BaseCodeDialog::~BaseCodeDialog()
{
}

void 
BaseCodeDialog::SetTexts(char *title, char *c, char *d)
{
	SetTitle(title);
	CodeEdit->SetValue(c);
	CaptEdit->SetValue(d);
}

void 
BaseCodeDialog::GetTexts(char *c, char *d)
{
char *ptr;

	ptr = (char *)CodeEdit->GetValue().GetData();
	strcpy(c, ptr);
	ptr = (char *)CaptEdit->GetValue().GetData();
	strcpy(d, ptr);
}

// ---------------------------------------------------------------------
BEGIN_EVENT_TABLE(CodeDialog, wxDialog)
END_EVENT_TABLE()

CodeDialog::CodeDialog(wxWindow *p) :
	BaseCodeDialog(p)
{
wxBoxSizer *main_sizer;

	main_sizer = new wxBoxSizer(wxVERTICAL);
	main_sizer->Add(code_sizer, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);
}

CodeDialog::~CodeDialog()
{
}

bool 
CodeDialog::NewCode(bool al, SimpleCodeTable *ct)
{
char *title;
char buff1[DUMMY_BUFFER_SIZE],buff2[DUMMY_BUFFER_SIZE];
CodeTableEntry *cte;
bool ret=FALSE;

	if(al)
		title = "New Allegaince";
	else
		title = "New Code";

	SetTexts(title, NULL, NULL);

	if(ShowModal() != wxID_CANCEL) {
		GetTexts(buff1, buff2);
		cte = new CodeTableEntry(buff1, buff2);
		ct->Append(cte);
		ret = TRUE;
	}

	return(ret);
}

bool 
CodeDialog::EditCode(bool al, CodeTableEntry *cte)
{
char *title;
char *desc;
char *code;
bool ret=FALSE;
char buff1[DUMMY_BUFFER_SIZE],buff2[DUMMY_BUFFER_SIZE];

	if(al)
		title = "Edit Allegaince";
	else
		title = "Edit Code";

	code = cte->GetCode();
	desc = cte->GetDesc();
	SetTexts(title, code, desc);

	if(ShowModal() != wxID_CANCEL) {
		GetTexts(buff1, buff2);
		cte->NewEntry(buff1, buff2);
		ret = TRUE;
	}

	return(ret);
}

// ---------------------------------------------------------------------
BEGIN_EVENT_TABLE(TradeDialog, wxDialog)
END_EVENT_TABLE()

#define MAX_SPECIAL_STRINGS		3
static wxString special_str[MAX_SPECIAL_STRINGS] = {
	"None",
	"2-4,7-9 (In)",
	"6,8 (Ri)"
};

TradeDialog::TradeDialog(wxWindow *p) :
	BaseCodeDialog(p)
{
int i;
wxStaticText *msg[10];

	msg[0] = new wxStaticText(this, -1, "");
	msg[1] = new wxStaticText(this, -1, "Siz");
	msg[2] = new wxStaticText(this, -1, "Atm");
	msg[3] = new wxStaticText(this, -1, "Hyd");
	msg[4] = new wxStaticText(this, -1, "Pop");
	msg[5] = new wxStaticText(this, -1, "Gov");
	msg[6] = new wxStaticText(this, -1, "Law");
	msg[7] = new wxStaticText(this, -1, "Min:");
	msg[8] = new wxStaticText(this, -1, "Max:");
	msg[9] = new wxStaticText(this, -1, "Special:");
	for(i = 0;i < 6;i++) {
		mins[i] = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET, -1));
		maxs[i] = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(COL_OFFSET, -1));
	}
	special = new wxChoice(this, -1, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 4), -1),
			MAX_SPECIAL_STRINGS, special_str);


	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_2 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Trade Code Determination"), wxHORIZONTAL);
    wxBoxSizer* sizer_3 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_4 = new wxBoxSizer(wxHORIZONTAL);
    wxGridSizer* grid_sizer_1 = new wxGridSizer(3, 7, 0, 0);
    sizer_1->Add(code_sizer, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(msg[0], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[1], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[2], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[3], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[4], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[5], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[6], 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_1->Add(msg[7], 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_1->Add(mins[0], 0, 0, 0);
    grid_sizer_1->Add(mins[1], 0, 0, 0);
    grid_sizer_1->Add(mins[2], 0, 0, 0);
    grid_sizer_1->Add(mins[3], 0, 0, 0);
    grid_sizer_1->Add(mins[4], 0, 0, 0);
    grid_sizer_1->Add(mins[5], 0, 0, 0);
    grid_sizer_1->Add(msg[8], 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_1->Add(maxs[0], 0, 0, 0);
    grid_sizer_1->Add(maxs[1], 0, 0, 0);
    grid_sizer_1->Add(maxs[2], 0, 0, 0);
    grid_sizer_1->Add(maxs[3], 0, 0, 0);
    grid_sizer_1->Add(maxs[4], 0, 0, 0);
    grid_sizer_1->Add(maxs[5], 0, 0, 0);
    sizer_3->Add(grid_sizer_1, 1, wxEXPAND, 0);
    sizer_4->Add(msg[9], 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
    sizer_4->Add(special, 0, wxALL, DLG_OFFSET / 2);
    sizer_3->Add(sizer_4, 0, wxALL, DLG_OFFSET);
    sizer_2->Add(sizer_3, 1, wxEXPAND, 0);
    sizer_1->Add(sizer_2, 1, wxALL | wxEXPAND, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, sizer_1);
}

TradeDialog::~TradeDialog()
{
}

bool 
TradeDialog::NewTrade(TradeTable *tt)
{
bool ret=FALSE;
char buff1[DUMMY_BUFFER_SIZE],buff2[DUMMY_BUFFER_SIZE];
int i,min_vals[6],max_vals[6];
TRADE_GEN_CODE code;
TradeTableEntry *tte;

	SetTexts("New Trade", NULL, NULL);
	for(i = 0;i < 6;i++) {
		mins[i]->SetValue("");
		maxs[i]->SetValue("");
	}
	special->SetSelection(0);

	if(ShowModal() != wxID_CANCEL) {
		GetTexts(buff1, buff2);
		for(i = 0;i < 6;i++) {
			min_vals[i] = atoi((char *)mins[i]->GetValue().GetData());
			max_vals[i] = atoi((char *)maxs[i]->GetValue().GetData());
		}
		code = (TRADE_GEN_CODE) special->GetSelection();
		tte = new TradeTableEntry(buff1, buff2, min_vals, max_vals, 
						code, FALSE);
		tt->Append(tte);
		ret = TRUE;
	}

	return(ret);
}

bool 
TradeDialog::EditTrade(TradeTableEntry *tte)
{
bool ret=FALSE;
char *desc,*code;
char buff1[DUMMY_BUFFER_SIZE],buff2[DUMMY_BUFFER_SIZE];
int i,min_vals[6],max_vals[6];
TRADE_GEN_CODE g_code;

	code = tte->GetCode();
	desc = tte->GetDesc();
	SetTexts("New Trade", code, desc);
	for(i = 0;i < 6;i++) {
		char lbuff[12];

		sprintf(lbuff, "%d", tte->GetMin(i));
		mins[i]->SetValue(lbuff);
		sprintf(lbuff, "%d", tte->GetMax(i));
		maxs[i]->SetValue(lbuff);
	}
	special->SetSelection((int) tte->GetSpecial());

	if(ShowModal() != wxID_CANCEL) {
		GetTexts(buff1, buff2);
		for(i = 0;i < 6;i++) {
			min_vals[i] = atoi((char *)mins[i]->GetValue().GetData());
			max_vals[i] = atoi((char *)maxs[i]->GetValue().GetData());
		}
		g_code = (TRADE_GEN_CODE) special->GetSelection();
		tte->NewEntry(buff1, buff2, min_vals, max_vals, g_code);
		ret = TRUE;
	}

	return(ret);
}

// --------------------------------------------------------------------
BEGIN_EVENT_TABLE(BaseDialog, wxDialog)
	EVT_BUTTON(ID_BASE1_BTN, BaseDialog::Btn1)
	EVT_BUTTON(ID_BASE2_BTN, BaseDialog::Btn2)
	EVT_CHECKBOX(ID_BASE1_CB, BaseDialog::Cb1)
	EVT_CHECKBOX(ID_BASE2_CB, BaseDialog::Cb2)
//	EVT_PAINT(BaseDialog::OnPaint)
END_EVENT_TABLE()

BaseDialog::BaseDialog(wxWindow *p) :
	BaseCodeDialog(p)
{
	select_dlg = NULL;
	default_bitmap = new wxBitmap(blank_b_xpm);

	bases[0] = new wxCheckBox(this, ID_BASE1_CB, "Bitmap 1",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));
	load[0] = new wxButton(this, ID_BASE1_BTN, "Select",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));
	bases[1] = new wxCheckBox(this, ID_BASE2_CB, "Bitmap 2",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));
	load[1] = new wxButton(this, ID_BASE2_BTN, "Select",
			wxPoint(-1, -1),
			wxSize(2 * COL_OFFSET, -1));

	bitmap[0] = new wxStaticBitmap(this, -1, *default_bitmap);
	bitmap[1] = new wxStaticBitmap(this, -1, *default_bitmap);


	wxBoxSizer* sizer_1 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(2, 3, DLG_OFFSET, DLG_OFFSET);
    sizer_1->Add(code_sizer, 0, wxALL, DLG_OFFSET);
    grid_sizer_1->Add(bases[0], 0, 0, 0);
    grid_sizer_1->Add(load[0], 0, 0, 0);
    grid_sizer_1->Add(bitmap[0], 0, wxALIGN_CENTER_VERTICAL, 0);
    grid_sizer_1->Add(bases[1], 0, 0, 0);
    grid_sizer_1->Add(load[1], 0, 0, 0);
    grid_sizer_1->Add(bitmap[1], 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_1->Add(grid_sizer_1, 0, wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, sizer_1);
}

BaseDialog::~BaseDialog()
{
}

bool 
BaseDialog::NewBase(BitmapList *b, BaseTable *bt)
{
bool ret=FALSE;
int i;

	bm_ndx[0] = bm_ndx[1] = -1;
	bl = b;
	SetTexts("New Base", NULL, NULL);
	for(i = 0;i < 2;i++) {
		bases[i]->SetValue(FALSE);
	}
	bte = new BaseTableEntry();
	UpdateBitmaps();

	if(ShowModal() != wxID_CANCEL) {
		// sorry, it is ONLY one char
		char *ptr,code[2];

		ptr = (char *)CodeEdit->GetValue().GetData();
		code[0] = ptr[0];
		code[1] = 0;

		bte->SetValues(code, (char *)CaptEdit->GetValue().GetData(), 
				b->NthName(bm_ndx[0]),
				b->NthName(bm_ndx[1]));
		bt->Append(bte);
		ret = TRUE;
	}
	else
		delete bte;
	
	return(ret);
}

bool 
BaseDialog::EditBase(BitmapList *b, BaseTableEntry *bbte)
{
bool ret=FALSE;
int i;
	
	bm_ndx[0] = bbte->GetIndex(0);
	bm_ndx[1] = bbte->GetIndex(1);
	bl = b;
	bte = new BaseTableEntry(bbte->GetCode(), bbte->GetDesc(),
			b->NthName(bm_ndx[0]), b->NthName(bm_ndx[1]));
	b->SetBitmapIndex(bte);
	SetTexts("Edit Base", bbte->GetCode(), bbte->GetDesc());
	for(i = 0;i < 2;i++) {
		if(bm_ndx[i] < 0)
			bases[i]->SetValue(FALSE);
		else
			bases[i]->SetValue(TRUE);
	}
	UpdateBitmaps();

	if(ShowModal() != wxID_CANCEL) {
		char *ptr,code[2];
		
		ptr = (char *)CodeEdit->GetValue().GetData();
		code[0] = ptr[0];
		code[1] = 0;

		bte->SetValues(code, (char *)CaptEdit->GetValue().GetData(), 
				b->NthName(bm_ndx[0]),
				b->NthName(bm_ndx[1]));
		ret = TRUE;
	} else
		delete bte;

	return(ret);
}

void 
BaseDialog::Btn1(wxCommandEvent& event)
{
	DoBtn(0);
}

void 
BaseDialog::Btn2(wxCommandEvent& event)
{
	DoBtn(1);
}

void 
BaseDialog::Cb1(wxCommandEvent& event)
{
	DoCb(0);
}

void 
BaseDialog::Cb2(wxCommandEvent& event)
{
	DoCb(1);
}

void
BaseDialog::DoBtn(int ndx)
{
int ret;

	if(NULL == select_dlg)
		select_dlg = new SelectBitmapDialog(this);

	if((ret = select_dlg->GetBitmap(bl, bte->GetIndex(ndx))) > -1) {
		bm_ndx[ndx] = ret;
		bte->SetIndex(ndx, ret);

		UpdateBitmaps();
	}
}

void
BaseDialog::DoCb(int ndx)
{
	load[ndx]->Enable(bases[ndx]->GetValue());
	UpdateBitmaps();
}

// bulk update...
void
BaseDialog::UpdateBitmaps(void)
{
int i,j;
wxBitmap *bm;

	for(i = 0;i < 2;i++) {
		j = bte->GetIndex(i);
		bm = default_bitmap;
		if(bases[i]->GetValue()) {
			if((bm = bl->NthBM(j)) == NULL)
				bm = default_bitmap;
		}
		bitmap[i]->SetBitmap(*bm);
	}

	Refresh();
}

#if 0
void
BaseDialog::OnPaint(wxPaintEvent& event)
{
int i,j,x,y;

	wxDialog::OnPaint(event);
	wxPaintDC dc(this);
	dc.BeginDrawing();
	wxMemoryDC mdc;

	for(i = 0;i < 2;i++) {
		if(bases[i]->GetValue()) {
			j = bte->GetIndex(i);
			if(bl->NthBM(j) != NULL) {
				load[i]->GetPosition(&x, &y);
				mdc.SelectObject(*bl->NthBM(j));
				dc.Blit(x + (2 * COL_OFFSET) + DLG_OFFSET, y, 15, 15, 
						&mdc, 0, 0, wxCOPY);
				mdc.SelectObject(wxNullBitmap);
			}
		}
	}

	dc.EndDrawing();
}
#endif

// =======================================================================
BEGIN_EVENT_TABLE(TCodeDialog, wxDialog)
	EVT_BUTTON(ID_NEW, TCodeDialog::New)
	EVT_BUTTON(ID_EDIT, TCodeDialog::Edit)
	EVT_BUTTON(ID_DEL, TCodeDialog::Del)
END_EVENT_TABLE()

// ---------------------------------------------------------------------------
TCodeDialog::TCodeDialog(wxWindow *p, bool l) :
	StdDialog(p, "Edit Codes")
{
wxButton *btn[3];

	local = l;
	nb = new wxNotebook(this, -1, 
			wxPoint(0, 0),
			wxSize(TAB_WIDTH, TAB_HEIGHT));

	bases = BuildNBPage("Bases");
	alleg = BuildNBPage("Alleg");
	sector = BuildNBPage("Sector");
	system = BuildNBPage("System");
	other = BuildNBPage("Other");

	btn[0] = new wxButton(this, ID_EDIT, "Edit",
			wxPoint(BTN_COL1, BTN_ROW1),
			wxSize(2 * COL_OFFSET, -1));
	btn[1] = new wxButton(this, ID_DEL, "Delete",
			wxPoint(BTN_COL2, BTN_ROW1),
			wxSize(2 * COL_OFFSET, -1));
	btn[2] = new wxButton(this, ID_NEW, "New",
			wxPoint(BTN_COL3, BTN_ROW1),
			wxSize(2 * COL_OFFSET, -1));

	wxBoxSizer* sizer_4 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_5 = new wxBoxSizer(wxHORIZONTAL);
    sizer_4->Add(new wxNotebookSizer(nb), 1, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_5->Add(btn[0], 0, wxALL, DLG_OFFSET / 2);
    sizer_5->Add(btn[1], 0, wxALL, DLG_OFFSET / 2);
    sizer_5->Add(btn[2], 0, wxALL, DLG_OFFSET / 2);
    sizer_4->Add(sizer_5, 0, wxALL, DLG_OFFSET / 2);

	DoLayout(wxALL, DLG_OFFSET, sizer_4);

	// create the dialog boxen
	code_dialog = new CodeDialog(this);
	base_dialog = new BaseDialog(this);
	trade_dialog = new TradeDialog(this);
}

TCodeDialog::~TCodeDialog()
{
}

wxListBox *
TCodeDialog::BuildNBPage(char *title)
{
wxPanel *panel;
wxListBox *lb;
wxBoxSizer *nb_sizer;

	panel = new wxPanel(nb);
	lb = new wxListBox(panel, -1, 
			wxPoint(DLG_OFFSET, DLG_OFFSET),
			wxSize(LIST_WIDTH, LIST_HEIGHT),
			0, NULL);
	nb->AddPage(panel, title, FALSE, -1);
	nb_sizer = new wxBoxSizer(wxHORIZONTAL);
	nb_sizer->Add(lb, 0, wxALL, DLG_OFFSET / 2);
	panel->SetAutoLayout(TRUE);
	panel->SetSizer(nb_sizer);

	return(lb);
}

// -----------------------------------------------------------------------
bool
TCodeDialog::EditCodes(TCodes *c, BitmapList *b)
{
	bl = b;
	codes = c;

//	bl->BuildBitmapList(codes->GetBaseTable());

	BuildList(codes->GetBaseTable(), bases);
	BuildList(codes->GetAllegTable(), alleg);
	BuildList(codes->GetTradeTable(), sector);
	BuildList(codes->GetSystTable(), system);
	BuildList(codes->GetOtherTable(), other);


	if(ShowModal() != wxID_CANCEL)
		return(TRUE);

	return(FALSE);
}

// -----------------------------------------------------------------------
void
TCodeDialog::BuildList(SimpleCodeTable *ct, wxListBox *dest)
{
char buffer[DUMMY_BUFFER_SIZE];
int i=0;
CodeTableEntry *cte;
ListNode *n;

	dest->Clear();
	n = ct->First();
	while(n != NULL) {
		cte = (CodeTableEntry *)n->Data();
		if(local == cte->IsLocal()) {
			cte->GetFormated(buffer);
			dest->Append(buffer);
		}
		n = n->Next();
		i++;
	}

	if(i)
		dest->SetSelection(0);
}

// -----------------------------------------------------------------------
void
TCodeDialog::New(wxCommandEvent& event)
{
ListNode *n;
int c_ndx;
CodeTableEntry *cte;
SimpleCodeTable *ct;
LookupTable *lt;
wxListBox *lb;
bool alleg_flag=FALSE,stat=FALSE;
char buff[DUMMY_BUFFER_SIZE];

	c_ndx = nb->GetSelection();
	if(TAB_BASES == c_ndx) {
		BaseTable *bt;

		bt = codes->GetBaseTable();
		lt = bt;
		lb = bases;
		if(stat = base_dialog->NewBase(bl, bt))
			bl->BuildBitmapList(codes->GetBaseTable());
	} else if(TAB_SECTOR == c_ndx) {
		TradeTable *tt;

		tt = codes->GetTradeTable();
		lt = tt;
		lb = sector;
		stat = trade_dialog->NewTrade(tt);
    } else { 
		if(TAB_ALLEG == c_ndx) {
			alleg_flag = TRUE;
			ct = codes->GetAllegTable();
			lb = alleg;
		} else if(TAB_SYSTEM == c_ndx) {
			ct = codes->GetSystTable();
			lb = system;
		} else {
			ct = codes->GetOtherTable();
			lb = other;
		}
		lt = ct;
		stat = code_dialog->NewCode(alleg_flag, ct);
    }

	if(stat) {
		n = lt->Last();
		cte = (CodeTableEntry *) n->Data();
		cte->GetFormated(buff);
		lb->Append(buff);
	}
}

void
TCodeDialog::Edit(wxCommandEvent& event)
{
ListNode *n;
int c_ndx,ndx;
bool stat=FALSE;
wxListBox *lb;
LookupTable *lt;
char buff[DUMMY_BUFFER_SIZE];

	c_ndx = nb->GetSelection();
	if(TAB_BASES == c_ndx) {
		BaseTable *bt;
		BaseTableEntry *bte;

		ndx = bases->GetSelection();
		bt = codes->GetBaseTable();
		n = bt->Nth(ndx);
		bte = (BaseTableEntry *) n->Data();
		lb = bases;
		lt = bt;
		bl->SetBitmapIndex(bte);
		if(stat = base_dialog->EditBase(bl, bte))
			bl->SetBitmapIndex(bte);
	} else if(TAB_SECTOR == c_ndx) {
		TradeTable *tt;
		TradeTableEntry *tte;

		ndx = sector->GetSelection();
		tt = codes->GetTradeTable();
		n = tt->Nth(ndx);
		tte = (TradeTableEntry *) n->Data();
		lb = sector;
		lt = tt;
		stat = trade_dialog->EditTrade(tte);
	} else {
		bool alleg_flag=FALSE;
		SimpleCodeTable *ct;
		CodeTableEntry *cte;

		if(TAB_ALLEG == c_ndx) {
			alleg_flag = TRUE;
			ct = codes->GetAllegTable();
			lb = alleg;
		} else if(TAB_SYSTEM == c_ndx) {
			ct = codes->GetSystTable();
			lb = system;
		} else {
			ct = codes->GetOtherTable();
			lb = other;
		}
		ndx = lb->GetSelection();
		n = ct->Nth(ndx);
		cte = (CodeTableEntry *) n->Data();
		lt = ct;
		stat = code_dialog->EditCode(alleg_flag, cte);
	}

	if(stat) {
		lt->GetFormated(buff);
		lb->SetString(ndx, buff);
	}
}

void
TCodeDialog::Del(wxCommandEvent& event)
{
ListNode *n;
int c_ndx,ndx;
wxListBox *lb=NULL;

	c_ndx = nb->GetSelection();
	if(TAB_BASES == c_ndx) {
		BaseTable *bt;
		BaseTableEntry *bte;

		ndx = bases->GetSelection();
		bt = codes->GetBaseTable();
		n = bt->Nth(ndx);
		bte = (BaseTableEntry *) n->Data();
		lb = bases;

		bt->DeleteNode(n);
		delete bte;
	} else if(TAB_SECTOR == c_ndx) {
		NotImplemented("Trade Codes");
	} else {
		SimpleCodeTable *ct;
		CodeTableEntry *cte;

		if(TAB_ALLEG == c_ndx) {
			ct = codes->GetAllegTable();
			lb = alleg;
		} else if(TAB_SECTOR == c_ndx) {
			ct = codes->GetTradeTable();
			lb = sector;
		} else if(TAB_SYSTEM == c_ndx) {
			ct = codes->GetSystTable();
			lb = system;
		} else {
			ct = codes->GetOtherTable();
			lb = other;
		}
		ndx = lb->GetSelection();
		n = ct->Nth(ndx);
		cte = (CodeTableEntry *) n->Data();

		ct->DeleteNode(n);
		delete cte;
	}

	if(lb != NULL) 
		lb->Delete(ndx);
}

// =======================================================================

