/*
 * File:      3d.cpp
 * Purpose:   
 * Author:    Mark A. Nordstrand
 * Created:   
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: 3d.cpp,v $ $Revision: 1.9 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#include "3d.h"

#define MAX_FILE_LENGTH		256
// =======================================================================
Star3D::Star3D(int x_, int y_, int z_, char *n, char *s) :
	ListData()
{
int i;

	for(i = 0;i < MAX_3D_STARS;i++)
		stars[i] = NULL;
//	view_x = view_y = view_z = 0;
	x = x_;
	y = y_;
	z = z_;
	stars[0] = new DetailStar(n, s);
}

Star3D::~Star3D()
{
int i;

	for(i = 0;i < MAX_3D_STARS;i++) {
		if(stars[i] != NULL)
			delete stars[i];
	}
}

bool
Star3D::AddStar(char *n, char *s)
{
int i;

	for(i = 0;i < MAX_3D_STARS;i++) {
		if(stars[i] != NULL) {
			stars[i] = new DetailStar(n, s);
			return(TRUE);
		}
	}

	return(FALSE);
}

// -----------------------------------------------------------------------
Sector3D::Sector3D(TCodes *c, char *dn) :
	LinkedList()
{
	min_x = max_x = min_y = max_y = min_z = max_z = 0;
//	view_min_x = view_max_x = view_min_y = 
//		view_max_y = view_min_z = view_max_z = 0;
	codes = c;
	file_name = NULL;
	dir_name = new char[strlen(dn) + 1];
	strcpy(dir_name, dn);
}

Sector3D::~Sector3D()
{
	if(file_name != NULL)
		delete file_name;
}

int
Sector3D::Load(char *f)
{
int count=0,i;
char buff[MAX_FILE_LENGTH],*ptrs[6];
int x,y,z;
float f_x,f_y,f_z;
FILE *fp;
GenericParse gp;
Star3D *star;

	if((fp = fopen(f, "r")) != NULL) {
		if(file_name != NULL) 
			delete file_name;
		file_name = new char[strlen(f) + 1];
		strcpy(file_name, f);
		while(fgets(buff, MAX_FILE_LENGTH, fp) != NULL) {
			if('#' == buff[0])
				continue;
			
			// since the last field is lumin. and it's ignored,
			//  ignore the cr(-lf) crap
			i = gp.Parse(buff, ptrs, 6);

			f_x = atof(ptrs[0]);
			f_y = atof(ptrs[1]);
			f_z = atof(ptrs[2]);
			x = (int) (f_x * 10.0);
			y = (int) (f_y * 10.0);
			z = (int) (f_z * 10.0);

			if(x < min_x) min_x = x;
			if(x > max_x) max_x = x;
			if(y < min_y) min_y = y;
			if(y > max_y) max_y = y;
			if(x < min_z) min_z = z;
			if(x > max_z) max_z = z;

//fprintf(stderr, "%d %d %d <%s> <%s>\n", x, y, z, ptrs[2], ptrs[3]);
			if((star = Find(x, y, z)) != NULL) {
				star->AddStar(ptrs[3], ptrs[4]);
			} else {
				star = new Star3D(x, y, z, ptrs[3], ptrs[4]);
				Append(star);
			}
			count++;
		}
	}

	return(count);
}

Star3D *
Sector3D::Find(int x, int y, int z)
{
ListNode *n;
Star3D *s;

	n = First();
	while(n != NULL) {
		s = (Star3D *) n->Data();
		if((s->GetX() == x) && (s->GetY() == y) && (s->GetZ() == z))
			return(s);
		n = Next();
	}

	return(NULL);
}

void 
Sector3D::SetName(char *n)
{
	if(file_name != NULL)
		delete file_name;
	file_name = new char[strlen(n) + 1];
	strcpy(file_name, n);
}

void 
Sector3D::Write(void)
{
char buff[20],buff1[80];
int i,x,y,z,x_r,y_r,z_r;
Star3D *stars;
DetailStar *star;
ListNode *n;
FILE *fp;

	if((fp = fopen(file_name, "w+")) != NULL) {
		n = First();
		while(n != NULL) {
			stars = (Star3D *)n->Data();
			x = stars->GetX();
			y = stars->GetY();
			z = stars->GetZ();
			x_r = x % 10;
			y_r = y % 10;
			z_r = z % 10;
			if(x < 0)
				x_r = -x_r;
			if(y < 0)
				y_r = -y_r;
			if(z < 0)
				z_r = -z_r;
			x /= 10;
			y /= 10;
			z /= 10;
			for(i = 0;i < MAX_3D_STARS; i++) {
				if((star = stars->GetStar(i)) != NULL) {
					fprintf(fp, "%d.%d:%d.%d:%d.%d:%s:%s\n",
						x, x_r, y, y_r, z, z_r,
						star->GetName(buff1), star->GetStarStr(buff));
				}
			}
			n = Next();
		}
		fclose(fp);
	}
}

