/*
 * File:    t_res.h
 * Purpose:	general resource defs
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_res.h,v $ $Revision: 1.19 $ $Author: man $ $Date: 2003/11/02 03:00:06 $" */

#ifndef T_RES_H
#define T_RES_H

// resource defines
//  the general file to use
#ifdef __WINDOWS__
#define RESOURCE_FILE			"mtu.ini"
#else
#define RESOURCE_FILE			"mtu"
#endif

// common buffer size
#define MAX_FILE_LENGTH			256

// helper
#define VALUE_FALSE				'F'
#define VALUE_TRUE				'T'

// sector program's 'display' history
#define SECTION_DISPLAY             "Display"
//#define ENTRY_DISPLAY				"Sector"
#define ENTRY_DISPLAY_NAME			"SectorName"
#define ENTRY_DISPLAY_ROUTES		"SectorRoutes"
#define ENTRY_DISPLAY_BORDERS		"SectorBorders"
#define ENTRY_DISPLAY_NAME3D		"SectorName3D"
#define ENTRY_DISPLAY_DETAIL3D		"SectorDetailed3D"
#define ENTRY_DISPLAY_ROUTES3D		"SectorRoutes3D"
#define ENTRY_DISPLAY_SCALE			"SectorScale"
#define ENTRY_DISPLAY_ROT_X			"SectorRotX"
#define ENTRY_DISPLAY_ROT_Y			"SectorRotY"
#define ENTRY_DISPLAY_ROT_Z			"SectorRotZ"
#define ENTRY_SECTOR_LIST			"List"
#define ENTRY_SECTOR_DETAIL			"Detail"
#define ENTRY_SECTOR_MAP			"Map"

// sector program's read only status (obsolete?)
#define SECTION_READONLY            "ReadOnly"
#define ENTRY_SEC                   "Sec"
#define ENTRY_DAT                   "Dat"

// history lists 
#define SECTION_HISTORY				"History"
#define ENTRY_SECT_FILES            "SectorFile"
#define ENTRY_SYST_FILES            "SystemFile"

// where to find the main data file
#define SECTION_DATA				"Data"
#define ENTRY_DATA_DIR				"DataDir"
#define ENTRY_DATA_FILE             "DataFile"
#define ENTRY_MTU_DIR				"MtuDir"

// misc. executables
#define SECTION_EXECUTE				"Execute"
#define ENTRY_DIR					"ExeDir"
#define ENTRY_SECTOR				"Sector"
#define ENTRY_SYSGEN				"SysGen"
#define ENTRY_SYSTEM				"System"
#define ENTRY_ENC_TBL				"EncTbl"
#define ENTRY_TRADE					"Trade"
#define ENTRY_SEARCH				"Search"
#define ENTRY_WORLD					"World"
#define ENTRY_CONFIG				"CodeEd"
#define ENTRY_WORD					"Word"
#define ENTRY_SECGEN				"SecGen"
#define ENTRY_EDITOR				"Editor"
#define ENTRY_GRAPHICS				"Graphics"
#define ENTRY_VIEWER				"Viewer"
#define ENTRY_BROWSER				"Browser"
#define ENTRY_STARGEN				"StarGen"
#define ENTRY_UWPGEN				"UWPGen"

// help system
#define SECTION_HELP				"Help"
#define ENTRY_HELP_DIR				"Dir"
#define ENTRY_HELP_VIEWER			"Viewer"

// encounter table 
#define SECTION_ENCOUNTER			"Encounter"
#define ENTRY_TRAV_VER              "TravVer"
#define ENTRY_METHOD                "Method"
#define ENTRY_DICE                  "Dice"
//#define ENTRY_DIE_SIZE              "DieSize"
#define ENTRY_NUM_DIE               "NumDice"
#define ENTRY_TABLE_1D6             "Table1D6"
#define ENTRY_TABLE_2D6             "Table2D6"
#define ENTRY_TABLE_D20             "TableD20"

// colors
#define SECTION_COLOR				"Color"
#define ENTRY_CUSTOM_COLOR			"Custom"

// bitmaps
#define SECTION_BITMAP				"Bitmaps"
#define ENTRY_BITMAP_NAME			"Name"
#define ENTRY_BITMAP_FILE			"Bitmap"

// word
#define SECTION_WORD				"Word"
#define ENTRY_COUNT					"Count"
#define ENTRY_CASE					"Case"

// trade
#define SECTION_TRADE				"Trade"
#define ENTRY_FULL_BOOK_7			"Book7"
#define ENTRY_TRADE_RULE			"Enhanced"

// communications
#define SECTION_COMMUNICATION		"Communication"
#define ENTRY_PORT					"Port"

// sysgen
#define SECTION_SYSGEN				"Sysgen"
#define ENTRY_STAR_GEN				"StarGen"
#define ENTRY_ORBIT_GEN				"OrbitGen"
#define ENTRY_GEN_DETAIL			"Detail"
#define ENTRY_TECH_GEN				"TechGen"
#define ENTRY_TECH_MIN				"TechMin"
#define ENTRY_TECH_MAX				"TechMax"

#endif

