/*
 * File:      t_hex.h
 * Purpose:   traveller hex digit class
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_hex.h,v $ $Revision: 1.5 $ $Author: man $ $Date: 2003/05/17 02:45:12 $" */

#include <string.h>

#ifndef T_HEX_H
#define T_HEX_H


typedef enum T_HEX_TYPE {
	T_HEX_FULL,				// 0-Z
//	T_HEX_FULL_SPACE        // 0-Z w/ 35=' '
//	T_HEX_PORT,
	T_HEX_SIZE,             // 0-A
//	T_HEX_SIZE_EXT,         // 0-A w/ 11=S, 12=R
	T_HEX_SIZE_GG,          // as above w/ 13,14 = ' ' (GGs)
	T_HEX_TEN,              // 0-A
//	T_HEX_TEN_SPACE,        // 0-A w/ 11=' '
	T_HEX_HEX,              // 0-F
//	T_HEX_HEX_SPACE,        // 0-F w/ 16 = ' '
	T_HEX_21,               // 0-L
//	T_HEX_21_SPACE          // 0-L w/ 22 = ' '
	};

// max digits, 0-9 and A-Z w/o I,O
#define MAX_T_HEX		34

class t_hex
{
public:
	t_hex();
	t_hex(t_hex *t);
	t_hex(short s, T_HEX_TYPE v=T_HEX_FULL);
	t_hex(char c, T_HEX_TYPE v=T_HEX_FULL);
	~t_hex();

	char get_t_hex(void);
	short get_t_hex_val(void) { return(val); };

	void set_t_hex(char);
	void set_t_hex_val(short);

	T_HEX_TYPE GetType(void) { return(type); };
private:
	short			val;
	T_HEX_TYPE		type;
    static char *val_str;// = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
	static char *size_str;
//	static char *space_str;

	short xlat_digit(char c);
	short get_max(void);
};



#endif

