/*
 * File:	sector.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_frame.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2000/07/15 14:04:33 $" */

#ifndef T_FRAME_H
#define T_FRAME_H

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/dc.h"
#include "wx/frame.h"
#include "wx/scrolwin.h"
#include "wx/textctrl.h"

// ====================================================
// misc canvases
// Define a new canvas which can receive some events
#define TEXT_X_OFFSET	16
#define TEXT_Y_INCR		12

// base dumping interface
class DisplayMethod
{
public:
	DisplayMethod();
	DisplayMethod(wxDC *d, int x=0, int y=0, int len=-1);
	DisplayMethod(FILE *fpx, int len=-1);
	DisplayMethod(wxTextCtrl *tc, int len=-1);
	virtual ~DisplayMethod();

	void Start(char *buff=NULL);
	void Header1(char *buff);
	void Header2(char *buff);
	void Line(char *);
	void Finish(char *buff=NULL);
	
// not implemented yet
	void UpdateLine(int, char *buff, wxColour *, wxColour *);

	char *SplitLine(char *);

private:
	void CommonInit(int len);

	FILE *fpx;
	wxDC *dc;
	wxTextCtrl *text;

	int cur_y;
	int line_length;
	int offset;

	int x_base,y_base;
};

// ====================================================
// general frame
class SubFrame : public wxFrame
{
public:
	SubFrame(wxFrame *frame, const char *title,
			 int x, int y, int w, int h, long s);
	~SubFrame();

	void OnSize(int w, int h);

	bool ToggleShow(void);
	bool IsShown(void) { return(isShown); };

	void OnCloseWindow(wxCloseEvent &event);

	virtual void MenuCheckCallBack(SubFrame *) = 0;

	wxScrolledWindow	*canvas;

private:
	// recursion flag (for OnSize''ing)
	bool		recFlag;
	bool		isShown;
	DECLARE_EVENT_TABLE()
};

#endif

