/*
 * File:    t_code.h
 * Purpose:	wrapper around various common codes
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_code.h,v $ $Revision: 1.6 $ $Author: man $ $Date: 2001/12/02 18:16:21 $" */


#ifndef T_CODE_H
#define T_CODE_H

#include "codetbl.h"

// gather all the common code tables into a single class
class TCodes
{
public:
	TCodes(char *cfg_dir);
	~TCodes();

    bool LoadCfg(char *cfg_dir);
    bool SaveCfg(char *cfg_dir);

	TradeTable *GetTradeTable(void) { return(trade_table); };
	CodeTable *GetSystTable(void) { return(syst_table); };
	CodeTable *GetOtherTable(void) { return(other_table); };
	CodeTable *GetAllegTable(void) { return(alleg_table); };
	BaseTable *GetBaseTable(void) { return(base_table); };

	void WriteHeader(FILE *fpx, char *sect_str, char *format_str);

	void ClearLocal(void);

private:
	TradeTable		*trade_table;
	CodeTable		*syst_table;
	CodeTable		*other_table;
	CodeTable		*alleg_table;
	BaseTable		*base_table;

};

#endif

