/*
 * File:      t_bm.h
 * Purpose:   general (small) bitmap list
 * Author:    Mark A. Nordstrand
 * Created:   9/25/1999
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_bm.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


#ifndef T_BM_H
#define T_BM_H

#include "wx/list.h"
#include "wx/bitmap.h"

#include "codetbl.h"

#include "wx/confbase.h"
#include "wx/fileconf.h"

// ========================================================================
class NamedBitmap : public wxObject
{
public:
	NamedBitmap(char *f, char *n);
	NamedBitmap(wxBitmap *bm, char *n);
	~NamedBitmap();

	char *GetFilename(void) { return(file_name); };
	char *GetName(void) { return(name); };
	wxBitmap *GetBM(void) { return(bm); };

	void SetName(char *n);
	void SetFilename(char *f);

private:
	char *file_name;
	char *name;
	wxBitmap *bm;
};

// ---------------------------------------------------------------------------
class BitmapList : public wxList
{
public:
	BitmapList(wxConfig *config);
	~BitmapList();

	wxBitmap *NthBM(int n, bool NULL_OK=FALSE);
	char *NthName(int n);
	NamedBitmap *GetNth(int n);
	char *NthFilename(int n);

	bool Load(wxConfig *cfg);
	bool Save(wxConfig *cfg);

	int BuildBitmapList(BaseTable *bt);
	void SetBitmapIndex(BaseTableEntry *bte);

private:
	wxBitmap		*_default;
};

#endif

