//
// File:		stargen.h
// Purpose:		global declarations for stargen
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: stargen.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/04/13 14:20:14 $"

#ifndef STARGEN_H
#define STARGEN_H

#include "d_star.h"
#include "t_dice.h"

// primary, 2 comp. ea. w/ a comp.
#define MAX_STAR_GEN				5
#define STAR_BUFFER_SIZE			8

#define MAX_STAR_TABLE_ENTRY		13

#define STARGEN_DATA_FILE			"stargen.dat"

// in order to have access to the tables, inherit from DetailStar 
class GenStar : public DetailStar
{
public:
	GenStar(char *f);
	~GenStar() {};

	void GenStars(int num, char *uwp, char *st[5]);

	void GenerateStar(int ndx, int *type_roll, int *size_roll, 
					char *uwp, char *st);
	int GenSystemNature(void);
	int GenOrbit(bool trinary);
	int GenMaxOrbits(char *star);

	// special one for when we already have a generated star
	void GenComp(char *p, char *st);

private:
	void VerifyStar(char *st);
	void LookupStar(char *st, int *t, int *s, int *ndx);

	Dice			dice;

	static char		system_nature[MAX_STAR_TABLE_ENTRY+1];
	static char		primary_type[MAX_STAR_TABLE_ENTRY+1];
	static char		primary_size[MAX_STAR_TABLE_ENTRY][6];
	static char		companion_type[MAX_STAR_TABLE_ENTRY+1];
	static char		companion_size[MAX_STAR_TABLE_ENTRY][6];
	static char		companion_orbit[MAX_STAR_TABLE_ENTRY+1];
	static char		companion_die[MAX_STAR_TABLE_ENTRY+1];
	static int		max_orbits[MAX_STAR_TABLE_ENTRY];

};

#endif

