/*
 * File:      mtu_dir.h
 * Purpose:   general directory structure for mtu.
 * Author:    Mark A. Nordstrand
 * Created:   9/1/2000
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: mtu_dir.h,v $ $Revision: 1.7 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#error Use of mtu_dir.h has been deprecated.  Use mtu_file.h instead.

#ifndef MTU_DIR_H
#define MTU_DIR_H

#define MTUD_NOTES		0x01
#define MTUD_SYS		0x02
#define MTUD_ENC		0x04
#define MTUD_WORLD		0x08
#define MTUD_ALL		(MTUD_NOTES | MTUD_SYS | MTUD_ENC | MTUD_WORLD)

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

class MTUDir
{
public:
	MTUDir(char *mtu_dir);
	~MTUDir();

	void SetUniv(char *u);
	void SetSect(char *s);
	void CrackNames(char *f_name);
	void ClearNames(void);
	void ClearSect(void);

	void Set3D(void) { for_3d = TRUE; };
	void Clear3D(void) { for_3d = FALSE; };
	char *GetMainDir(void) { return(main_dir); };

	char *GetUnivDir(char *buff);
	char *GetSectDir(char *buff);

	char *GetDataDir(char *buff);
	char *GetNotesDir(char *buff);
	char *GetSysDir(char *buff);
	char *GetEncDir(char *buff);
	char *GetWorldDir(char *buff);

	void VerifyDirs(unsigned int which=MTUD_ALL);

private:
	char *ExtractDir(char *n);
	char *BuildDir(char *buff, char *str, bool extra=TRUE);

	bool	for_3d;		// for 3D
	char	*main_dir;
	char	*univ_dir;
	char	*sect_dir;
};

#endif

