/*
 * File:      clr_dlg.h
 * Purpose:   MTU menu program
 * Author:    Mark A. Nordstrand
 * Created:   9/25/1999
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: clr_dlg.h,v $ $Revision: 1.5 $ $Author: man $ $Date: 2003/05/03 18:53:00 $" */


#ifndef CLR_DLG_H
#define CLR_DLG_H

#include "t_dlg.h"
#include "color.h"

#include "wx/confbase.h"
#include "wx/fileconf.h"

// ==================================================================
class ColorArray 
{
public:
	ColorArray(wxConfig *config);
	ColorArray(ColorArray *c);
	~ColorArray();

	int Copy(ColorArray *c);
	int	GetMaxColors(void) { return(max_colors); };
	wxColour *GetColor(int ndx);
	char *GetName(int ndx);

	bool AddColor(unsigned char r_val, unsigned char g_val,
			unsigned char b_val, char *n);
	bool DeleteColor(int ndx);
	bool EditColor(int ndx, unsigned char r_val, unsigned char g_val,
			unsigned char b_val, char *n);

	bool WriteColors(wxConfig *config);
	bool LoadColors(wxConfig *config);

private:
	void Clear(void);

	int			max_colors;
	wxColour	*colors[TOTAL_COLORS];
	char		*names[TOTAL_COLORS];
};

// ==================================================================
class BaseColorDialog : public StdDialog
{
public:
	BaseColorDialog(wxWindow *p, char *title);
	virtual ~BaseColorDialog();

private:
};

// ==================================================================
class SelectColorDialog : public BaseColorDialog
{
public:
	SelectColorDialog(wxWindow *p, ColorArray *c);
	~SelectColorDialog();

	bool SelectColor(int *ndx);

private:
	void OnButton(wxCommandEvent &event);
	void DoSelection(int ndx, bool draw);

	wxBitmapButton	*colors[TOTAL_COLORS];

	int				selection;

	ColorArray		*color_array;

	DECLARE_EVENT_TABLE()
};

#endif

