/*
 * File:      3d.h
 * Purpose:   
 * Author:    Mark A. Nordstrand
 * Created:   
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: 3d.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#ifndef D3_H
#define D3_H

#include "d_star.h"
#include "t_code.h"
#include "llist.h"

// ========================================================================
// 3D universe

// this should be somewhere else!
#define MAX_3D_STARS 3

class Star3D : public ListData
{
public:
	Star3D(int x, int y, int z, char *name, char *st);
	~Star3D();

	int GetX(void) { return(x); };
	int GetY(void) { return(y); };
	int GetZ(void) { return(z); };

	DetailStar *GetStar(int ndx) { return(stars[ndx]); };
	bool AddStar(char *n, char *s);

private:
	int 			x,y,z;
	DetailStar		*stars[MAX_3D_STARS];
	
};

class Sector3D : public LinkedList
{
public:
	Sector3D(TCodes *codes, char *dir_name);
	~Sector3D();

	int Load(char *file_name);

	Star3D *Find(int x, int y, int z);

	int GetMaxX(void) { return(max_x); };
	int GetMinX(void) { return(min_x); };
	int GetMaxY(void) { return(max_y); };
	int GetMinY(void) { return(min_y); };
	int GetMaxZ(void) { return(max_z); };
	int GetMinZ(void) { return(min_z); };

	char *GetFileName(void) { return(file_name); };

	void SetName(char *);
	void Write(void);

	char *GetDirName(void) { return(dir_name); };

private:
	TCodes		*codes;
	int			max_x;
	int			min_x;
	int			max_y;
	int			min_y;
	int			max_z;
	int			min_z;

	char		*file_name;
	char		*dir_name;
};

#endif

