/*
 * File:		conv.c 
 * Purpose:		common routines for gal2mtu utilities
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: conv.c,v $ $Revision: 1.5 $ $Author: man $ $Date: 2002/10/07 23:48:13 $" */

#include <unistd.h>
#include "conv.h"

/* these 2 should be hideous enough that the user changes it */
#define DEFAULT_COLOR			10
#define DEFAULT_BASE			"Box:Box"

#define ROUTE_THRESHOLD			8

static char *bm_map[] = {
	"Triangle",
	"Box",
	"Diamond",
	"Star"
};

/* simple line reader -- strips off /n/l */
char *read_line(FILE *in, char *buff)
{
char *ret=NULL;

	ret = fgets(buff, BUFFER_SIZE, in);
	if(('\n' == buff[strlen(buff)-1]) || ('\r' == buff[strlen(buff)-1])) 
		buff[strlen(buff)-1] = '\0';
	if(('\n' == buff[strlen(buff)-1]) || ('\r' == buff[strlen(buff)-1])) 
		buff[strlen(buff)-1] = '\0';

	return(ret);
}

/* 
 * convert a text file
 */
int 
conv_text_file(char *gal_file, char *mtu_file, int err)
{
FILE *gal_fp,*mtu_fp;
char buffer[BUFFER_SIZE];

	if((gal_fp = fopen(gal_file, "r")) == NULL) {
		if(err)
			fprintf(stderr, "Cannot open %s for reading(%d).\n", 
				gal_file, errno);
		return(0);
	}
	if((mtu_fp = fopen(mtu_file, "a+")) == NULL) {
		/* this one should be reported */
		fprintf(stderr, "Cannot open %s for writing(%d).\n", mtu_file, errno);
		fclose(gal_fp);
		return(0);
	}

	while(read_line(gal_fp, buffer) != NULL) {
		fprintf(mtu_fp, "%s\n", buffer);
	}

	fclose(gal_fp);
	fclose(mtu_fp);
	return(1);
}

/* dump the start info for the 2 sector files */
static void print_headers(FILE *sec, FILE *dat, char *n)
{
char buff1[BUFFER_SIZE];
char buff2[BUFFER_SIZE];

	fprintf(sec, 
	  "\nThe data in the sector text files is laid out in column format:\n\n");
	fprintf(sec, " 1-14: Name\n");
	fprintf(sec, "15-18: HexNbr\n");
	fprintf(sec, "20-28: UWP\n");
   	fprintf(sec, "31: Bases\n");
	fprintf(sec, "33-47: Codes && Comments\n");
   	fprintf(sec, "49: Zone\n");
	fprintf(sec, "52-54: PBG\n");
	fprintf(sec, "56-57: Allegiance\n");
	fprintf(sec, "59-74: Stellar Data\n");
	fprintf(sec, 
		"....+....1....+....2....+....3....+....4"
		"....+....5....+....6....+....7....+....8\n");

	fprintf(dat, 
		"#######################################"
		"#######################################\n");
	fprintf(dat, "##\n## %s.dat\n## data file for %s.sec\n##\n", n, n);
	fprintf(dat, 
		"#######################################"
		"#######################################\n");
	
	fprintf(dat, "\n");
	fprintf(dat, 
		"#######################################"
		"#######################################\n");
	fprintf(dat, "##\n## Name Section\n## Format\n## N:Name\n##\n");
	fprintf(dat, 
		"#######################################"
		"#######################################\n");
}

/* 
 * parse a subsector
 *  stream through the galictic file, and spit appropriate bits
 *  to the .sec and .dat files
 */
static int
parse_ss(FILE *gal, FILE *sec, FILE *dat, char *gal_dir, char *mtu_dir)
{
char buff[BUFFER_SIZE],buff1[BUFFER_SIZE],buff2[BUFFER_SIZE],lbuff[8];
int count=0;
	
	while(read_line(gal, buff) != NULL) {
		count++;
		if((strlen(buff) == 0) || ('@' == buff[0]) || ('#' == buff[0]))
			continue;

		if('$' == buff[0]) {			/* route */
			char loc[5],dest_x[5],dest_y[5];
			int x1,x2,y1,y2;

			strncpy(loc, &buff[1], 4);
			loc[4] = 0;
			strncpy(dest_x, &buff[6], 2);
			dest_x[2] = 0;
			strncpy(dest_y, &buff[8], 2);
			dest_y[2] = 0;
			x2 = atoi(loc);
			x1 = x2 / 100;
			y1 = x2 % 100;
			x2 = atoi(dest_x);
			y2 = atoi(dest_y);
			if(((x2 - x1) > ROUTE_THRESHOLD) ||
				((x1 - x2) > ROUTE_THRESHOLD)) {
				if('-' == buff[11])
					x2 -= 32;
				else
					x2 += 32;
				sprintf(dest_x, "%d", x2);
			}
			if(((y2 - y1) > ROUTE_THRESHOLD) ||
				((y1 - y2) > ROUTE_THRESHOLD)) {
				if('-' == buff[13])
					y2 -= 40;
				else
					y2 += 40;
				sprintf(dest_y, "%d", y2);
			}

			fprintf(dat, "R:%s:%s:%s:0\n", loc, dest_x, dest_y);
		} else {
			if(strlen(buff) > 57) {
				buff[57] = 0;
				if(('f' == buff[62]) || ('m' == buff[62])) {
					lbuff[0] = buff[14];
					lbuff[1] = buff[15];
					lbuff[2] = buff[16];
					lbuff[3] = buff[17];
					lbuff[4] = 0;

					sprintf(buff1, "%s/menu", mtu_dir);
					mkdir(buff1, 0755);
					strcat(buff1, "/p");
					strcat(buff1, lbuff);
					strcat(buff1, ".");
					sprintf(buff2, "%s/loc/p%s.", gal_dir, lbuff);

					if('f' == buff[62]) {
						char nbuff[BUFFER_SIZE],*ptr;
						FILE *nfp;

						sprintf(nbuff, "%smenu", buff1);
						if((nfp = fopen(nbuff, "a+")) != NULL) {
							ptr = strchr(mtu_dir, '/');
							ptr++;
							fprintf(nfp, "D:%s/desc\n", ptr);
							sprintf(nbuff, "p%s.txt", lbuff);
							fprintf(nfp, "T:%s Info:%s\n", lbuff, nbuff);
							fclose(nfp);
						}
						sprintf(buff1, "%s/desc", mtu_dir);
						mkdir(buff1, 0755);
						strcat(buff1, "/p");
						strcat(buff1, lbuff);
						strcat(buff1, ".txt");
						strcat(buff2, "txt");
						conv_text_file(buff2, buff1, 1);
					} else if('m' == buff[62]) {
						char buff3[BUFFER_SIZE],*ptr;
						FILE *gal_fp;

						strcat(buff1, "menu");
						strcat(buff2, "mnu");
						ptr = strrchr(buff1, '/');
						ptr++;
						sprintf(buff3, "%s", ptr);

						if((gal_fp = fopen(buff2, "r")) == NULL) {
							fprintf(stderr, "Cannot open %s for reading(%d).\n",
											buff2, errno);
						} else {
							char gal_buff[BUFFER_SIZE],mtu_buff[BUFFER_SIZE];
							FILE *mtu_fp;

							strcpy(gal_buff, gal_dir);
							ptr = strrchr(gal_buff, '/');
							*ptr = 0;
							ptr = strrchr(gal_buff, '/');
							*ptr = 0;
							strcpy(mtu_buff, mtu_dir);
							ptr = strrchr(mtu_buff, '/');
							*ptr = 0;
							ptr = strrchr(mtu_buff, '/');
							*ptr = 0;
							sprintf(buff1, "%s/menu/", mtu_dir);
							mkdir(buff1, 0775);
							sprintf(buff1, "%s/menu/%s", mtu_dir, buff3);
							if((mtu_fp = fopen(buff1, "a+")) == NULL) {
								fprintf(stderr, 
									"Cannot open %s for writing(%d).\n", 
									buff1, errno);
								fclose(gal_fp);
							}

							convert_menu(gal_fp, gal_buff, mtu_fp, mtu_buff);
							fclose(gal_fp);
							fclose(mtu_fp);
						}

					}
				} else if((buff[62] != 0) && (buff[62] != ' ') &&
						(buff[62] != '-')) {
//					fprintf(stderr, "gal:<%s> mtu:<%s> d:<%s>  ",
//							gal_dir, mtu_dir, buff);
					fprintf(stderr, 
							"Attachment field of '%c' (0x%x) unknown.\n", 
							buff[62], buff[62]);
				}
			}
			if('*' == buff[19]) {
				strncpy(buff1, buff, 14);
				buff1[14] = 0;
				strstrip(buff1, 1);
				strstrip(buff1, 0);
				strncpy(buff2, &buff[22], 25);
				buff2[25] = 0;
				strstrip(buff2, 1);
				strstrip(buff2, 0);

				fprintf(dat, "P:%c%c%c%c:%s:%s:%s\n", buff[14], buff[15],
						buff[16], buff[17], buff1, buff2, 
						bm_map[buff[20] - '1']);
			} else {
				fprintf(sec, "%s\n", buff);
			}
		}
		// set this for future checks....
		buff[62] = 0;
	}

	return(count);
}

/*
 * parse the 'top level' galactic file.
 *  stream through the main galactic sector file.
 */
int 
parse_galactic(char *gal_dir, FILE *gal, FILE *sec, FILE *dat, 
			char *mtu_dir, char *n)
{
char buff[BUFFER_SIZE];
int line_count=0;
int bases=0,alleg=0;
FILE *temp;				/* for routes */

	sprintf(buff, "/tmp/sec.%d", getpid());
	if((temp = fopen(buff, "w")) == NULL) {
		fprintf(stderr, "Cannot open %s for writing(%d).\n", buff, errno);
		return(0);
	}

	fprintf(temp, 
		"\n#######################################"
		"#######################################\n");
	fprintf(temp, "##\n## Title section\n## format:\n## T:which(R or B):color index:caption\n##\n");
	fprintf(temp, 
		"#######################################"
		"#######################################\n");
	fprintf(temp, "T:B:%d:Unlabeled Border\nT:R:%d:Unlabeled Route\n\n", 
		DEFAULT_COLOR, DEFAULT_COLOR);
	fprintf(temp, 
		"#######################################"
		"#######################################\n");
	fprintf(temp, "##\n## Route section\n## format:\n## R:source:dest. X:dest. Y:route index\n##\n");
	fprintf(temp, 
		"#######################################"
		"#######################################\n");

	print_headers(sec, dat, n);
	/* parse the main file */
	while(read_line(gal, buff) != NULL) {
		line_count++;
		if(1 == line_count) { 				/* sector name */
			fprintf(dat, "N:%s\n\n", buff);
			fprintf(dat, 
				"#######################################"
				"#######################################\n");
			fprintf(dat, "##\n## Subsector section\n## format:\n## S:ndx(A-P):name\n##\n");
			fprintf(dat, 
				"#######################################"
				"#######################################\n");
		} else if((line_count > 2) 
				&& (line_count < 19)) {		/* subsector names/files */
			char *file,*name;
			FILE *gal2;
			char buff2[BUFFER_SIZE];

			buff[49] = 0;
			file = &buff[29];
			buff[28] = 0;
			name = &buff[3];

			strstrip(name, 1);
			fprintf(dat, "S:%c:%s\n", buff[0], name);

			strstrip(file, 1);
			sprintf(buff2, "%s/%s/%s", gal_dir, "map", file);
			if((gal2 = fopen(buff2, "r")) == NULL) {
				fprintf(stderr, "Cannot open %s for reading(%d).\n", 
					buff2, errno);
			} else {
				parse_ss(gal2, sec, temp, gal_dir, mtu_dir);
				fclose(gal2);
			}

		} else {							/* parse.... */
			if(strncmp(buff, "Bases:", 6) == 0) {
				bases = 1;
				fprintf(temp, 
					"\n#######################################"
					"#######################################\n");
				fprintf(temp, "##\n## Bases section\n## format:\n## E:c:text:1st bitmap:2nd bitmap(optional)\n##\n");
				fprintf(temp, 
					"#######################################"
					"#######################################\n");
			} else if(strncmp(buff, "Allegiance:", 11) == 0) {
				fprintf(temp, 
					"\n#######################################"
					"#######################################\n");
				fprintf(temp, "##\n## Allegiance section\n## format:\n## E:co:text\n##\n");
				fprintf(temp, 
					"#######################################"
					"#######################################\n");
				alleg = 1;
			} else if(alleg) {
				char *code,*desc;

				if(buff[3] != ' ') {
					code = &buff[3];
					desc = &buff[8];
					buff[5] = 0;
					fprintf(temp, "A:%s:%s\n", code, desc);
				}
			} else if(bases) {
				char *code,*desc;

				code = &buff[0];
				desc = &buff[4];
				buff[1] = 0;
				if((*code != 0) && (*code != ' '))
					fprintf(temp, "E:%s:%s:%s\n", code, desc, DEFAULT_BASE);
			}
		}
	}

	fclose(temp);

	/* go back thru the temp file, and append it to the dat file */
	sprintf(buff, "/tmp/sec.%d", getpid());
	if((temp = fopen(buff, "r")) == NULL) {
		fprintf(stderr, "Cannot open %s for reading(%d).\n", buff, errno);
		return(0);
	}

	while(read_line(temp, buff) != NULL) {
		fprintf(dat, "%s\n", buff);
	}
	fclose(temp);
	unlink(buff);

	return(1);
}

