/***********************************************************************
*	Lifepath.c	A lifepath generation for CyberPunk 2.0.2.0. (TM)
*					Written in ANSI C by Robert Deck during July-August 1992
*				   The data tables contained within this program are Copyright
*				   R. Talsorian Games.  All other code is original to the author
*              and may not be used commercially without his express written
*              permission.
************************************************************************/ 
 
/* Version 2.0 */

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define TRUE 1
#define FALSE 0

/************************************************************************
*	CP structure for handling generated data
************************************************************************/

struct SIBLING {
	char	*trait[3];
	};

struct PERSON {
	int	style[3],race,mot[5];
	};

struct YEAR {
	int	num,pflag;
	char	*event[5];
	struct	PERSON	P;
	};

struct CP {
	int 	total,stat[17],role,eb,age,sib,wage;
	char	*family[4],*psycat,*QU[25];
	struct	YEAR		YE[12];
	struct 	SIBLING	SI[7];
	} Dude;


/************************************************************************
*	Prototyping of functions
************************************************************************/

int  die_roll		( int num, int size );
int  checknum		( int min, int max );
char *stripspc		( char *string );
void make_person	( struct PERSON *Person );
void life_path		( struct CP *Punk );
void output			( struct CP *Punk );


/************************************************************************
*	Begining Tables for character generation
************************************************************************/

static char *
roles[45] = {
	"Rocker",											/* Charasmatic Leadership */
	"Cult Leader              (v2,2)",			/* Charasmatic Leadership */
	"Stripper                 (WGF)",			/* Vamp */
	"Spy                      (WGF)",			/* Chameleon */
	"Solo",												/* Combat Sense */
	"Corporate Operative      (v1,3)",			/* Combat Sense */
	"Ex-Cybersoldier          (v1,3)",			/* Combat Sense */
	"Bodyguard                (v1,3)",			/* Combat Sense */
	"Bounty Hunter            (v1,3)",			/* Combat Sense */
	"Street Samurai           (v1,3)",			/* Combat Sense */
	"Space Marine             (Deep Space)",	/* Space Combat */
	"PA Trooper               (Max Metal)",	/* PA Combat Sense */
	"Cop",												/* Authority */
	"Private Eye              (v1,4)",			/* Research */
	"Corporate",										/* Resources */
	"Government Official      (v1,4)",			/* Resources */
	"Lawyer                   (v2,2)",			/* Credibility */
	"Media",												/* Credibility */
	"Journalist/Correspondent (v2,1)",			/* Credibility */
	"Investigative Reporter   (v2,1)",			/* Credibility */
	"War Correspondent        (v2,1)",			/* Credibility */
	"Sensationalist           (v2,1)",			/* Credibility */
	"Tabloid Media            (v2,1)",			/* Titillate */
	"Fixer",												/* Streetdeal */
	"Scavenger                (v1,2)",			/* Streetdeal */
	"Pimp/Pusher              (v1,2)",			/* Streetdeal */
	"Broker                   (v1,2)",			/* Streetdeal */
	"Racketeer                (v1,2)",			/* Streetdeal */
	"Black Marketeer          (v1,2)",			/* Streetdeal */
	"Techie",											/* Jury Rig */
	"Salver                   (Deep Space)",	/* Salvage */
	"Medic",												/* Medical Tech */
	"Jockey                   (v1,4)",			/* Brotherhood */
	"Highrider                (v1,5)",			/* Brotherhood */
	"Workganger               (v1,4)",			/* Workgang */
	"Netrunner",										/* Interface */
	"Rogue Hunter             (v1,3)",			/* Interface */
	"Nomad",												/* Family */
	"Pirate                   (v1,4)",			/* Family */
	"Poser StreetPunk         (v1,4)",			/* Rank */
	"Chromer StreetPunk       (v1,4)",			/* Rank */
	"Booster StreetPunk       (v1,4)",			/* Rank */
	"'Dorpher StreetPunk      (v1,4)",			/* Rank */
	"Zoomer StreetPunk        (v1,4)",			/* Rank */
	"Inquisitor Predator      (Night's Edge)"	/* Rank */};

static char *
statistic[17] = {
	"Intelligence       (INT) ",
	"Reflexes           (REF) ",
	"Cool               (CL)  ",
	"Technical Ability  (TECH)",
	"Luck               (LK)  ",
	"Attractiveness     (ATT) ",
	"Movement Allowance (MA)  ",
	"Empathy            (EMP) ",
	"Body Type          (BOD) ",
	"Psyche             (PSY) ",
	"Reputation         (REP) ",
	"Run                (RUN) ",
	"Leap               (LEAP)",
	"Humanity           (HUM) ",
	"Body Type Modifier (BTM) ",
	"Lift               (LIFT)",
	"Save               (SAVE)"};


/************************************************************************
*	Origins and Personal Style
************************************************************************/

static char *
clothes[10] = {
	"Biker Leathers",
	"Blue Jeans",
	"Corporate Suits",
	"Jumpsuits",
	"Miniskirts",
	"High Fashion",
	"Cammos",
	"Normal Clothes",
	"Nude",
	"Bag Lady Chic"};

static char *
hairstyle[10] = {
	"Mohawk",
	"Long & Ratty",
	"Short and Spiked",
	"Wild & All Over",
	"Bald",
	"Striped",
	"Tinted",
	"Neat, Short",
	"Short, Curly",
	"Long, Straight"};

static char *
affectations[10] = {
	"Tatoos",
	"Mirrorshades",
	"Ritual Scars",
	"Spiked Gloves",
	"Nose Rings",
	"Earrings",
	"Long Fingernails",
	"Spiked Heeled Boots",
	"Weird Contact Lenses",
	"Fingerless Gloves"};


/************************************************************************
*	Ethnicity
************************************************************************/

static char *
ethnicity[10] = {
	"Anglo-American",
	"African",
	"Japanese/Korean",
	"Central European/Soviet",
	"Pacific Islander",
	"Chinese/Southeast Asian",
	"Black American",
	"Hispanic American",
	"Central/South American",
	"European"};


/************************************************************************
*	Family Background
************************************************************************/

static char *
fam_rank[10] = {
	"Family rank: Corporate Executive",
	"Family rank: Corporate Manager",
	"Family rank: Corporate Technician",
	"Family rank: Nomad Pack",
	"Family rank: Pirate Fleet",
	"Family rank: Gang Family",
	"Family rank: Crime Lord",
	"Family rank: Combat Zone Poor",
	"Family rank: Urban Homeless",
	"Family rank: Arcology Family"};

static char *
parents_bad[10] = {
	"Your parent(s) died in warfare",
	"Your parent(s) died in an accident",
	"Your parent(s) were murdered",
	"Your parent(s) have amnesia and don't remember you",
	"You never knew your parents",
	"Your parent(s) are in hiding to protect you",
	"You were left with relatives for safe keeping",
	"You grew up on the Street and never had parents",
	"Your parent(s) gave you up for adoption",
	"Your parent(s) sold you for money"};

static char *
child_envir[10] = {
	"Childhood: Spent on the street, with no adult supervision",
	"Childhood: Spent in a safe Corporate Suburbia",
	"Childhood: In a Nomad Pack moving from town to town",
	"Childhood: In a decaying, once upscale neighborhood",
	"Childhood: In a defended Corporate Zone in the central City",
	"Childhood: In the heart of the Combat Zone",
	"Childhood: In a small village or town far from the City",
	"Childhood: In a large arcology city",
	"Childhood: In an aquatic Pirate Pack",
	"Childhood: On a Corporate controlled Farm or Research Facility"};

static char *
fam_tragedy[10] = {
	"Family lost everything through betrayal",
	"Family lost everything through bad management",
	"Family exiled/driven from their original home/nation/corporation",
	"Family is imprisoned and you alone escaped",
	"Family vanished; you are the only remaining member",
	"Family was murdered/killed and you were the only survivor",
	"Family is involved in a longterm conspiracy or organized crime",
	"Your family was scattered to the winds due to misfortune",
	"Your family has a hereditary feud that has lasted for generations",
	"You inherited a debt; you must honor this debt before moving on"};

static char *
gender[4] = {
	"Male",
	"Female",
	"Male",
	"Female"};

static char *
older[10] = {
	"Older",
	"Older",
	"Older",
	"Older",
	"Older",
	"Younger",
	"Younger",
	"Younger",
	"Younger",
	"Twin"};

static char *
sib_feel[5] = {
	"Sibling dislikes you",
	"Sibling likes you",
	"Sibling neutral",
	"They hero worship you",
	"They hate you"};


/************************************************************************
*	Motivations
************************************************************************/

static char *
per_trait[10] = {
	"Shy and secretive",
	"Rebellious, antisocial, violent",
	"Arrogant, proud, and aloof",
	"Moody, rash, and headstrong",
	"Picky, fussy, and nervous",
	"Stable and serious",
	"Silly and fluffheaded",
	"Sneaky and deceptive",
	"Intellectual and detatched",
	"Friendly and outgoing"};

static char *
val_person[10] = {
	"A parent",
	"Brother or sister",
	"Lover",
	"Friend",
	"Yourself",
	"A pet",
	"Teacher or master",
	"Public figure",
	"A personal hero",
	"No one"};

static char *
val_idea[10] = {
	"Money",
	"Honor",
	"Your word",
	"Honesty",
	"Knowledge",
	"Vengance",
	"Love",
	"Power",
	"Having a good time",
	"Friendship"};

static char *
feel_people[10] = {
	"Neutral",
	"Neutral",
	"You/they like almost everyone",
	"You/they hate almost everyone",
	"People are tools to be used and discarded",
	"Each person is a valuable individual",
	"People are obsticles, crush them if they interfere",
	"People are untrustworthy, depend only on yourself",
	"Kill the humans and let the cockroaches take over",
	"People are wonderful"};

static char *
val_thing[10] = {
	"A weapon",
	"A tool",
	"A piece of clothing",
	"A photograph",
	"A book or diary",
	"A recording",
	"A musical instrument",
	"A piece of jewelry",
	"A toy",
	"A letter"};


/************************************************************************
*	Big Problems, Big Wins
************************************************************************/

static char *
disaster[10] = {
	"Financial loss or debt",
	"Imprisonment",
	"Illness or addiction",
	"Betrayal",
	"Accident",
	"Lover, friend or relative killed",
	"False accusation",
	"Hunted by the law",
	"Hunted by a corporation",
	"Mental or physical incapacitation"};

static char *
lucky[10] = {
	"Make powerful connection",
	"Financial windfall",
	"Big score",
	"Find a sensei",
	"Find a teacher",
	"Powerful corporate executive owes you one favor",
	"Local nomad pack befriends you",
	"Make a friend on the police force",
	"Local bostergang likes you",
	"Find a combat teacher"};

static char *
gonna_do[5] = {
	"Your reaction: Clear your name",
	"Your reaction: Live it down and try to forget it",
	"Your reaction: Hunt down those responsible and make then pay",
	"Your reaction: Get what's rightfully yours",
	"Your reaction: Save, if possible, anyone else involved in the situation"};


/************************************************************************
*	Friends and Enemies
************************************************************************/

static char *
enemy[10] = {
	"They are: Ex friend",
	"They are: Ex lover",
	"They are: Relative",
	"They are: Childhood enemy",
	"They are: Person working for you",
	"They are: Person you work for",
	"They are: Partner or co-worker",
	"They are: Booster gang member",
	"They are: Drifting Nomad",
	"They are: Government official"};

static char *
cause[10] = {
	"Reason: Caused the other to lose face or status",
	"Reason: Caused the loss of a lover, friend, or relative",
	"Reason: Caused a major humiliation",
	"Reason: Accused the other of cowardace/personal flaw",
	"Reason: Caused a physical disability",
	"Reason: Deserted or betrayed the other",
	"Reason: Turned down the other's job offer/romantic invitation",
	"Reason: Just hate each other",
	"Reason: Was a romantic rival",
	"Reason: Foiled a plan of the other's"};

static char *
whatcha_do[5] = {
	"Reaction: Go into a murderous rage and attack",
	"Reaction: Avoid the scum",
	"Reaction: Backstab indirectly",
	"Reaction: Ignore the scum",
	"Reaction: Rip into them verbally"};

static char *
resources[10] = {
	"Resources: Just themselves",
	"Resources: Just themselves",
	"Resources: Just themselves",
	"Resources: They and a few friends",
	"Resources: They and a few friends",
	"Resources: An entire gang",
	"Resources: An entire gang",
	"Resources: A small Corporation",
	"Resources: A large Corporation",
	"Resources: An entire Government Agency"};

static char *
buddy[10] = {
	"Person you work for/with",
	"Like big brother/sister",
	"Like a kid brother/sister",
	"A teacher/mentor",
	"An old lover (choose)",
	"An old enemy (choose)",
	"Like a foster parent",
	"A relative",
	"Reconnect with childhood friend",
	"Met through common interest"};


/************************************************************************
*	Romantic Life
************************************************************************/

static char *
tragic_love[10] = {
	"Tragedy: Lover died in accident",
	"Tragedy: Lover mysteriously vanished",
	"Tragedy: It didn't work out",
	"Tragedy: A personal goal or vendetta came between you",
	"Tragedy: Lover kidnapped",
	"Tragedy: Lover went insane",
	"Tragedy: Lover commited suicide",
	"Tragedy: Lover killed in a fight",
	"Tragedy: Rival cut you out of the action",
	"Tragedy: Lover imprisoned or exiled"};

static char *
problem_love[10] = {
	"Problem: Lover's friends/family hate you",
	"Problem: Lover's friends/family want you dead",
	"Problem: Your friends/family hate them",
	"Problem: One of you has a romatic rival",
	"Problem: Separated in some way",
	"Problem: You fight contantly",
	"Problem: You're professional rivals",
	"Problem: One of you is insanely jealous",
	"Problem: One of you is messing around",
	"Problem: Conflicting backgrounds or families"};

static char*
mutual_feel[10] = {
	"Mutual feelings: They still love you",
	"Mutual feelings: You still love them",
	"Mutual feelings: You still love each other",
	"Mutual feelings: You hate them",
	"Mutual feelings: They hate you",
	"Mutual feelings: You hate each other",
	"Mutual feelings: You're friends",
	"Mutual feelings: No feelings, it's over",
	"Mutual feelings: You like them, they hate you",
	"Mutual feelings: You hate them, they like you"};	


/************************************************************************
*	Uniformly-distributed random number generator.
*	Generates a number between 1 and n, with all results having
*	EQUAL probability.  The expressions rand()%n or srand48()%n
*	have uniformly-distributed results ONLY if n is a power of 2
*	...which is why this routine is needed.
************************************************************************/
/* RAND_MAX is not guaranteed to be 32767 on all machines, so we limit
*  the result of rand() to this value to prevent overflows.
*
*  the formula is:
*
*  {rand() from 0 to 32767} * (desired range) / (max range) + 1
*/

#define unirand(n) ((long)(rand()&0x00007fff)*(n)/0x00008000+1L)



/************************************************************************
*	Die roll
************************************************************************/

int die_roll( int num, int size )

{
	int cnt, roll = 0;
	for (cnt = 0; cnt < num; cnt++) roll += unirand(size);
	return roll;
}


/************************************************************************
*	checknum
************************************************************************/

int checknum( int min, int max )

{
	int getit;
   fflush(stdin);
	scanf("%d",&getit);
	while ( getit < min || getit > max ) {
		printf("Number out of range.  Min = %d, Max = %d.  Retry: ",min,max);
      fflush(stdin);
		scanf("%d",&getit);
	}
	return getit;
}


/************************************************************************
*	This function strips all white space from a string.
*************************************************************************/

char *stripspc(char *string)
{
	short i, l = strlen(string), p = 0;
	for (i = 0; i < l; i++) if (!isspace(string[i])) string[p++] = string[i];
	string[p] = '\0';
	return string;
}


/************************************************************************
*	Make person.  Create a person for yourself, lifepath, etc.
************************************************************************/

void make_person ( struct PERSON *Person )

{
	int cnt;

	for ( cnt = 0; cnt < 3; cnt ++ )	Person->style[cnt] = die_roll(1,10) - 1;

	Person->race = die_roll(1,10) - 1;
	
	for ( cnt = 0; cnt < 5; cnt ++ )	Person->mot[cnt] = die_roll(1,10) - 1;
}


/************************************************************************
*	Life Path.  Generate character background based on age.
************************************************************************/

void life_path ( struct CP *Punk )

{
	int roll,cnt,tmp;

	Punk->family[0] = fam_rank[die_roll(1,10)-1];		/* Family BG   */

	if ( die_roll(1,10) > 6 ) Punk->family[1] = "Both parents are living";
	else Punk->family[1] = parents_bad[die_roll(1,10)-1];

	if ( die_roll(1,10) > 6 ) Punk->family[2] = "Family status is okay even if parents are missing or dead";
	else Punk->family[2] = fam_tragedy[die_roll(1,10)-1];

	Punk->family[3] = child_envir[die_roll(1,10)-1];

	Punk->sib = die_roll(1,10);								/* # Siblings  */
	if ( Punk->sib > 7 )	Punk->sib = 0;

	for ( cnt = 0; cnt < Punk->sib; cnt++ ) {
		Punk->SI[cnt].trait[0] = gender[die_roll(1,4)-1];
		Punk->SI[cnt].trait[1] = older[die_roll(1,10)-1];
		Punk->SI[cnt].trait[2] = sib_feel[die_roll(1,5)-1];
	}

	for ( cnt = 0; cnt < 17; cnt++ ) Punk->stat[cnt] = 0;

	for ( cnt = 0; cnt < Punk->age - 16; cnt++ ) {

	switch ( die_roll(1,10) ) {
		case 1:
		case 2:
		case 3:	if ( die_roll (1,10) % 2 ) {
						Punk->YE[cnt].num 	= 4;
						Punk->YE[cnt].pflag	= FALSE;
						Punk->YE[cnt].event[0]	= "Disaster Strikes";
						roll = die_roll(1,10);
						Punk->YE[cnt].event[1]	= disaster[roll-1];
						if (roll == 1) {
							Punk->eb	= Punk->eb - (100 * die_roll(1,10));
							Punk->YE[cnt].event[2] = "You lost some eb in a bad deal";
						}
						if (roll == 2) Punk->YE[cnt].event[2] = "Imprisoned for 6 months";
						if (roll == 3) {
							Punk->stat[1] += -1;
							Punk->YE[cnt].event[2] = "You lost 1 point of Reflexes";
						}
						if (roll == 4) {
							tmp = die_roll(1,10);
							if ( tmp < 4 ) 
								Punk->YE[cnt].event[2] = "You are being blackmailed";
							if ( tmp > 3 && tmp < 8 )
								Punk->YE[cnt].event[2] = "A secret of yours was exposed";
							if ( tmp > 7 ) 
								Punk->YE[cnt].event[2] = "You were betrayed by a close friend";
						}
						if (roll == 5) {
							tmp = die_roll(1,10);
							if ( tmp < 5 ) {
								Punk->stat[5] += -5;
								Punk->YE[cnt].event[2] = "Horribly disfigured from accident";
							}
							if ( tmp == 5 || tmp == 6 )
								Punk->YE[cnt].event[2] = "Hospitalized for 1d10 months";
							if ( tmp == 7 || tmp == 8 ) 
								Punk->YE[cnt].event[2] = "Lost memory of 1d10 months of this year";
							if ( tmp == 9 || tmp == 10 ) 
								Punk->YE[cnt].event[2] = "80% chance of nightmares about accident";
						}
						if (roll == 6) {
							tmp = die_roll(1,10);
							if ( tmp < 6 ) 
								Punk->YE[cnt].event[2] = "They died accidentally";
							if ( tmp > 5 && tmp < 9 )
								Punk->YE[cnt].event[2] = "They were murdered by unknown parties";
							if ( tmp > 8 ) 
								Punk->YE[cnt].event[2] = "They were murdered and you know who did it";
						}
						if (roll == 7) {
							tmp = die_roll(1,10);
							if ( tmp < 4 ) 
								Punk->YE[cnt].event[2] = "The accusation is theft";
							if ( tmp == 4 || tmp == 5 )
								Punk->YE[cnt].event[2] = "The accusation is cowardace";
							if ( tmp >5  && tmp < 9 )
								Punk->YE[cnt].event[2] = "The accusation is murder";
							if ( tmp == 9 ) 
								Punk->YE[cnt].event[2] = "The accusation is rape";
							if ( tmp == 10 ) 
								Punk->YE[cnt].event[2] = "The accusation is lying or betrayal";
						}
						if (roll == 8) {
							tmp = die_roll(1,10);
							if ( tmp < 4 ) 
								Punk->YE[cnt].event[2] = "Only a couple of local cops want you";
							if ( tmp > 3 && tmp < 7 )
								Punk->YE[cnt].event[2] = "The entire local force wants you";
							if ( tmp > 6 && tmp < 9 )
								Punk->YE[cnt].event[2] = "The State Police or Militia wants you";
							if ( tmp > 8 ) 
								Punk->YE[cnt].event[2] = "The FBI or equivalent national force wants you";
						}
						if (roll == 9) {
							tmp = die_roll(1,10);
							if ( tmp < 4 ) 
								Punk->YE[cnt].event[2] = "A small, local firm";
							if ( tmp > 3 && tmp < 7 )
								Punk->YE[cnt].event[2] = "A medium, statewide company";
							if ( tmp > 6 && tmp < 9 )
								Punk->YE[cnt].event[2] = "A large, national corporation";
							if ( tmp > 8 ) 
								Punk->YE[cnt].event[2] = "A huge, multi-national conglomorate with armies, ninjas, etc";
						}
						if (roll == 10) { 
							tmp = die_roll(1,10);
							if ( tmp < 4 ) {
								Punk->YE[cnt].event[2] = "A nervous disorder";
								Punk->stat[1] += -1;
							}
							if ( tmp > 3 && tmp < 8 ) {
								Punk->YE[cnt].event[2] = "A mental problem";
								Punk->stat[2] += -1;
							}
							if ( tmp > 7 ) {
								Punk->YE[cnt].event[2] = "Major psychosis.  Voices, violent, irrational, etc.";
								Punk->stat[2] += -1;
								Punk->stat[1] += -1;
							}
						}
						Punk->YE[cnt].event[3] = gonna_do[die_roll(1,5)-1];
					}
					else {
						Punk->YE[cnt].num 	= 3;
						Punk->YE[cnt].pflag 	= FALSE;
						Punk->YE[cnt].event[0] = "You get lucky";
						roll = die_roll(1,10);
						Punk->YE[cnt].event[1] = lucky[roll-1];
						if (roll == 1) {
							if ( tmp < 5 )
								Punk->YE[cnt].event[2] = "It's in the Police force";
							if ( tmp > 4 && tmp < 8 )
								Punk->YE[cnt].event[2] = "It's in the Distric Attorney's office";
							if ( tmp > 7 )
								Punk->YE[cnt].event[2] = "It's in the Mayor's office";
						}
						if (roll == 2 || roll == 3) {
							Punk->eb	+= (100 * die_roll(1,10));

						}
						if (roll == 4) Punk->YE[cnt].event[2] = "Start martial art at +2, or add +1 to existing martial art";
						if (roll == 5) Punk->YE[cnt].event[2] = "Start INT skill at +2, or add +1 to existing INT skill";
						if (roll == 6) Punk->YE[cnt].event[2] = "So ya better use it wisely, chombata!";
						if (roll == 7) Punk->YE[cnt].event[2] = "Call on them once/month, at a Family +2 rating";
						if (roll == 8) Punk->YE[cnt].event[2] = "Call on him for a tip at Streetwise +2 involving police";
						if (roll == 9) Punk->YE[cnt].event[2] = "Call on them once/month, at a Family +2 level";
						if (roll ==10) Punk->YE[cnt].event[2] = "Begin combat skill at +2, or add +1 -- Not m. art or brawling";
					}
					break;
		case 4:
		case 5:
		case 6:	if ( die_roll(1,10) > 5 ) {
						Punk->YE[cnt].num 	= 5;
						Punk->YE[cnt].pflag 	= TRUE;
						Punk->YE[cnt].event[0] =  "Made an enemy";
						Punk->YE[cnt].event[1] = enemy[die_roll(1,10)-1];
						Punk->YE[cnt].event[2] = cause[die_roll(1,10)-1];
						Punk->YE[cnt].event[3] = whatcha_do[die_roll(1,5)-1];
						Punk->YE[cnt].event[4] = resources[die_roll(1,10)-1];
						make_person ( &Punk->YE[cnt].P );
					}
					else {
						Punk->YE[cnt].num 	= 2;
						Punk->YE[cnt].pflag 	= TRUE;
						Punk->YE[cnt].event[0] = "Made a friend";
						Punk->YE[cnt].event[1] = buddy[die_roll(1,10)-1];
						make_person ( &Punk->YE[cnt].P );
					}
					break;
		case 7:
		case 8:	roll = die_roll(1,10);
					if ( roll < 5 ) {
						Punk->YE[cnt].num 	= 1;
						Punk->YE[cnt].pflag 	= FALSE;
						Punk->YE[cnt].event[0] = "Happy love affair";
					}
					if ( roll == 5 ) {
						Punk->YE[cnt].num 	= 3;
						Punk->YE[cnt].pflag 	= TRUE;
						Punk->YE[cnt].event[0] = "Tragic love affair";
						Punk->YE[cnt].event[1] = tragic_love[die_roll(1,10)-1];
						Punk->YE[cnt].event[2] = mutual_feel[die_roll(1,10)-1];
						make_person ( &Punk->YE[cnt].P );
					}
					if ( roll == 6 || roll == 7 ) {
						Punk->YE[cnt].num 	= 3;
						Punk->YE[cnt].pflag 	= TRUE;
						Punk->YE[cnt].event[0] = "Love affair with problems";
						Punk->YE[cnt].event[1] = problem_love[die_roll(1,10)-1];
						Punk->YE[cnt].event[2] = mutual_feel[die_roll(1,10)-1];
						make_person ( &Punk->YE[cnt].P );
					}
					if ( roll > 7 ) {
						Punk->YE[cnt].num 	= 1;
						Punk->YE[cnt].pflag 	= FALSE;
						Punk->YE[cnt].event[0] = "Fast affairs and hot dates";
					}
					break;
		case 9:
		case 10:	Punk->YE[cnt].num 	= 1;
					Punk->YE[cnt].pflag 	= FALSE;
					Punk->YE[cnt].event[0] = "Nothing happened this year";
					break;
		default:	break;
	}
	}
}


/************************************************************************
*	Output.  Send created character to user defined text file.
************************************************************************/

void output ( struct CP *Punk )

{
	FILE *fp1;
	char filename[40];  /* used to be not enough space to copy "lifefile" */
	int cnt,tmp;

	fflush(stdin);
	printf("Please enter output file name: "); fgets(filename, 40, stdin);
	stripspc(filename);

	if ( strlen(filename) <= 1) strcpy(filename,"lifefile");
	fp1 = fopen(filename,"w");

	for ( cnt = 0; cnt < 17; cnt++ )
		fprintf(fp1,"%s = %2d\n",statistic[cnt],Punk->stat[cnt]);

	fprintf(fp1,"\n");

	fprintf(fp1,"Starting Eurobucks        :  %d\n",Punk->eb);

	fprintf(fp1,"\n");

	fprintf(fp1,"Family Background\n");
	for ( cnt = 0; cnt < 4; cnt++ )
		fprintf(fp1,"%s\n",Punk->family[cnt]);

	if ( Punk->sib == 0 )
		 fprintf(fp1,"You are an only child\n");
	else {
		for ( cnt = 0; cnt < Punk->sib; cnt++ ) {
			fprintf(fp1,"Sibling #%d\t",cnt);
			fprintf(fp1,"%-10s %-10s %-s\n",
				Punk->SI[cnt].trait[0],Punk->SI[cnt].trait[1],Punk->SI[cnt].trait[2]);
		}
	}

	fprintf(fp1,"\n");

	for ( cnt = 0; cnt < Punk->age - 16  ; cnt++ ) {

		fprintf(fp1,"Lifepath %2d:  ",cnt + 16);

		for ( tmp = 0; tmp < Punk->YE[cnt].num; tmp++ )
			fprintf(fp1,"%s\n",Punk->YE[cnt].event[tmp]);

		if ( Punk->YE[cnt].pflag ) {
			fprintf(fp1,"Sex (Change if desired)   :  %s\n",gender[die_roll(1,4)-1]);
			fprintf(fp1,"Their role                :  %s\n",roles[die_roll(1,45)-1]);
			fprintf(fp1,"Clothing                  :  %s\n",clothes[Punk->YE[cnt].P.style[0]]);
			fprintf(fp1,"Hair                      :  %s\n",hairstyle[Punk->YE[cnt].P.style[1]]);
			fprintf(fp1,"Affectations              :  %s\n",affectations[Punk->YE[cnt].P.style[2]]);
			fprintf(fp1,"Ethnicity                 :  %s\n",ethnicity[Punk->YE[cnt].P.race]);
			fprintf(fp1,"Personality Traits        :  %s\n",per_trait[Punk->YE[cnt].P.mot[0]]);
			fprintf(fp1,"Person valued most        :  %s\n",val_person[Punk->YE[cnt].P.mot[1]]);
			fprintf(fp1,"Idea you value most       :  %s\n",val_idea[Punk->YE[cnt].P.mot[2]]);
			fprintf(fp1,"Feelings about most people:  %s\n",feel_people[Punk->YE[cnt].P.mot[3]]);
			fprintf(fp1,"Most valued possession    :  %s\n",val_thing[Punk->YE[cnt].P.mot[4]]);
		}
		fprintf(fp1,"\n");
	}

	fclose(fp1);
}


/************************************************************************
*	Main
************************************************************************/

void main(int argc,char *argv[])

{
	printf("Lifepath 2.0 -- A lifepath creation program for the CyberPunk RPG.\n");
	printf("Orignal ANSI C coding by Robert Deck.  This is freeware -- see docs.\n");
	printf("Copyright and trademarks for the CyberPunk game are held by\n");
	printf("R. Talsorian Games.  This software is not approved by R. Talsorian Games.\n\n");

	Dude.age = atoi(argv[1]);

	if ( Dude.age < 16 || Dude.age > 28 || argc != 2 ) {
		printf("Usage: lifepath [16 <= age <= 28]\n");
		exit(0);
	}

	srand(time(NULL));

	life_path(&Dude);

	output(&Dude);

}
