/************************************************************************
*	cybrdata.h
*	Data file for Cyber.c  All of the information here belongs to someone
*	else other than the author of Cyber.  Primary copyright holders are
*	R. Talsorian Games (CyberPunk 2.0.2.0.), (Maximum Metal), (Deep Space),
*	Prometheus Press (InterFace) and Ianus Publications, Inc. (Night's Edge).
************************************************************************/ 

/************************************************************************
*	If you are a programmer planning to modify Cyber.c, please note that
*	the order of these data tables is critical for correct operation of
*	Cyber.  Any changed data/order in one must be reflected in the other.
*	
*	There are two skill lists, short_skills and long_skills.  Any changes
*	made to one must be made to the other.
************************************************************************/ 

/************************************************************************
*	NUMREGSKILLS is the number of regular, everyone can get them, skills
*
*	NUMROLES is the number of roles the user has to choose from
***********************************************************************/

#define NUMREGSKILLS 110
#define NUMROLES 45


/************************************************************************
*	Character Roles, compiled from many sources.
***********************************************************************/

static char *
roles[45] = {
	"Rocker",											/* Charasmatic Leadership */
	"Cult Leader              (v2,2)",			/* Charasmatic Leadership */
	"Stripper                 (WGF)",			/* Vamp */
	"Spy                      (WGF)",			/* Chameleon */
	"Solo",												/* Combat Sense */
	"Corporate Operative      (v1,3)",			/* Combat Sense */
	"Ex-Cybersoldier          (v1,3)",			/* Combat Sense */
	"Bodyguard                (v1,3)",			/* Combat Sense */
	"Bounty Hunter            (v1,3)",			/* Combat Sense */
	"Street Samurai           (v1,3)",			/* Combat Sense */
	"Space Marine             (Deep Space)",	/* Space Combat */
	"PA Trooper               (Max Metal)",	/* PA Combat Sense */
	"Cop",												/* Authority */
	"Private Eye              (v1,4)",			/* Research */
	"Corporate",										/* Resources */
	"Government Official      (v1,4)",			/* Resources */
	"Lawyer                   (v2,2)",			/* Credibility */
	"Media",												/* Credibility */
	"Journalist/Correspondent (v2,1)",			/* Credibility */
	"Investigative Reporter   (v2,1)",			/* Credibility */
	"War Correspondent        (v2,1)",			/* Credibility */
	"Sensationalist           (v2,1)",			/* Credibility */
	"Tabloid Media            (v2,1)",			/* Titillate */
	"Fixer",												/* Streetdeal */
	"Scavenger                (v1,2)",			/* Streetdeal */
	"Pimp/Pusher              (v1,2)",			/* Streetdeal */
	"Broker                   (v1,2)",			/* Streetdeal */
	"Racketeer                (v1,2)",			/* Streetdeal */
	"Black Marketeer          (v1,2)",			/* Streetdeal */
	"Techie",											/* Jury Rig */
	"Salver                   (Deep Space)",	/* Salvage */
	"Medic",												/* Medical Tech */
	"Jockey                   (v1,4)",			/* Brotherhood */
	"Highrider                (v1,5)",			/* Brotherhood */
	"Workganger               (v1,4)",			/* Workgang */
	"Netrunner",										/* Interface */
	"Rogue Hunter             (v1,3)",			/* Interface */
	"Nomad",												/* Family */
	"Pirate                   (v1,4)",			/* Family */
	"Poser StreetPunk         (v1,4)",			/* Rank */
	"Chromer StreetPunk       (v1,4)",			/* Rank */
	"Booster StreetPunk       (v1,4)",			/* Rank */
	"'Dorpher StreetPunk      (v1,4)",			/* Rank */
	"Zoomer StreetPunk        (v1,4)",			/* Rank */
	"Inquisitor Predator      (Night's Edge)"	/* Rank */};


/************************************************************************
*	Stats for CyberPunk, both rolled and calculated.
*	NOTE: PSY is an optional stat, and is from Night's Edge.
***********************************************************************/

static char *
statistic[17] = {
	"Intelligence       (INT) ",
	"Reflexes           (REF) ",
	"Cool               (CL)  ",
	"Technical Ability  (TECH)",
	"Luck               (LK)  ",
	"Attractiveness     (ATT) ",
	"Movement Allowance (MA)  ",
	"Empathy            (EMP) ",
	"Body Type          (BOD) ",
	"Psyche             (PSY) ",
	"Reputation         (REP) ",
	"Run                (RUN) ",
	"Leap               (LEAP)",
	"Humanity           (HUM) ",
	"Body Type Modifier (BTM) ",
	"Lift               (LIFT)",
	"Save               (SAVE)"};


/************************************************************************
*	Short Skills List
*	
*	Short Skill description format:
*	"(XXXX)#NNNNNNNNNNNNNNNNNNNNNNNNNNNN"
*	XXXX = Parent stat of skill, 4 letters or less.
*	#    = Padding blanks btwn stat & skill name.
*	NNN* = Name of skill & padding blanks, 28 characters.
************************************************************************/
#define num_skills 159

/* Allows access of skill list through sorted index */
#define short_index(n) short_skills[skill_index[n]]
#define long_index(n)   long_skills[skill_index[n]]

int  skill_index[num_skills];

static char *
short_skills[num_skills] = {



	"(ATTR) Personal Grooming           ",	/* 0 */
	"(ATTR) Wardrobe & Style            ", /* 1 */
	"(BOD)  Endurance                   ", /* 2 */
	"(BOD)  Strength Feat               ", /* 3 */
	"(BOD)  Swimming                    ", /* 4 */
	"(COOL) Interrogation               ", /* 5 */
	"(COOL) Intimidate                  ", /* 6 */
	"(COOL) Meditation                  ", /* 7 */
	"(COOL) Oratory                     ", /* 8 */
	"(COOL) Resist Torture/Drugs        ", /* 9 */
	"(COOL) Streetwise                  ", /* 10 */
	"(EMP)  Favors                      ", /* 11 */
	"(EMP)  Human Perception            ", /* 12 */
	"(EMP)  Interview                   ", /* 13 */
	"(EMP)  Leadership                  ", /* 14 */
	"(EMP)  Seduction                   ", /* 15 */
	"(EMP)  Social                      ", /* 16 */
	"(EMP)  Persuasion & Fast Talk      ", /* 17 */
	"(EMP)  Perform                     ", /* 18 */
	"(INT)  Accounting                  ", /* 19 */
	"(INT)  Anthropology                ", /* 20 */
	"(INT)  Appraise                    ", /* 21 */
	"(INT)  Astrogation                 ", /* 22 */
	"(INT)  Awareness/Notice            ", /* 23 */
	"(INT)  Biology                     ", /* 24 */
	"(INT)  Body Language               ", /* 25 */
	"(INT)  Braindance                  ", /* 26 */
	"(INT)  Chemistry                   ", /* 27 */
	"(INT)  Composition                 ", /* 28 */
	"(INT)  Diagnose Illness            ", /* 29 */
	"(INT)  Education & Gen. Knowledge  ", /* 30 */
	"(INT)  ECM                         ", /* 31 */
	"(INT)  Expert                      ", /* 32 */
	"(INT)  Gamble                      ", /* 33 */
	"(INT)  Geology                     ", /* 34 */
	"(INT)  Hide/Evade                  ", /* 35 */
	"(INT)  History                     ", /* 36 */
	"(INT)  Know Language (choose)      ", /* 37 */
	"(INT)  Library Search              ", /* 38 */
	"(INT)  Mathematics                 ", /* 39 */
	"(INT)  Municipal Communications    ", /* 40 */
	"(INT)  Navigation                  ", /* 41 */
	"(INT)  Physics                     ", /* 42 */
	"(INT)  Programming                 ", /* 43 */
	"(INT)  Remove Alarm                ", /* 44 */
	"(INT)  Seamanship                  ", /* 45 */
	"(INT)  Shadow/Track                ", /* 46 */
	"(INT)  Space Survival              ", /* 47 */
	"(INT)  Stock Market                ", /* 48 */
	"(INT)  System Knowledge            ", /* 49 */
	"(INT)  Teaching                    ", /* 50 */
	"(INT)  Vampire Lore                ", /* 51 */
	"(INT)  Wilderness Survival         ", /* 52 */
	"(INT)  Zoology                     ", /* 53 */
	"(REF)  Archery                     ", /* 54 */
	"(REF)  Athletics                   ", /* 55 */
	"(REF)  Brawling                    ", /* 56 */
	"(REF)  Cadre Tactics               ", /* 57 */
	"(REF)  Climbing                    ", /* 58 */
	"(REF)  Dance                       ", /* 59 */
	"(REF)  Dodge & Escape              ", /* 60 */
	"(REF)  Driving                     ", /* 61 */
	"(REF)  EVA                         ", /* 62 */
	"(REF)  Fast Draw                   ", /* 63 */
	"(REF)  Fencing                     ", /* 64 */
	"(REF)  Handgun                     ", /* 65 */
	"(REF)  Heavy Weapons               ", /* 66 */
	"(REF)  Martial Art (choose)        ", /* 67 */
	"(REF)  Melee                       ", /* 68 */
	"(REF)  Motorcycle                  ", /* 69 */
	"(REF)  Operate Hvy. Mach.          ", /* 70 */
	"(REF)  Pilot (OTV)                 ", /* 71 */
	"(REF)  Pilot (Gyro)                ", /* 72 */
	"(REF)  Pilot (Fixed Wing)          ", /* 73 */
	"(REF)  Pilot (Dirigible)           ", /* 74 */
	"(REF)  Pilot (Power Armor)         ", /* 75 */
	"(REF)  Pilot (Vect. Thust Vehicle) ", /* 76 */
	"(REF)  Pilot (Spaceplane, Shuttle) ", /* 77 */
	"(REF)  Rifle                       ", /* 78 */
	"(REF)  Skate                       ", /* 79 */
	"(REF)  Slight of Hand              ", /* 80 */
	"(REF)  Stealth                     ", /* 81 */
	"(REF)  Submachine Gun              ", /* 82 */
	"(REF)  Zero-G Maneuver             ", /* 83 */
	"(REF)  Zero-G Combat               ", /* 84 */
	"(TECH) Aero Tech                   ", /* 85 */
	"(TECH) AV Tech                     ", /* 86 */
	"(TECH) Basic Tech                  ", /* 87 */
	"(TECH) Bio Tech                    ", /* 88 */
	"(TECH) Cryotank Operation          ", /* 89 */
	"(TECH) Cyberdeck Design            ", /* 90 */
	"(TECH) Cyber Tech                  ", /* 91 */
	"(TECH) Demolitions                 ", /* 92 */
	"(TECH) Desktop Engineering         ", /* 93 */
	"(TECH) Disguise                    ", /* 94 */
	"(TECH) Electronics                 ", /* 95 */
	"(TECH) Electronic Security         ", /* 96 */
	"(TECH) First Aid                   ", /* 97 */
	"(TECH) Forgery                     ", /* 98 */
	"(TECH) Gyro Tech                   ", /* 99 */
	"(TECH) Paint or Draw               ", /* 100 */
	"(TECH) Photo or Film               ", /* 101 */
	"(TECH) Pharmaceuticals             ", /* 102 */
	"(TECH) Pick Lock                   ", /* 103 */
	"(TECH) Pick Pocket                 ", /* 104 */
	"(TECH) Play Instrument             ", /* 105 */
	"(TECH) Power Armor Tech            ", /* 106 */
	"(TECH) Weaponsmith                 ", /* 107 */
	"(TECH) Spacecraft Tech             ", /* 108 */
	"(PSY)  Psychic Skill               ", /* 109 */
	"(SPEC) Charasmatic Leadership      ", /* 110 */
	"(SPEC) Vamp                        ", /* 111 */
	"(SPEC) Chameleon                   ", /* 112 */
	"(SPEC) Combat Sense                ", /* 113 */
	"(SPEC) Space Combat Sense          ", /* 114 */
	"(SPEC) PA Combat Sense             ", /* 115 */
	"(SPEC) Authority                   ", /* 116 */
	"(SPEC) Research                    ", /* 117 */
	"(SPEC) Resources                   ", /* 118 */
	"(SPEC) Credibility                 ", /* 119 */
	"(SPEC) Titilate                    ", /* 120 */
	"(SPEC) StreetDeal                  ", /* 121 */
	"(SPEC) Jury Rig                    ", /* 122 */
	"(SPEC) Salvage                     ", /* 123 */
	"(SPEC) Medical Tech                ", /* 124 */
	"(SPEC) BrotherHood                 ", /* 125 */
	"(SPEC) Workgang                    ", /* 126 */
	"(SPEC) Interface                   ", /* 127 */
	"(SPEC) Family                      ", /* 128 */
	"(SPEC) Rank                        ", /* 129 */
	"(PSY)  Animals                     ", /* 130 */
	"(PSY)  Charm                       ", /* 131 */
	"(PSY)  Cure                        ", /* 132 */
	"(PSY)  Hypnological                ", /* 133 */
	"(PSY)  Illusion                    ", /* 134 */
	"(PSY)  Mania                       ", /* 135 */
	"(PSY)  Mental                      ", /* 136 */
	"(PSY)  Mental Assault              ", /* 137 */
	"(PSY)  Mnemonic                    ", /* 138 */
	"(PSY)  Psychic Assault             ", /* 139 */
	"(PSY)  Sensory                     ", /* 140 */
	"(PSY)  Telepathy                   ", /* 141 */
	"(PSY)  Astral                      ", /* 142 */
	"(PSY)  Precognition                ", /* 143 */
	"(PSY)  Psychometry                 ", /* 144 */
	"(PSY)  Cryokinesis                 ", /* 145 */
	"(PSY)  Electrokinesis              ", /* 146 */
	"(PSY)  Healing                     ", /* 147 */
	"(PSY)  Kinesis                     ", /* 148 */
	"(PSY)  Matter Alteration           ", /* 149 */
	"(PSY)  Psychokinesis               ", /* 150 */
	"(PSY)  Pyrokinesis                 ", /* 151 */
	"(PSY)  Radiokinesis                ", /* 152 */
	"(PSY)  Teleportation               ", /* 153 */
	"(PSY)  Astral Body                 ", /* 154 */
	"(PSY)  Body Control                ", /* 155 */
	"(PSY)  Psychic Focus               ", /* 156 */
	"(PSY)  Transform                   ", /* 157 */
	"(PSY)  Regeneration                "};/* 158 */


/************************************************************************
*	Long Skills List
*	
*	Long Skill description format:
*	"(XXXX)#NNNNNNNNNNNNNNNNNNNNNNNNNNNN#-#MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM"
*	XXXX = Parent stat of skill, 4 letters or less.
*	#    = Padding blanks btwn stat, skill name, dash and description
*	NNN* = Name of skill, 28 letter or less.
*	-    = Separating dash btwn name and description.
*	MMM* = Skill description and padding blanks, out to 71 characters, total.
************************************************************************/

static char *
long_skills[159] = {
	"(ATTR) Personal Grooming - How to maximize your personal appearance     ",
	"(ATTR) Wardrobe & Style - How to know what clothes to wear & be cool    ",
	"(BOD)  Endurance - The ability to withstand pain or hardship over time  ",
	"(BOD)  Strength Feat - Bend bars, lift gates, tear phone books, etc.    ",
	"(BOD)  Swimming - How to move through water competently                 ",
	"(COOL) Interrogation - Getting specific information from people         ",
	"(COOL) Intimidate - Getting what you want by personality and/or force   ",
	"(COOL) Meditation - Calming down, professionally.  Bonus to PSY skills. ",
	"(COOL) Oratory - The skill of public speaking                           ",
	"(COOL) Resist Torture/Drugs - Increased toughness vs. physical interr.  ",
	"(COOL) Streetwise - If you have to ask, you will never know...          ",
	"(EMP)  Favors - Getting stuff on 'I owe ya one' for non-Fixers          ",
	"(EMP)  Human Perception - Detect lies, evasions, moods, emotional clues ",
	"(EMP)  Interview - Getting interesting nonspecific information          ",
	"(EMP)  Leadership - Leading and convincing people to follow youe        ",
	"(EMP)  Seduction - Forming and maintaining romantic relationships       ",
	"(EMP)  Social - Ettiquette, functioning well at various social events   ",
	"(EMP)  Persuasion & Fast Talk - Talking others into doing what you want ",
	"(EMP)  Perform - The skill of trained acting, singing, stady-up, etc.   ",
	"(INT)  Accounting - Balance books, create/detect false books, budgets   ",
	"(INT)  Anthropology - The knowledge of human cultures, customs & habits ",
	"(INT)  Appraise - Telling how much something is worth                   ",
	"(INT)  Astrogation - Navagation between planets, stars, orbits          ",
	"(INT)  Awareness/Notice - A trained observer skill                      ",
	"(INT)  Biology - General knowledge of plants, animals and life processes",
	"(INT)  Body Language - Nonverbal communication detection                ",
	"(INT)  Braindance - VR interface/combat/learning skill for non-'runners ",
	"(INT)  Chemistry - Mixing compounds and creating various chemicals      ",
	"(INT)  Composition -  Writing songs, stories, articles, flyers, etc.    ",
	"(INT)  Diagnose Illness - Clinically diagnosing symptoms & medical probs",
	"(INT)  Education & Gen. Knowledge - Book learning through HS/college    ",
	"(INT)  ECM - Using jamming equipment & methods effectively              ",
	"(INT)  Expert - Expert knowledge in a specific field                    ",
	"(INT)  Gamble - Make bets, figure odds, and play games of chance        ",
	"(INT)  Geology - Knowledge of rocks, minerals, and geologic structures  ",
	"(INT)  Hide/Evade - Losing pursuers, covering tracks, and evading       ",
	"(INT)  History - Knowledge of facts and figures of past events          ",
	"(INT)  Know Language (choose) - Knowledge of a foreign toungue          ",
	"(INT)  Library Search - Using databases, DataTerms (tm), libraries      ",
	"(INT)  Mathematics - Understanding calcuations and math formulas        ",
	"(INT)  Municipal Communications - Navagating the beaurucratic system    ",
	"(INT)  Navigation - Plotting courses over land, sea, orienteering, etc. ",
	"(INT)  Physics - Calculating physical principles,  Requires Math +4     ",
	"(INT)  Programming - Writing computer programs & re-programming systems ",
	"(INT)  Remove Alarm - Overcoming simple electronic security systems     ",
	"(INT)  Seamanship - How to act competently on a ship, sea legs, etc.    ",
	"(INT)  Shadow/Track - Covertly following people, usually in urban area  ",
	"(INT)  Space Survival - Space suit operation, space legs, etc.          ",
	"(INT)  Stock Market - Stocks, bonds, commodities, playing the market    ",
	"(INT)  System Knowledge - Knowledge of the Net, its lore, history, etc. ",
	"(INT)  Teaching - How to impart knowledge to other people               ",
	"(INT)  Vampire Lore - Knowledge of and about Vampire practices, culture ",
	"(INT)  Wilderness Survival - Surviving outside, outdoor tracking/hunting",
	"(INT)  Zoology - Relationships of/btwn lifeforms and their environment  ",
	"(REF)  Archery - Use of bows, crossbows, and arrow based ranged attacks ",
	"(REF)  Athletics - Accurate throwing, climbing, balancing, movement     ",
	"(REF)  Brawling - Untrained unarmed man to man combat, streetfighting   ",
	"(REF)  Cadre Tactics - Small group organization & tactics               ",
	"(REF)  Climbing - Urban, rock, free, and mountain climbing              ",
	"(REF)  Dance - Moving to music, for fun and profit                      ",
	"(REF)  Dodge & Escape - Dodiging attacks & escaping grapples/hold       ",
	"(REF)  Driving - Pilot ground vehicles, including tracked & hovercraft  ",
	"(REF)  EVA - Moving outside a space vehicle                             ",
	"(REF)  Fast Draw - Avoid the snapshot penalty, increased initative      ",
	"(REF)  Fencing - The mastery of swords, rapiers, and monoblades         ",
	"(REF)  Handgun - The effective use of handguns of any type              ",
	"(REF)  Heavy Weapons - As above, but mortars, autocannon, missles, etc. ",
	"(REF)  Martial Art (choose) - Trained combat, may include weapons       ",
	"(REF)  Melee - Ability to use hand to hand weapons in combat            ",
	"(REF)  Motorcycle - Required to use two and three wheeled vehicles      ",
	"(REF)  Operate Hvy. Mach. - Required to use tractors, construction equip",
	"(REF)  Pilot (OTV) - Operation of an Orbital Transfer Vehicle           ",
	"(REF)  Pilot (Gyro) - Operation of Gyro and Rotorcraft (Helocopters)    ",
	"(REF)  Pilot (Fixed Wing) - Operation of planes, jets                   ",
	"(REF)  Pilot (Dirigible) - Operation of lighter that air craft          ",
	"(REF)  Pilot (Power Armor) - Operation of APAC Armor                    ",
	"(REF)  Pilot (Vect. Thust Vehicle) - Operation of AV-XX's Harriers      ",
	"(REF)  Pilot (Spaceplane, Shuttle) - Operation of Earth-Orbit vehicles  ",
	"(REF)  Rifle - Effective use of rifles and shotguns                     ",
	"(REF)  Skate - Skateboards, in-line skates, roller skates, etc.         ",
	"(REF)  Slight of Hand - Palming objects, simple card/magic tricks, etc  ",
	"(REF)  Stealth - Evading human detection: hide in shadows, move silently",
	"(REF)  Submachine Gun - Effective use of a Sub-Machine Gun              ",
	"(REF)  Zero-G Maneuver - Advanced Space legs, not running into stuff    ",
	"(REF)  Zero-G Combat - Killing in Zero-G, dealing with recoil, knives   ",
	"(TECH) Aero Tech - Diagnose and repair of airplanes, jets, Ospreys      ",
	"(TECH) AV Tech - Diagnose and repair of ducted fans aerodyne vehicles   ",
	"(TECH) Basic Tech - Diagnose and repair of basic electrical & mechanics ",
	"(TECH) Bio Tech - Modifying existing lifeforms & environments by design ",
	"(TECH) Cryotank Operation - Operation/repair of life suspension devices ",
	"(TECH) Cyberdeck Design - Design and modification of cyberdecks         ",
	"(TECH) Cyber Tech - Reapiring and maintaining cyberwear                 ",
	"(TECH) Demolitions - Knowledge and use of explosives, timers, fuses     ",
	"(TECH) Desktop Engineering - Design using CAD on a personal computer    ",
	"(TECH) Disguise - Modifying personal appearance to resemble someone else",
	"(TECH) Electronics - Maintain/repairing/modifying personal electronics  ",
	"(TECH) Electronic Security - Install/remove locks, sensors, cameras     ",
	"(TECH) First Aid - Bind wounds, stop bleeding, stabilize the injured    ",
	"(TECH) Forgery - Copying/creating false documents, ID's, money          ",
	"(TECH) Gyro Tech - Repair/maintain gyrocopters, helocopters, rotorcraft ",
	"(TECH) Paint or Draw - Skill of producing professional drawings/painting",
	"(TECH) Photo or Film - Skill of producing professional photo/movie/video",
	"(TECH) Pharmaceuticals - Design/manufacture of drugs and medicines      ",
	"(TECH) Pick Lock - Defeating mechanical security measures               ",
	"(TECH) Pick Pocket -  Covertly removing small items from people/shops   ",
	"(TECH) Play Instrument - Specific to each instrument                    ",
	"(TECH) Power Armor Tech - Repair/maintenance of Power Armor             ",
	"(TECH) Weaponsmith - Repair/maintain/modify of weapons of all types     ",
	"(TECH) Spacecraft Tech - Repair/maintainenance of spacecraft            ",
	"(PSY)  Psychic Skill - Paranormal abilities, only if PSY >= 5           ",
	"(COOL) Charasmatic Leadership - Sway crowds up to (level^2)*200         ",
	"(EMP)  Vamp - Conning someone by using charm, wiles, & unkept promises  ",
	"(INT)  Chameleon - Chameleon/2 of Assumed Role's Special Ability to spy ",
	"(SPEC) Combat Sense - Bonus to awareness & initative in combat situation",
	"(SPEC) Space Combat Sense - 1/2 CS when planetside.  + to Zero-G skills ",
	"(SPEC) PA Combat Sense - Reduce by 1/2 when out of suit.  Like Solo CS  ",
	"(COOL) Authority - Ability to intimidate/control others by your position",
	"(COOL) Research - Similar to Streetdeal, but for information only       ",
	"(INT)  Resources - Access to organization's resources, like persuasion  ",
	"(INT)  Credibility - Ability to be believed by viewers/jury/police/etc  ",
	"(INT)  Titilate - Ability to dress up the ordinary & make people watch  ",
	"(COOL) StreetDeal - Ability to deal with the underground info network   ",
	"(TECH) Jury Rig -  General repair/modify, works for 1d6 turns per level ",
	"(INT)  Salvage -  Ability to spot/retreve stuff.  Use 1/2 for Jury Rig  ",
	"(INT)  Medical Tech - Ability to perform major surgury & medical repairs",
	"(INT)  BrotherHood - Ability to call upon help of any other pilot       ",
	"(INT)  Workgang - Ability to call upon resources/help of any workgangers",
	"(INT)  Interface - (NOT REF) Ability to manupulate interface programs   ",
	"(INT)  Family - Ability to call upon resources/help of extended family  ",
	"(COOL) Rank - Your standing in the gang: ability to get help/resources  ",
	"(PSY)  Animals - Character can detect/summon/influence/talk to animals  ",
	"(PSY)  Charm - Character can influence another being(s) actions         ",
	"(PSY)  Cure - Character can heal or regenerate lost PSY and COOL points ",
	"(PSY)  Hypnological - Character can affect another being's sleep/dreams ",
	"(PSY)  Illusion - Character can affect another being's sensory input(s) ",
	"(PSY)  Mania - Character can alter moods and emotions of a being        ",
	"(PSY)  Mental - Character can read thoughts and mind of another being   ",
	"(PSY)  Mental Assault - Char. can attk. another being's mental faculties",
	"(PSY)  Mnemonic - Character can alter memories of a being & him/herself ",
	"(PSY)  Psychic Assault - Character can attack another being's spirit    ",
	"(PSY)  Sensory - Character can heighten his/her own senses              ",
	"(PSY)  Telepathy - Communicate with other being, no language barriers   ",
	"(PSY)  Astral - Character can operate in the Astral realm               ",
	"(PSY)  Precognition - Character can predict the most probable future    ",
	"(PSY)  Psychometry - Character sees the history of things/places/beings ",
	"(PSY)  Cryokinesis - Character can lower temperatures                   ",
	"(PSY)  Electrokinesis - Character can manipulate electricity            ",
	"(PSY)  Healing - Character can heal himself and others of physical harm ",
	"(PSY)  Kinesis - Character can manipulate kinetic energy                ",
	"(PSY)  Matter Alteration - Character can create/destroy/alter matter    ",
	"(PSY)  Psychokinesis - Character can move matter in various ways        ",
	"(PSY)  Pyrokinesis - Character can raise temperatures                   ",
	"(PSY)  Radiokinesis - Character can affect radiation                    ",
	"(PSY)  Teleportation - Character can move instantaneously btwn 2 points ",
	"(PSY)  Astral Body - Character can travel through the Astral realm      ",
	"(PSY)  Body Control - Character is able to affect/control their own body",
	"(PSY)  Psychic Focus - Character able to focus energy, boosting stats   ",
	"(PSY)  Regeneration - Character can regenerate at an accelerated rate   ",
	"(PSY)  Transform - Character can temporarily change shape/form          "};


/************************************************************************
*	Vampire Quirks List - From Night's Edge
************************************************************************/

static char *
vquirks[23] = {
	"+1 to stat of your choice                    +3",
	"-1 to stat of your choice                    -3",
	"+1 to skill of your choice                   +2",
	"-1 to skill of your choice                   -2",
	"Stake through heart will kill                -4",
	"Boiling oil/holy water will kill             -5",
	"Decapitation with shovel will kill           -4",
	"Poppy seeds on grave will kill               -6",
	"Coin (or other object) in mouth will kill    -6",
	"Buried at crossroads will kill               -2",
	"Immersion in water (specific type) will kill -6",
	"Fear of Crosses/Holy Symbols                 -3",
	"Cannot enter churches                        -1",
	"Fear of Garlic/other common herb             -3",
	"Fear of Other Holy Item(s)                   -2",
	"Fear of Silver/Wood                          -4",
	"Stench of Grave                              -4",
	"Physical Deformity                           -2",
	"Awakens earlier than usual                   +2",
	"Awakens later than usual                     -2",
	"Must sleep in coffin                         -2",
	"Must sleep on bodies                         -4",
	"Cannot cross running water/line of salt      -3"
	};


/************************************************************************
*	WereWolf Quirks List - From Night's Edge
************************************************************************/

static char *
wquirks[10] = {
	"+1 to stat of your choice                    +3",
	"-1 to stat of your choice                    -3",
	"+1 to skill of your choice                   +2",
	"-1 to skill of your choice                   -2",
	"Touched by a martyr's blood will kill        -4",
	"Shot in the head will kill                   -6",
	"Fear of Crosses/Holy Symbols                 -3",
	"Fear of Fire                                 -4",
	"Fear of Wolfsbane                            -4",
	"Fear of the New Moon                         -6"
	};


/************************************************************************
*	Origins and Personal Style
************************************************************************/

static char *
clothes[10] = {
	"Biker Leathers",
	"Blue Jeans",
	"Corporate Suits",
	"Jumpsuits",
	"Miniskirts",
	"High Fashion",
	"Cammos",
	"Normal Clothes",
	"Nude",
	"Bag Lady Chic"};

static char *
hairstyle[10] = {
	"Mohawk",
	"Long & Ratty",
	"Short and Spiked",
	"Wild & All Over",
	"Bald",
	"Striped",
	"Tinted",
	"Neat, Short",
	"Short, Curly",
	"Long, Straight"};

static char *
affectations[10] = {
	"Tatoos",
	"Mirrorshades",
	"Ritual Scars",
	"Spiked Gloves",
	"Nose Rings",
	"Earrings",
	"Long Fingernails",
	"Spiked Heeled Boots",
	"Weird Contact Lenses",
	"Fingerless Gloves"};


/************************************************************************
*	Ethnicity
************************************************************************/

static char *
ethnicity[10] = {
	"Anglo-American",
	"African",
	"Japanese/Korean",
	"Central European/Soviet",
	"Pacific Islander",
	"Chinese/Southeast Asian",
	"Black American",
	"Hispanic American",
	"Central/South American",
	"European"};


/************************************************************************
*	Family Background
************************************************************************/

static char *
fam_rank[10] = {
	"Family rank: Corporate Executive",
	"Family rank: Corporate Manager",
	"Family rank: Corporate Technician",
	"Family rank: Nomad Pack",
	"Family rank: Pirate Fleet",
	"Family rank: Gang Family",
	"Family rank: Crime Lord",
	"Family rank: Combat Zone Poor",
	"Family rank: Urban Homeless",
	"Family rank: Arcology Family"};

static char *
parents_bad[10] = {
	"Your parent(s) died in warfare",
	"Your parent(s) died in an accident",
	"Your parent(s) were murdered",
	"Your parent(s) have amnesia and don't remember you",
	"You never knew your parents",
	"Your parent(s) are in hiding to protect you",
	"You were left with relatives for safe keeping",
	"You grew up on the Street and never had parents",
	"Your parent(s) gave you up for adoption",
	"Your parent(s) sold you for money"};

static char *
child_envir[10] = {
	"Childhood: Spent on the street, with no adult supervision",
	"Childhood: Spent in a safe Corporate Suburbia",
	"Childhood: In a Nomad Pack moving from town to town",
	"Childhood: In a decaying, once upscale neighborhood",
	"Childhood: In a defended Corporate Zone in the central City",
	"Childhood: In the heart of the Combat Zone",
	"Childhood: In a small village or town far from the City",
	"Childhood: In a large arcology city",
	"Childhood: In an aquatic Pirate Pack",
	"Childhood: On a Corporate controlled Farm or Research Facility"};

static char *
fam_tragedy[10] = {
	"Family lost everything through betrayal",
	"Family lost everything through bad management",
	"Family exiled/driven from their original home/nation/corporation",
	"Family is imprisoned and you alone escaped",
	"Family vanished; you are the only remaining member",
	"Family was murdered/killed and you were the only survivor",
	"Family is involved in a longterm conspiracy or organized crime",
	"Your family was scattered to the winds due to misfortune",
	"Your family has a hereditary feud that has lasted for generations",
	"You inherited a debt; you must honor this debt before moving on"};

static char *
gender[4] = {
	"Male",
	"Female",
	"Male",
	"Female"};

static char *
older[10] = {
	"Older",
	"Older",
	"Older",
	"Older",
	"Older",
	"Younger",
	"Younger",
	"Younger",
	"Younger",
	"Twin"};

static char *
sib_feel[5] = {
	"Sibling dislikes you",
	"Sibling likes you",
	"Sibling neutral",
	"They hero worship you",
	"They hate you"};


/************************************************************************
*	Motivations
************************************************************************/

static char *
per_trait[10] = {
	"Shy and secretive",
	"Rebellious, antisocial, violent",
	"Arrogant, proud, and aloof",
	"Moody, rash, and headstrong",
	"Picky, fussy, and nervous",
	"Stable and serious",
	"Silly and fluffheaded",
	"Sneaky and deceptive",
	"Intellectual and detatched",
	"Friendly and outgoing"};

static char *
val_person[10] = {
	"A parent",
	"Brother or sister",
	"Lover",
	"Friend",
	"Yourself",
	"A pet",
	"Teacher or master",
	"Public figure",
	"A personal hero",
	"No one"};

static char *
val_idea[10] = {
	"Money",
	"Honor",
	"Your word",
	"Honesty",
	"Knowledge",
	"Vengance",
	"Love",
	"Power",
	"Having a good time",
	"Friendship"};

static char *
feel_people[10] = {
	"Neutral",
	"Neutral",
	"You/they like almost everyone",
	"You/they hate almost everyone",
	"People are tools to be used and discarded",
	"Each person is a valuable individual",
	"People are obsticles, crush them if they interfere",
	"People are untrustworthy, depend only on yourself",
	"Kill the humans and let the cockroaches take over",
	"People are wonderful"};

static char *
val_thing[10] = {
	"A weapon",
	"A tool",
	"A piece of clothing",
	"A photograph",
	"A book or diary",
	"A recording",
	"A musical instrument",
	"A piece of jewelry",
	"A toy",
	"A letter"};


/************************************************************************
*	Big Problems, Big Wins
************************************************************************/

static char *
disaster[10] = {
	"Financial loss or debt",
	"Imprisonment",
	"Illness or addiction",
	"Betrayal",
	"Accident",
	"Lover, friend or relative killed",
	"False accusation",
	"Hunted by the law",
	"Hunted by a corporation",
	"Mental or physical incapacitation"};

static char *
lucky[10] = {
	"Make powerful connection",
	"Financial windfall",
	"Big score",
	"Find a sensei",
	"Find a teacher",
	"Powerful corporate executive owes you one favor",
	"Local nomad pack befriends you",
	"Make a friend on the police force",
	"Local bostergang likes you",
	"Find a combat teacher"};

static char *
gonna_do[5] = {
	"Your reaction: Clear your name",
	"Your reaction: Live it down and try to forget it",
	"Your reaction: Hunt down those responsible and make then pay",
	"Your reaction: Get what's rightfully yours",
	"Your reaction: Save, if possible, anyone else involved in the situation"};


/************************************************************************
*	Friends and Enemies
************************************************************************/

static char *
enemy[10] = {
	"They are: Ex friend",
	"They are: Ex lover",
	"They are: Relative",
	"They are: Childhood enemy",
	"They are: Person working for you",
	"They are: Person you work for",
	"They are: Partner or co-worker",
	"They are: Booster gang member",
	"They are: Drifting Nomad",
	"They are: Government official"};

static char *
cause[10] = {
	"Reason: Caused the other to lose face or status",
	"Reason: Caused the loss of a lover, friend, or relative",
	"Reason: Caused a major humiliation",
	"Reason: Accused the other of cowardace/personal flaw",
	"Reason: Caused a physical disability",
	"Reason: Deserted or betrayed the other",
	"Reason: Turned down the other's job offer/romantic invitation",
	"Reason: Just hate each other",
	"Reason: Was a romantic rival",
	"Reason: Foiled a plan of the other's"};

static char *
whatcha_do[5] = {
	"Reaction: Go into a murderous rage and attack",
	"Reaction: Avoid the scum",
	"Reaction: Backstab indirectly",
	"Reaction: Ignore the scum",
	"Reaction: Rip into them verbally"};

static char *
resources[10] = {
	"Resources: Just themselves",
	"Resources: Just themselves",
	"Resources: Just themselves",
	"Resources: They and a few friends",
	"Resources: They and a few friends",
	"Resources: An entire gang",
	"Resources: An entire gang",
	"Resources: A small Corporation",
	"Resources: A large Corporation",
	"Resources: An entire Government Agency"};

static char *
buddy[10] = {
	"Person you work for/with",
	"Like big brother/sister",
	"Like a kid brother/sister",
	"A teacher/mentor",
	"An old lover (choose)",
	"An old enemy (choose)",
	"Like a foster parent",
	"A relative",
	"Reconnect with childhood friend",
	"Met through common interest"};


/************************************************************************
*	Romantic Life
************************************************************************/

static char *
tragic_love[10] = {
	"Tragedy: Lover died in accident",
	"Tragedy: Lover mysteriously vanished",
	"Tragedy: It didn't work out",
	"Tragedy: A personal goal or vendetta came between you",
	"Tragedy: Lover kidnapped",
	"Tragedy: Lover went insane",
	"Tragedy: Lover commited suicide",
	"Tragedy: Lover killed in a fight",
	"Tragedy: Rival cut you out of the action",
	"Tragedy: Lover imprisoned or exiled"};

static char *
problem_love[10] = {
	"Problem: Lover's friends/family hate you",
	"Problem: Lover's friends/family want you dead",
	"Problem: Your friends/family hate them",
	"Problem: One of you has a romatic rival",
	"Problem: Separated in some way",
	"Problem: You fight contantly",
	"Problem: You're professional rivals",
	"Problem: One of you is insanely jealous",
	"Problem: One of you is messing around",
	"Problem: Conflicting backgrounds or families"};

static char*
mutual_feel[10] = {
	"Mutual feelings: They still love you",
	"Mutual feelings: You still love them",
	"Mutual feelings: You still love each other",
	"Mutual feelings: You hate them",
	"Mutual feelings: They hate you",
	"Mutual feelings: You hate each other",
	"Mutual feelings: You're friends",
	"Mutual feelings: No feelings, it's over",
	"Mutual feelings: You like them, they hate you",
	"Mutual feelings: You hate them, they like you"};	


